/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.CreateConstraintConstantAction;
import org.apache.derby.impl.sql.execute.DDLConstantAction;
import org.apache.derby.impl.sql.execute.RowUtil;

class CreateTableConstantAction
extends DDLConstantAction {
    private char lockGranularity;
    private boolean onCommitDeleteRows;
    private boolean onRollbackDeleteRows;
    private String tableName;
    private String schemaName;
    private int tableType;
    private ColumnInfo[] columnInfo;
    private CreateConstraintConstantAction[] constraintActions;
    private Properties properties;

    CreateTableConstantAction(String string, String string2, int n, ColumnInfo[] columnInfoArray, CreateConstraintConstantAction[] createConstraintConstantActionArray, Properties properties, char c2, boolean bl, boolean bl2) {
        this.schemaName = string;
        this.tableName = string2;
        this.tableType = n;
        this.columnInfo = columnInfoArray;
        this.constraintActions = createConstraintConstantActionArray;
        this.properties = properties;
        this.lockGranularity = c2;
        this.onCommitDeleteRows = bl;
        this.onRollbackDeleteRows = bl2;
    }

    public String toString() {
        if (this.tableType == 3) {
            return this.constructToString("DECLARE GLOBAL TEMPORARY TABLE ", this.tableName);
        }
        return this.constructToString("CREATE TABLE ", this.tableName);
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        TableDescriptor tableDescriptor;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        activation.setForCreateTable();
        ExecRow execRow = RowUtil.getEmptyValueRow(this.columnInfo.length, languageConnectionContext);
        for (int j = 0; j < this.columnInfo.length; ++j) {
            if (this.columnInfo[j].defaultValue != null) {
                execRow.setColumn(j + 1, this.columnInfo[j].defaultValue);
                continue;
            }
            execRow.setColumn(j + 1, this.columnInfo[j].dataType.getNull());
        }
        long l = transactionController.createConglomerate("heap", execRow.getRowArray(), null, this.properties, this.tableType == 3 ? 3 : 0);
        if (this.tableType != 3) {
            dataDictionary.startWriting(languageConnectionContext);
        }
        SchemaDescriptor schemaDescriptor = this.tableType == 3 ? dataDictionary.getSchemaDescriptor(this.schemaName, transactionController, true) : DDLConstantAction.getSchemaDescriptorForCreate(dataDictionary, activation, this.schemaName);
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        if (this.tableType != 3) {
            tableDescriptor = dataDescriptorGenerator.newTableDescriptor(this.tableName, schemaDescriptor, this.tableType, this.lockGranularity);
            dataDictionary.addDescriptor(tableDescriptor, schemaDescriptor, 1, false, transactionController);
        } else {
            tableDescriptor = dataDescriptorGenerator.newTableDescriptor(this.tableName, schemaDescriptor, this.tableType, this.onCommitDeleteRows, this.onRollbackDeleteRows);
            tableDescriptor.setUUID(dataDictionary.getUUIDFactory().createUUID());
        }
        UUID uUID = tableDescriptor.getUUID();
        activation.setDDLTableDescriptor(tableDescriptor);
        int n = 1;
        TupleDescriptor[] tupleDescriptorArray = new ColumnDescriptor[this.columnInfo.length];
        for (int j = 0; j < this.columnInfo.length; ++j) {
            UUID uUID2 = this.columnInfo[j].newDefaultUUID;
            if (this.columnInfo[j].defaultInfo != null && uUID2 == null) {
                uUID2 = dataDictionary.getUUIDFactory().createUUID();
            }
            ColumnDescriptor columnDescriptor = new ColumnDescriptor(this.columnInfo[j].name, n++, this.columnInfo[j].dataType, this.columnInfo[j].defaultValue, this.columnInfo[j].defaultInfo, tableDescriptor, uUID2, this.columnInfo[j].autoincStart, this.columnInfo[j].autoincInc);
            tupleDescriptorArray[j] = columnDescriptor;
        }
        if (this.tableType != 3) {
            dataDictionary.addDescriptorArray(tupleDescriptorArray, tableDescriptor, 2, false, transactionController);
        }
        ColumnDescriptorList columnDescriptorList = tableDescriptor.getColumnDescriptorList();
        for (int j = 0; j < tupleDescriptorArray.length; ++j) {
            columnDescriptorList.add(tupleDescriptorArray[j]);
        }
        ConglomerateDescriptor conglomerateDescriptor = dataDescriptorGenerator.newConglomerateDescriptor(l, null, false, null, false, null, uUID, schemaDescriptor.getUUID());
        if (this.tableType != 3) {
            dataDictionary.addDescriptor(conglomerateDescriptor, schemaDescriptor, 0, false, transactionController);
        }
        ConglomerateDescriptorList conglomerateDescriptorList = tableDescriptor.getConglomerateDescriptorList();
        conglomerateDescriptorList.add(conglomerateDescriptor);
        if (this.constraintActions != null) {
            int n2;
            for (n2 = 0; n2 < this.constraintActions.length; ++n2) {
                if (this.constraintActions[n2].isForeignKeyConstraint()) continue;
                this.constraintActions[n2].executeConstantAction(activation);
            }
            for (n2 = 0; n2 < this.constraintActions.length; ++n2) {
                if (!this.constraintActions[n2].isForeignKeyConstraint()) continue;
                this.constraintActions[n2].executeConstantAction(activation);
            }
        }
        if (this.tableType == 3) {
            languageConnectionContext.addDeclaredGlobalTempTable(tableDescriptor);
        }
    }
}

