/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.SQLException;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DDUtils;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.ConstraintInfo;
import org.apache.derby.impl.sql.execute.CreateIndexConstantAction;
import org.apache.derby.impl.sql.execute.IndexConstantAction;

public class CreateConstraintConstantAction
extends ConstraintConstantAction {
    public String[] columnNames;
    public String constraintText;
    private ConstraintInfo otherConstraintInfo;
    private ClassFactory cf;
    private boolean enabled;
    private ProviderInfo[] providerInfo;

    CreateConstraintConstantAction(String string, int n, String string2, UUID uUID, String string3, String[] stringArray, IndexConstantAction indexConstantAction, String string4, boolean bl, ConstraintInfo constraintInfo, ProviderInfo[] providerInfoArray) {
        super(string, n, string2, uUID, string3, indexConstantAction);
        this.columnNames = stringArray;
        this.constraintText = string4;
        this.enabled = bl;
        this.otherConstraintInfo = constraintInfo;
        this.providerInfo = providerInfoArray;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        ConglomerateDescriptor conglomerateDescriptor = null;
        ConglomerateDescriptor[] conglomerateDescriptorArray = null;
        ConstraintDescriptor constraintDescriptor = null;
        TableDescriptor tableDescriptor = null;
        UUID uUID = null;
        if (this.constraintType == 1) {
            return;
        }
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        this.cf = languageConnectionContext.getLanguageConnectionFactory().getClassFactory();
        boolean bl = activation.getForCreateTable();
        dataDictionary.startWriting(languageConnectionContext);
        SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(this.schemaName, transactionController, true);
        tableDescriptor = activation.getDDLTableDescriptor();
        if (tableDescriptor == null) {
            tableDescriptor = this.tableId != null ? dataDictionary.getTableDescriptor(this.tableId) : dataDictionary.getTableDescriptor(this.tableName, schemaDescriptor);
            if (tableDescriptor == null) {
                throw StandardException.newException("X0X05.S", this.tableName);
            }
            activation.setDDLTableDescriptor(tableDescriptor);
        }
        UUIDFactory uUIDFactory = dataDictionary.getUUIDFactory();
        if (this.indexAction != null) {
            String string;
            if (this.indexAction.getIndexName() == null) {
                string = uUIDFactory.createUUID().toString();
                this.indexAction.setIndexName(string);
            } else {
                string = this.indexAction.getIndexName();
            }
            this.indexAction.executeConstantAction(activation);
            conglomerateDescriptorArray = tableDescriptor.getConglomerateDescriptors();
            for (int j = 0; !(j >= conglomerateDescriptorArray.length || (conglomerateDescriptor = conglomerateDescriptorArray[j]).isIndex() && string.equals(conglomerateDescriptor.getConglomerateName())); ++j) {
            }
            uUID = conglomerateDescriptor.getUUID();
        }
        UUID uUID2 = uUIDFactory.createUUID();
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        switch (this.constraintType) {
            case 2: {
                constraintDescriptor = dataDescriptorGenerator.newPrimaryKeyConstraintDescriptor(tableDescriptor, this.constraintName, false, false, this.genColumnPositions(tableDescriptor, false), uUID2, uUID, schemaDescriptor, this.enabled, 0);
                dataDictionary.addConstraintDescriptor(constraintDescriptor, transactionController);
                break;
            }
            case 3: {
                constraintDescriptor = dataDescriptorGenerator.newUniqueConstraintDescriptor(tableDescriptor, this.constraintName, false, false, this.genColumnPositions(tableDescriptor, false), uUID2, uUID, schemaDescriptor, this.enabled, 0);
                dataDictionary.addConstraintDescriptor(constraintDescriptor, transactionController);
                break;
            }
            case 4: {
                constraintDescriptor = dataDescriptorGenerator.newCheckConstraintDescriptor(tableDescriptor, this.constraintName, false, false, uUID2, this.constraintText, new ReferencedColumnsDescriptorImpl(this.genColumnPositions(tableDescriptor, false)), schemaDescriptor, this.enabled);
                dataDictionary.addConstraintDescriptor(constraintDescriptor, transactionController);
                break;
            }
            case 6: {
                ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor = DDUtils.locateReferencedConstraint(dataDictionary, tableDescriptor, this.constraintName, this.columnNames, this.otherConstraintInfo);
                DDUtils.validateReferentialActions(dataDictionary, tableDescriptor, this.constraintName, this.otherConstraintInfo, this.columnNames);
                constraintDescriptor = dataDescriptorGenerator.newForeignKeyConstraintDescriptor(tableDescriptor, this.constraintName, false, false, this.genColumnPositions(tableDescriptor, false), uUID2, uUID, schemaDescriptor, referencedKeyConstraintDescriptor, this.enabled, this.otherConstraintInfo.getReferentialActionDeleteRule(), this.otherConstraintInfo.getReferentialActionUpdateRule());
                dataDictionary.addConstraintDescriptor(constraintDescriptor, transactionController);
                if (!bl && dataDictionary.activeConstraint(constraintDescriptor)) {
                    CreateConstraintConstantAction.validateFKConstraint(transactionController, dataDictionary, (ForeignKeyConstraintDescriptor)constraintDescriptor, referencedKeyConstraintDescriptor, ((CreateIndexConstantAction)this.indexAction).getIndexTemplateRow());
                }
                dependencyManager.addDependency(constraintDescriptor, referencedKeyConstraintDescriptor, languageConnectionContext.getContextManager());
                break;
            }
        }
        if (this.providerInfo != null) {
            for (int j = 0; j < this.providerInfo.length; ++j) {
                Provider provider = null;
                try {
                    provider = (Provider)this.providerInfo[j].getDependableFinder().getDependable(this.providerInfo[j].getObjectId());
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                dependencyManager.addDependency(constraintDescriptor, provider, languageConnectionContext.getContextManager());
            }
        }
        if (!bl) {
            dependencyManager.invalidateFor(tableDescriptor, 22, languageConnectionContext);
        }
        if (this.constraintType == 6) {
            dependencyManager.invalidateFor(((ForeignKeyConstraintDescriptor)constraintDescriptor).getReferencedConstraint().getTableDescriptor(), 22, languageConnectionContext);
        }
    }

    public boolean isForeignKeyConstraint() {
        return this.constraintType == 6;
    }

    private int[] genColumnPositions(TableDescriptor tableDescriptor, boolean bl) throws StandardException {
        int[] nArray = new int[this.columnNames.length];
        for (int j = 0; j < this.columnNames.length; ++j) {
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(this.columnNames[j]);
            if (columnDescriptor == null) {
                throw StandardException.newException("42X14", this.columnNames[j], (Object)this.tableName);
            }
            if (bl && !columnDescriptor.getType().getTypeId().orderable(this.cf)) {
                throw StandardException.newException("X0X67.S", columnDescriptor.getType().getTypeId().getSQLTypeName());
            }
            nArray[j] = columnDescriptor.getPosition();
        }
        return nArray;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String getConstraintText() {
        return this.constraintText;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE CONSTRAINT " + this.constraintName);
        stringBuffer.append("\n=========================\n");
        if (this.columnNames == null) {
            stringBuffer.append("columnNames == null\n");
        } else {
            for (int j = 0; j < this.columnNames.length; ++j) {
                stringBuffer.append("\n\tcol[" + j + "]" + this.columnNames[j].toString());
            }
        }
        stringBuffer.append("\n");
        stringBuffer.append(this.constraintText);
        stringBuffer.append("\n");
        if (this.otherConstraintInfo != null) {
            stringBuffer.append(this.otherConstraintInfo.toString());
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

