/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.TableScanResultSet;

public class BulkTableScanResultSet
extends TableScanResultSet
implements CursorResultSet {
    private DataValueDescriptor[][] rowArray;
    private int curRowPosition;
    private int numRowsInArray;
    private static int OUT_OF_ROWS = 0;

    public BulkTableScanResultSet(long l, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, Activation activation, GeneratedMethod generatedMethod, int n, GeneratedMethod generatedMethod2, int n2, GeneratedMethod generatedMethod3, int n3, boolean bl, Qualifier[][] qualifierArray, String string, String string2, boolean bl2, boolean bl3, int n4, int n5, int n6, boolean bl4, int n7, int n8, boolean bl5, double d2, double d3, GeneratedMethod generatedMethod4) throws StandardException {
        super(l, staticCompiledOpenConglomInfo, activation, generatedMethod, n, generatedMethod2, n2, generatedMethod3, n3, bl, qualifierArray, string, string2, bl2, bl3, n4, n5, n6, bl4, n7, n8, bl5, d2, d3, generatedMethod4);
    }

    protected void openScanController(TransactionController transactionController) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray;
        DataValueDescriptor[] dataValueDescriptorArray2 = this.startPosition == null ? null : this.startPosition.getRowArray();
        DataValueDescriptor[] dataValueDescriptorArray3 = dataValueDescriptorArray = this.stopPosition == null ? null : this.stopPosition.getRowArray();
        if (this.qualifiers != null) {
            this.clearOrderableCache(this.qualifiers);
        }
        if (transactionController == null) {
            transactionController = this.activation.getTransactionController();
        }
        this.scanController = transactionController.openCompiledScan(this.activation.getResultSetHoldability(), this.forUpdate ? 4 : 0, this.lockMode, this.isolationLevel, this.accessedCols, dataValueDescriptorArray2, this.startSearchOperator, this.qualifiers, dataValueDescriptorArray, this.stopSearchOperator, this.scoci, this.dcoci);
        this.scanControllerOpened = true;
        this.rowsThisScan = 0L;
        this.activation.informOfRowCount(this, this.scanController.getEstimatedRowCount());
    }

    public void openCore() throws StandardException {
        super.openCore();
        this.beginTime = this.getCurrentTimeMillis();
        this.rowArray = new DataValueDescriptor[this.rowsPerRead][];
        this.rowArray[0] = this.candidate.getRowArrayClone();
        this.numRowsInArray = 0;
        this.curRowPosition = -1;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public void reopenCore() throws StandardException {
        super.reopenCore();
        this.numRowsInArray = 0;
        this.curRowPosition = -1;
    }

    public ExecRow getNextRowCore() throws StandardException {
        ExecRow execRow = null;
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen && this.scanControllerOpened) {
            if (this.currentRow == null) {
                this.currentRow = this.getCompactRow(this.candidate, this.accessedCols, null, this.isKeyed);
            }
            block0: while (true) {
                if (this.curRowPosition >= this.numRowsInArray - 1 && this.reloadArray() == OUT_OF_ROWS) {
                    this.setCurrentRow(null);
                    this.setRowCountIfPossible(this.rowsThisScan);
                    return null;
                }
                while (true) {
                    if (++this.curRowPosition >= this.numRowsInArray) continue block0;
                    this.candidate.setRowArray(this.rowArray[this.curRowPosition]);
                    this.currentRow = this.setCompactRow(this.candidate, this.currentRow);
                    ++this.rowsSeen;
                    ++this.rowsThisScan;
                    if (!this.skipRow(this.candidate)) break block0;
                    ++this.rowsFiltered;
                }
                break;
            }
            execRow = this.currentRow;
        }
        this.setCurrentRow(execRow);
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execRow;
    }

    private int reloadArray() throws StandardException {
        this.curRowPosition = -1;
        this.numRowsInArray = ((GroupFetchScanController)((Object)this.scanController)).fetchNextGroup(this.rowArray, null);
        return this.numRowsInArray;
    }

    public void close() throws StandardException {
        super.close();
        this.numRowsInArray = -1;
        this.curRowPosition = -1;
        this.rowArray = null;
    }

    protected boolean canGetInstantaneousLocks() {
        return true;
    }

    public boolean requiresRelocking() {
        return this.isolationLevel == 2 || this.isolationLevel == 3 || this.isolationLevel == 1;
    }
}

