/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.ConnectionContext;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.GeneratedByteCode;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.CursorActivation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionContext;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.ResultSetFactory;
import org.apache.derby.iapi.sql.execute.TemporaryRowHolder;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.sql.execute.InsertResultSet;
import org.apache.derby.impl.sql.execute.RowResultSet;
import org.apache.derby.impl.sql.execute.UnionResultSet;

public abstract class BaseActivation
implements CursorActivation,
GeneratedByteCode {
    protected ResultSetFactory rsFactory;
    protected ExecutionFactory exFactory;
    protected DataValueFactory dvFactory;
    protected LanguageConnectionContext lcc;
    protected ContextManager cm;
    protected ExecutionContext ec;
    protected ExecPreparedStatement preStmt;
    protected ResultSet resultSet;
    protected ResultDescription resultDescription;
    protected boolean closed;
    private String cursorName;
    protected int numSubqueries;
    private boolean singleExecution;
    private boolean inUse;
    private java.sql.ResultSet targetVTI;
    private SQLWarning warnings;
    private GeneratedClass gc;
    private boolean checkRowCounts;
    private HashSet rowCountsCheckedThisExecution = new HashSet(4, 0.9f);
    private static final long MAX_SQRT = (long)Math.sqrt(9.223372036854776E18);
    private static final int TEN_PERCENT_THRESHOLD = 400;
    private ConglomerateController updateHeapCC;
    private ScanController indexSC;
    private long indexConglomerateNumber = -1L;
    private TableDescriptor ddlTableDescriptor;
    private int maxRows = -1;
    private boolean forCreateTable;
    private boolean scrollable;
    private boolean resultSetHoldability;
    private CursorResultSet forUpdateIndexScan;
    private boolean autoGeneratedKeysResultSetMode;
    private int[] autoGeneratedKeysColumnIndexes;
    private String[] autoGeneratedKeysColumnNames;
    protected int indexOfSessionTableNamesInSavedObjects = -1;
    protected ExecRow[] row;
    protected ParameterValueSet pvs;
    protected CursorResultSet[] raParentResultSets;
    protected Hashtable parentResultSets;
    private Calendar cal;

    protected BaseActivation() {
    }

    public final void initFromContext(Context context) {
        this.cm = context.getContextManager();
        this.lcc = (LanguageConnectionContext)this.cm.getContext("LanguageConnectionContext");
        this.dvFactory = this.lcc.getDataValueFactory();
        this.ec = this.lcc.getExecutionContext();
        this.rsFactory = this.ec.getResultSetFactory();
        this.exFactory = this.ec.getExecutionFactory();
        this.inUse = true;
        this.lcc.addActivation(this);
    }

    public final ExecPreparedStatement getPreparedStatement() {
        return this.preStmt;
    }

    public ConstantAction getConstantAction() {
        return this.preStmt.getConstantAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkStatementValidity() throws StandardException {
        if (this.preStmt == null) {
            return;
        }
        Object object2 = this.preStmt;
        synchronized (object2) {
            if (this.gc == this.preStmt.getActivationClass() && this.preStmt.upToDate()) {
                return;
            }
        }
        object2 = StandardException.newException("XCL32.S");
        ((StandardException)object2).setReport(1);
        throw object2;
    }

    public final void setupActivation(ExecPreparedStatement execPreparedStatement, boolean bl) {
        this.preStmt = execPreparedStatement;
        if (execPreparedStatement != null) {
            this.resultDescription = execPreparedStatement.getResultDescription();
            this.scrollable = bl;
        } else {
            this.resultDescription = null;
            this.scrollable = false;
        }
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public void clearResultSet() {
        this.resultSet = null;
    }

    public RowLocation getRowLocationTemplate(int n) {
        return (RowLocation)((RowLocation)this.getPreparedStatement().getSavedObject(n)).cloneObject();
    }

    public ResultDescription getResultDescription() {
        return this.resultDescription;
    }

    public void reset() throws StandardException {
        if (!(this.resultSet == null || this.resultSetHoldability && this.resultSet.returnsRows())) {
            this.resultSet.close();
            this.resultSet = null;
        }
        this.updateHeapCC = null;
        if (!this.isSingleExecution()) {
            this.clearWarnings();
        }
    }

    public final void close() throws StandardException {
        if (!this.closed) {
            if (this.resultSet != null) {
                this.resultSet.finish();
                this.resultSet = null;
            }
            this.reset();
            this.closed = true;
            LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
            languageConnectionContext.removeActivation(this);
            if (this.preStmt != null) {
                this.preStmt.finish(languageConnectionContext);
                this.preStmt = null;
            }
            try {
                this.closeActivationAction();
            }
            catch (Throwable throwable) {
                throw StandardException.plainWrapException(throwable);
            }
        }
    }

    protected void closeActivationAction() throws Exception {
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setSingleExecution() {
        this.singleExecution = true;
    }

    public boolean isSingleExecution() {
        return this.singleExecution;
    }

    public int getNumSubqueries() {
        return this.numSubqueries;
    }

    public boolean isCursorActivation() {
        return false;
    }

    public final void setGC(GeneratedClass generatedClass) {
        this.gc = generatedClass;
    }

    public final GeneratedClass getGC() {
        return this.gc;
    }

    public final GeneratedMethod getMethod(String string) throws StandardException {
        return this.getGC().getMethod(string);
    }

    public Object e0() throws StandardException {
        return null;
    }

    public Object e1() throws StandardException {
        return null;
    }

    public Object e2() throws StandardException {
        return null;
    }

    public Object e3() throws StandardException {
        return null;
    }

    public Object e4() throws StandardException {
        return null;
    }

    public Object e5() throws StandardException {
        return null;
    }

    public Object e6() throws StandardException {
        return null;
    }

    public Object e7() throws StandardException {
        return null;
    }

    public Object e8() throws StandardException {
        return null;
    }

    public Object e9() throws StandardException {
        return null;
    }

    public boolean checkIfThisActivationHasHoldCursor(String string) {
        if (!this.inUse) {
            return false;
        }
        if (!this.resultSetHoldability) {
            return false;
        }
        if (this.indexOfSessionTableNamesInSavedObjects == -1) {
            return false;
        }
        if (this.resultSet != null && !this.resultSet.isClosed() && this.resultSet.returnsRows()) {
            return ((ArrayList)this.getPreparedStatement().getSavedObject(this.indexOfSessionTableNamesInSavedObjects)).contains(string);
        }
        return false;
    }

    public void setCursorName(String string) {
        if (this.isCursorActivation()) {
            this.cursorName = string;
        }
    }

    public String getCursorName() {
        return this.isCursorActivation() ? this.cursorName : null;
    }

    public void setResultSetHoldability(boolean bl) {
        this.resultSetHoldability = bl;
    }

    public boolean getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    public void setAutoGeneratedKeysResultsetInfo(int[] nArray, String[] stringArray) {
        this.autoGeneratedKeysResultSetMode = true;
        this.autoGeneratedKeysColumnIndexes = nArray;
        this.autoGeneratedKeysColumnNames = stringArray;
    }

    public boolean getAutoGeneratedKeysResultsetMode() {
        return this.autoGeneratedKeysResultSetMode;
    }

    public int[] getAutoGeneratedKeysColumnIndexes() {
        return this.autoGeneratedKeysColumnIndexes;
    }

    public String[] getAutoGeneratedKeysColumnNames() {
        return this.autoGeneratedKeysColumnNames;
    }

    public ResultSetFactory getResultSetFactory() {
        return this.rsFactory;
    }

    public ExecutionFactory getExecutionFactory() {
        return this.exFactory;
    }

    public CursorResultSet getTargetResultSet() {
        return null;
    }

    protected DataValueDescriptor getSetAutoincrementValue(int n, long l) throws StandardException {
        NumberDataValue numberDataValue = ((InsertResultSet)this.resultSet).getSetAutoincrementValue(n, l);
        return numberDataValue;
    }

    public CursorResultSet getCursorResultSet() {
        return null;
    }

    public void throwIfClosed(String string) throws StandardException {
        if (this.closed) {
            throw StandardException.newException("XCL05.S", string);
        }
    }

    public static void setColumnPosition(int[] nArray, int n, int n2) {
        nArray[n] = n2;
    }

    public static void allocateQualArray(Qualifier[][] qualifierArray, int n, int n2) {
        qualifierArray[n] = new Qualifier[n2];
    }

    public static void setQualifier(Qualifier[][] qualifierArray, Qualifier qualifier, int n, int n2) {
        qualifierArray[n][n2] = qualifier;
    }

    public static void reinitializeQualifiers(Qualifier[][] qualifierArray) {
        if (qualifierArray != null) {
            for (int j = 0; j < qualifierArray.length; ++j) {
                for (int k = 0; k < qualifierArray[j].length; ++k) {
                    qualifierArray[j][k].reinitialize();
                }
            }
        }
    }

    public final void markUnused() {
        this.inUse = false;
    }

    public final boolean isInUse() {
        return this.inUse;
    }

    public void addWarning(SQLWarning sQLWarning) {
        if (this.warnings == null) {
            this.warnings = sQLWarning;
        } else {
            this.warnings.setNextWarning(sQLWarning);
        }
    }

    public SQLWarning getWarnings() {
        return this.warnings;
    }

    public void clearWarnings() {
        this.warnings = null;
    }

    protected static void nullToPrimitiveTest(DataValueDescriptor dataValueDescriptor, String string) throws StandardException {
        if (dataValueDescriptor.isNull()) {
            throw StandardException.newException("39004", string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void informOfRowCount(NoPutResultSet noPutResultSet, long l) throws StandardException {
        if (this.checkRowCounts) {
            boolean bl = false;
            int n = noPutResultSet.resultSetNumber();
            Integer n2 = ReuseFactory.getInteger(n);
            if (this.rowCountsCheckedThisExecution.add(n2)) {
                ExecPreparedStatement execPreparedStatement = this.getPreparedStatement();
                synchronized (execPreparedStatement) {
                    Vector<Long> vector = this.getRowCountCheckVector();
                    if (vector == null) {
                        vector = new Vector<Long>();
                        this.setRowCountCheckVector(vector);
                    }
                    Long l2 = null;
                    if (n < vector.size()) {
                        l2 = (Long)vector.elementAt(n);
                    } else {
                        vector.setSize(n + 1);
                    }
                    if (l2 != null) {
                        long l3 = l2;
                        if (l != l3) {
                            if (l3 >= 400L) {
                                long l4 = l3 / (l - l3);
                                if (Math.abs(l4) <= 10L) {
                                    bl = true;
                                }
                            } else {
                                long l5 = l - l3;
                                if (Math.abs(l5) <= MAX_SQRT && l5 * l5 > Math.abs(4L * l3)) {
                                    bl = true;
                                }
                            }
                        }
                    } else {
                        l2 = new Long(l);
                        vector.setElementAt(l2, n);
                    }
                }
            }
            if (bl) {
                this.preStmt.makeInvalid(23, this.lcc);
            }
        }
    }

    public void startExecution() throws StandardException {
        this.shouldWeCheckRowCounts();
        if (this.checkRowCounts) {
            this.rowCountsCheckedThisExecution.clear();
        }
    }

    public ConglomerateController getHeapConglomerateController() {
        return this.updateHeapCC;
    }

    public void setHeapConglomerateController(ConglomerateController conglomerateController) {
        this.updateHeapCC = conglomerateController;
    }

    public void clearHeapConglomerateController() {
        this.updateHeapCC = null;
    }

    public ScanController getIndexScanController() {
        return this.indexSC;
    }

    public void setIndexScanController(ScanController scanController) {
        this.indexSC = scanController;
    }

    public long getIndexConglomerateNumber() {
        return this.indexConglomerateNumber;
    }

    public void setIndexConglomerateNumber(long l) {
        this.indexConglomerateNumber = l;
    }

    public void clearIndexScanInfo() {
        this.indexSC = null;
        this.indexConglomerateNumber = -1L;
    }

    public void setForCreateTable() {
        this.forCreateTable = true;
    }

    public boolean getForCreateTable() {
        return this.forCreateTable;
    }

    public void setDDLTableDescriptor(TableDescriptor tableDescriptor) {
        this.ddlTableDescriptor = tableDescriptor;
    }

    public TableDescriptor getDDLTableDescriptor() {
        return this.ddlTableDescriptor;
    }

    public void setMaxRows(int n) {
        this.maxRows = n;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setTargetVTI(java.sql.ResultSet resultSet) {
        this.targetVTI = resultSet;
    }

    public java.sql.ResultSet getTargetVTI() {
        return this.targetVTI;
    }

    private void shouldWeCheckRowCounts() throws StandardException {
        int n = this.getExecutionCount() + 1;
        if (n == 1) {
            this.checkRowCounts = true;
        } else if (n < 5) {
            this.checkRowCounts = false;
        } else {
            int n2 = this.getStalePlanCheckInterval();
            if (n2 == 0) {
                TransactionController transactionController = this.getTransactionController();
                n2 = PropertyUtil.getServiceInt(transactionController, "derby.language.stalePlanCheckInterval", 5, Integer.MAX_VALUE, 100);
                this.setStalePlanCheckInterval(n2);
            }
            this.checkRowCounts = n % n2 == 1;
        }
        this.setExecutionCount(n);
    }

    protected abstract int getExecutionCount();

    protected abstract void setExecutionCount(int var1);

    protected abstract Vector getRowCountCheckVector();

    protected abstract void setRowCountCheckVector(Vector var1);

    protected abstract int getStalePlanCheckInterval();

    protected abstract void setStalePlanCheckInterval(int var1);

    public final boolean getScrollable() {
        return this.scrollable;
    }

    protected final void setParameterValueSet(int n, boolean bl) {
        this.pvs = this.lcc.getLanguageFactory().newParameterValueSet(this.lcc.getLanguageConnectionFactory().getClassFactory().getClassInspector(), n, bl);
    }

    public ParameterValueSet getParameterValueSet() {
        if (this.pvs == null) {
            this.setParameterValueSet(0, false);
        }
        return this.pvs;
    }

    public void setParameters(ParameterValueSet parameterValueSet, DataTypeDescriptor[] dataTypeDescriptorArray) throws StandardException {
        if (!this.isClosed()) {
            if (this.pvs == null || dataTypeDescriptorArray == null) {
                this.pvs = parameterValueSet;
                return;
            }
            DataTypeDescriptor[] dataTypeDescriptorArray2 = this.preStmt.getParameterTypes();
            boolean bl = false;
            if (dataTypeDescriptorArray2 != null && dataTypeDescriptorArray2.length == dataTypeDescriptorArray.length) {
                bl = true;
                for (int j = 0; j < dataTypeDescriptorArray.length; ++j) {
                    DataTypeDescriptor dataTypeDescriptor = dataTypeDescriptorArray[j];
                    DataTypeDescriptor dataTypeDescriptor2 = dataTypeDescriptorArray2[j];
                    if (!dataTypeDescriptor.isExactTypeAndLengthMatch(dataTypeDescriptor2)) {
                        bl = false;
                        break;
                    }
                    if (dataTypeDescriptor.isNullable() == dataTypeDescriptor2.isNullable()) continue;
                    bl = false;
                    break;
                }
            }
            if (!bl) {
                throw StandardException.newException("XCL10.S");
            }
            parameterValueSet.transferDataValues(this.pvs);
        }
    }

    public void throwIfMissingParms() throws StandardException {
        if (this.pvs != null && !this.pvs.allAreSet()) {
            throw StandardException.newException("07000");
        }
    }

    public void setCurrentRow(ExecRow execRow, int n) {
        if (this.row != null) {
            this.row[n] = execRow;
        }
    }

    public void clearCurrentRow(int n) {
        if (this.row != null) {
            this.row[n] = null;
        }
    }

    protected final DataValueDescriptor getColumnFromRow(int n, int n2) throws StandardException {
        if (this.row[n] == null) {
            return null;
        }
        return this.row[n].getColumn(n2);
    }

    protected void checkPositionedStatement(String string, String string2) throws StandardException {
        ExecPreparedStatement execPreparedStatement = this.getPreparedStatement();
        if (execPreparedStatement == null) {
            return;
        }
        LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
        CursorActivation cursorActivation = languageConnectionContext.lookupCursorActivation(string);
        if (cursorActivation != null && !string2.equals(cursorActivation.getPreparedStatement().getObjectName())) {
            execPreparedStatement.makeInvalid(5, languageConnectionContext);
        }
    }

    public NoPutResultSet materializeResultSetIfPossible(NoPutResultSet noPutResultSet) throws StandardException {
        noPutResultSet.openCore();
        Vector<ExecRow> vector = new Vector<ExecRow>();
        int n = 0;
        FormatableBitSet formatableBitSet = null;
        int n2 = this.getLanguageConnectionContext().getOptimizerFactory().getMaxMemoryPerTable();
        ExecRow execRow = noPutResultSet.getNextRowCore();
        if (execRow != null) {
            formatableBitSet = new FormatableBitSet(execRow.nColumns() + 1);
            formatableBitSet.set(1);
        }
        while (execRow != null && (n += execRow.getColumn(1).getLength()) <= n2) {
            vector.addElement(execRow.getClone(formatableBitSet));
            execRow = noPutResultSet.getNextRowCore();
        }
        noPutResultSet.close();
        if (execRow == null) {
            int n3 = noPutResultSet.resultSetNumber();
            int n4 = vector.size();
            if (n4 == 0) {
                return new RowResultSet((Activation)this, (ExecRow)null, true, n3, 0.0, 0.0, null);
            }
            RowResultSet[] rowResultSetArray = new RowResultSet[n4];
            UnionResultSet[] unionResultSetArray = new UnionResultSet[n4 - 1];
            for (int j = 0; j < n4; ++j) {
                rowResultSetArray[j] = new RowResultSet((Activation)this, (ExecRow)vector.elementAt(j), true, n3, 1.0, 0.0, null);
                if (j <= 0) continue;
                unionResultSetArray[j - 1] = new UnionResultSet(j > 1 ? unionResultSetArray[j - 2] : rowResultSetArray[0], rowResultSetArray[j], this, n3, j + 1, 0.0, null);
            }
            noPutResultSet.finish();
            if (n4 == 1) {
                return rowResultSetArray[0];
            }
            return unionResultSetArray[unionResultSetArray.length - 1];
        }
        return noPutResultSet;
    }

    public void setParentResultSet(TemporaryRowHolder temporaryRowHolder, String string) {
        Vector<TemporaryRowHolder> vector;
        if (this.parentResultSets == null) {
            this.parentResultSets = new Hashtable();
        }
        if ((vector = (Vector<TemporaryRowHolder>)this.parentResultSets.get(string)) == null) {
            vector = new Vector<TemporaryRowHolder>();
            vector.addElement(temporaryRowHolder);
        } else {
            vector.addElement(temporaryRowHolder);
        }
        this.parentResultSets.put(string, vector);
    }

    public Vector getParentResultSet(String string) {
        return (Vector)this.parentResultSets.get(string);
    }

    public Hashtable getParentResultSets() {
        return this.parentResultSets;
    }

    public void clearParentResultSets() {
        if (this.parentResultSets != null) {
            this.parentResultSets.clear();
        }
    }

    public void setForUpdateIndexScan(CursorResultSet cursorResultSet) {
        this.forUpdateIndexScan = cursorResultSet;
    }

    public CursorResultSet getForUpdateIndexScan() {
        return this.forUpdateIndexScan;
    }

    protected Calendar getCalendar() {
        if (this.cal == null) {
            this.cal = new GregorianCalendar();
        }
        return this.cal;
    }

    public final LanguageConnectionContext getLanguageConnectionContext() {
        return this.lcc;
    }

    public final TransactionController getTransactionController() {
        return this.lcc.getTransactionExecute();
    }

    ExecutionContext getExecutionContext() {
        return this.ec;
    }

    public ContextManager getContextManager() {
        return this.cm;
    }

    public DataValueFactory getDataValueFactory() {
        return this.dvFactory;
    }

    public Connection getCurrentConnection() throws SQLException {
        ConnectionContext connectionContext = (ConnectionContext)((Object)this.cm.getContext("JDBC_ConnectionContext"));
        return connectionContext.getNestedConnection(true);
    }

    public java.sql.ResultSet[][] getDynamicResults() {
        return null;
    }

    public int getMaxDynamicResults() {
        return 0;
    }

    public NumberDataValue getDB2Length(DataValueDescriptor dataValueDescriptor, int n, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            numberDataValue = this.getDataValueFactory().getNullInteger(null);
        }
        if (dataValueDescriptor.isNull()) {
            numberDataValue.setToNull();
        } else if (n >= 0) {
            numberDataValue.setValue(n);
        } else {
            numberDataValue.setValue(dataValueDescriptor.getLength());
        }
        return numberDataValue;
    }
}

