/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;

public class AnyResultSet
extends NoPutResultSetImpl {
    private ExecRow rowWithNulls;
    private StatementContext statementContext;
    public final NoPutResultSet source;
    private GeneratedMethod emptyRowFun;
    public int subqueryNumber;
    public int pointOfAttachment;

    public AnyResultSet(NoPutResultSet noPutResultSet, Activation activation, GeneratedMethod generatedMethod, int n, int n2, int n3, double d2, double d3) {
        super(activation, n, d2, d3);
        this.source = noPutResultSet;
        this.emptyRowFun = generatedMethod;
        this.subqueryNumber = n2;
        this.pointOfAttachment = n3;
        this.constructorTime += this.getElapsedMillis(this.beginTime);
    }

    public void openCore() throws StandardException {
        if (this.isOpen) {
            this.reopenCore();
            return;
        }
        this.beginTime = this.getCurrentTimeMillis();
        this.source.openCore();
        if (this.statementContext == null) {
            this.statementContext = this.getLanguageConnectionContext().getStatementContext();
        }
        this.statementContext.setSubqueryResultSet(this.subqueryNumber, this, this.activation.getNumSubqueries());
        ++this.numOpens;
        this.isOpen = true;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public void reopenCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.source.reopenCore();
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public void finish() throws StandardException {
        this.source.finish();
        this.finishAndRTS();
    }

    public ExecRow getNextRowCore() throws StandardException {
        ExecRow execRow = null;
        Object var2_2 = null;
        ExecRow execRow2 = null;
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            execRow = this.source.getNextRowCore();
            execRow2 = execRow != null ? execRow : (this.rowWithNulls == null ? (this.rowWithNulls = (ExecRow)this.emptyRowFun.invoke(this.activation)) : this.rowWithNulls);
        }
        this.currentRow = execRow2;
        this.setCurrentRow(execRow2);
        ++this.rowsSeen;
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execRow2;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            this.currentRow = null;
            this.source.close();
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public int getPointOfAttachment() {
        return this.pointOfAttachment;
    }

    public long getTimeSpent(int n) {
        long l = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n == 0) {
            return l - this.source.getTimeSpent(1);
        }
        return l;
    }
}

