/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.conn;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.conn.Authorizer;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.StringUtil;

class GenericAuthorizer
implements Authorizer {
    private static final int NO_ACCESS = 0;
    private static final int READ_ACCESS = 1;
    private static final int FULL_ACCESS = 2;
    private int userAccessLevel;
    boolean readOnlyConnection;
    private final LanguageConnectionContext lcc;
    private final String authorizationId;

    GenericAuthorizer(String string, LanguageConnectionContext languageConnectionContext, boolean bl) throws StandardException {
        this.lcc = languageConnectionContext;
        this.authorizationId = string;
        if (bl) {
            this.refresh();
        }
    }

    private boolean connectionMustRemainReadOnly() {
        return this.lcc.getDatabase().isReadOnly() || this.userAccessLevel == 1;
    }

    public void authorize(int n) throws StandardException {
        short s2 = this.lcc.getStatementContext().getSQLAllowed();
        switch (n) {
            case 2: 
            case 3: {
                if (s2 != 3) break;
                throw GenericAuthorizer.externalRoutineException(n, s2);
            }
            case 1: {
                if (s2 <= 1) break;
                throw GenericAuthorizer.externalRoutineException(n, s2);
            }
            case 0: 
            case 5: {
                if (this.isReadOnlyConnection()) {
                    throw StandardException.newException("25502");
                }
                if (s2 <= 0) break;
                throw GenericAuthorizer.externalRoutineException(n, s2);
            }
            case 4: 
            case 6: {
                if (this.isReadOnlyConnection()) {
                    throw StandardException.newException("25503");
                }
                if (s2 <= 0) break;
                throw GenericAuthorizer.externalRoutineException(n, s2);
            }
        }
    }

    private static StandardException externalRoutineException(int n, int n2) {
        String string;
        if (n2 == 1) {
            string = "38002";
        } else if (n2 == 2) {
            switch (n) {
                case 0: 
                case 4: 
                case 5: 
                case 6: {
                    string = "38002";
                    break;
                }
                default: {
                    string = "38004";
                    break;
                }
            }
        } else {
            string = "38001";
        }
        return StandardException.newException(string);
    }

    public String getAuthorizationId() {
        return this.authorizationId;
    }

    private void getUserAccessLevel() throws StandardException {
        this.userAccessLevel = 0;
        if (this.userOnAccessList("derby.database.fullAccessUsers")) {
            this.userAccessLevel = 2;
        }
        if (this.userAccessLevel == 0 && this.userOnAccessList("derby.database.readOnlyAccessUsers")) {
            this.userAccessLevel = 1;
        }
        if (this.userAccessLevel == 0) {
            this.userAccessLevel = this.getDefaultAccessLevel();
        }
    }

    private int getDefaultAccessLevel() throws StandardException {
        TransactionController transactionController = this.lcc.getTransactionExecute();
        String string = PropertyUtil.getServiceProperty(transactionController, "derby.database.defaultConnectionMode");
        if (string == null) {
            return 2;
        }
        if (StringUtil.SQLEqualsIgnoreCase(string, "noAccess")) {
            return 0;
        }
        if (StringUtil.SQLEqualsIgnoreCase(string, "readOnlyAccess")) {
            return 1;
        }
        if (StringUtil.SQLEqualsIgnoreCase(string, "fullAccess")) {
            return 2;
        }
        return 2;
    }

    private boolean userOnAccessList(String string) throws StandardException {
        TransactionController transactionController = this.lcc.getTransactionExecute();
        String string2 = PropertyUtil.getServiceProperty(transactionController, string);
        return IdUtil.idOnList(this.authorizationId, string2);
    }

    public boolean isReadOnlyConnection() {
        return this.readOnlyConnection;
    }

    public void setReadOnlyConnection(boolean bl, boolean bl2) throws StandardException {
        if (bl2 && !bl && this.connectionMustRemainReadOnly()) {
            throw StandardException.newException("25505");
        }
        this.readOnlyConnection = bl;
    }

    public void refresh() throws StandardException {
        this.getUserAccessLevel();
        if (!this.readOnlyConnection) {
            this.readOnlyConnection = this.connectionMustRemainReadOnly();
        }
        if (this.userAccessLevel == 0) {
            throw StandardException.newException("04501.C");
        }
    }
}

