/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class VirtualColumnNode
extends ValueNode {
    ResultSetNode sourceResultSet;
    ResultColumn sourceColumn;
    int columnId;
    boolean correlated = false;

    public void init(Object object2, Object object3, Object object4) {
        ResultColumn resultColumn = (ResultColumn)object3;
        this.sourceResultSet = (ResultSetNode)object2;
        this.sourceColumn = resultColumn;
        this.columnId = (Integer)object4;
        this.setType(resultColumn.getTypeServices());
    }

    public void printSubNodes(int n) {
    }

    public ResultSetNode getSourceResultSet() {
        return this.sourceResultSet;
    }

    public ResultColumn getSourceColumn() {
        return this.sourceColumn;
    }

    public String getTableName() {
        return this.sourceColumn != null ? this.sourceColumn.getTableName() : null;
    }

    public String getSchemaName() throws StandardException {
        return this.sourceColumn != null ? this.sourceColumn.getSchemaName() : null;
    }

    public boolean updatableByCursor() {
        return this.sourceColumn != null ? this.sourceColumn.updatableByCursor() : false;
    }

    public ResultColumn getSourceResultColumn() {
        return this.sourceColumn;
    }

    void setCorrelated() {
        this.correlated = true;
    }

    boolean getCorrelated() {
        return this.correlated;
    }

    public boolean isCloneable() {
        return true;
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n = this.sourceColumn.getResultSetNumber();
        if (this.sourceColumn.isRedundant()) {
            this.sourceColumn.getExpression().generateExpression(expressionClassBuilder, methodBuilder);
            return;
        }
        expressionClassBuilder.pushColumnReference(methodBuilder, n, this.sourceColumn.getVirtualColumnId());
        methodBuilder.cast(this.sourceColumn.getTypeCompiler().interfaceName());
    }

    protected int getOrderableVariantType() throws StandardException {
        return this.sourceColumn.getOrderableVariantType();
    }

    public DataTypeDescriptor getTypeServices() {
        DataTypeDescriptor dataTypeDescriptor = super.getTypeServices();
        if (dataTypeDescriptor == null && this.sourceColumn != null && (dataTypeDescriptor = this.sourceColumn.getTypeServices()) != null) {
            this.setType(dataTypeDescriptor);
        }
        return dataTypeDescriptor;
    }
}

