/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class ValueNodeList
extends QueryTreeNodeVector {
    public void printSubNodes(int n) {
    }

    public void setClause(int n) {
        int n2 = this.size();
        for (int j = 0; j < n2; ++j) {
            ValueNode valueNode = (ValueNode)this.elementAt(j);
            valueNode.setClause(n);
        }
    }

    public void addValueNode(ValueNode valueNode) throws StandardException {
        this.addElement(valueNode);
    }

    public void bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ValueNode valueNode = (ValueNode)this.elementAt(j);
            valueNode = valueNode.bindExpression(fromList, subqueryList, vector);
            this.setElementAt(valueNode, j);
        }
    }

    public void genSQLJavaSQLTrees() throws StandardException {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ValueNode valueNode = (ValueNode)this.elementAt(j);
            if (valueNode.getTypeId().systemBuiltIn()) continue;
            this.setElementAt(valueNode.genSQLJavaSQLTree(), j);
        }
    }

    public DataTypeDescriptor getDominantTypeServices() throws StandardException {
        DataTypeDescriptor dataTypeDescriptor = null;
        for (int j = 0; j < this.size(); ++j) {
            ValueNode valueNode = (ValueNode)this.elementAt(j);
            if (valueNode.isParameterNode()) continue;
            DataTypeDescriptor dataTypeDescriptor2 = valueNode.getTypeServices();
            dataTypeDescriptor = dataTypeDescriptor == null ? dataTypeDescriptor2 : dataTypeDescriptor.getDominantType(dataTypeDescriptor2, this.getClassFactory());
        }
        return dataTypeDescriptor;
    }

    public DataTypeDescriptor getTypeServices() throws StandardException {
        DataTypeDescriptor dataTypeDescriptor = null;
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ValueNode valueNode = (ValueNode)this.elementAt(j);
            DataTypeDescriptor dataTypeDescriptor2 = valueNode.getTypeServices();
            if (dataTypeDescriptor != null || dataTypeDescriptor2 == null) continue;
            dataTypeDescriptor = dataTypeDescriptor2;
            break;
        }
        return dataTypeDescriptor;
    }

    boolean allSamePrecendence(int n) {
        boolean bl = true;
        int n2 = this.size();
        for (int j = 0; j < n2; ++j) {
            ValueNode valueNode = (ValueNode)this.elementAt(j);
            DataTypeDescriptor dataTypeDescriptor = valueNode.getTypeServices();
            if (dataTypeDescriptor == null) {
                return false;
            }
            if (n == dataTypeDescriptor.getTypeId().typePrecedence()) continue;
            return false;
        }
        return bl;
    }

    public void compatible(ValueNode valueNode) throws StandardException {
        int n = this.size();
        TypeId typeId = valueNode.getTypeId();
        TypeCompiler typeCompiler = valueNode.getTypeCompiler();
        for (int j = 0; j < n; ++j) {
            ValueNode valueNode2 = (ValueNode)this.elementAt(j);
            if (valueNode2.isParameterNode() || typeCompiler.compatible(valueNode2.getTypeId())) continue;
            throw StandardException.newException("42815.S.171", typeId.getSQLTypeName(), (Object)valueNode2.getTypeId().getSQLTypeName());
        }
    }

    public void comparable(ValueNode valueNode) throws StandardException {
        int n = this.size();
        TypeId typeId = valueNode.getTypeId();
        TypeCompiler typeCompiler = valueNode.getTypeCompiler();
        for (int j = 0; j < n; ++j) {
            ValueNode valueNode2 = (ValueNode)this.elementAt(j);
            if (typeCompiler.comparable(valueNode2.getTypeId(), false, this.getClassFactory())) continue;
            throw StandardException.newException("42818", typeId.getSQLTypeName(), (Object)valueNode2.getTypeId().getSQLTypeName());
        }
    }

    public boolean isNullable() {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            if (!((ValueNode)this.elementAt(j)).getTypeServices().isNullable()) continue;
            return true;
        }
        return false;
    }

    public boolean containsParameterNode() {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            if (!((ValueNode)this.elementAt(j)).isParameterNode()) continue;
            return true;
        }
        return false;
    }

    public boolean containsAllParameterNodes() {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            if (((ValueNode)this.elementAt(j)).isParameterNode()) continue;
            return false;
        }
        return true;
    }

    public boolean containsAllConstantNodes() {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            if ((ValueNode)this.elementAt(j) instanceof ConstantNode) continue;
            return false;
        }
        return true;
    }

    void sortInAscendingOrder(DataValueDescriptor dataValueDescriptor) throws StandardException {
        int n = this.size();
        boolean bl = true;
        while (bl) {
            bl = false;
            for (int j = 1; j < n; ++j) {
                ConstantNode constantNode = (ConstantNode)this.elementAt(j);
                DataValueDescriptor dataValueDescriptor2 = constantNode.getValue();
                ConstantNode constantNode2 = (ConstantNode)this.elementAt(j - 1);
                DataValueDescriptor dataValueDescriptor3 = constantNode2.getValue();
                if ((dataValueDescriptor != null || dataValueDescriptor3.compare(dataValueDescriptor2) <= 0) && (dataValueDescriptor == null || !dataValueDescriptor.greaterThan(dataValueDescriptor3, dataValueDescriptor2).equals(true))) continue;
                this.setElementAt(constantNode, j - 1);
                this.setElementAt(constantNode2, j);
                bl = true;
            }
        }
    }

    public void setParameterDescriptor(DataTypeDescriptor dataTypeDescriptor) throws StandardException {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ValueNode valueNode = (ValueNode)this.elementAt(j);
            if (!valueNode.isParameterNode()) continue;
            ((ParameterNode)valueNode).setDescriptor(dataTypeDescriptor);
        }
    }

    public void preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        int n2 = this.size();
        for (int j = 0; j < n2; ++j) {
            ValueNode valueNode = (ValueNode)this.elementAt(j);
            valueNode.preprocess(n, fromList, subqueryList, predicateList);
        }
    }

    public ValueNodeList remapColumnReferencesToExpressions() throws StandardException {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            this.setElementAt(((ValueNode)this.elementAt(j)).remapColumnReferencesToExpressions(), j);
        }
        return this;
    }

    public boolean isConstantExpression() {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            boolean bl = ((ValueNode)this.elementAt(j)).isConstantExpression();
            if (bl) continue;
            return bl;
        }
        return true;
    }

    public boolean constantExpression(PredicateList predicateList) {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            boolean bl = ((ValueNode)this.elementAt(j)).constantExpression(predicateList);
            if (bl) continue;
            return bl;
        }
        return true;
    }

    public boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        boolean bl2 = true;
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            bl2 = ((ValueNode)this.elementAt(j)).categorize(jBitSet, bl) && bl2;
        }
        return bl2;
    }

    protected int getOrderableVariantType() throws StandardException {
        int n = 3;
        int n2 = this.size();
        for (int j = 0; j < n2; ++j) {
            int n3 = ((ValueNode)this.elementAt(j)).getOrderableVariantType();
            n = Math.min(n, n3);
        }
        return n;
    }
}

