/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.IsNullNode;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class UnaryOperatorNode
extends ValueNode {
    String operator;
    String methodName;
    int operatorType;
    String resultInterfaceType;
    String receiverInterfaceType;
    ValueNode operand;
    public static final int UNARY_PLUS = 1;
    public static final int UNARY_MINUS = 2;
    public static final int NOT = 3;
    public static final int IS_NULL = 4;
    public static final int XMLPARSE_OP = 0;
    public static final int XMLSERIALIZE_OP = 1;
    static final String[] UnaryOperators = new String[]{"xmlparse", "xmlserialize"};
    static final String[] UnaryMethodNames = new String[]{"XMLParse", "XMLSerialize"};
    static final String[] UnaryResultTypes = new String[]{"org.apache.derby.iapi.types.XMLDataValue", "org.apache.derby.iapi.types.StringDataValue"};
    static final String[] UnaryArgTypes = new String[]{"org.apache.derby.iapi.types.StringDataValue", "org.apache.derby.iapi.types.XMLDataValue"};
    private Object[] additionalArgs;

    public void init(Object object2, Object object3, Object object4) {
        this.operand = (ValueNode)object2;
        if (object3 instanceof String) {
            this.operator = (String)object3;
            this.methodName = (String)object4;
            this.operatorType = -1;
        } else {
            this.operatorType = (Integer)object3;
            this.operator = UnaryOperators[this.operatorType];
            this.methodName = UnaryMethodNames[this.operatorType];
            this.resultInterfaceType = UnaryResultTypes[this.operatorType];
            this.receiverInterfaceType = UnaryArgTypes[this.operatorType];
            this.additionalArgs = (Object[])object4;
        }
    }

    public void init(Object object2) {
        this.operand = (ValueNode)object2;
        this.operatorType = -1;
    }

    void setOperator(String string) {
        this.operator = string;
        this.operatorType = -1;
    }

    String getOperatorString() {
        return this.operator;
    }

    void setMethodName(String string) {
        this.methodName = string;
        this.operatorType = -1;
    }

    public String toString() {
        return "";
    }

    public void printSubNodes(int n) {
    }

    public ValueNode getOperand() {
        return this.operand;
    }

    public void setClause(int n) {
        super.setClause(n);
        if (this.operand != null) {
            this.operand.setClause(n);
        }
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        return this.bindUnaryOperator(fromList, subqueryList, vector);
    }

    protected ValueNode bindUnaryOperator(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        if (this.operand == null) {
            return this;
        }
        this.operand = this.operand.bindExpression(fromList, subqueryList, vector);
        if (this.operand.isParameterNode()) {
            this.bindParameter();
        }
        if (!(this.operand instanceof UntypedNullConstantNode || this.operand.getTypeId().systemBuiltIn() || this instanceof IsNullNode)) {
            this.operand = this.operand.genSQLJavaSQLTree();
        }
        if (this.operatorType == 0) {
            this.bindXMLParse();
        } else if (this.operatorType == 1) {
            this.bindXMLSerialize();
        }
        return this;
    }

    public void bindXMLParse() throws StandardException {
        TypeId typeId = this.operand.getTypeId();
        if (typeId != null) {
            switch (typeId.getJDBCTypeId()) {
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    break;
                }
                default: {
                    throw StandardException.newException("42X25", this.methodName, (Object)typeId.getSQLTypeName());
                }
            }
        }
        this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(456));
    }

    public void bindXMLSerialize() throws StandardException {
        TypeId typeId = this.operand.getTypeId();
        if (typeId != null && !typeId.isXMLTypeId()) {
            throw StandardException.newException("42X25", this.methodName, (Object)typeId.getSQLTypeName());
        }
        DataTypeDescriptor dataTypeDescriptor = (DataTypeDescriptor)this.additionalArgs[0];
        TypeId typeId2 = dataTypeDescriptor.getTypeId();
        switch (typeId2.getJDBCTypeId()) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                break;
            }
            default: {
                throw StandardException.newException("X0X17.S", typeId2.getSQLTypeName());
            }
        }
        this.setType(dataTypeDescriptor);
    }

    public ValueNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        if (this.operand != null) {
            this.operand = this.operand.preprocess(n, fromList, subqueryList, predicateList);
        }
        return this;
    }

    public boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        return this.operand == null ? false : this.operand.categorize(jBitSet, bl);
    }

    public ValueNode remapColumnReferencesToExpressions() throws StandardException {
        if (this.operand != null) {
            this.operand = this.operand.remapColumnReferencesToExpressions();
        }
        return this;
    }

    public boolean isConstantExpression() {
        return this.operand == null ? true : this.operand.isConstantExpression();
    }

    public boolean constantExpression(PredicateList predicateList) {
        return this.operand == null ? true : this.operand.constantExpression(predicateList);
    }

    void bindParameter() throws StandardException {
        if (this.operatorType == 0) {
            ((ParameterNode)this.operand).setDescriptor(DataTypeDescriptor.getBuiltInDataTypeDescriptor(2005));
        } else {
            if (this.operatorType == 1) {
                throw StandardException.newException("X0X14.S");
            }
            if (this.operand.getTypeServices() == null) {
                throw StandardException.newException("42X36", this.operator);
            }
        }
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        if (this.operand == null) {
            return;
        }
        String string = this.operatorType == -1 ? this.getTypeCompiler().interfaceName() : this.resultInterfaceType;
        boolean bl = !this.getTypeId().isBooleanTypeId();
        String string2 = this.getReceiverInterfaceName();
        this.operand.generateExpression(expressionClassBuilder, methodBuilder);
        methodBuilder.cast(string2);
        if (bl) {
            LocalField localField = expressionClassBuilder.newFieldDeclaration(2, string);
            methodBuilder.getField(localField);
            int n = 1 + this.addMethodParams(methodBuilder);
            methodBuilder.callMethod((short)185, null, this.methodName, string, n);
            methodBuilder.putField(localField);
        } else {
            int n = this.addMethodParams(methodBuilder);
            methodBuilder.callMethod((short)185, null, this.methodName, string, n);
        }
    }

    public String getReceiverInterfaceName() throws StandardException {
        if (this.operatorType != -1) {
            return this.receiverInterfaceType;
        }
        return this.operand.getTypeCompiler().interfaceName();
    }

    protected int getOrderableVariantType() throws StandardException {
        return this.operand != null ? this.operand.getOrderableVariantType() : 3;
    }

    public Visitable accept(Visitor visitor) throws StandardException {
        Visitable visitable = visitor.visit(this);
        if (visitor.skipChildren(this)) {
            return visitable;
        }
        if (this.operand != null && !visitor.stopTraversal()) {
            this.operand = (ValueNode)this.operand.accept(visitor);
        }
        return visitable;
    }

    protected int addMethodParams(MethodBuilder methodBuilder) {
        if (this.operatorType == 0) {
            methodBuilder.push((Boolean)this.additionalArgs[0]);
            return 1;
        }
        if (this.operatorType == 1) {
            DataTypeDescriptor dataTypeDescriptor = (DataTypeDescriptor)this.additionalArgs[0];
            methodBuilder.push(dataTypeDescriptor.getJDBCTypeId());
            methodBuilder.push(dataTypeDescriptor.getMaximumWidth());
            return 2;
        }
        return 0;
    }
}

