/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.DateTimeDataValue;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class UnaryDateTimestampOperatorNode
extends UnaryOperatorNode {
    private static final String TIMESTAMP_METHOD_NAME = "getTimestamp";
    private static final String DATE_METHOD_NAME = "getDate";

    public void init(Object object2, Object object3) throws StandardException {
        this.setType((DataTypeDescriptor)object3);
        switch (this.getTypeServices().getJDBCTypeId()) {
            case 91: {
                super.init(object2, "date", DATE_METHOD_NAME);
                break;
            }
            case 93: {
                super.init(object2, "timestamp", TIMESTAMP_METHOD_NAME);
                break;
            }
            default: {
                super.init(object2);
            }
        }
    }

    protected ValueNode bindUnaryOperator(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        boolean bl = false;
        boolean bl2 = false;
        super.bindUnaryOperator(fromList, subqueryList, vector);
        DataTypeDescriptor dataTypeDescriptor = this.operand.getTypeServices();
        switch (dataTypeDescriptor.getJDBCTypeId()) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                if (TIMESTAMP_METHOD_NAME.equals(this.methodName)) {
                    this.invalidOperandType();
                }
                bl2 = true;
                break;
            }
            case 1: 
            case 12: {
                break;
            }
            case 91: {
                if (TIMESTAMP_METHOD_NAME.equals(this.methodName)) {
                    this.invalidOperandType();
                }
                bl = true;
                break;
            }
            case 0: {
                break;
            }
            case 93: {
                if (!TIMESTAMP_METHOD_NAME.equals(this.methodName)) break;
                bl = true;
                break;
            }
            default: {
                this.invalidOperandType();
            }
        }
        if (this.operand instanceof ConstantNode) {
            DataValueFactory dataValueFactory = this.getLanguageConnectionContext().getDataValueFactory();
            DataValueDescriptor dataValueDescriptor = ((ConstantNode)this.operand).getValue();
            DateTimeDataValue dateTimeDataValue = null;
            dateTimeDataValue = dataValueDescriptor.isNull() ? (TIMESTAMP_METHOD_NAME.equals(this.methodName) ? dataValueFactory.getNullTimestamp(null) : dataValueFactory.getNullDate(null)) : (TIMESTAMP_METHOD_NAME.equals(this.methodName) ? dataValueFactory.getTimestamp(dataValueDescriptor) : dataValueFactory.getDate(dataValueDescriptor));
            return (ValueNode)this.getNodeFactory().getNode(76, dateTimeDataValue, this.getContextManager());
        }
        if (bl) {
            return this.operand;
        }
        return this;
    }

    private void invalidOperandType() throws StandardException {
        throw StandardException.newException("42X25", this.getOperatorString(), (Object)this.getOperand().getTypeServices().getSQLstring());
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        expressionClassBuilder.pushDataValueFactory(methodBuilder);
        this.operand.generateExpression(expressionClassBuilder, methodBuilder);
        methodBuilder.cast("org.apache.derby.iapi.types.DataValueDescriptor");
        methodBuilder.callMethod((short)185, null, this.methodName, this.getTypeCompiler().interfaceName(), 1);
    }
}

