/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.impl.sql.compile.QueryTreeNode;

public class TableName
extends QueryTreeNode {
    String tableName;
    String schemaName;
    private boolean hasSchema;
    private int tokBeginOffset = -1;
    private int tokEndOffset = -1;

    public void init(Object object2, Object object3) {
        this.hasSchema = object2 != null;
        this.schemaName = (String)object2;
        this.tableName = (String)object3;
    }

    public void init(Object object2, Object object3, Object object4, Object object5) {
        this.init(object2, object3);
        this.tokBeginOffset = (Integer)object4;
        this.tokEndOffset = (Integer)object5;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean hasSchema() {
        return this.hasSchema;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public int getTokenBeginOffset() {
        return this.tokBeginOffset;
    }

    public int getTokenEndOffset() {
        return this.tokEndOffset;
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }

    public String getFullTableName() {
        if (this.schemaName != null) {
            return this.schemaName + "." + this.tableName;
        }
        return this.tableName;
    }

    public String toString() {
        if (this.hasSchema) {
            return this.getFullTableName();
        }
        return this.tableName;
    }

    public boolean equals(TableName tableName) {
        if (tableName == null) {
            return false;
        }
        String string = this.getFullTableName();
        if (string == null) {
            return true;
        }
        if (this.schemaName == null || tableName.getSchemaName() == null) {
            return this.tableName.equals(tableName.getTableName());
        }
        return string.equals(tableName.getFullTableName());
    }

    public boolean equals(String string, String string2) {
        String string3 = this.getFullTableName();
        if (string3 == null) {
            return true;
        }
        if (this.schemaName == null || string == null) {
            return this.tableName.equals(string2);
        }
        return string3.equals(string + "." + string2);
    }

    public void bind(DataDictionary dataDictionary) throws StandardException {
        this.schemaName = this.getSchemaDescriptor(this.schemaName).getSchemaName();
    }

    public int hashCode() {
        return this.getFullTableName().hashCode();
    }

    public boolean equals(Object object2) {
        if (!(object2 instanceof TableName)) {
            return false;
        }
        TableName tableName = (TableName)object2;
        return this.getFullTableName().equals(tableName.getFullTableName());
    }
}

