/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.ColumnDefinitionNode;
import org.apache.derby.impl.sql.compile.ConstraintDefinitionNode;
import org.apache.derby.impl.sql.compile.CreateTableNode;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.FKConstraintDefinitionNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.ModifyColumnNode;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.TableElementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.ConstraintInfo;
import org.apache.derby.impl.sql.execute.IndexConstantAction;

public class TableElementList
extends QueryTreeNodeVector {
    private int numColumns;
    private TableDescriptor td;

    public void addTableElement(TableElementNode tableElementNode) {
        this.addElement(tableElementNode);
        if (tableElementNode instanceof ColumnDefinitionNode || tableElementNode.getElementType() == 7) {
            ++this.numColumns;
        }
    }

    public String toString() {
        return "";
    }

    void validate(DDLStatementNode dDLStatementNode, DataDictionary dataDictionary, TableDescriptor tableDescriptor) throws StandardException {
        ConstraintDescriptorList constraintDescriptorList;
        this.td = tableDescriptor;
        int n = 0;
        int n2 = this.size();
        Hashtable hashtable = new Hashtable(n2 + 2, 0.999f);
        Hashtable hashtable2 = new Hashtable(n2 + 2, 0.999f);
        Vector<Object> vector = new Vector<Object>();
        if (tableDescriptor != null && (constraintDescriptorList = dataDictionary.getConstraintDescriptors(tableDescriptor)) != null) {
            for (int j = 0; j < constraintDescriptorList.size(); ++j) {
                ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(j);
                if (constraintDescriptor.getConstraintType() != 2 && constraintDescriptor.getConstraintType() != 3) continue;
                vector.addElement(constraintDescriptor);
            }
        }
        int n3 = 0;
        if (dDLStatementNode instanceof CreateTableNode) {
            n3 = ((CreateTableNode)dDLStatementNode).tableType;
        }
        for (int j = 0; j < n2; ++j) {
            Object object2;
            String string;
            Object object3;
            Object object4;
            TableElementNode tableElementNode = (TableElementNode)this.elementAt(j);
            if (tableElementNode instanceof ColumnDefinitionNode) {
                object4 = (ColumnDefinitionNode)this.elementAt(j);
                if (n3 == 3 && (((ColumnDefinitionNode)object4).getDataTypeServices().getTypeId().isLongConcatableTypeId() || ((ColumnDefinitionNode)object4).getDataTypeServices().getTypeId().isUserDefinedTypeId())) {
                    throw StandardException.newException("42962", ((ColumnDefinitionNode)object4).getColumnName());
                }
                this.checkForDuplicateColumns(dDLStatementNode, hashtable, ((ColumnDefinitionNode)object4).getColumnName());
                ((ColumnDefinitionNode)object4).checkUserType(tableDescriptor);
                ((ColumnDefinitionNode)object4).bindAndValidateDefault(dataDictionary, tableDescriptor);
                ((ColumnDefinitionNode)object4).validateAutoincrement(dataDictionary, tableDescriptor, n3);
                if (tableElementNode instanceof ModifyColumnNode) {
                    object3 = (ModifyColumnNode)object4;
                    ((ModifyColumnNode)object3).checkExistingConstraints(tableDescriptor);
                } else if (((ColumnDefinitionNode)object4).isAutoincrementColumn()) {
                    ++n;
                }
            } else if (tableElementNode.getElementType() == 7) {
                object4 = tableElementNode.getName();
                if (tableDescriptor.getColumnDescriptor((String)object4) != null) break;
                throw StandardException.newException("42X14", object4, (Object)tableDescriptor.getQualifiedName());
            }
            if (!tableElementNode.hasConstraint()) continue;
            object4 = (ConstraintDefinitionNode)tableElementNode;
            ((ConstraintDefinitionNode)object4).bind(dDLStatementNode, dataDictionary);
            if (((ConstraintDefinitionNode)object4).getConstraintType() == 2 || ((ConstraintDefinitionNode)object4).getConstraintType() == 3) {
                string = null;
                object2 = null;
                for (int k = 0; k < vector.size(); ++k) {
                    Object object5;
                    object3 = vector.elementAt(k);
                    if (object3 instanceof ConstraintDefinitionNode) {
                        object5 = (ConstraintDefinitionNode)object3;
                        string = ((ConstraintDefinitionNode)object5).getConstraintMoniker();
                        object2 = ((ConstraintDefinitionNode)object5).getColumnList().getColumnNames();
                    } else if (object3 instanceof ConstraintDescriptor) {
                        object5 = (ConstraintDescriptor)object3;
                        string = ((ConstraintDescriptor)object5).getConstraintName();
                        object2 = ((ConstraintDescriptor)object5).getColumnDescriptors().getColumnNames();
                    }
                    if (!this.columnsMatch(((ConstraintDefinitionNode)object4).getColumnList().getColumnNames(), (String[])object2)) continue;
                    throw StandardException.newException("42Z93", ((ConstraintDefinitionNode)object4).getConstraintMoniker(), (Object)string);
                }
                vector.addElement(object4);
            }
            if (object4 instanceof ConstraintDefinitionNode) {
                this.checkForDuplicateConstraintNames(dDLStatementNode, hashtable2, ((ConstraintDefinitionNode)object4).getConstraintMoniker());
            }
            if (((ConstraintDefinitionNode)object4).getConstraintType() == 5 && (object3 = ((ConstraintDefinitionNode)object4).getConstraintMoniker()) != null) {
                string = ((ConstraintDefinitionNode)object4).getDropSchemaName();
                object2 = string == null ? tableDescriptor.getSchemaDescriptor() : this.getSchemaDescriptor(string);
                ConstraintDescriptor constraintDescriptor = dataDictionary.getConstraintDescriptorByName(tableDescriptor, (SchemaDescriptor)object2, (String)object3, false);
                if (constraintDescriptor == null) {
                    throw StandardException.newException("42X86", object2.getSchemaName() + "." + (String)object3, (Object)tableDescriptor.getQualifiedName());
                }
                this.getCompilerContext().createDependency(constraintDescriptor);
            }
            if (((ConstraintDefinitionNode)object4).hasPrimaryKeyConstraint()) {
                this.verifyUniqueColumnList(dDLStatementNode, (ConstraintDefinitionNode)object4);
                if (tableDescriptor == null) {
                    this.setColumnListToNotNull((ConstraintDefinitionNode)object4);
                    continue;
                }
                this.checkForNullColumns((ConstraintDefinitionNode)object4, tableDescriptor);
                continue;
            }
            if (((ConstraintDefinitionNode)object4).hasUniqueKeyConstraint()) {
                this.verifyUniqueColumnList(dDLStatementNode, (ConstraintDefinitionNode)object4);
                this.checkForNullColumns((ConstraintDefinitionNode)object4, tableDescriptor);
                continue;
            }
            if (!((ConstraintDefinitionNode)object4).hasForeignKeyConstraint()) continue;
            this.verifyUniqueColumnList(dDLStatementNode, (ConstraintDefinitionNode)object4);
        }
        if (n > 1) {
            throw StandardException.newException("428C1");
        }
    }

    public int countConstraints(int n) {
        int n2 = 0;
        int n3 = this.size();
        for (int j = 0; j < n3; ++j) {
            ConstraintDefinitionNode constraintDefinitionNode;
            TableElementNode tableElementNode = (TableElementNode)this.elementAt(j);
            if (!(tableElementNode instanceof ConstraintDefinitionNode) || n != (constraintDefinitionNode = (ConstraintDefinitionNode)tableElementNode).getConstraintType()) continue;
            ++n2;
        }
        return n2;
    }

    public int countNumberOfColumns() {
        return this.numColumns;
    }

    public int genColumnInfos(ColumnInfo[] columnInfoArray) {
        int n = 0;
        int n2 = this.size();
        for (int j = 0; j < n2; ++j) {
            if (((TableElementNode)this.elementAt(j)).getElementType() == 7) {
                columnInfoArray[j] = new ColumnInfo(((TableElementNode)this.elementAt(j)).getName(), null, null, null, null, null, 2, 0L, 0L);
                break;
            }
            if (!(this.elementAt(j) instanceof ColumnDefinitionNode)) {
                ++n;
                continue;
            }
            ColumnDefinitionNode columnDefinitionNode = (ColumnDefinitionNode)this.elementAt(j);
            columnInfoArray[j - n] = new ColumnInfo(columnDefinitionNode.getColumnName(), columnDefinitionNode.getDataTypeServices(), columnDefinitionNode.getDefaultValue(), columnDefinitionNode.getDefaultInfo(), null, columnDefinitionNode.getOldDefaultUUID(), columnDefinitionNode.getAction(), columnDefinitionNode.isAutoincrementColumn() ? columnDefinitionNode.getAutoincrementStart() : 0L, columnDefinitionNode.isAutoincrementColumn() ? columnDefinitionNode.getAutoincrementIncrement() : 0L);
            if (!columnDefinitionNode.hasConstraint()) continue;
            ++n;
        }
        return n;
    }

    public void appendNewColumnsToRCL(FromBaseTable fromBaseTable) throws StandardException {
        int n = this.size();
        ResultColumnList resultColumnList = fromBaseTable.getResultColumns();
        TableName tableName = fromBaseTable.getTableName();
        for (int j = 0; j < n; ++j) {
            if (!(this.elementAt(j) instanceof ColumnDefinitionNode)) continue;
            ColumnDefinitionNode columnDefinitionNode = (ColumnDefinitionNode)this.elementAt(j);
            ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(94, columnDefinitionNode.getColumnName(), tableName, columnDefinitionNode.getDataTypeServices(), this.getContextManager());
            ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, columnDefinitionNode.getDataTypeServices(), valueNode, this.getContextManager());
            resultColumn.setName(columnDefinitionNode.getColumnName());
            resultColumnList.addElement(resultColumn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindAndValidateCheckConstraints(FromList fromList) throws StandardException {
        FromBaseTable fromBaseTable = (FromBaseTable)fromList.elementAt(0);
        int n = this.size();
        CompilerContext compilerContext = this.getCompilerContext();
        Vector vector = new Vector();
        for (int j = 0; j < n; ++j) {
            Object object2;
            ConstraintDefinitionNode constraintDefinitionNode;
            TableElementNode tableElementNode = (TableElementNode)this.elementAt(j);
            if (!(tableElementNode instanceof ConstraintDefinitionNode) || (constraintDefinitionNode = (ConstraintDefinitionNode)tableElementNode).getConstraintType() != 4) continue;
            ValueNode valueNode = constraintDefinitionNode.getCheckCondition();
            int n2 = compilerContext.getReliability();
            try {
                object2 = new ProviderList();
                ProviderList providerList = compilerContext.getCurrentAuxiliaryProviderList();
                compilerContext.setCurrentAuxiliaryProviderList((ProviderList)object2);
                compilerContext.setReliability(1657);
                valueNode = valueNode.bindExpression(fromList, null, vector);
                if (vector.size() != 0) {
                    throw StandardException.newException("42Y01", constraintDefinitionNode.getConstraintText());
                }
                valueNode = valueNode.checkIsBoolean();
                constraintDefinitionNode.setCheckCondition(valueNode);
                if (((Hashtable)object2).size() > 0) {
                    constraintDefinitionNode.setAuxiliaryProviderList((ProviderList)object2);
                }
                compilerContext.setCurrentAuxiliaryProviderList(providerList);
            }
            finally {
                compilerContext.setReliability(n2);
            }
            object2 = fromBaseTable.getResultColumns();
            int n3 = ((ResultColumnList)object2).countReferencedColumns();
            int[] nArray = new int[n3];
            ((ResultColumnList)object2).recordColumnReferences(nArray, 1);
            constraintDefinitionNode.setCheckColumnReferences(nArray);
            ResultColumnList resultColumnList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
            ((ResultColumnList)object2).copyReferencedColumnsToNewList(resultColumnList);
            if (constraintDefinitionNode.getColumnList() != null) {
                String string = ((ResultColumn)constraintDefinitionNode.getColumnList().elementAt(0)).getName();
                if (n3 > 1 || !string.equals(((ResultColumn)resultColumnList.elementAt(0)).getName())) {
                    throw StandardException.newException("42621", string);
                }
            }
            constraintDefinitionNode.setColumnList(resultColumnList);
            ((ResultColumnList)object2).clearColumnReferences();
        }
    }

    void genConstraintActions(ConstraintConstantAction[] constraintConstantActionArray, String string, SchemaDescriptor schemaDescriptor, DataDictionary dataDictionary) throws StandardException {
        int n = this.size();
        int n2 = 0;
        for (int j = 0; j < n; ++j) {
            String[] stringArray = null;
            TableElementNode tableElementNode = (TableElementNode)this.elementAt(j);
            IndexConstantAction indexConstantAction = null;
            if (!tableElementNode.hasConstraint() || tableElementNode instanceof ColumnDefinitionNode) continue;
            ConstraintDefinitionNode constraintDefinitionNode = (ConstraintDefinitionNode)tableElementNode;
            if (constraintDefinitionNode.getColumnList() != null) {
                stringArray = new String[constraintDefinitionNode.getColumnList().size()];
                constraintDefinitionNode.getColumnList().exportNames(stringArray);
            }
            int n3 = constraintDefinitionNode.getConstraintType();
            String string2 = constraintDefinitionNode.getConstraintText();
            String string3 = constraintDefinitionNode.getConstraintMoniker();
            if (constraintDefinitionNode.requiresBackingIndex()) {
                indexConstantAction = this.genIndexAction(constraintDefinitionNode.requiresUniqueIndex(), null, constraintDefinitionNode, stringArray, true, schemaDescriptor, string, n3, dataDictionary);
            }
            if (n3 == 5) {
                constraintConstantActionArray[n2] = this.getGenericConstantActionFactory().getDropConstraintConstantAction(string3, constraintDefinitionNode.getDropSchemaName(), string, this.td.getUUID(), schemaDescriptor.getSchemaName(), indexConstantAction, constraintDefinitionNode.getDropBehavior(), constraintDefinitionNode.getVerifyType());
                continue;
            }
            ProviderList providerList = constraintDefinitionNode.getAuxiliaryProviderList();
            ConstraintInfo constraintInfo = null;
            ProviderInfo[] providerInfoArray = null;
            if (constraintDefinitionNode instanceof FKConstraintDefinitionNode) {
                constraintInfo = ((FKConstraintDefinitionNode)constraintDefinitionNode).getReferencedConstraintInfo();
            }
            if (providerList != null && providerList.size() > 0) {
                DependencyManager dependencyManager = dataDictionary.getDependencyManager();
                providerInfoArray = dependencyManager.getPersistentProviderInfos(providerList);
            } else {
                providerInfoArray = new ProviderInfo[]{};
            }
            constraintConstantActionArray[n2++] = this.getGenericConstantActionFactory().getCreateConstraintConstantAction(string3, n3, string, this.td != null ? this.td.getUUID() : (UUID)null, schemaDescriptor.getSchemaName(), stringArray, indexConstantAction, string2, true, constraintInfo, providerInfoArray);
        }
    }

    private boolean columnsMatch(String[] stringArray, String[] stringArray2) {
        boolean bl = true;
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        int n = stringArray.length;
        int n2 = stringArray2.length;
        for (int j = 0; j < n; ++j) {
            bl = false;
            for (int k = 0; k < n2; ++k) {
                if (!stringArray[j].equals(stringArray2[k])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private IndexConstantAction genIndexAction(boolean bl, String string, ConstraintDefinitionNode constraintDefinitionNode, String[] stringArray, boolean bl2, SchemaDescriptor schemaDescriptor, String string2, int n, DataDictionary dataDictionary) throws StandardException {
        if (string == null) {
            string = constraintDefinitionNode.getBackingIndexName(dataDictionary);
        }
        if (n == 5) {
            return this.getGenericConstantActionFactory().getDropIndexConstantAction(null, string, string2, schemaDescriptor.getSchemaName(), this.td.getUUID(), this.td.getHeapConglomerateId());
        }
        boolean[] blArray = new boolean[stringArray.length];
        for (int j = 0; j < blArray.length; ++j) {
            blArray[j] = true;
        }
        return this.getGenericConstantActionFactory().getCreateIndexConstantAction(bl, "BTREE", schemaDescriptor.getSchemaName(), string, string2, this.td != null ? this.td.getUUID() : (UUID)null, 0L, stringArray, blArray, bl2, constraintDefinitionNode.getBackingIndexUUID(), constraintDefinitionNode.getProperties());
    }

    private void checkForDuplicateColumns(DDLStatementNode dDLStatementNode, Hashtable hashtable, String string) throws StandardException {
        String string2 = hashtable.put(string, string);
        if (string2 != null && dDLStatementNode instanceof CreateTableNode) {
            throw StandardException.newException("42X12", string);
        }
    }

    private void checkForDuplicateConstraintNames(DDLStatementNode dDLStatementNode, Hashtable hashtable, String string) throws StandardException {
        if (string == null) {
            return;
        }
        String string2 = hashtable.put(string, string);
        if (string2 != null && dDLStatementNode instanceof CreateTableNode) {
            throw StandardException.newException("42X91", string);
        }
    }

    private void verifyUniqueColumnList(DDLStatementNode dDLStatementNode, ConstraintDefinitionNode constraintDefinitionNode) throws StandardException {
        String string;
        if (dDLStatementNode instanceof CreateTableNode && (string = constraintDefinitionNode.getColumnList().verifyCreateConstraintColumnList(this)) != null) {
            throw StandardException.newException("42X93", dDLStatementNode.getRelativeName(), (Object)string);
        }
        string = constraintDefinitionNode.getColumnList().verifyUniqueNames(false);
        if (string != null) {
            throw StandardException.newException("42X92", string);
        }
    }

    private void setColumnListToNotNull(ConstraintDefinitionNode constraintDefinitionNode) {
        ResultColumnList resultColumnList = constraintDefinitionNode.getColumnList();
        int n = resultColumnList.size();
        for (int j = 0; j < n; ++j) {
            String string = ((ResultColumn)resultColumnList.elementAt(j)).getName();
            DataTypeDescriptor dataTypeDescriptor = this.getColumnDataTypeDescriptor(string);
            dataTypeDescriptor.setNullability(false);
        }
    }

    private void checkForNullColumns(ConstraintDefinitionNode constraintDefinitionNode, TableDescriptor tableDescriptor) throws StandardException {
        ResultColumnList resultColumnList = constraintDefinitionNode.getColumnList();
        int n = resultColumnList.size();
        for (int j = 0; j < n; ++j) {
            String string = ((ResultColumn)resultColumnList.elementAt(j)).getName();
            DataTypeDescriptor dataTypeDescriptor = tableDescriptor == null ? this.getColumnDataTypeDescriptor(string) : this.getColumnDataTypeDescriptor(string, tableDescriptor);
            if (dataTypeDescriptor == null || !dataTypeDescriptor.isNullable()) continue;
            throw StandardException.newException("42831", string);
        }
    }

    private DataTypeDescriptor getColumnDataTypeDescriptor(String string) {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ColumnDefinitionNode columnDefinitionNode;
            TableElementNode tableElementNode = (TableElementNode)this.elementAt(j);
            if (!(tableElementNode instanceof ColumnDefinitionNode) || !string.equals((columnDefinitionNode = (ColumnDefinitionNode)tableElementNode).getColumnName())) continue;
            return columnDefinitionNode.getDataTypeServices();
        }
        return null;
    }

    private DataTypeDescriptor getColumnDataTypeDescriptor(String string, TableDescriptor tableDescriptor) {
        ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(string);
        if (columnDescriptor != null) {
            return columnDescriptor.getType();
        }
        return this.getColumnDataTypeDescriptor(string);
    }

    public boolean containsColumnName(String string) {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            TableElementNode tableElementNode = (TableElementNode)this.elementAt(j);
            if (!(tableElementNode instanceof ColumnDefinitionNode) || !string.equals(((ColumnDefinitionNode)tableElementNode).getName())) continue;
            return true;
        }
        return false;
    }
}

