/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.lang.reflect.Method;
import java.util.Vector;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.JSQLType;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.MethodCallNode;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.SQLToJavaValueNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class StaticMethodCallNode
extends MethodCallNode {
    private TableName procedureName;
    private LocalField[] outParamArrays;
    private int[] applicationParameterNumbers;
    private boolean isSystemCode;
    private boolean alreadyBound;
    private LocalField returnsNullOnNullState;
    AliasDescriptor ad;

    public void init(Object object2, Object object3) {
        if (object2 instanceof String) {
            this.init(object2);
        } else {
            this.procedureName = (TableName)object2;
            this.init(this.procedureName.getTableName());
        }
        this.javaClassName = (String)object3;
    }

    public JavaValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        if (this.alreadyBound) {
            return this;
        }
        this.bindParameters(fromList, subqueryList, vector);
        if (this.javaClassName == null) {
            object6 = this.getCompilerContext();
            if (this.ad == null && ((SchemaDescriptor)(object5 = this.getSchemaDescriptor((String)(object4 = this.procedureName != null ? this.procedureName.getSchemaName() : null), object4 != null))).getUUID() != null) {
                object3 = this.getDataDictionary().getRoutineList(((SchemaDescriptor)object5).getUUID().toString(), this.methodName, this.forCallStatement ? (char)'P' : 'F');
                for (int j = object3.size() - 1; j >= 0; --j) {
                    TypeDescriptor typeDescriptor;
                    object2 = (AliasDescriptor)object3.get(j);
                    RoutineAliasInfo routineAliasInfo = (RoutineAliasInfo)((AliasDescriptor)object2).getAliasInfo();
                    int n = routineAliasInfo.getParameterCount();
                    if (n != this.methodParms.length) continue;
                    TypeDescriptor[] typeDescriptorArray = routineAliasInfo.getParameterTypes();
                    int n2 = n;
                    if (routineAliasInfo.getMaxDynamicResultSets() > 0) {
                        ++n2;
                    }
                    this.signature = new JSQLType[n2];
                    for (int k = 0; k < n; ++k) {
                        Object object7;
                        Object object8;
                        TypeId typeId;
                        typeDescriptor = typeDescriptorArray[k];
                        TypeId typeId2 = typeId = TypeId.getBuiltInTypeId(typeDescriptor.getJDBCTypeId());
                        int n3 = routineAliasInfo.getParameterModes()[k];
                        if (n3 != 1) {
                            switch (typeId.getJDBCTypeId()) {
                                case -5: 
                                case 4: 
                                case 5: 
                                case 7: 
                                case 8: {
                                    object8 = this.getTypeCompiler(typeId).getCorrespondingPrimitiveTypeName().concat("[]");
                                    break;
                                }
                                default: {
                                    object8 = typeId.getCorrespondingJavaTypeName().concat("[]");
                                }
                            }
                            typeId = TypeId.getUserDefinedTypeId((String)object8, false);
                        }
                        object8 = new DataTypeDescriptor(typeId, typeDescriptor.getPrecision(), typeDescriptor.getScale(), typeDescriptor.isNullable(), typeDescriptor.getMaximumWidth());
                        this.signature[k] = new JSQLType((DataTypeDescriptor)object8);
                        ValueNode valueNode = null;
                        if (this.methodParms[k] instanceof SQLToJavaValueNode) {
                            SQLToJavaValueNode sQLToJavaValueNode = (SQLToJavaValueNode)this.methodParms[k];
                            valueNode = sQLToJavaValueNode.getSQLValueNode();
                        }
                        boolean bl = true;
                        if (valueNode == null || !valueNode.isParameterNode()) {
                            if (n3 != 1) {
                                throw StandardException.newException("42886", RoutineAliasInfo.parameterMode(n3), (Object)routineAliasInfo.getParameterNames()[k]);
                            }
                            bl = false;
                        } else {
                            if (this.applicationParameterNumbers == null) {
                                this.applicationParameterNumbers = new int[n];
                            }
                            this.applicationParameterNumbers[k] = ((ParameterNode)valueNode).getParameterNumber();
                        }
                        DataTypeDescriptor dataTypeDescriptor = new DataTypeDescriptor(typeId2, typeDescriptor.getPrecision(), typeDescriptor.getScale(), typeDescriptor.isNullable(), typeDescriptor.getMaximumWidth());
                        boolean bl2 = false;
                        if (!bl) {
                            if (valueNode instanceof UntypedNullConstantNode) {
                                valueNode.setDescriptor(dataTypeDescriptor);
                            } else {
                                TypeId typeId3;
                                if (valueNode != null) {
                                    typeId3 = valueNode.getTypeId();
                                    object7 = valueNode.getTypeServices();
                                } else {
                                    object7 = DataTypeDescriptor.getSQLDataTypeDescriptor(this.methodParms[k].getJavaTypeName());
                                    if (object7 == null) {
                                        throw StandardException.newException("X0X57.S", this.methodParms[k].getJavaTypeName());
                                    }
                                    typeId3 = ((DataTypeDescriptor)object7).getTypeId();
                                }
                                if (!this.getTypeCompiler(typeId2).storable(typeId3, this.getClassFactory())) {
                                    throw StandardException.newException("42821", typeId2.getSQLTypeName(), (Object)typeId3.getSQLTypeName());
                                }
                                if (!dataTypeDescriptor.isExactTypeAndLengthMatch((DataTypeDescriptor)object7)) {
                                    bl2 = true;
                                }
                            }
                        } else if (typeId2.variableLength() && n3 != 4) {
                            bl2 = true;
                        }
                        if (bl2) {
                            if (valueNode == null) {
                                valueNode = (ValueNode)this.getNodeFactory().getNode(36, this.methodParms[k], this.getContextManager());
                            }
                            object7 = (ValueNode)this.getNodeFactory().getNode(60, valueNode, dataTypeDescriptor, this.getContextManager());
                            this.methodParms[k] = (JavaValueNode)this.getNodeFactory().getNode(28, object7, this.getContextManager());
                            this.methodParms[k] = this.methodParms[k].bindExpression(fromList, subqueryList, vector);
                        }
                        if (!bl) continue;
                        valueNode.setDescriptor(dataTypeDescriptor);
                    }
                    if (n2 != n) {
                        TypeId typeId = TypeId.getUserDefinedTypeId("java.sql.ResultSet[]", false);
                        typeDescriptor = new DataTypeDescriptor(typeId, 0, 0, false, -1);
                        this.signature[n] = new JSQLType((DataTypeDescriptor)typeDescriptor);
                    }
                    this.routineInfo = routineAliasInfo;
                    this.ad = object2;
                    if (!((SchemaDescriptor)object5).isSystemSchema() || routineAliasInfo.getReturnType() != null || routineAliasInfo.getSQLAllowed() == 3) break;
                    this.isSystemCode = true;
                    break;
                }
            }
            if (this.ad == null) {
                object4 = this.procedureName == null ? this.methodName : this.procedureName;
                throw StandardException.newException("42Y03", object4);
            }
            object6.createDependency(this.ad);
            this.methodName = this.ad.getAliasInfo().getMethodName();
            this.javaClassName = this.ad.getJavaClassName();
        }
        this.javaClassName = this.verifyClassExist(this.javaClassName, true);
        this.resolveMethodCall(this.javaClassName, true);
        this.alreadyBound = true;
        if (this.routineInfo != null && (object6 = this.routineInfo.getReturnType()) != null && ((TypeId)(object4 = TypeId.getBuiltInTypeId(object6.getJDBCTypeId()))).variableLength()) {
            object5 = new DataTypeDescriptor((TypeId)object4, object6.getPrecision(), object6.getScale(), object6.isNullable(), object6.getMaximumWidth());
            object3 = (ValueNode)this.getNodeFactory().getNode(36, this, this.getContextManager());
            ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(60, object3, object5, this.getContextManager());
            object2 = (JavaValueNode)this.getNodeFactory().getNode(28, valueNode, this.getContextManager());
            return ((JavaValueNode)object2).bindExpression(fromList, subqueryList, vector);
        }
        return this;
    }

    public void generateOneParameter(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, int n) throws StandardException {
        Object object2;
        String string;
        int n2;
        SQLToJavaValueNode sQLToJavaValueNode = null;
        if (this.methodParms[n] instanceof SQLToJavaValueNode) {
            sQLToJavaValueNode = (SQLToJavaValueNode)this.methodParms[n];
        }
        if (this.routineInfo != null) {
            n2 = this.routineInfo.getParameterModes()[n];
        } else {
            n2 = 1;
            if (sQLToJavaValueNode != null && sQLToJavaValueNode.getSQLValueNode().isParameterNode()) {
                int n3 = ((ParameterNode)sQLToJavaValueNode.getSQLValueNode()).getParameterNumber();
                string = this.methodParameterTypes[n];
                if (string.endsWith("[]")) {
                    object2 = expressionClassBuilder.getConstructor();
                    expressionClassBuilder.pushThisAsActivation((MethodBuilder)object2);
                    object2.callMethod((short)185, null, "getParameterValueSet", "org.apache.derby.iapi.sql.ParameterValueSet", 0);
                    object2.push(n3);
                    object2.push(0);
                    object2.callMethod((short)185, null, "setParameterMode", "void", 2);
                    object2.endStatement();
                }
            }
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                if (sQLToJavaValueNode != null) {
                    sQLToJavaValueNode.returnsNullOnNullState = this.returnsNullOnNullState;
                }
                super.generateOneParameter(expressionClassBuilder, methodBuilder, n);
                break;
            }
        }
        switch (n2) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 4: {
                String string2 = this.methodParameterTypes[n];
                string = string2.substring(0, string2.length() - 2);
                object2 = expressionClassBuilder.newFieldDeclaration(2, string2);
                if (this.outParamArrays == null) {
                    this.outParamArrays = new LocalField[this.methodParms.length];
                }
                this.outParamArrays[n] = object2;
                methodBuilder.pushNewArray(string, 1);
                methodBuilder.putField((LocalField)object2);
                if (n2 == 4) break;
                methodBuilder.swap();
                methodBuilder.setArrayElement(0);
                methodBuilder.getField((LocalField)object2);
            }
        }
    }

    public boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        if (bl) {
            return false;
        }
        boolean bl2 = true;
        bl2 = bl2 && super.categorize(jBitSet, bl);
        return bl2;
    }

    public String toString() {
        return "";
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n;
        Object object2;
        int n2;
        int n3;
        if (this.routineInfo != null && !this.routineInfo.calledOnNullInput() && this.routineInfo.getParameterCount() != 0) {
            this.returnsNullOnNullState = expressionClassBuilder.newFieldDeclaration(2, "boolean");
        }
        if (this.returnsNullOnNullState != null) {
            methodBuilder.push(false);
            methodBuilder.setField(this.returnsNullOnNullState);
            methodBuilder.pushThis();
        }
        int n4 = this.generateParameters(expressionClassBuilder, methodBuilder);
        LocalField localField = null;
        if (this.routineInfo != null) {
            boolean bl;
            n3 = this.routineInfo.getSQLAllowed();
            if (n3 != 3) {
                n2 = n3 == 1 ? 1 : (n3 == 0 ? 0 : 2);
                this.generateAuthorizeCheck((ActivationClassBuilder)expressionClassBuilder, methodBuilder, n2);
            }
            n2 = this.isSystemCode ? 2 : 1;
            boolean bl2 = bl = this.routineInfo.getReturnType() != null;
            if (bl) {
                ++n2;
            }
            if (n2 != 0) {
                expressionClassBuilder.pushThisAsActivation(methodBuilder);
                methodBuilder.callMethod((short)185, null, "getLanguageConnectionContext", "org.apache.derby.iapi.sql.conn.LanguageConnectionContext", 0);
                methodBuilder.callMethod((short)185, null, "getStatementContext", "org.apache.derby.iapi.sql.conn.StatementContext", 0);
                for (int j = 1; j < n2; ++j) {
                    methodBuilder.dup();
                }
            }
            if (this.isSystemCode) {
                methodBuilder.callMethod((short)185, null, "setSystemCode", "void", 0);
            }
            if (bl) {
                localField = expressionClassBuilder.newFieldDeclaration(2, "short");
                methodBuilder.callMethod((short)185, null, "getSQLAllowed", "short", 0);
                methodBuilder.setField(localField);
            }
            methodBuilder.push((short)n3);
            methodBuilder.push(false);
            methodBuilder.callMethod((short)185, null, "setSQLAllowed", "void", 2);
        }
        if (this.routineInfo != null && (n3 = this.methodParameterTypes.length - this.methodParms.length) != 0) {
            n2 = this.routineInfo.getMaxDynamicResultSets();
            if (n2 > 0) {
                MethodBuilder methodBuilder2 = expressionClassBuilder.getClassBuilder().newMethodBuilder(1, "int", "getMaxDynamicResults");
                methodBuilder2.push(n2);
                methodBuilder2.methodReturn();
                methodBuilder2.complete();
            }
            MethodBuilder methodBuilder3 = expressionClassBuilder.getClassBuilder().newMethodBuilder(1, "java.sql.ResultSet[][]", "getDynamicResults");
            MethodBuilder methodBuilder4 = expressionClassBuilder.getConstructor();
            object2 = expressionClassBuilder.newFieldDeclaration(2, "java.sql.ResultSet[][]");
            methodBuilder3.getField((LocalField)object2);
            methodBuilder4.pushNewArray("java.sql.ResultSet[]", n3);
            methodBuilder4.setField((LocalField)object2);
            for (n = 0; n < n3; ++n) {
                methodBuilder.pushNewArray("java.sql.ResultSet", 1);
                methodBuilder.dup();
                methodBuilder.getField((LocalField)object2);
                methodBuilder.swap();
                methodBuilder.setArrayElement(n);
            }
            methodBuilder3.methodReturn();
            methodBuilder3.complete();
            n4 += n3;
        }
        String string = this.getJavaTypeName();
        MethodBuilder methodBuilder5 = null;
        MethodBuilder methodBuilder6 = methodBuilder;
        if (this.returnsNullOnNullState != null) {
            int n5;
            methodBuilder5 = expressionClassBuilder.newGeneratedFun(string, 2, this.methodParameterTypes);
            Class<?>[] classArray = ((Method)this.method).getExceptionTypes();
            for (n5 = 0; n5 < classArray.length; ++n5) {
                methodBuilder5.addThrownException(classArray[n5].getName());
            }
            methodBuilder5.getField(this.returnsNullOnNullState);
            methodBuilder5.conditionalIf();
            methodBuilder5.pushNull(string);
            methodBuilder5.startElseCode();
            if (!this.actualMethodReturnType.equals(string)) {
                methodBuilder5.pushNewStart(string);
            }
            for (n5 = 0; n5 < n4; ++n5) {
                methodBuilder5.getParameter(n5);
            }
            methodBuilder6 = methodBuilder5;
        }
        methodBuilder6.callMethod((short)184, this.method.getDeclaringClass().getName(), this.methodName, this.actualMethodReturnType, n4);
        if (this.returnsNullOnNullState != null) {
            if (!this.actualMethodReturnType.equals(string)) {
                methodBuilder5.pushNewComplete(1);
            }
            methodBuilder5.completeConditional();
            methodBuilder5.methodReturn();
            methodBuilder5.complete();
            methodBuilder.callMethod((short)182, expressionClassBuilder.getClassBuilder().getFullName(), methodBuilder5.getName(), string, n4);
            methodBuilder5 = null;
        }
        if (this.routineInfo != null) {
            if (localField != null) {
                expressionClassBuilder.pushThisAsActivation(methodBuilder);
                methodBuilder.callMethod((short)185, null, "getLanguageConnectionContext", "org.apache.derby.iapi.sql.conn.LanguageConnectionContext", 0);
                methodBuilder.callMethod((short)185, null, "getStatementContext", "org.apache.derby.iapi.sql.conn.StatementContext", 0);
                methodBuilder.getField(localField);
                methodBuilder.push(true);
                methodBuilder.callMethod((short)185, null, "setSQLAllowed", "void", 2);
            }
            if (this.outParamArrays != null) {
                MethodBuilder methodBuilder7 = expressionClassBuilder.getConstructor();
                expressionClassBuilder.pushThisAsActivation(methodBuilder7);
                methodBuilder7.callMethod((short)185, null, "getParameterValueSet", "org.apache.derby.iapi.sql.ParameterValueSet", 0);
                expressionClassBuilder.pushThisAsActivation(methodBuilder);
                methodBuilder.callMethod((short)185, null, "getParameterValueSet", "org.apache.derby.iapi.sql.ParameterValueSet", 0);
                object2 = this.routineInfo.getParameterModes();
                for (n = 0; n < this.outParamArrays.length; ++n) {
                    Object object3 = object2[n];
                    if (object3 == true) continue;
                    ValueNode valueNode = ((SQLToJavaValueNode)this.methodParms[n]).getSQLValueNode();
                    int n6 = this.applicationParameterNumbers[n];
                    methodBuilder7.dup();
                    methodBuilder7.push(n6);
                    methodBuilder7.push((int)object3);
                    methodBuilder7.callMethod((short)185, null, "setParameterMode", "void", 2);
                    LocalField localField2 = this.outParamArrays[n];
                    methodBuilder.dup();
                    methodBuilder.push(n6);
                    methodBuilder.callMethod((short)185, null, "getParameter", "org.apache.derby.iapi.types.DataValueDescriptor", 1);
                    DataTypeDescriptor dataTypeDescriptor = valueNode.getTypeServices();
                    boolean bl = dataTypeDescriptor.getTypeId().isNumericTypeId();
                    boolean bl3 = ((Method)this.method).getParameterTypes()[n].getComponentType().isPrimitive();
                    if (bl) {
                        if (!bl3) {
                            methodBuilder.cast("org.apache.derby.iapi.types.NumberDataValue");
                        }
                    } else if (dataTypeDescriptor.getTypeId().isBooleanTypeId() && !bl3) {
                        methodBuilder.cast("org.apache.derby.iapi.types.BooleanDataValue");
                    }
                    if (dataTypeDescriptor.getTypeId().variableLength()) {
                        methodBuilder.dup();
                    }
                    methodBuilder.getField(localField2);
                    methodBuilder.getArrayElement(0);
                    if (bl && !bl3) {
                        methodBuilder.upCast("java.lang.Number");
                    }
                    methodBuilder.callMethod((short)185, null, "setValue", "void", 1);
                    if (!dataTypeDescriptor.getTypeId().variableLength()) continue;
                    methodBuilder.push(bl ? dataTypeDescriptor.getPrecision() : dataTypeDescriptor.getMaximumWidth());
                    methodBuilder.push(dataTypeDescriptor.getScale());
                    methodBuilder.push(bl);
                    methodBuilder.callMethod((short)185, "org.apache.derby.iapi.types.VariableSizeDataValue", "setWidth", "org.apache.derby.iapi.types.DataValueDescriptor", 3);
                    methodBuilder.endStatement();
                }
                methodBuilder7.endStatement();
                methodBuilder.endStatement();
            }
        }
    }
}

