/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.JSQLType;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class SQLToJavaValueNode
extends JavaValueNode {
    ValueNode value;
    LocalField returnsNullOnNullState;

    public void init(Object object2) {
        this.value = (ValueNode)object2;
    }

    public void printSubNodes(int n) {
    }

    public String getJavaTypeName() {
        JSQLType jSQLType = this.getJSQLType();
        if (jSQLType == null) {
            return "";
        }
        return this.mapToTypeID(jSQLType).getCorrespondingJavaTypeName();
    }

    public String getPrimitiveTypeName() throws StandardException {
        JSQLType jSQLType = this.getJSQLType();
        if (jSQLType == null) {
            return "";
        }
        return this.getTypeCompiler(this.mapToTypeID(jSQLType)).getCorrespondingPrimitiveTypeName();
    }

    public JSQLType getJSQLType() {
        if (this.jsqlType == null) {
            if (this.value.isParameterNode()) {
                this.jsqlType = ((ParameterNode)this.value).getJSQLType();
            } else {
                DataTypeDescriptor dataTypeDescriptor = this.value.getTypeServices();
                if (dataTypeDescriptor != null) {
                    this.jsqlType = new JSQLType(dataTypeDescriptor);
                }
            }
        }
        return this.jsqlType;
    }

    public void setClause(int n) {
        super.setClause(n);
        this.value.setClause(n);
    }

    public JavaValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        this.value = this.value.bindExpression(fromList, subqueryList, vector);
        return this;
    }

    public JavaValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.value = this.value.remapColumnReferencesToExpressions();
        return this;
    }

    public boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        return this.value.categorize(jBitSet, bl);
    }

    public void preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        this.value.preprocess(n, fromList, subqueryList, predicateList);
    }

    protected int getOrderableVariantType() throws StandardException {
        return this.value.getOrderableVariantType();
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.generateSQLValue(expressionClassBuilder, methodBuilder);
        this.generateJavaValue(expressionClassBuilder, methodBuilder);
    }

    public void generateSQLValue(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.value.generateExpression(expressionClassBuilder, methodBuilder);
    }

    public void generateJavaValue(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        if (this.isPrimitiveType() || this.mustCastToPrimitive()) {
            String string = this.value.getTypeCompiler().getCorrespondingPrimitiveTypeName();
            String[] stringArray = new String[]{this.getSQLValueInterfaceName()};
            MethodBuilder methodBuilder2 = expressionClassBuilder.newGeneratedFun(string, 2, stringArray);
            methodBuilder2.getParameter(0);
            if (this.returnsNullOnNullState != null) {
                this.generateReturnsNullOnNullCheck(methodBuilder2);
            } else {
                methodBuilder2.dup();
                methodBuilder2.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
                methodBuilder2.push(string);
                methodBuilder2.callMethod((short)184, "org.apache.derby.impl.sql.execute.BaseActivation", "nullToPrimitiveTest", "void", 2);
            }
            methodBuilder2.callMethod((short)185, "org.apache.derby.iapi.types.DataValueDescriptor", this.value.getTypeCompiler().getPrimitiveMethodName(), string, 0);
            methodBuilder2.methodReturn();
            methodBuilder2.complete();
            methodBuilder.pushThis();
            methodBuilder.swap();
            methodBuilder.callMethod((short)182, null, methodBuilder2.getName(), string, 1);
        } else {
            if (this.returnsNullOnNullState != null) {
                this.generateReturnsNullOnNullCheck(methodBuilder);
            }
            methodBuilder.callMethod((short)185, "org.apache.derby.iapi.types.DataValueDescriptor", "getObject", "java.lang.Object", 0);
            methodBuilder.cast(this.value.getTypeId().getCorrespondingJavaTypeName());
        }
    }

    private void generateReturnsNullOnNullCheck(MethodBuilder methodBuilder) {
        methodBuilder.dup();
        methodBuilder.callMethod((short)185, "org.apache.derby.iapi.services.io.Storable", "isNull", "boolean", 0);
        methodBuilder.conditionalIf();
        methodBuilder.push(true);
        methodBuilder.startElseCode();
        methodBuilder.getField(this.returnsNullOnNullState);
        methodBuilder.completeConditional();
        methodBuilder.setField(this.returnsNullOnNullState);
    }

    public String getSQLValueInterfaceName() throws StandardException {
        return this.value.getTypeCompiler().interfaceName();
    }

    ValueNode getSQLValueNode() {
        return this.value;
    }

    Object getConstantValueAsObject() throws StandardException {
        return this.value.getConstantValueAsObject();
    }

    public Visitable accept(Visitor visitor) throws StandardException {
        Visitable visitable = visitor.visit(this);
        if (visitor.skipChildren(this)) {
            return visitable;
        }
        if (this.value != null && !visitor.stopTraversal()) {
            this.value = (ValueNode)this.value.accept(visitor);
        }
        return visitable;
    }
}

