/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.sql.ResultSetMetaData;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.derby.catalog.types.DefaultInfoImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.compile.NodeFactory;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionContext;
import org.apache.derby.iapi.store.access.StoreCostController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.AllResultColumn;
import org.apache.derby.impl.sql.compile.BaseColumnNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.CurrentRowLocationNode;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.DefaultNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableElementList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.TableOperatorNode;
import org.apache.derby.impl.sql.compile.UnionNode;
import org.apache.derby.impl.sql.compile.UpdateNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;

public class ResultColumnList
extends QueryTreeNodeVector {
    protected boolean indexRow;
    protected long conglomerateId;
    int orderBySelect = 0;
    protected boolean forUpdate;
    private boolean countMismatchAllowed;
    private int initialListSize = 0;

    public void addResultColumn(ResultColumn resultColumn) {
        resultColumn.setVirtualColumnId(this.size() + 1);
        this.addElement(resultColumn);
    }

    public void appendResultColumns(ResultColumnList resultColumnList, boolean bl) {
        int n = this.size();
        int n2 = n + 1;
        int n3 = resultColumnList.size();
        for (int j = 0; j < n3; ++j) {
            ((ResultColumn)resultColumnList.elementAt(j)).setVirtualColumnId(n2);
            ++n2;
        }
        if (bl) {
            this.destructiveAppend(resultColumnList);
        } else {
            this.nondestructiveAppend(resultColumnList);
        }
    }

    public ResultColumn getResultColumn(int n) {
        ResultColumn resultColumn;
        if (n <= this.size() && (resultColumn = (ResultColumn)this.elementAt(n - 1)).getColumnPosition() == n) {
            return resultColumn;
        }
        int n2 = this.size();
        for (int j = 0; j < n2; ++j) {
            ResultColumn resultColumn2 = (ResultColumn)this.elementAt(j);
            if (resultColumn2.getColumnPosition() != n) continue;
            return resultColumn2;
        }
        return null;
    }

    public ResultColumn getOrderByColumn(int n) {
        if (n == 0) {
            return null;
        }
        return this.getResultColumn(n);
    }

    public ResultColumn getResultColumn(String string) {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            if (!string.equals(resultColumn.getName())) continue;
            resultColumn.setReferenced();
            return resultColumn;
        }
        return null;
    }

    public ResultColumn getResultColumn(String string, String string2) {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            if (string != null && (resultColumn.getTableName() == null || !string.equals(resultColumn.getTableName())) || !string2.equals(resultColumn.getName())) continue;
            resultColumn.setReferenced();
            return resultColumn;
        }
        return null;
    }

    public ResultColumn getAtMostOneResultColumn(ColumnReference columnReference, String string) throws StandardException {
        int n = this.size();
        ResultColumn resultColumn = null;
        String string2 = columnReference.getColumnName();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn2 = (ResultColumn)this.elementAt(j);
            if (!string2.equals(resultColumn2.getName())) continue;
            if (resultColumn != null) {
                throw StandardException.newException("42Y34", string2, (Object)string);
            }
            resultColumn2.setReferenced();
            resultColumn = resultColumn2;
        }
        return resultColumn;
    }

    public ResultColumn getOrderByColumn(String string, TableName tableName, int n) throws StandardException {
        int n2 = this.size();
        ResultColumn resultColumn = null;
        for (int j = 0; j < n2; ++j) {
            ColumnReference columnReference;
            ValueNode valueNode;
            ResultColumn resultColumn2 = (ResultColumn)this.elementAt(j);
            if (tableName != null && (!((valueNode = resultColumn2.getExpression()) instanceof ColumnReference) || !tableName.equals((columnReference = (ColumnReference)valueNode).getTableNameNode()) && n != columnReference.getTableNumber()) || !string.equals(resultColumn2.getName())) continue;
            if (resultColumn == null) {
                resultColumn = resultColumn2;
                continue;
            }
            if (j < n2 - this.orderBySelect) {
                throw StandardException.newException("42X79", string);
            }
            this.removeElement(resultColumn2);
            this.decOrderBySelect();
            break;
        }
        return resultColumn;
    }

    public ResultColumn getOrderByColumn(String string, TableName tableName) throws StandardException {
        int n = this.size();
        ResultColumn resultColumn = null;
        for (int j = 0; j < n; ++j) {
            ColumnReference columnReference;
            ValueNode valueNode;
            ResultColumn resultColumn2 = (ResultColumn)this.elementAt(j);
            if (tableName != null && ((valueNode = resultColumn2.getExpression()) == null || !(valueNode instanceof ColumnReference) || !tableName.equals((columnReference = (ColumnReference)valueNode).getTableNameNode())) || !string.equals(resultColumn2.getName())) continue;
            if (resultColumn == null) {
                resultColumn = resultColumn2;
                continue;
            }
            if (j < n - this.orderBySelect) {
                throw StandardException.newException("42X79", string);
            }
            this.removeElement(resultColumn2);
            this.decOrderBySelect();
            break;
        }
        return resultColumn;
    }

    void copyResultColumnNames(ResultColumnList resultColumnList) {
        int n = this.countMismatchAllowed ? resultColumnList.size() : this.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            ResultColumn resultColumn2 = (ResultColumn)resultColumnList.elementAt(j);
            resultColumn.setName(resultColumn2.getName());
            resultColumn.setNameGenerated(resultColumn2.isNameGenerated());
        }
    }

    public void treePrint(int n) {
    }

    public void bindExpressions(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        this.expandAllsAndNameColumns(fromList);
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ValueNode valueNode = (ValueNode)this.elementAt(j);
            valueNode = ((ResultColumn)valueNode).bindExpression(fromList, subqueryList, vector);
            this.setElementAt(valueNode, j);
        }
    }

    public void bindResultColumnsToExpressions() throws StandardException {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ((ResultColumn)this.elementAt(j)).bindResultColumnToExpression();
        }
    }

    public void bindResultColumnsByName(TableDescriptor tableDescriptor, DMLStatementNode dMLStatementNode) throws StandardException {
        int n = this.size();
        Hashtable<String, String> hashtable = new Hashtable<String, String>(n + 2, 0.999f);
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            String string = resultColumn.getName();
            String string2 = hashtable.put(string, string);
            if (string2 != null && string2.equals(string)) {
                if (dMLStatementNode instanceof UpdateNode) {
                    throw StandardException.newException("42X16", string);
                }
                throw StandardException.newException("42X13", string);
            }
            resultColumn.bindResultColumnByName(tableDescriptor, j + 1);
        }
    }

    public void bindResultColumnsByName(ResultColumnList resultColumnList, FromVTI fromVTI, DMLStatementNode dMLStatementNode) throws StandardException {
        int n = this.size();
        Hashtable<String, String> hashtable = new Hashtable<String, String>(n + 2, 0.999f);
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            String string = resultColumn.getName();
            String string2 = hashtable.put(string, string);
            if (string2 != null && string2.equals(string)) {
                if (dMLStatementNode instanceof UpdateNode) {
                    throw StandardException.newException("42X16", string);
                }
                throw StandardException.newException("42X13", string);
            }
            ResultColumn resultColumn2 = resultColumnList.getResultColumn(null, resultColumn.getName());
            if (resultColumn2 == null) {
                throw StandardException.newException("42X14", resultColumn.getName(), (Object)fromVTI.getNewInvocation().getJavaClassName());
            }
            ColumnDescriptor columnDescriptor = new ColumnDescriptor(resultColumn.getName(), resultColumn2.getVirtualColumnId(), resultColumn2.getType(), null, null, (TableDescriptor)null, null, 0L, 0L);
            resultColumn.setColumnDescriptor(null, columnDescriptor);
            resultColumn.setVirtualColumnId(j + 1);
        }
    }

    public void bindResultColumnsByPosition(TableDescriptor tableDescriptor) throws StandardException {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ((ResultColumn)this.elementAt(j)).bindResultColumnByPosition(tableDescriptor, j + 1);
        }
    }

    public void preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        int n2 = this.size();
        for (int j = 0; j < n2; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            this.setElementAt(resultColumn.preprocess(n, fromList, subqueryList, predicateList), j);
        }
    }

    void checkStorableExpressions(ResultColumnList resultColumnList) throws StandardException {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(j);
            ((ResultColumn)this.elementAt(j)).checkStorableExpression(resultColumn);
        }
    }

    public int[] getStreamStorableColIds(int n) throws StandardException {
        int n2;
        int n3 = 0;
        boolean[] blArray = new boolean[n];
        int n4 = this.size();
        for (n2 = 0; n2 < n4; ++n2) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n2);
            if (!resultColumn.getTypeId().streamStorable()) continue;
            ColumnDescriptor columnDescriptor = resultColumn.getTableColumnDescriptor();
            blArray[columnDescriptor.getPosition() - 1] = true;
        }
        for (n2 = 0; n2 < blArray.length; ++n2) {
            if (!blArray[n2]) continue;
            ++n3;
        }
        if (n3 == 0) {
            return null;
        }
        int[] nArray = new int[n3];
        int n5 = 0;
        for (int j = 0; j < blArray.length; ++j) {
            if (!blArray[j]) continue;
            nArray[n5++] = j;
        }
        return nArray;
    }

    void checkStorableExpressions() throws StandardException {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ((ResultColumn)this.elementAt(j)).checkStorableExpression();
        }
    }

    public void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.generateCore(activationClassBuilder, methodBuilder, false);
    }

    void generateNulls(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.generateCore(activationClassBuilder, methodBuilder, true);
    }

    void generateCore(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, boolean bl) throws StandardException {
        MethodBuilder methodBuilder2 = expressionClassBuilder.newUserExprFun();
        LocalField localField = expressionClassBuilder.newFieldDeclaration(2, "org.apache.derby.iapi.sql.execute.ExecRow");
        this.genCreateRow(expressionClassBuilder, localField, "getValueRow", "org.apache.derby.iapi.sql.execute.ExecRow", this.size());
        int n = this.size();
        MethodBuilder methodBuilder3 = expressionClassBuilder.getConstructor();
        for (int j = 0; j < n; ++j) {
            ValueNode valueNode;
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            if (!bl && ((valueNode = resultColumn.getExpression()) instanceof VirtualColumnNode && !((VirtualColumnNode)valueNode).getCorrelated() || valueNode instanceof ColumnReference && !((ColumnReference)valueNode).getCorrelated())) continue;
            if (!bl && resultColumn.getExpression() instanceof ConstantNode && !((ConstantNode)resultColumn.getExpression()).isNull() && !methodBuilder3.statementNumHitLimit(1)) {
                methodBuilder3.getField(localField);
                methodBuilder3.push(j + 1);
                resultColumn.generateExpression(expressionClassBuilder, methodBuilder3);
                methodBuilder3.cast("org.apache.derby.iapi.types.DataValueDescriptor");
                methodBuilder3.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "setColumn", "void", 2);
                continue;
            }
            methodBuilder2.getField(localField);
            methodBuilder2.push(j + 1);
            boolean bl2 = true;
            if (resultColumn.isAutoincrementGenerated()) {
                methodBuilder2.pushThis();
                methodBuilder2.push(resultColumn.getColumnPosition());
                methodBuilder2.push(resultColumn.getTableColumnDescriptor().getAutoincInc());
                methodBuilder2.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", "getSetAutoincrementValue", "org.apache.derby.iapi.types.DataValueDescriptor", 2);
                bl2 = false;
            } else if (bl || resultColumn.getExpression() instanceof ConstantNode && ((ConstantNode)resultColumn.getExpression()).isNull()) {
                methodBuilder2.getField(localField);
                methodBuilder2.push(j + 1);
                methodBuilder2.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "getColumn", "org.apache.derby.iapi.types.DataValueDescriptor", 1);
                expressionClassBuilder.generateNullWithExpress(methodBuilder2, resultColumn.getTypeCompiler());
            } else {
                resultColumn.generateExpression(expressionClassBuilder, methodBuilder2);
            }
            if (bl2) {
                methodBuilder2.cast("org.apache.derby.iapi.types.DataValueDescriptor");
            }
            methodBuilder2.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "setColumn", "void", 2);
        }
        methodBuilder2.getField(localField);
        methodBuilder2.methodReturn();
        methodBuilder2.complete();
        expressionClassBuilder.pushMethodReference(methodBuilder, methodBuilder2);
    }

    public ExecRow buildEmptyRow() throws StandardException {
        int n = this.size();
        ExecRow execRow = this.getExecutionFactory().getValueRow(n);
        int n2 = 1;
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            DataTypeDescriptor dataTypeDescriptor = resultColumn.getTypeServices();
            DataValueDescriptor dataValueDescriptor = dataTypeDescriptor.getNull();
            execRow.setColumn(n2++, dataValueDescriptor);
        }
        return execRow;
    }

    public ExecRow buildEmptyIndexRow(TableDescriptor tableDescriptor, ConglomerateDescriptor conglomerateDescriptor, StoreCostController storeCostController, DataDictionary dataDictionary) throws StandardException {
        int[] nArray = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions();
        ExecRow execRow = this.getExecutionFactory().getValueRow(nArray.length + 1);
        for (int j = 0; j < nArray.length; ++j) {
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(nArray[j]);
            DataTypeDescriptor dataTypeDescriptor = columnDescriptor.getType();
            DataValueDescriptor dataValueDescriptor = dataTypeDescriptor.getNull();
            execRow.setColumn(j + 1, dataValueDescriptor);
        }
        RowLocation rowLocation = storeCostController.newRowLocationTemplate();
        execRow.setColumn(nArray.length + 1, rowLocation);
        return execRow;
    }

    void generateHolder(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.generateHolder(expressionClassBuilder, methodBuilder, null, null);
    }

    void generateHolder(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, FormatableBitSet formatableBitSet, FormatableBitSet formatableBitSet2) throws StandardException {
        expressionClassBuilder.pushMethodReference(methodBuilder, this.generateHolderMethod(expressionClassBuilder, formatableBitSet, formatableBitSet2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MethodBuilder generateHolderMethod(ExpressionClassBuilder expressionClassBuilder, FormatableBitSet formatableBitSet, FormatableBitSet formatableBitSet2) throws StandardException {
        String string;
        String string2;
        int n = -1;
        if (formatableBitSet != null) {
            int n2 = formatableBitSet.anySetBit();
            while (n2 != -1) {
                n = n2;
                n2 = formatableBitSet.anySetBit(n2);
            }
        } else {
            n = this.size() - 1;
        }
        MethodBuilder methodBuilder = expressionClassBuilder.newExprFun();
        if (this.indexRow) {
            string2 = "getIndexableRow";
            string = "org.apache.derby.iapi.sql.execute.ExecIndexRow";
        } else {
            string2 = "getValueRow";
            string = "org.apache.derby.iapi.sql.execute.ExecRow";
        }
        int n3 = this.size();
        LocalField localField = expressionClassBuilder.newFieldDeclaration(2, "org.apache.derby.iapi.sql.execute.ExecRow");
        this.genCreateRow(expressionClassBuilder, localField, string2, string, n + 1);
        int n4 = formatableBitSet != null ? formatableBitSet.anySetBit() : 0;
        for (int j = 0; j < n3; ++j) {
            Object object2;
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            if (resultColumn.getExpression() instanceof CurrentRowLocationNode) {
                RowLocation rowLocation;
                object2 = null;
                object2 = this.getLanguageConnectionContext().getTransactionCompile().openConglomerate(this.conglomerateId, false, 0, 6, 2);
                try {
                    rowLocation = object2.newRowLocationTemplate();
                }
                finally {
                    if (object2 != null) {
                        object2.close();
                    }
                }
                int n5 = expressionClassBuilder.addItem(rowLocation);
                methodBuilder.getField(localField);
                methodBuilder.push(n + 1);
                methodBuilder.pushThis();
                methodBuilder.push(n5);
                methodBuilder.callMethod((short)185, "org.apache.derby.iapi.sql.Activation", "getRowLocationTemplate", "org.apache.derby.iapi.types.RowLocation", 1);
                methodBuilder.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
                methodBuilder.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "setColumn", "void", 2);
                continue;
            }
            if (formatableBitSet2 != null && formatableBitSet2.getNumBitsSet() != 0 && (object2 = resultColumn.getExpression()) instanceof VirtualColumnNode) continue;
            methodBuilder.getField(localField);
            methodBuilder.push(n4 + 1);
            resultColumn.generateHolder(expressionClassBuilder, methodBuilder);
            methodBuilder.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "setColumn", "void", 2);
            if (formatableBitSet != null) {
                n4 = formatableBitSet.anySetBit(n4);
                continue;
            }
            ++n4;
        }
        methodBuilder.getField(localField);
        methodBuilder.methodReturn();
        methodBuilder.complete();
        return methodBuilder;
    }

    private void genCreateRow(ExpressionClassBuilder expressionClassBuilder, LocalField localField, String string, String string2, int n) throws StandardException {
        MethodBuilder methodBuilder = expressionClassBuilder.getConstructor();
        expressionClassBuilder.pushGetExecutionFactoryExpression(methodBuilder);
        methodBuilder.push(n);
        methodBuilder.callMethod((short)185, null, string, string2, 1);
        methodBuilder.setField(localField);
        methodBuilder.statementNumHitLimit(1);
    }

    public ResultColumnDescriptor[] makeResultDescriptors() {
        ExecutionContext executionContext = (ExecutionContext)this.getContextManager().getContext("ExecutionContext");
        return this.makeResultDescriptors(executionContext);
    }

    ResultColumnDescriptor[] makeResultDescriptors(ExecutionContext executionContext) {
        ResultColumnDescriptor[] resultColumnDescriptorArray = new ResultColumnDescriptor[this.size()];
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            resultColumnDescriptorArray[j] = executionContext.getExecutionFactory().getResultColumnDescriptor((ResultColumnDescriptor)((Object)this.elementAt(j)));
        }
        return resultColumnDescriptorArray;
    }

    public void expandAllsAndNameColumns(FromList fromList) throws StandardException {
        int n;
        boolean bl = false;
        for (n = 0; n < this.size(); ++n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n);
            if (resultColumn instanceof AllResultColumn) {
                TableName tableName;
                bl = true;
                TableName tableName2 = resultColumn.getTableNameObject();
                if (tableName2 != null) {
                    String string = tableName2.getSchemaName();
                    String string2 = tableName2.getTableName();
                    tableName = this.makeTableName(string, string2);
                } else {
                    tableName = null;
                }
                ResultColumnList resultColumnList = fromList.expandAll(tableName);
                resultColumnList.nameAllResultColumns();
                resultColumnList.setClause(1);
                this.removeElementAt(n);
                for (int j = 0; j < resultColumnList.size(); ++j) {
                    this.insertElementAt(resultColumnList.elementAt(j), n + j);
                }
                this.markInitialSize();
                continue;
            }
            resultColumn.guaranteeColumnName();
        }
        if (bl) {
            n = this.size();
            for (int j = 0; j < n; ++j) {
                ((ResultColumn)this.elementAt(j)).setVirtualColumnId(j + 1);
            }
        }
    }

    public void nameAllResultColumns() throws StandardException {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            resultColumn.guaranteeColumnName();
        }
    }

    public void copyTypesAndLengthsToSource(ResultColumnList resultColumnList) {
        int n = this.size() > resultColumnList.size() ? this.size() : resultColumnList.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(j);
            ResultColumn resultColumn2 = (ResultColumn)this.elementAt(j);
            resultColumn.setType(resultColumn2.getTypeServices());
            resultColumn.getExpression().setType(resultColumn2.getTypeServices());
        }
    }

    boolean columnTypesAndLengthsMatch() throws StandardException {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            if (resultColumn.isGenerated() || resultColumn.columnTypeAndLengthMatch()) continue;
            return false;
        }
        return true;
    }

    boolean columnTypesAndLengthsMatch(ResultColumnList resultColumnList) throws StandardException {
        boolean bl = true;
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            ResultColumn resultColumn2 = (ResultColumn)resultColumnList.elementAt(j);
            if (resultColumn.isGenerated() || resultColumn2.isGenerated() || resultColumn.columnTypeAndLengthMatch(resultColumn2)) continue;
            bl = false;
        }
        return bl;
    }

    public boolean nopProjection(ResultColumnList resultColumnList) {
        if (this.size() != resultColumnList.size()) {
            return false;
        }
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            ResultColumn resultColumn2 = null;
            if (resultColumn.getExpression() instanceof VirtualColumnNode) {
                resultColumn2 = ((VirtualColumnNode)resultColumn.getExpression()).getSourceColumn();
            } else if (resultColumn.getExpression() instanceof ColumnReference) {
                resultColumn2 = ((ColumnReference)resultColumn.getExpression()).getSource();
            } else {
                return false;
            }
            ResultColumn resultColumn3 = (ResultColumn)resultColumnList.elementAt(j);
            if (resultColumn2 == resultColumn3) continue;
            return false;
        }
        return true;
    }

    public ResultColumnList copyListAndObjects() throws StandardException {
        ResultColumnList resultColumnList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            ResultColumn resultColumn2 = resultColumn.cloneMe();
            resultColumnList.addResultColumn(resultColumn2);
        }
        return resultColumnList;
    }

    public void genVirtualColumnNodes(ResultSetNode resultSetNode, ResultColumnList resultColumnList) throws StandardException {
        this.genVirtualColumnNodes(resultSetNode, resultColumnList, true);
    }

    public void genVirtualColumnNodes(ResultSetNode resultSetNode, ResultColumnList resultColumnList, boolean bl) throws StandardException {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            DataTypeDescriptor dataTypeDescriptor = resultColumn.getTypeServices();
            resultColumn.expression = (ValueNode)this.getNodeFactory().getNode(107, resultSetNode, resultColumnList.elementAt(j), ReuseFactory.getInteger(j + 1), this.getContextManager());
            if (!bl) continue;
            resultColumn.setReferenced();
        }
    }

    public void adjustVirtualColumnIds(int n) {
        int n2 = this.size();
        for (int j = 0; j < n2; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            resultColumn.adjustVirtualColumnId(n);
            ((VirtualColumnNode)resultColumn.getExpression()).columnId += n;
        }
    }

    public void doProjection() throws StandardException {
        int n;
        int n2 = 0;
        int n3 = this.size();
        ResultColumnList resultColumnList = new ResultColumnList();
        for (n = 0; n < n3; ++n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n);
            if (!resultColumn.isReferenced() && resultColumn.getExpression() instanceof VirtualColumnNode && !((VirtualColumnNode)resultColumn.getExpression()).getSourceColumn().isReferenced()) {
                resultColumnList.addElement(resultColumn);
                ++n2;
                continue;
            }
            if (n2 >= 1) {
                resultColumn.adjustVirtualColumnId(-n2);
            }
            resultColumn.setReferenced();
        }
        for (n = 0; n < resultColumnList.size(); ++n) {
            this.removeElement((ResultColumn)resultColumnList.elementAt(n));
        }
    }

    public String verifyUniqueNames(boolean bl) throws StandardException {
        int n = this.size();
        Hashtable<String, String> hashtable = new Hashtable<String, String>(n + 2, 0.999f);
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            if (bl && resultColumn.isNameGenerated()) {
                throw StandardException.newException("42908");
            }
            String string = ((ResultColumn)this.elementAt(j)).getName();
            String string2 = hashtable.put(string, string);
            if (string2 == null || !string2.equals(string)) continue;
            return string;
        }
        return null;
    }

    public void propagateDCLInfo(ResultColumnList resultColumnList, String string) throws StandardException {
        if (resultColumnList.size() != this.size() && !resultColumnList.getCountMismatchAllowed()) {
            throw StandardException.newException("42X32", string);
        }
        String string2 = resultColumnList.verifyUniqueNames(false);
        if (string2 != null) {
            throw StandardException.newException("42X33", string2);
        }
        this.copyResultColumnNames(resultColumnList);
    }

    void rejectParameters() throws StandardException {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            resultColumn.rejectParameter();
        }
    }

    void rejectXMLValues() throws StandardException {
        int n = this.size();
        ResultColumn resultColumn = null;
        for (int j = 1; j <= n; ++j) {
            if (j > this.initialListSize || (resultColumn = this.getResultColumn(j)) == null || resultColumn.getType() == null || !resultColumn.getType().getTypeId().isXMLTypeId()) continue;
            throw StandardException.newException("X0X15.S");
        }
    }

    public void setResultSetNumber(int n) {
        int n2 = this.size();
        for (int j = 0; j < n2; ++j) {
            ((ResultColumn)this.elementAt(j)).setResultSetNumber(n);
        }
    }

    public void setRedundant() {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ((ResultColumn)this.elementAt(j)).setRedundant();
        }
    }

    public void checkColumnUpdateability(String[] stringArray, String string) throws StandardException {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            if (!resultColumn.updated() || resultColumn.foundInList(stringArray)) continue;
            throw StandardException.newException("42X31", resultColumn.getName(), (Object)string);
        }
    }

    public void setUnionResultExpression(ResultColumnList resultColumnList, int n, int n2, String string) throws StandardException {
        TableName tableName = (TableName)this.getNodeFactory().getNode(34, null, null, this.getContextManager());
        ContextManager contextManager = this.getContextManager();
        int n3 = this.size();
        for (int j = 0; j < n3; ++j) {
            TypeId typeId;
            TypeId typeId2;
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            ResultColumn resultColumn2 = (ResultColumn)resultColumnList.elementAt(j);
            ValueNode valueNode = resultColumn.getExpression();
            ValueNode valueNode2 = resultColumn2.getExpression();
            if (!resultColumn2.isAutoincrementGenerated() && resultColumn.isAutoincrementGenerated()) {
                resultColumn.resetAutoincrementGenerated();
            }
            if ((typeId2 = valueNode.getTypeId()) == null || (typeId = valueNode2.getTypeId()) == null) continue;
            ClassFactory classFactory = this.getClassFactory();
            if (!valueNode.getTypeCompiler().storable(typeId, classFactory) && !valueNode2.getTypeCompiler().storable(typeId2, classFactory)) {
                throw StandardException.newException("42X61", typeId2.getSQLTypeName(), (Object)typeId.getSQLTypeName(), (Object)string);
            }
            DataTypeDescriptor dataTypeDescriptor = valueNode.getTypeServices().getDominantType(valueNode2.getTypeServices(), classFactory);
            ColumnReference columnReference = (ColumnReference)this.getNodeFactory().getNode(62, resultColumn.getName(), tableName, this.getContextManager());
            columnReference.setType(dataTypeDescriptor);
            if (valueNode instanceof ColumnReference) {
                columnReference.copyFields((ColumnReference)valueNode);
            } else {
                columnReference.setNestingLevel(n2);
                columnReference.setSourceLevel(n2);
            }
            columnReference.setTableNumber(n);
            resultColumn.setExpression(columnReference);
            resultColumn.setType(resultColumn.getTypeServices().getDominantType(resultColumn2.getTypeServices(), classFactory));
            if (resultColumn.getName() == null || resultColumn.isNameGenerated() || resultColumn2.getName() == null) continue;
            if (resultColumn2.isNameGenerated()) {
                resultColumn.setName(resultColumn2.getName());
                resultColumn.setNameGenerated(true);
                continue;
            }
            if (resultColumn.getName().equals(resultColumn2.getName())) continue;
            resultColumn.setName(null);
            resultColumn.guaranteeColumnName();
            resultColumn.setNameGenerated(true);
        }
    }

    public void checkAutoincrementUnion(ResultSetNode resultSetNode) throws StandardException {
        ResultSetNode resultSetNode2 = ((TableOperatorNode)resultSetNode).getLeftResultSet();
        ResultSetNode resultSetNode3 = ((TableOperatorNode)resultSetNode).getRightResultSet();
        if (resultSetNode2 instanceof UnionNode) {
            this.checkAutoincrementUnion(resultSetNode2);
        } else {
            this.checkAutoincrement(resultSetNode2.getResultColumns());
        }
        if (resultSetNode3 instanceof UnionNode) {
            this.checkAutoincrementUnion(resultSetNode3);
        } else {
            this.checkAutoincrement(resultSetNode3.getResultColumns());
        }
    }

    public boolean isExactTypeAndLengthMatch(ResultColumnList resultColumnList) {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            ResultColumn resultColumn2 = (ResultColumn)resultColumnList.elementAt(j);
            if (resultColumn.getTypeServices().isExactTypeAndLengthMatch(resultColumn2.getTypeServices())) continue;
            return false;
        }
        return true;
    }

    public boolean updateOverlaps(int[] nArray) {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            if (!resultColumn.updated()) continue;
            int n2 = resultColumn.getColumnPosition();
            for (int k = 0; k < nArray.length; ++k) {
                if (nArray[k] != n2) continue;
                return true;
            }
        }
        return false;
    }

    ResultColumn[] getSortedByPosition() {
        int n = this.size();
        Object[] objectArray = new ResultColumn[n];
        for (int j = 0; j < n; ++j) {
            objectArray[j] = (ResultColumn)this.elementAt(j);
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    public int[] sortMe() {
        ResultColumn[] resultColumnArray = this.getSortedByPosition();
        int[] nArray = new int[resultColumnArray.length];
        for (int j = 0; j < resultColumnArray.length; ++j) {
            nArray[j] = resultColumnArray[j].getColumnPosition();
        }
        return nArray;
    }

    public ResultColumnList expandToAll(TableDescriptor tableDescriptor, TableName tableName) throws StandardException {
        ResultColumnList resultColumnList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        ResultColumn[] resultColumnArray = this.getSortedByPosition();
        int n = 0;
        ColumnDescriptorList columnDescriptorList = tableDescriptor.getColumnDescriptorList();
        int n2 = columnDescriptorList.size();
        for (int j = 0; j < n2; ++j) {
            ResultColumn resultColumn;
            ColumnDescriptor columnDescriptor = columnDescriptorList.elementAt(j);
            if (n < resultColumnArray.length && columnDescriptor.getPosition() == resultColumnArray[n].getColumnPosition()) {
                resultColumn = resultColumnArray[n];
                ++n;
            } else {
                resultColumn = this.makeColumnReferenceFromName(tableName, columnDescriptor.getColumnName());
                resultColumn.bindResultColumnByPosition(tableDescriptor, columnDescriptor.getPosition());
            }
            resultColumnList.addResultColumn(resultColumn);
        }
        return resultColumnList;
    }

    public void bindUntypedNullsToResultColumns(ResultColumnList resultColumnList) throws StandardException {
        if (resultColumnList == null) {
            throw StandardException.newException("42X07");
        }
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(j);
            ResultColumn resultColumn2 = (ResultColumn)this.elementAt(j);
            resultColumn2.typeUntypedNullExpression(resultColumn);
        }
    }

    void markUpdated() {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ((ResultColumn)this.elementAt(j)).markUpdated();
        }
    }

    void markUpdatableByCursor() {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            if (((ResultColumn)this.elementAt(j)).getSourceTableName() == null) continue;
            ((ResultColumn)this.elementAt(j)).markUpdatableByCursor();
        }
    }

    public String verifyCreateConstraintColumnList(TableElementList tableElementList) {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            String string = ((ResultColumn)this.elementAt(j)).getName();
            if (tableElementList.containsColumnName(string)) continue;
            return string;
        }
        return null;
    }

    public void exportNames(String[] stringArray) {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            stringArray[j] = ((ResultColumn)this.elementAt(j)).getName();
        }
    }

    public int countNumberOfSimpleColumnReferences() {
        int n = 0;
        int n2 = this.size();
        for (int j = 0; j < n2; ++j) {
            if (!(((ResultColumn)this.elementAt(j)).getExpression() instanceof ColumnReference)) continue;
            ++n;
        }
        return n;
    }

    public ResultColumn findParentResultColumn(ResultColumn resultColumn) {
        ResultColumn resultColumn2 = null;
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ValueNode valueNode;
            ResultColumn resultColumn3 = (ResultColumn)this.elementAt(j);
            if (resultColumn3.getExpression() instanceof ColumnReference) {
                valueNode = (ColumnReference)resultColumn3.getExpression();
                if (((ColumnReference)valueNode).getSource() != resultColumn) continue;
                resultColumn2 = resultColumn3;
                break;
            }
            if (!(resultColumn3.getExpression() instanceof VirtualColumnNode) || ((VirtualColumnNode)(valueNode = (VirtualColumnNode)resultColumn3.getExpression())).getSourceColumn() != resultColumn) continue;
            resultColumn2 = resultColumn3;
            break;
        }
        return resultColumn2;
    }

    public void setClause(int n) {
        int n2 = this.size();
        for (int j = 0; j < n2; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            resultColumn.setClause(n);
        }
    }

    void markUpdated(ResultColumnList resultColumnList) {
        int n = resultColumnList.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(j);
            ResultColumn resultColumn2 = this.getResultColumn(resultColumn.getName());
            if (resultColumn2 == null) continue;
            resultColumn2.markUpdated();
        }
    }

    void markColumnsInSelectListUpdatableByCursor(Vector vector) {
        this.commonCodeForUpdatableByCursor(vector, true);
    }

    private void commonCodeForUpdatableByCursor(Vector vector, boolean bl) {
        if (vector == null || vector.size() == 0) {
            this.markUpdatableByCursor();
        } else {
            int n = vector.size();
            for (int j = 0; j < n; ++j) {
                String string = (String)vector.elementAt(j);
                ResultColumn resultColumn = this.getResultColumn(string);
                if (resultColumn == null && bl) continue;
                resultColumn.markUpdatableByCursor();
            }
        }
    }

    void markUpdatableByCursor(Vector vector) {
        this.commonCodeForUpdatableByCursor(vector, false);
    }

    boolean updatableByCursor(int n) {
        return this.getResultColumn(n).updatableByCursor();
    }

    public boolean isCloneable() {
        boolean bl = true;
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            if (resultColumn.getExpression().isCloneable()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void remapColumnReferencesToExpressions() throws StandardException {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            resultColumn.setExpression(resultColumn.getExpression().remapColumnReferencesToExpressions());
        }
    }

    void setIndexRow(long l, boolean bl) {
        this.indexRow = true;
        this.conglomerateId = l;
        this.forUpdate = bl;
    }

    public boolean hasConsistentTypeInfo() {
        boolean bl = true;
        return bl;
    }

    public boolean containsAllResultColumn() {
        boolean bl = false;
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            if (!(this.elementAt(j) instanceof AllResultColumn)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public int countReferencedColumns() {
        int n = 0;
        int n2 = this.size();
        for (int j = 0; j < n2; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            if (!resultColumn.isReferenced()) continue;
            ++n;
        }
        return n;
    }

    public void recordColumnReferences(int[] nArray, int n) {
        int n2 = 0;
        int n3 = this.size();
        for (int j = 0; j < n3; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            if (!resultColumn.isReferenced()) continue;
            nArray[n2++] = j + n;
        }
    }

    public void recordColumnReferences(boolean[] blArray, JBitSet[] jBitSetArray, int n) {
        int n2 = this.size();
        for (int j = 0; j < n2; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            if (!(resultColumn.getExpression() instanceof ColumnReference)) continue;
            int n3 = ((ColumnReference)resultColumn.getExpression()).getColumnNumber();
            blArray[n3] = true;
            jBitSetArray[n].set(n3);
        }
    }

    int allTopCRsFromSameTable() {
        int n = -1;
        int n2 = this.size();
        for (int j = 0; j < n2; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            ValueNode valueNode = resultColumn.getExpression();
            if (!(valueNode instanceof ColumnReference)) continue;
            ColumnReference columnReference = (ColumnReference)valueNode;
            if (n == -1) {
                n = columnReference.getTableNumber();
                continue;
            }
            if (n == columnReference.getTableNumber()) continue;
            return -1;
        }
        return n;
    }

    public void clearColumnReferences() {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            if (!resultColumn.isReferenced()) continue;
            resultColumn.setUnreferenced();
        }
    }

    public void copyReferencedColumnsToNewList(ResultColumnList resultColumnList) {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            if (!resultColumn.isReferenced()) continue;
            resultColumnList.addElement(resultColumn);
        }
    }

    public void copyColumnsToNewList(ResultColumnList resultColumnList, FormatableBitSet formatableBitSet) {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            if (!formatableBitSet.isSet(resultColumn.getColumnPosition())) continue;
            resultColumnList.addElement(resultColumn);
        }
    }

    public FormatableBitSet getColumnReferenceMap() {
        FormatableBitSet formatableBitSet = new FormatableBitSet(this.size());
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            if (!resultColumn.isReferenced()) continue;
            formatableBitSet.set(j);
        }
        return formatableBitSet;
    }

    void pullVirtualIsReferenced() {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            resultColumn.pullVirtualIsReferenced();
        }
    }

    public void clearTableNames() {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            resultColumn.clearTableName();
        }
    }

    protected void setCountMismatchAllowed(boolean bl) {
        this.countMismatchAllowed = bl;
    }

    protected boolean getCountMismatchAllowed() {
        return this.countMismatchAllowed;
    }

    public int getTotalColumnSize() {
        int n = 0;
        int n2 = this.size();
        for (int j = 0; j < n2; ++j) {
            n += ((ResultColumn)this.elementAt(j)).getMaximumColumnSize();
        }
        return n;
    }

    public void createListFromResultSetMetaData(ResultSetMetaData resultSetMetaData, TableName tableName, String string) throws StandardException {
        try {
            int n = resultSetMetaData.getColumnCount();
            if (n <= 0) {
                throw StandardException.newException("42X57", string, (Object)String.valueOf(n));
            }
            for (int j = 1; j <= n; ++j) {
                TypeId typeId;
                boolean bl = resultSetMetaData.isNullable(j) != 0;
                int n2 = resultSetMetaData.getColumnType(j);
                switch (n2) {
                    case 1111: 
                    case 2000: {
                        typeId = TypeId.getUserDefinedTypeId(resultSetMetaData.getColumnTypeName(j), false);
                        break;
                    }
                    default: {
                        typeId = TypeId.getBuiltInTypeId(n2);
                    }
                }
                if (typeId == null) {
                    throw StandardException.newException("42Y23", Integer.toString(j));
                }
                int n3 = typeId.variableLength() ? resultSetMetaData.getColumnDisplaySize(j) : (n2 == -1 || n2 == -4 ? Integer.MAX_VALUE : 0);
                int n4 = typeId.isDecimalTypeId() ? resultSetMetaData.getPrecision(j) : 0;
                int n5 = typeId.isDecimalTypeId() ? resultSetMetaData.getScale(j) : 0;
                DataTypeDescriptor dataTypeDescriptor = new DataTypeDescriptor(typeId, n4, n5, bl, n3);
                ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(94, resultSetMetaData.getColumnName(j), tableName, dataTypeDescriptor, this.getContextManager());
                ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, resultSetMetaData.getColumnName(j), valueNode, this.getContextManager());
                resultColumn.setType(dataTypeDescriptor);
                this.addResultColumn(resultColumn);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof StandardException) {
                throw (StandardException)throwable;
            }
            throw StandardException.unexpectedUserException(throwable);
        }
    }

    public void addRCForRID() throws StandardException {
        CurrentRowLocationNode currentRowLocationNode = (CurrentRowLocationNode)this.getNodeFactory().getNode(2, this.getContextManager());
        ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, "", currentRowLocationNode, this.getContextManager());
        resultColumn.markGenerated();
        this.addResultColumn(resultColumn);
    }

    public void markAllUnreferenced() throws StandardException {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            resultColumn.setUnreferenced();
        }
    }

    boolean allExpressionsAreColumns(ResultSetNode resultSetNode) {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ValueNode valueNode;
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            ValueNode valueNode2 = resultColumn.getExpression();
            if (!(valueNode2 instanceof VirtualColumnNode) && !(valueNode2 instanceof ColumnReference)) {
                return false;
            }
            if (valueNode2 instanceof VirtualColumnNode && ((VirtualColumnNode)(valueNode = (VirtualColumnNode)valueNode2)).getSourceResultSet() != resultSetNode) {
                ((VirtualColumnNode)valueNode).setCorrelated();
                return false;
            }
            if (!(valueNode2 instanceof ColumnReference) || !((ColumnReference)(valueNode = (ColumnReference)valueNode2)).getCorrelated()) continue;
            return false;
        }
        return true;
    }

    int[] mapSourceColumns() {
        int[] nArray = new int[this.size()];
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ValueNode valueNode;
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            if (resultColumn.getExpression() instanceof VirtualColumnNode) {
                valueNode = (VirtualColumnNode)resultColumn.getExpression();
                if (((VirtualColumnNode)valueNode).getCorrelated()) {
                    nArray[j] = -1;
                    continue;
                }
                nArray[j] = ((VirtualColumnNode)valueNode).getSourceColumn().getVirtualColumnId();
                continue;
            }
            if (resultColumn.getExpression() instanceof ColumnReference) {
                valueNode = (ColumnReference)resultColumn.getExpression();
                if (((ColumnReference)valueNode).getCorrelated()) {
                    nArray[j] = -1;
                    continue;
                }
                nArray[j] = ((ColumnReference)valueNode).getSource().getVirtualColumnId();
                continue;
            }
            nArray[j] = -1;
        }
        return nArray;
    }

    public void setNullability(boolean bl) {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            resultColumn.setNullability(bl);
        }
    }

    FormatableBitSet getReferencedFormatableBitSet(boolean bl, boolean bl2, boolean bl3) {
        int n;
        int n2 = 0;
        int n3 = this.size();
        FormatableBitSet formatableBitSet = new FormatableBitSet(n3);
        if (bl) {
            if (bl2) {
                for (int j = 0; j < n3; ++j) {
                    formatableBitSet.set(j);
                }
                return formatableBitSet;
            }
            return null;
        }
        for (n = 0; n < n3; ++n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n);
            if (!resultColumn.isReferenced() || bl3 && !(resultColumn.getExpression() instanceof BaseColumnNode)) continue;
            formatableBitSet.set(n);
            ++n2;
        }
        if (n2 != n || bl2) {
            return formatableBitSet;
        }
        return null;
    }

    ResultColumnList compactColumns(boolean bl, boolean bl2) throws StandardException {
        int n;
        int n2 = 0;
        if (bl) {
            return this;
        }
        ResultColumnList resultColumnList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        int n3 = this.size();
        for (n = 0; n < n3; ++n) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(n);
            if (!resultColumn.isReferenced()) continue;
            resultColumnList.addResultColumn(resultColumn);
            ++n2;
        }
        if (n2 != n || bl2) {
            return resultColumnList;
        }
        return this;
    }

    void removeJoinColumns(ResultColumnList resultColumnList) {
        int n = resultColumnList.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(j);
            String string = resultColumn.getName();
            ResultColumn resultColumn2 = this.getResultColumn(string);
            if (resultColumn2 == null) continue;
            this.removeElement(resultColumn2);
        }
    }

    ResultColumnList getJoinColumns(ResultColumnList resultColumnList) {
        ResultColumnList resultColumnList2 = new ResultColumnList();
        int n = resultColumnList.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(j);
            String string = resultColumn.getName();
            ResultColumn resultColumn2 = this.getResultColumn(string);
            resultColumnList2.addElement(resultColumn2);
        }
        return resultColumnList2;
    }

    void resetVirtualColumnIds() {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ((ResultColumn)this.elementAt(j)).setVirtualColumnId(j + 1);
        }
    }

    boolean reusableResult() {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            if (resultColumn.getExpression() instanceof ConstantNode || resultColumn.getExpression() instanceof AggregateNode) continue;
            return false;
        }
        return true;
    }

    public int[] getColumnPositions(TableDescriptor tableDescriptor) throws StandardException {
        int n = this.size();
        int[] nArray = new int[n];
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            String string = resultColumn.getName();
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(string);
            if (columnDescriptor == null) {
                throw StandardException.newException("42X14", string, (Object)tableDescriptor.getQualifiedName());
            }
            nArray[j] = columnDescriptor.getPosition();
        }
        return nArray;
    }

    public String[] getColumnNames() {
        String[] stringArray = new String[this.size()];
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            stringArray[j] = resultColumn.getName();
        }
        return stringArray;
    }

    void replaceDefaults(TableDescriptor tableDescriptor, ResultColumnList resultColumnList) throws StandardException {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            Object object2;
            ColumnDescriptor columnDescriptor;
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            if (!resultColumn.isDefaultColumn()) continue;
            if (resultColumnList == null) {
                columnDescriptor = tableDescriptor.getColumnDescriptor(j + 1);
            } else {
                object2 = (ResultColumn)resultColumnList.elementAt(j);
                columnDescriptor = tableDescriptor.getColumnDescriptor(((ResultColumn)object2).getName());
            }
            if (columnDescriptor == null) {
                throw StandardException.newException("42X06", tableDescriptor.getQualifiedName());
            }
            if (columnDescriptor.isAutoincrement()) {
                resultColumn.setAutoincrementGenerated();
            }
            if ((object2 = (DefaultInfoImpl)columnDescriptor.getDefaultInfo()) != null) {
                DefaultDescriptor defaultDescriptor = columnDescriptor.getDefaultDescriptor(this.getDataDictionary());
                this.getCompilerContext().createDependency(defaultDescriptor);
                resultColumn.setExpression(DefaultNode.parseDefault(((DefaultInfoImpl)object2).getDefaultText(), this.getLanguageConnectionContext(), this.getCompilerContext()));
            } else {
                resultColumn.setExpression((ValueNode)this.getNodeFactory().getNode(13, this.getContextManager()));
            }
            resultColumn.setDefaultColumn(false);
        }
    }

    void checkForInvalidDefaults() throws StandardException {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            if (resultColumn.isAutoincrementGenerated() || !resultColumn.isDefaultColumn()) continue;
            throw StandardException.newException("42Y85");
        }
    }

    void verifyAllOrderable() throws StandardException {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            resultColumn.verifyOrderable();
        }
    }

    public void populate(TableDescriptor tableDescriptor, int[] nArray) throws StandardException {
        if (nArray == null) {
            return;
        }
        int n = nArray.length;
        TableName tableName = this.makeTableName(tableDescriptor.getSchemaName(), tableDescriptor.getName());
        for (int j = 0; j < n; ++j) {
            int n2 = nArray[j];
            String string = tableDescriptor.getColumnDescriptor(n2).getColumnName();
            ResultColumn resultColumn = this.makeColumnFromName(string);
            this.addResultColumn(resultColumn);
        }
    }

    private ResultColumn makeColumnFromName(String string) throws StandardException {
        ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, string, null, this.getContextManager());
        return resultColumn;
    }

    private ResultColumn makeColumnReferenceFromName(TableName tableName, String string) throws StandardException {
        ContextManager contextManager = this.getContextManager();
        NodeFactory nodeFactory = this.getNodeFactory();
        ResultColumn resultColumn = (ResultColumn)nodeFactory.getNode(80, null, nodeFactory.getNode(62, string, tableName, contextManager), contextManager);
        return resultColumn;
    }

    public void checkAutoincrement(ResultColumnList resultColumnList) throws StandardException {
        int n = this.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(j);
            ResultColumn resultColumn2 = (ResultColumn)(resultColumnList == null ? null : resultColumnList.elementAt(j));
            ColumnDescriptor columnDescriptor = resultColumn.getTableColumnDescriptor();
            if (columnDescriptor == null || !columnDescriptor.isAutoincrement()) continue;
            if (resultColumn2 != null && resultColumn2.isAutoincrementGenerated()) {
                resultColumn2.setColumnDescriptor(columnDescriptor.getTableDescriptor(), columnDescriptor);
                continue;
            }
            if (!columnDescriptor.isAutoincAlways()) continue;
            throw StandardException.newException("42Z23", resultColumn.getName());
        }
    }

    public void incOrderBySelect() {
        ++this.orderBySelect;
    }

    public void decOrderBySelect() {
        --this.orderBySelect;
    }

    public int getOrderBySelect() {
        return this.orderBySelect;
    }

    public void copyOrderBySelect(ResultColumnList resultColumnList) {
        this.orderBySelect = resultColumnList.orderBySelect;
    }

    protected void markInitialSize() {
        this.initialListSize = this.size();
    }
}

