/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.catalog.types.SynonymAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.NodeFactory;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionFactory;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.execute.GenericConstantActionFactory;
import org.apache.derby.impl.sql.execute.GenericExecutionFactory;

public abstract class QueryTreeNode
implements Visitable {
    public static final int AUTOINCREMENT_START_INDEX = 0;
    public static final int AUTOINCREMENT_INC_INDEX = 1;
    public static final int AUTOINCREMENT_IS_AUTOINCREMENT_INDEX = 2;
    int beginOffset;
    int endOffset;
    private int nodeType;
    private ContextManager cm;
    private LanguageConnectionContext lcc;
    private GenericConstantActionFactory constantActionFactory;

    public void setContextManager(ContextManager contextManager) {
        this.cm = contextManager;
    }

    public final ContextManager getContextManager() {
        return this.cm;
    }

    public final NodeFactory getNodeFactory() {
        return this.getLanguageConnectionContext().getLanguageConnectionFactory().getNodeFactory();
    }

    public final GenericConstantActionFactory getGenericConstantActionFactory() {
        if (this.constantActionFactory == null) {
            GenericExecutionFactory genericExecutionFactory = (GenericExecutionFactory)this.getExecutionFactory();
            this.constantActionFactory = genericExecutionFactory.getConstantActionFactory();
        }
        return this.constantActionFactory;
    }

    public final ExecutionFactory getExecutionFactory() {
        ExecutionFactory executionFactory = this.getLanguageConnectionContext().getLanguageConnectionFactory().getExecutionFactory();
        return executionFactory;
    }

    protected final ClassFactory getClassFactory() {
        return this.getLanguageConnectionContext().getLanguageConnectionFactory().getClassFactory();
    }

    protected final LanguageConnectionContext getLanguageConnectionContext() {
        if (this.lcc == null) {
            this.lcc = (LanguageConnectionContext)this.getContextManager().getContext("LanguageConnectionContext");
        }
        return this.lcc;
    }

    public String getSPSName() {
        return null;
    }

    public int getBeginOffset() {
        return this.beginOffset;
    }

    public void setBeginOffset(int n) {
        this.beginOffset = n;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public void setEndOffset(int n) {
        this.endOffset = n;
    }

    protected String nodeHeader() {
        return "";
    }

    public static String formatNodeString(String string, int n) {
        return "";
    }

    public void treePrint() {
    }

    public void treePrint(int n) {
    }

    public static void debugPrint(String string) {
    }

    protected static void debugFlush() {
    }

    public void printSubNodes(int n) {
    }

    public String toString() {
        return "";
    }

    public void printLabel(int n, String string) {
    }

    public QueryTreeNode bind() throws StandardException {
        return this;
    }

    public boolean referencesSessionSchema() throws StandardException {
        return false;
    }

    final boolean isSessionSchema(SchemaDescriptor schemaDescriptor) {
        return this.isSessionSchema(schemaDescriptor.getSchemaName());
    }

    final boolean isSessionSchema(String string) {
        return "SESSION".equals(string);
    }

    public long getRowEstimate() {
        return 0L;
    }

    public QueryTreeNode optimize() throws StandardException {
        return this;
    }

    public GeneratedClass generate(ByteArray byteArray) throws StandardException {
        throw StandardException.newException("42Z50", this.nodeHeader());
    }

    protected void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        throw StandardException.newException("42Z50", this.nodeHeader());
    }

    public ResultDescription makeResultDescription() throws StandardException {
        return null;
    }

    public DataTypeDescriptor[] getParameterTypes() throws StandardException {
        return this.getCompilerContext().getParameterTypes();
    }

    public ConstantAction makeConstantAction() throws StandardException {
        return null;
    }

    public boolean needsSavepoint() {
        return true;
    }

    public String executeStatementName() {
        return null;
    }

    public String executeSchemaName() {
        return null;
    }

    public void setNodeType(int n) {
        this.nodeType = n;
    }

    protected int getNodeType() {
        return this.nodeType;
    }

    protected boolean isInstanceOf(int n) {
        return this.nodeType == n;
    }

    public final DataDictionary getDataDictionary() {
        return this.getLanguageConnectionContext().getDataDictionary();
    }

    public final DependencyManager getDependencyManager() {
        return this.getDataDictionary().getDependencyManager();
    }

    protected final CompilerContext getCompilerContext() {
        return (CompilerContext)this.getContextManager().getContext("CompilerContext");
    }

    protected final TypeCompiler getTypeCompiler(TypeId typeId) {
        return this.getCompilerContext().getTypeCompilerFactory().getTypeCompiler(typeId);
    }

    public Visitable accept(Visitor visitor) throws StandardException {
        return visitor.visit(this);
    }

    protected int getIntProperty(String string, String string2) throws StandardException {
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("42Y58", string, (Object)string2);
        }
        return n;
    }

    public static QueryTreeNode parseQueryText(CompilerContext compilerContext, String string, Object[] objectArray, LanguageConnectionContext languageConnectionContext) throws StandardException {
        Parser parser = compilerContext.getParser();
        LanguageConnectionFactory languageConnectionFactory = languageConnectionContext.getLanguageConnectionFactory();
        QueryTreeNode queryTreeNode = parser.parseStatement(string, objectArray);
        return queryTreeNode;
    }

    protected int getStatementType() {
        return 0;
    }

    public boolean foundString(String[] stringArray, String string) {
        if (stringArray == null) {
            return false;
        }
        for (int j = 0; j < stringArray.length; ++j) {
            if (!stringArray[j].equals(string)) continue;
            return true;
        }
        return false;
    }

    public ConstantNode getNullNode(TypeId typeId, ContextManager contextManager) throws StandardException {
        QueryTreeNode queryTreeNode = null;
        NodeFactory nodeFactory = this.getNodeFactory();
        switch (typeId.getJDBCTypeId()) {
            case 12: {
                queryTreeNode = nodeFactory.getNode(77, typeId, contextManager);
                break;
            }
            case 1: {
                queryTreeNode = nodeFactory.getNode(61, typeId, contextManager);
                break;
            }
            case -6: {
                queryTreeNode = nodeFactory.getNode(75, typeId, contextManager);
                break;
            }
            case 5: {
                queryTreeNode = nodeFactory.getNode(74, typeId, contextManager);
                break;
            }
            case 4: {
                queryTreeNode = nodeFactory.getNode(70, typeId, contextManager);
                break;
            }
            case -5: {
                queryTreeNode = nodeFactory.getNode(71, typeId, contextManager);
                break;
            }
            case 7: {
                queryTreeNode = nodeFactory.getNode(69, typeId, contextManager);
                break;
            }
            case 8: {
                queryTreeNode = nodeFactory.getNode(68, typeId, contextManager);
                break;
            }
            case 2: 
            case 3: {
                queryTreeNode = nodeFactory.getNode(67, typeId, contextManager);
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                queryTreeNode = nodeFactory.getNode(76, typeId, contextManager);
                break;
            }
            case -2: {
                queryTreeNode = nodeFactory.getNode(58, typeId, contextManager);
                break;
            }
            case -3: {
                queryTreeNode = nodeFactory.getNode(59, typeId, contextManager);
                break;
            }
            case -1: {
                queryTreeNode = nodeFactory.getNode(73, typeId, contextManager);
                break;
            }
            case 2005: {
                queryTreeNode = nodeFactory.getNode(196, typeId, contextManager);
                break;
            }
            case -4: {
                queryTreeNode = nodeFactory.getNode(72, typeId, contextManager);
                break;
            }
            case 2004: {
                queryTreeNode = nodeFactory.getNode(195, typeId, contextManager);
                break;
            }
            case 456: {
                queryTreeNode = nodeFactory.getNode(199, typeId, contextManager);
                break;
            }
            default: {
                if (typeId.getSQLTypeName().equals("BOOLEAN")) {
                    queryTreeNode = nodeFactory.getNode(38, typeId, contextManager);
                    break;
                }
                if (!typeId.builtIn()) {
                    queryTreeNode = nodeFactory.getNode(76, typeId, contextManager);
                    break;
                }
                return null;
            }
        }
        return (ConstantNode)queryTreeNode;
    }

    public DataValueDescriptor convertDefaultNode(DataTypeDescriptor dataTypeDescriptor) throws StandardException {
        return null;
    }

    public void init(Object object2) throws StandardException {
    }

    public void init(Object object2, Object object3) throws StandardException {
    }

    public void init(Object object2, Object object3, Object object4) throws StandardException {
    }

    public void init(Object object2, Object object3, Object object4, Object object5) throws StandardException {
    }

    public void init(Object object2, Object object3, Object object4, Object object5, Object object6) throws StandardException {
    }

    public void init(Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) throws StandardException {
    }

    public void init(Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) throws StandardException {
    }

    public void init(Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) throws StandardException {
    }

    public void init(Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10) throws StandardException {
    }

    public void init(Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11) throws StandardException {
    }

    public void init(Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12) throws StandardException {
    }

    public void init(Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13) throws StandardException {
    }

    public void init(Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13, Object object14) throws StandardException {
    }

    public void init(Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13, Object object14, Object object15) throws StandardException {
    }

    public TableName makeTableName(String string, String string2) throws StandardException {
        return (TableName)this.getNodeFactory().getNode(34, string, string2, this.getContextManager());
    }

    public boolean isAtomic() throws StandardException {
        return false;
    }

    public Object getCursorInfo() throws StandardException {
        return null;
    }

    protected final TableDescriptor getTableDescriptor(String string, SchemaDescriptor schemaDescriptor) throws StandardException {
        TableDescriptor tableDescriptor;
        if (this.isSessionSchema(schemaDescriptor) && (tableDescriptor = this.getLanguageConnectionContext().getTableDescriptorForDeclaredGlobalTempTable(string)) != null) {
            return tableDescriptor;
        }
        if (schemaDescriptor.getUUID() == null) {
            return null;
        }
        TableDescriptor tableDescriptor2 = this.getDataDictionary().getTableDescriptor(string, schemaDescriptor);
        if (tableDescriptor2 == null || tableDescriptor2.isSynonymDescriptor()) {
            return null;
        }
        return tableDescriptor2;
    }

    final SchemaDescriptor getSchemaDescriptor(String string) throws StandardException {
        return this.getSchemaDescriptor(string, true);
    }

    final SchemaDescriptor getSchemaDescriptor(String string, boolean bl) throws StandardException {
        Object object2;
        SchemaDescriptor schemaDescriptor = null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string == null) {
            object2 = this.getCompilerContext();
            schemaDescriptor = object2.getCompilationSchema();
            if (schemaDescriptor == null) {
                schemaDescriptor = this.getLanguageConnectionContext().getDefaultSchema();
                bl2 = true;
                object2.setCompilationSchema(schemaDescriptor);
            } else {
                bl3 = true;
            }
            string = schemaDescriptor.getSchemaName();
        }
        object2 = this.getDataDictionary();
        SchemaDescriptor schemaDescriptor2 = object2.getSchemaDescriptor(string, this.getLanguageConnectionContext().getTransactionCompile(), bl);
        if (bl2 || bl3) {
            if (schemaDescriptor2 != null) {
                if (!schemaDescriptor2.getUUID().equals(schemaDescriptor.getUUID())) {
                    if (bl2) {
                        this.getLanguageConnectionContext().setDefaultSchema(schemaDescriptor2);
                    }
                    this.getCompilerContext().setCompilationSchema(schemaDescriptor2);
                }
            } else {
                schemaDescriptor.setUUID(null);
                schemaDescriptor2 = schemaDescriptor;
            }
        }
        return schemaDescriptor2;
    }

    public TableName resolveTableToSynonym(TableName tableName) throws StandardException {
        AliasDescriptor aliasDescriptor;
        Object object2;
        DataDictionary dataDictionary = this.getDataDictionary();
        String string = tableName.getTableName();
        String string2 = tableName.getSchemaName();
        boolean bl = false;
        CompilerContext compilerContext = this.getCompilerContext();
        while ((object2 = this.getSchemaDescriptor(string2, false)) != null && ((SchemaDescriptor)object2).getUUID() != null && (aliasDescriptor = dataDictionary.getAliasDescriptor(((SchemaDescriptor)object2).getUUID().toString(), string, 'S')) != null) {
            compilerContext.createDependency(aliasDescriptor);
            bl = true;
            SynonymAliasInfo synonymAliasInfo = (SynonymAliasInfo)aliasDescriptor.getAliasInfo();
            string = synonymAliasInfo.getSynonymTable();
            string2 = synonymAliasInfo.getSynonymSchema();
        }
        if (!bl) {
            return null;
        }
        object2 = new TableName();
        ((TableName)object2).init(string2, string);
        return object2;
    }

    String verifyClassExist(String string, boolean bl) throws StandardException {
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        ClassNotFoundException classNotFoundException = null;
        boolean bl2 = false;
        try {
            bl2 = classInspector.accessible(string);
        }
        catch (ClassNotFoundException classNotFoundException2) {
            classNotFoundException = classNotFoundException2;
        }
        if (!bl2) {
            throw StandardException.newException("42X51", classNotFoundException, (Object)string);
        }
        if (ClassInspector.primitiveType(string)) {
            throw StandardException.newException("42Y37", string);
        }
        return string;
    }

    public void setRefActionInfo(long l, int[] nArray, String string, boolean bl) {
    }

    void generateAuthorizeCheck(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder, int n) {
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        methodBuilder.callMethod((short)185, null, "getLanguageConnectionContext", "org.apache.derby.iapi.sql.conn.LanguageConnectionContext", 0);
        methodBuilder.callMethod((short)185, null, "getAuthorizer", "org.apache.derby.iapi.sql.conn.Authorizer", 0);
        methodBuilder.push(n);
        methodBuilder.callMethod((short)185, null, "authorize", "void", 1);
    }
}

