/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.lang.reflect.Member;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.JSQLType;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JavaToSQLValueNode;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.SQLToJavaValueNode;
import org.apache.derby.impl.sql.compile.SubqueryList;

public abstract class MethodCallNode
extends JavaValueNode {
    protected String methodName;
    protected String javaClassName;
    RoutineAliasInfo routineInfo;
    boolean internalCall;
    private String[] procedurePrimitiveArrayType;
    protected JSQLType[] signature;
    protected JavaValueNode[] methodParms;
    protected Member method;
    protected String actualMethodReturnType;
    String[] methodParameterTypes;

    public JSQLType[] getSignature() {
        return this.signature;
    }

    public void init(Object object2) {
        this.methodName = (String)object2;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    public void setClause(int n) {
        super.setClause(n);
        if (this.methodParms != null) {
            for (int j = 0; j < this.methodParms.length; ++j) {
                if (this.methodParms[j] == null) continue;
                this.methodParms[j].setClause(n);
            }
        }
    }

    public void addParms(JavaValueNode[] javaValueNodeArray) {
        this.methodParms = javaValueNodeArray;
    }

    public void addParms(Vector vector) throws StandardException {
        this.methodParms = new JavaValueNode[vector.size()];
        int n = vector.size();
        for (int j = 0; j < n; ++j) {
            QueryTreeNode queryTreeNode = (QueryTreeNode)vector.elementAt(j);
            if (!(queryTreeNode instanceof JavaValueNode)) {
                queryTreeNode = queryTreeNode instanceof JavaToSQLValueNode ? ((JavaToSQLValueNode)queryTreeNode).getJavaValueNode() : (SQLToJavaValueNode)this.getNodeFactory().getNode(28, queryTreeNode, this.getContextManager());
            }
            this.methodParms[j] = (JavaValueNode)queryTreeNode;
        }
    }

    public void printSubNodes(int n) {
    }

    public String toString() {
        return "";
    }

    final void bindParameters(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        if (this.methodParms != null) {
            int n = this.methodParms.length;
            if (this.signature == null) {
                this.signature = new JSQLType[n];
            }
            for (int j = 0; j < n; ++j) {
                String string;
                if (this.methodParms[j] == null) continue;
                this.methodParms[j] = this.methodParms[j].bindExpression(fromList, subqueryList, vector);
                if (this.routineInfo == null) {
                    this.signature[j] = this.methodParms[j].getJSQLType();
                }
                if (this.signature[j] == null || !(string = this.signature[j].getSQLType().getTypeId().getSQLTypeName()).equals("BLOB") && !string.equals("CLOB") && !string.equals("NCLOB")) continue;
                throw StandardException.newException("XJ082.U");
            }
        }
    }

    protected boolean areParametersQueryInvariant() throws StandardException {
        return this.getVariantTypeOfParams() == 2;
    }

    void throwNoMethodFound(String string, String[] stringArray, String[] stringArray2) throws StandardException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int j = 0; j < stringArray.length; ++j) {
            if (j != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray[j].length() != 0 ? stringArray[j] : "UNTYPED");
            if (stringArray2 == null || stringArray2[j].equals(stringArray[j])) continue;
            stringBuffer.append("(" + stringArray2[j] + ")");
        }
        throw StandardException.newException("42X50", string, (Object)this.methodName, (Object)stringBuffer);
    }

    public void preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        if (this.methodParms != null) {
            for (int j = 0; j < this.methodParms.length; ++j) {
                if (this.methodParms[j] == null) continue;
                this.methodParms[j].preprocess(n, fromList, subqueryList, predicateList);
            }
        }
    }

    public boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        if (bl) {
            return false;
        }
        boolean bl2 = true;
        if (this.methodParms != null) {
            for (int j = 0; j < this.methodParms.length; ++j) {
                if (this.methodParms[j] == null) continue;
                bl2 = this.methodParms[j].categorize(jBitSet, bl) && bl2;
            }
        }
        return bl2;
    }

    public JavaValueNode remapColumnReferencesToExpressions() throws StandardException {
        if (this.methodParms != null) {
            for (int j = 0; j < this.methodParms.length; ++j) {
                if (this.methodParms[j] == null) continue;
                this.methodParms[j] = this.methodParms[j].remapColumnReferencesToExpressions();
            }
        }
        return this;
    }

    public int generateParameters(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        String[] stringArray = this.methodParameterTypes;
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        for (int j = 0; j < this.methodParms.length; ++j) {
            this.generateOneParameter(expressionClassBuilder, methodBuilder, j);
            String string = MethodCallNode.getParameterTypeName(this.methodParms[j]);
            String string2 = stringArray[j];
            if (string2.equals(string)) continue;
            if (ClassInspector.primitiveType(string2)) {
                methodBuilder.cast(string2);
                continue;
            }
            if (this.routineInfo != null) continue;
            methodBuilder.upCast(string2);
        }
        return this.methodParms.length;
    }

    public static String getParameterTypeName(JavaValueNode javaValueNode) throws StandardException {
        String string = javaValueNode.isPrimitiveType() ? javaValueNode.getPrimitiveTypeName() : javaValueNode.getJavaTypeName();
        return string;
    }

    public void generateOneParameter(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, int n) throws StandardException {
        this.methodParms[n].generateExpression(expressionClassBuilder, methodBuilder);
    }

    public void setNullParameterInfo(String[] stringArray) throws StandardException {
        for (int j = 0; j < this.methodParms.length; ++j) {
            if (!this.methodParms[j].getJavaTypeName().equals("")) continue;
            DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getSQLDataTypeDescriptor(stringArray[j]);
            ((SQLToJavaValueNode)this.methodParms[j]).value.setDescriptor(dataTypeDescriptor);
            this.methodParms[j].setJavaTypeName(stringArray[j]);
            this.signature[j] = this.methodParms[j].getJSQLType();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void resolveMethodCall(String string, boolean bl) throws StandardException {
        Object object2;
        String string2;
        String[] stringArray;
        if (this.routineInfo == null && !this.internalCall && (this.getCompilerContext().getReliability() & 0x400) != 0) {
            String string3;
            StringBuffer stringBuffer = new StringBuffer().append(string);
            if (bl) {
                string3 = "::";
                throw StandardException.newException("42X01", stringBuffer.append(string3).append(this.methodName).toString());
            }
            string3 = ".";
            throw StandardException.newException("42X01", stringBuffer.append(string3).append(this.methodName).toString());
        }
        int n = this.signature.length;
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        String[] stringArray2 = null;
        boolean[] blArray = this.getIsParam();
        boolean bl2 = this.routineInfo != null && n != 0 && n != this.methodParms.length;
        int n2 = this.methodName.indexOf(40);
        if (n2 != -1) {
            stringArray = this.parseValidateSignature(this.methodName, n2, bl2);
            this.methodName = this.methodName.substring(0, n2);
            bl2 = false;
        } else {
            stringArray = this.getObjectSignature();
        }
        try {
            this.method = classInspector.findPublicMethod(string, this.methodName, stringArray, null, blArray, bl, bl2);
            if (n2 == -1 && this.routineInfo == null && this.method == null) {
                stringArray2 = this.getPrimitiveSignature(false);
                this.method = classInspector.findPublicMethod(string, this.methodName, stringArray, stringArray2, blArray, bl, bl2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.method = null;
        }
        if (this.method == null) {
            this.throwNoMethodFound(string, stringArray, stringArray2);
        }
        this.actualMethodReturnType = string2 = classInspector.getType(this.method);
        if (this.routineInfo == null) {
            if (string2.equals("void") && !this.forCallStatement) {
                throw StandardException.newException("42Y09");
            }
        } else {
            String string4;
            String string5 = null;
            object2 = this.routineInfo.getReturnType();
            if (object2 == null) {
                string4 = "void";
            } else {
                TypeId typeId = TypeId.getBuiltInTypeId(object2.getJDBCTypeId());
                switch (object2.getJDBCTypeId()) {
                    case -5: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: {
                        TypeCompiler typeCompiler = this.getTypeCompiler(typeId);
                        string4 = typeCompiler.getCorrespondingPrimitiveTypeName();
                        if (this.routineInfo.calledOnNullInput() || this.routineInfo.getParameterCount() == 0) break;
                        string5 = typeId.getCorrespondingJavaTypeName();
                        break;
                    }
                    default: {
                        string4 = typeId.getCorrespondingJavaTypeName();
                    }
                }
            }
            if (!string4.equals(string2)) {
                this.throwNoMethodFound(string4 + " " + string, stringArray, stringArray2);
            }
            if (string5 != null) {
                string2 = string5;
            }
        }
        this.setJavaTypeName(string2);
        this.methodParameterTypes = classInspector.getParameterTypes(this.method);
        block10: for (int j = 0; j < this.methodParameterTypes.length; ++j) {
            object2 = this.methodParameterTypes[j];
            if (this.routineInfo != null && j < this.routineInfo.getParameterCount()) {
                int n3 = this.routineInfo.getParameterModes()[j];
                switch (n3) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        object2 = ((String)object2).substring(0, ((String)object2).length() - 2);
                        break;
                    }
                    case 4: {
                        continue block10;
                    }
                }
            }
            if (!ClassInspector.primitiveType((String)object2)) continue;
            this.methodParms[j].castToPrimitive(true);
        }
        if (this.someParametersAreNull()) {
            this.setNullParameterInfo(this.methodParameterTypes);
        }
        DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getSQLDataTypeDescriptor(string2);
        if (!this.getCompilerContext().getReturnParameterFlag()) return;
        this.getCompilerContext().getParameterTypes()[0] = dataTypeDescriptor;
    }

    private String[] parseValidateSignature(String string, int n, boolean bl) throws StandardException {
        String[] stringArray;
        int n2 = string.length();
        if (n + 1 == n2 || string.charAt(n2 - 1) != ')') {
            throw StandardException.newException("46J01");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n + 1, n2 - 1), ",", true);
        String[] stringArray2 = new String[this.signature.length];
        boolean bl2 = false;
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String[] stringArray3;
            Object object2;
            stringArray = stringTokenizer.nextToken().trim();
            if (",".equals(stringArray)) {
                if (!bl2) {
                    throw StandardException.newException("46J01");
                }
                bl2 = false;
                continue;
            }
            if (stringArray.length() == 0) {
                throw StandardException.newException("46J01");
            }
            bl2 = true;
            if (++n3 > this.signature.length) {
                if (bl) {
                    object2 = this.signature[this.signature.length - 1].getSQLType().getTypeId().getCorrespondingJavaTypeName();
                    if (!stringArray.equals(object2)) {
                        throw StandardException.newException("22005", stringArray, object2);
                    }
                    if (stringArray2.length == this.signature.length) {
                        stringArray3 = new String[stringTokenizer.countTokens()];
                        System.arraycopy(stringArray2, 0, stringArray3, 0, stringArray2.length);
                        stringArray2 = stringArray3;
                    }
                    stringArray2[n3 - 1] = stringArray;
                    continue;
                }
                throw StandardException.newException("46J02", Integer.toString(n3), (Object)Integer.toString(this.signature.length));
            }
            object2 = this.signature[n3 - 1].getSQLType().getTypeId();
            if (stringArray.equals(((TypeId)object2).getCorrespondingJavaTypeName())) {
                stringArray2[n3 - 1] = stringArray;
                continue;
            }
            if ((((TypeId)object2).isNumericTypeId() && !((TypeId)object2).isDecimalTypeId() || ((TypeId)object2).isBooleanTypeId()) && stringArray.equals((stringArray3 = this.getTypeCompiler((TypeId)object2)).getCorrespondingPrimitiveTypeName())) {
                stringArray2[n3 - 1] = stringArray;
                continue;
            }
            throw StandardException.newException("22005", stringArray, (Object)((TypeId)object2).getSQLTypeName());
        }
        if (n3 != 0 && !bl2) {
            throw StandardException.newException("46J01");
        }
        if (n3 < stringArray2.length) {
            if (bl && n3 == this.signature.length - 1) {
                stringArray = new String[n3];
                System.arraycopy(stringArray2, 0, stringArray, 0, n3);
                return stringArray;
            }
            throw StandardException.newException("46J02", Integer.toString(n3), (Object)Integer.toString(this.signature.length));
        }
        return stringArray2;
    }

    protected boolean someParametersAreNull() {
        int n = this.signature.length;
        for (int j = 0; j < n; ++j) {
            if (this.signature[j] != null) continue;
            return true;
        }
        return false;
    }

    protected String[] getObjectSignature() throws StandardException {
        int n = this.signature.length;
        String[] stringArray = new String[n];
        for (int j = 0; j < n; ++j) {
            stringArray[j] = this.getObjectTypeName(this.signature[j]);
        }
        return stringArray;
    }

    protected boolean[] getIsParam() {
        if (this.methodParms == null) {
            return new boolean[0];
        }
        boolean[] blArray = new boolean[this.methodParms.length];
        for (int j = 0; j < this.methodParms.length; ++j) {
            if (!(this.methodParms[j] instanceof SQLToJavaValueNode)) continue;
            SQLToJavaValueNode sQLToJavaValueNode = (SQLToJavaValueNode)this.methodParms[j];
            if (!sQLToJavaValueNode.value.isParameterNode()) continue;
            blArray[j] = true;
        }
        return blArray;
    }

    private String getObjectTypeName(JSQLType jSQLType) throws StandardException {
        if (jSQLType != null) {
            switch (jSQLType.getCategory()) {
                case 0: {
                    TypeId typeId = this.mapToTypeID(jSQLType);
                    if (typeId == null) {
                        return null;
                    }
                    switch (typeId.getJDBCTypeId()) {
                        case -5: 
                        case 4: 
                        case 5: 
                        case 7: 
                        case 8: {
                            if (this.routineInfo == null) break;
                            TypeCompiler typeCompiler = this.getTypeCompiler(typeId);
                            return typeCompiler.getCorrespondingPrimitiveTypeName();
                        }
                    }
                    return typeId.getCorrespondingJavaTypeName();
                }
                case 1: {
                    return jSQLType.getJavaClassName();
                }
                case 2: {
                    return JSQLType.primitiveNames[jSQLType.getPrimitiveKind()];
                }
            }
        }
        return "";
    }

    String[] getPrimitiveSignature(boolean bl) throws StandardException {
        int n = this.signature.length;
        String[] stringArray = new String[n];
        block5: for (int j = 0; j < n; ++j) {
            JSQLType jSQLType = this.signature[j];
            if (jSQLType == null) {
                stringArray[j] = "";
                continue;
            }
            switch (jSQLType.getCategory()) {
                case 0: {
                    if (this.procedurePrimitiveArrayType != null && j < this.procedurePrimitiveArrayType.length && this.procedurePrimitiveArrayType[j] != null) {
                        stringArray[j] = this.procedurePrimitiveArrayType[j];
                        continue block5;
                    }
                    TypeId typeId = this.mapToTypeID(jSQLType);
                    if (typeId.isNumericTypeId() && !typeId.isDecimalTypeId() || typeId.isBooleanTypeId()) {
                        TypeCompiler typeCompiler = this.getTypeCompiler(typeId);
                        stringArray[j] = typeCompiler.getCorrespondingPrimitiveTypeName();
                        if (!bl) continue block5;
                        this.methodParms[j].castToPrimitive(true);
                        continue block5;
                    }
                    stringArray[j] = typeId.getCorrespondingJavaTypeName();
                    continue block5;
                }
                case 1: {
                    stringArray[j] = jSQLType.getJavaClassName();
                    continue block5;
                }
                case 2: {
                    stringArray[j] = JSQLType.primitiveNames[jSQLType.getPrimitiveKind()];
                    if (!bl) continue block5;
                    this.methodParms[j].castToPrimitive(true);
                    continue block5;
                }
            }
        }
        return stringArray;
    }

    protected int getOrderableVariantType() throws StandardException {
        return this.getVariantTypeOfParams();
    }

    private int getVariantTypeOfParams() throws StandardException {
        int n = 2;
        if (this.methodParms != null) {
            for (int j = 0; j < this.methodParms.length; ++j) {
                if (this.methodParms[j] != null) {
                    int n2 = this.methodParms[j].getOrderableVariantType();
                    if (n2 >= n) continue;
                    n = n2;
                    continue;
                }
                n = 0;
            }
        }
        return n;
    }

    public JavaValueNode[] getMethodParms() {
        return this.methodParms;
    }

    public Visitable accept(Visitor visitor) throws StandardException {
        Visitable visitable = visitor.visit(this);
        if (visitor.skipChildren(this)) {
            return visitable;
        }
        for (int j = 0; !visitor.stopTraversal() && j < this.methodParms.length; ++j) {
            if (this.methodParms[j] == null) continue;
            this.methodParms[j] = (JavaValueNode)this.methodParms[j].accept(visitor);
        }
        return visitable;
    }
}

