/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.JoinStrategy;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizableList;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.impl.sql.compile.CostEstimateImpl;
import org.apache.derby.impl.sql.compile.Level2CostEstimateImpl;
import org.apache.derby.impl.sql.compile.OptimizerImpl;

public class Level2OptimizerImpl
extends OptimizerImpl {
    private LanguageConnectionContext lcc;

    Level2OptimizerImpl(OptimizableList optimizableList, OptimizablePredicateList optimizablePredicateList, DataDictionary dataDictionary, boolean bl, boolean bl2, boolean bl3, int n, JoinStrategy[] joinStrategyArray, int n2, RequiredRowOrdering requiredRowOrdering, int n3, LanguageConnectionContext languageConnectionContext) throws StandardException {
        super(optimizableList, optimizablePredicateList, dataDictionary, bl, bl2, bl3, n, joinStrategyArray, n2, requiredRowOrdering, n3);
        this.optimizerTrace = languageConnectionContext.getOptimizerTrace();
        this.optimizerTraceHtml = languageConnectionContext.getOptimizerTraceHtml();
        this.lcc = languageConnectionContext;
        if (this.optimizerTrace) {
            this.trace(1, 0, 0, 0.0, null);
        }
    }

    public int getLevel() {
        return 2;
    }

    public CostEstimate newCostEstimate() {
        return new Level2CostEstimateImpl();
    }

    public CostEstimateImpl getNewCostEstimate(double d2, double d3, double d4) {
        return new Level2CostEstimateImpl(d2, d3, d4);
    }

    public void trace(int n, int n2, int n3, double d2, Object object2) {
        String string = null;
        if (!this.optimizerTrace) {
            return;
        }
        switch (n) {
            case 1: {
                string = "Optimization started at time " + this.timeOptimizationStarted + " using optimizer " + this.hashCode();
                break;
            }
            case 2: {
                string = "Optimization time exceeded at time " + this.currentTime + "\n" + this.bestCost();
                break;
            }
            case 3: {
                string = "No tables to optimize.";
                break;
            }
            case 4: {
                string = "We have a complete join order.";
                break;
            }
            case 5: {
                string = "Cost of sorting is " + this.sortCost;
                break;
            }
            case 6: {
                string = "No best plan found.";
                break;
            }
            case 7: {
                string = "Modifying access paths using optimizer " + this.hashCode();
                break;
            }
            case 8: {
                String string2 = this.timeExceeded ? "time exceeded" : "cost";
                Optimizable optimizable = this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition]);
                if (optimizable.getBestAccessPath().getCostEstimate() == null) {
                    string2 = "no best plan found";
                }
                string = "Short circuiting based on " + string2 + " at join position " + this.joinPosition;
                break;
            }
            case 9: {
                string = this.buildJoinOrder("\n\nSkipping join order: ", true, n2, this.proposedJoinOrder);
                break;
            }
            case 10: {
                string = "User specified join order is not legal.";
                break;
            }
            case 11: {
                string = "User-specified join order has now been optimized.";
                break;
            }
            case 12: {
                string = this.buildJoinOrder("\n\nConsidering join order: ", false, n2, this.proposedJoinOrder);
                break;
            }
            case 13: {
                string = "Total cost of non-sort-avoidance plan is " + this.currentCost;
                break;
            }
            case 14: {
                string = "Total cost of sort avoidance plan is " + this.currentSortAvoidanceCost;
                break;
            }
            case 15: {
                string = "Total cost of non-sort-avoidance plan with sort cost added is " + this.currentCost;
                break;
            }
            case 16: {
                string = "Current plan is a sort avoidance plan.\n\tBest cost is : " + this.bestCost + "\n\tThis cost is : " + this.currentSortAvoidanceCost;
                break;
            }
            case 17: {
                string = "This is the cheapest plan so far.";
                break;
            }
            case 18: {
                string = "Plan is a " + (n2 == 1 ? "normal" : "sort avoidance") + " plan.";
                break;
            }
            case 19: {
                string = "Cost of cheapest plan is " + this.currentCost;
                break;
            }
            case 20: {
                string = "Sort needed for ordering: " + (n2 != 2) + "\n\tRow ordering: " + this.requiredRowOrdering;
                break;
            }
            case 21: {
                string = this.buildJoinOrder("\n\nRemembering join order as best: ", false, n2, this.bestJoinOrder);
                break;
            }
            case 22: {
                string = "Skipping access path due to excess memory usage, maximum is " + this.maxMemoryPerTable;
                break;
            }
            case 23: {
                string = "Cost of " + d2 + " scans is: " + object2 + " for table " + n2;
                break;
            }
            case 24: {
                string = "Skipping HASH JOIN because optimizable is not materializable";
                break;
            }
            case 25: {
                string = "Skipping HASH JOIN because there are no hash key columns";
                break;
            }
            case 26: {
                int[] nArray = (int[])object2;
                string = "# hash key columns = " + nArray.length;
                for (int j = 0; j < nArray.length; ++j) {
                    string = "\n" + string + "hashKeyColumns[" + j + "] = " + nArray[j];
                }
                break;
            }
            case 27: {
                string = "Calling optimizeIt() for join node";
                break;
            }
            case 28: {
                JoinStrategy joinStrategy = (JoinStrategy)object2;
                string = "\nConsidering join strategy " + joinStrategy + " for table " + n2;
                break;
            }
            case 29: {
                string = "Remembering access path " + object2 + " as truly the best for table " + n2 + " for plan type " + (n3 == 1 ? " normal " : "sort avoidance") + "\n";
                break;
            }
            case 30: {
                string = "No more conglomerates to consider for table " + n2;
                break;
            }
            case 31: {
                ConglomerateDescriptor conglomerateDescriptor = (ConglomerateDescriptor)object2;
                String string3 = this.dumpConglomerateDescriptor(conglomerateDescriptor);
                string = "\nConsidering conglomerate " + string3 + " for table " + n2;
                break;
            }
            case 32: {
                string = "Scanning heap, but we have a full match on a unique key.";
                break;
            }
            case 33: {
                string = "Adding unordered optimizable, # of predicates = " + n2;
                break;
            }
            case 34: {
                string = "Changing access path for table " + n2;
                break;
            }
            case 35: {
                string = "Lock mode set to MODE_TABLE because no start or stop position";
                break;
            }
            case 36: {
                string = "Index does not cover query - cost including base row fetch is: " + d2 + " for table " + n2;
                break;
            }
            case 37: {
                string = "Lock mode set to MODE_RECORD because all start and stop positions are constant";
                break;
            }
            case 38: {
                ConglomerateDescriptor conglomerateDescriptor = (ConglomerateDescriptor)object2;
                String string4 = this.dumpConglomerateDescriptor(conglomerateDescriptor);
                string = "Estimating cost of conglomerate: " + this.costForTable(string4, n2);
                break;
            }
            case 39: {
                string = "Looking for user-specified index: " + object2 + " for table " + n2;
                break;
            }
            case 40: {
                string = "Guaranteed to match a single row - cost is: " + d2 + " for table " + n2;
                break;
            }
            case 41: {
                string = this.costIncluding("1st column", object2, n2);
                string = "Cost including extra first column selectivity is : " + object2 + " for table " + n2;
                break;
            }
            case 42: {
                string = "Calling nextAccessPath() for base table " + object2 + " with " + n2 + " predicates.";
                break;
            }
            case 43: {
                string = this.lockModeThreshold("MODE_TABLE", "greater", d2, n2);
                break;
            }
            case 44: {
                string = this.lockModeThreshold("MODE_RECORD", "less", d2, n2);
                break;
            }
            case 45: {
                string = this.costIncluding("start/stop", object2, n2);
                break;
            }
            case 46: {
                string = this.costIncluding("qualifier", object2, n2);
                break;
            }
            case 47: {
                string = this.costIncluding("non-qualifier", object2, n2);
                break;
            }
            case 60: {
                string = this.costIncluding("selectivity from statistics", object2, n2);
                break;
            }
            case 62: {
                string = this.costIncluding("statistics for index being considered", object2, n2);
                break;
            }
            case 61: {
                string = "Selectivity from statistics found. It is " + d2;
                break;
            }
            case 48: {
                string = "Index does not cover query: cost including row fetch is: " + this.costForTable(object2, n2);
                break;
            }
            case 49: {
                string = "\nRemembering join strategy " + object2 + " as best for table " + n2;
                break;
            }
            case 50: {
                string = "in best access path";
                break;
            }
            case 51: {
                string = "in best sort avoidance access path";
                break;
            }
            case 52: {
                string = "in best unknown access path";
                break;
            }
            case 53: {
                ConglomerateDescriptor conglomerateDescriptor = (ConglomerateDescriptor)object2;
                String string5 = this.dumpConglomerateDescriptor(conglomerateDescriptor);
                string = "Cost of conglomerate " + string5 + " scan for table number " + n2 + " is : ";
                break;
            }
            case 54: {
                string = object2.toString();
                break;
            }
            case 55: {
                string = "\tNumber of extra first column predicates is : " + n2 + ", extra first column selectivity is : " + d2;
                break;
            }
            case 56: {
                string = "\tNumber of extra start/stop predicates is : " + n2 + ", extra start/stop selectivity is : " + d2;
                break;
            }
            case 57: {
                string = "\tNumber of extra qualifiers is : " + n2 + ", extra qualifier selectivity is : " + d2;
                break;
            }
            case 58: {
                string = "\tNumber of extra non-qualifiers is : " + n2 + ", extra non-qualifier selectivity is : " + d2;
                break;
            }
            case 59: {
                string = "\tNumber of start/stop statistics predicates is : " + n2 + ", statistics start/stop selectivity is : " + d2;
            }
        }
        this.lcc.appendOptimizerTraceOutput(string + "\n");
    }

    private String costForTable(Object object2, int n) {
        return object2 + " for table " + n;
    }

    private String bestCost() {
        return "Best cost = " + this.bestCost + "\n";
    }

    private String buildJoinOrder(String string, boolean bl, int n, int[] nArray) {
        String string2 = string;
        for (int j = 0; j <= this.joinPosition; ++j) {
            string2 = string2 + " " + nArray[j];
        }
        if (bl) {
            string2 = string2 + " " + n;
        }
        return string2 + " with assignedTableMap = " + this.assignedTableMap + "\n\n";
    }

    private String lockModeThreshold(String string, String string2, double d2, int n) {
        return "Lock mode set to " + string + " because estimated row count of " + d2 + " " + string2 + " than threshold of " + n;
    }

    private String costIncluding(String string, Object object2, int n) {
        return "Cost including extra " + string + " start/stop selectivity is : " + this.costForTable(object2, n);
    }

    private String dumpConglomerateDescriptor(ConglomerateDescriptor conglomerateDescriptor) {
        String string = "";
        String[] stringArray = conglomerateDescriptor.getColumnNames();
        if (conglomerateDescriptor.isIndex() && stringArray != null) {
            IndexRowGenerator indexRowGenerator = conglomerateDescriptor.getIndexDescriptor();
            int[] nArray = indexRowGenerator.baseColumnPositions();
            string = ", key columns = {" + stringArray[nArray[0] - 1];
            for (int j = 1; j < nArray.length; ++j) {
                string = string + ", " + stringArray[nArray[j] - 1];
            }
            string = string + "}";
        }
        return "CD: conglomerateNumber = " + conglomerateDescriptor.getConglomerateNumber() + " name = " + conglomerateDescriptor.getConglomerateName() + " uuid = " + conglomerateDescriptor.getUUID() + " indexable = " + conglomerateDescriptor.isIndex() + string;
    }
}

