/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BetweenOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryComparisonOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryListOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryOperatorNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.ValueNodeList;

public final class InListOperatorNode
extends BinaryListOperatorNode {
    private boolean isOrdered;

    public void init(Object object2, Object object3) {
        this.init(object2, object3, "IN", "in");
    }

    public String toString() {
        return "";
    }

    public ValueNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        super.preprocess(n, fromList, subqueryList, predicateList);
        if (this.rightOperandList.size() == 1) {
            BinaryComparisonOperatorNode binaryComparisonOperatorNode = (BinaryComparisonOperatorNode)this.getNodeFactory().getNode(41, this.leftOperand, (ValueNode)this.rightOperandList.elementAt(0), this.getContextManager());
            binaryComparisonOperatorNode.bindComparisonOperator();
            return binaryComparisonOperatorNode;
        }
        if (this.leftOperand instanceof ColumnReference && this.rightOperandList.containsAllConstantNodes()) {
            TypeId typeId = this.leftOperand.getTypeServices().getTypeId();
            DataValueDescriptor dataValueDescriptor = null;
            if (!this.rightOperandList.allSamePrecendence(typeId.typePrecedence())) {
                dataValueDescriptor = typeId.getNull();
            }
            this.rightOperandList.sortInAscendingOrder(dataValueDescriptor);
            this.isOrdered = true;
            ValueNode valueNode = this.leftOperand.getClone();
            ValueNode valueNode2 = (ValueNode)this.rightOperandList.elementAt(0);
            ValueNode valueNode3 = (ValueNode)this.rightOperandList.elementAt(this.rightOperandList.size() - 1);
            DataValueDescriptor dataValueDescriptor2 = ((ConstantNode)valueNode2).getValue();
            DataValueDescriptor dataValueDescriptor3 = ((ConstantNode)valueNode3).getValue();
            if (dataValueDescriptor == null && dataValueDescriptor2.compare(dataValueDescriptor3) == 0 || dataValueDescriptor != null && dataValueDescriptor.equals(dataValueDescriptor2, dataValueDescriptor3).equals(true)) {
                BinaryComparisonOperatorNode binaryComparisonOperatorNode = (BinaryComparisonOperatorNode)this.getNodeFactory().getNode(41, this.leftOperand, valueNode2, this.getContextManager());
                binaryComparisonOperatorNode.bindComparisonOperator();
                return binaryComparisonOperatorNode;
            }
            ValueNodeList valueNodeList = (ValueNodeList)this.getNodeFactory().getNode(15, this.getContextManager());
            valueNodeList.addValueNode(valueNode2);
            valueNodeList.addValueNode(valueNode3);
            BetweenOperatorNode betweenOperatorNode = (BetweenOperatorNode)this.getNodeFactory().getNode(53, valueNode, valueNodeList, this.getContextManager());
            AndNode andNode = (AndNode)this.getNodeFactory().getNode(39, this, betweenOperatorNode.preprocess(n, fromList, subqueryList, predicateList), this.getContextManager());
            andNode.postBindFixup();
            this.setTransformed();
            return andNode;
        }
        return this;
    }

    ValueNode eliminateNots(boolean bl) throws StandardException {
        AndNode andNode = null;
        int n = this.rightOperandList.size();
        if (!bl) {
            return this;
        }
        ValueNode valueNode = this.leftOperand instanceof ColumnReference ? this.leftOperand.getClone() : this.leftOperand;
        BinaryComparisonOperatorNode binaryComparisonOperatorNode = (BinaryComparisonOperatorNode)this.getNodeFactory().getNode(47, valueNode, (ValueNode)this.rightOperandList.elementAt(0), this.getContextManager());
        binaryComparisonOperatorNode.bindComparisonOperator();
        BinaryOperatorNode binaryOperatorNode = binaryComparisonOperatorNode;
        for (int j = 1; j < n; ++j) {
            valueNode = this.leftOperand instanceof ColumnReference ? this.leftOperand.getClone() : this.leftOperand;
            BinaryComparisonOperatorNode binaryComparisonOperatorNode2 = (BinaryComparisonOperatorNode)this.getNodeFactory().getNode(47, valueNode, (ValueNode)this.rightOperandList.elementAt(j), this.getContextManager());
            binaryComparisonOperatorNode2.bindComparisonOperator();
            andNode = (AndNode)this.getNodeFactory().getNode(39, binaryOperatorNode, binaryComparisonOperatorNode2, this.getContextManager());
            andNode.postBindFixup();
            binaryOperatorNode = andNode;
        }
        return binaryOperatorNode;
    }

    public boolean selfReference(ColumnReference columnReference) throws StandardException {
        int n = this.rightOperandList.size();
        for (int j = 0; j < n; ++j) {
            ValueNode valueNode = (ValueNode)this.rightOperandList.elementAt(j);
            if (!valueNode.getTablesReferenced().get(columnReference.getTableNumber())) continue;
            return true;
        }
        return false;
    }

    public double selectivity(Optimizable optimizable) {
        return 0.3;
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n = this.rightOperandList.size();
        String string = "org.apache.derby.iapi.types.DataValueDescriptor";
        String string2 = "org.apache.derby.iapi.types.DataValueDescriptor";
        String string3 = "org.apache.derby.iapi.types.DataValueDescriptor[]";
        this.receiver = this.leftOperand;
        String string4 = this.getTypeCompiler().interfaceName();
        LocalField localField = expressionClassBuilder.newFieldDeclaration(2, string3);
        MethodBuilder methodBuilder2 = expressionClassBuilder.getConstructor();
        methodBuilder2.pushNewArray("org.apache.derby.iapi.types.DataValueDescriptor", n);
        methodBuilder2.setField(localField);
        int n2 = 0;
        MethodBuilder methodBuilder3 = null;
        MethodBuilder methodBuilder4 = methodBuilder2;
        for (int j = 0; j < n; ++j) {
            MethodBuilder methodBuilder5;
            if (this.rightOperandList.elementAt(j) instanceof ConstantNode) {
                ++n2;
                if (methodBuilder4.statementNumHitLimit(1)) {
                    MethodBuilder methodBuilder6 = expressionClassBuilder.newGeneratedFun("void", 2);
                    methodBuilder4.pushThis();
                    methodBuilder4.callMethod((short)182, null, methodBuilder6.getName(), "void", 0);
                    if (methodBuilder4 != methodBuilder2) {
                        methodBuilder4.methodReturn();
                        methodBuilder4.complete();
                    }
                    methodBuilder4 = methodBuilder6;
                }
                methodBuilder5 = methodBuilder4;
            } else {
                if (methodBuilder3 == null) {
                    methodBuilder3 = expressionClassBuilder.newGeneratedFun("void", 4);
                }
                methodBuilder5 = methodBuilder3;
            }
            methodBuilder5.getField(localField);
            ((ValueNode)this.rightOperandList.elementAt(j)).generateExpression(expressionClassBuilder, methodBuilder5);
            methodBuilder5.upCast(string);
            methodBuilder5.setArrayElement(j);
        }
        if (methodBuilder4 != methodBuilder2) {
            methodBuilder4.methodReturn();
            methodBuilder4.complete();
        }
        if (methodBuilder3 != null) {
            methodBuilder3.methodReturn();
            methodBuilder3.complete();
            methodBuilder.pushThis();
            methodBuilder.callMethod((short)182, null, methodBuilder3.getName(), "void", 0);
        }
        this.leftOperand.generateExpression(expressionClassBuilder, methodBuilder);
        methodBuilder.dup();
        methodBuilder.upCast(string2);
        methodBuilder.getField(localField);
        methodBuilder.push(this.isOrdered);
        methodBuilder.callMethod((short)185, string, this.methodName, string4, 3);
    }

    public void generateStartStopKey(boolean bl, boolean bl2, ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n;
        int n2;
        int n3 = this.leftOperand.getTypeId().getTypeFormatId();
        int n4 = this.leftOperand.getTypeId().isUserDefinedTypeId() ? this.leftOperand.getTypeId().getJDBCTypeId() : -1;
        int n5 = this.rightOperandList.size();
        int n6 = 0;
        if (n5 < 5) {
            n2 = 1;
            n = (n5 - 1) % 4 + 1;
        } else {
            n2 = (n5 - 5) / 3 + 2;
            n = (n5 - 5) % 3 + 1;
        }
        for (int j = 0; j < n2; ++j) {
            Object object2;
            int n7;
            int n8 = j == n2 - 1 ? n : (j == 0 ? 4 : 3);
            for (n7 = 0; n7 < n8; ++n7) {
                object2 = (ValueNode)this.rightOperandList.elementAt(n6++);
                ((ValueNode)object2).generateExpression(expressionClassBuilder, methodBuilder);
                methodBuilder.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
            }
            n7 = j < n2 - 1 ? 0 : (j == 0 ? 4 - n : 3 - n);
            for (int k = 0; k < n7; ++k) {
                methodBuilder.pushNull("org.apache.derby.iapi.types.DataValueDescriptor");
            }
            methodBuilder.push(n3);
            methodBuilder.push(n4);
            object2 = bl && bl2 || !bl && !bl2 ? "minValue" : "maxValue";
            methodBuilder.callMethod((short)184, "org.apache.derby.impl.sql.execute.BaseExpressionActivation", (String)object2, "org.apache.derby.iapi.types.DataValueDescriptor", 6);
        }
    }
}

