/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.services.io.FormatableIntHolder;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.ExpressionClassBuilderInterface;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.compile.BaseJoinStrategy;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;

public class HashJoinStrategy
extends BaseJoinStrategy {
    public boolean feasible(Optimizable optimizable, OptimizablePredicateList optimizablePredicateList, Optimizer optimizer) throws StandardException {
        int[] nArray = null;
        ConglomerateDescriptor conglomerateDescriptor = null;
        if (!optimizable.isMaterializable()) {
            optimizer.trace(24, 0, 0, 0.0, null);
            return false;
        }
        if (optimizable.isTargetTable()) {
            return false;
        }
        if (optimizable.isBaseTable()) {
            conglomerateDescriptor = optimizable.getCurrentAccessPath().getConglomerateDescriptor();
        }
        return (nArray = this.findHashKeyColumns(optimizable, conglomerateDescriptor, optimizablePredicateList)) != null;
    }

    public boolean ignoreBulkFetch() {
        return true;
    }

    public boolean multiplyBaseCostByOuterRows() {
        return false;
    }

    public OptimizablePredicateList getBasePredicates(OptimizablePredicateList optimizablePredicateList, OptimizablePredicateList optimizablePredicateList2, Optimizable optimizable) throws StandardException {
        for (int j = optimizablePredicateList.size() - 1; j >= 0; --j) {
            OptimizablePredicate optimizablePredicate = optimizablePredicateList.getOptPredicate(j);
            if (!optimizable.getReferencedTableMap().contains(optimizablePredicate.getReferencedMap())) continue;
            optimizablePredicateList2.addOptPredicate(optimizablePredicate);
            optimizablePredicateList.removeOptPredicate(j);
        }
        optimizablePredicateList2.classify(optimizable, optimizable.getCurrentAccessPath().getConglomerateDescriptor());
        return optimizablePredicateList2;
    }

    public double nonBasePredicateSelectivity(Optimizable optimizable, OptimizablePredicateList optimizablePredicateList) {
        double d2 = 1.0;
        if (optimizablePredicateList != null) {
            for (int j = 0; j < optimizablePredicateList.size(); ++j) {
                if (optimizablePredicateList.isRedundantPredicate(j)) continue;
                d2 *= optimizablePredicateList.getOptPredicate(j).selectivity(optimizable);
            }
        }
        return d2;
    }

    public void putBasePredicates(OptimizablePredicateList optimizablePredicateList, OptimizablePredicateList optimizablePredicateList2) throws StandardException {
        for (int j = optimizablePredicateList2.size() - 1; j >= 0; --j) {
            OptimizablePredicate optimizablePredicate = optimizablePredicateList2.getOptPredicate(j);
            optimizablePredicateList.addOptPredicate(optimizablePredicate);
            optimizablePredicateList2.removeOptPredicate(j);
        }
    }

    public void estimateCost(Optimizable optimizable, OptimizablePredicateList optimizablePredicateList, ConglomerateDescriptor conglomerateDescriptor, CostEstimate costEstimate, Optimizer optimizer, CostEstimate costEstimate2) {
    }

    public int maxCapacity(int n, int n2, double d2) {
        if (n >= 0) {
            return n;
        }
        if ((d2 += (double)ClassSize.estimateHashEntrySize()) <= 1.0) {
            return n2;
        }
        return (int)((double)n2 / d2);
    }

    public String getName() {
        return "HASH";
    }

    public int scanCostType() {
        return 1;
    }

    public String resultSetMethodName(boolean bl) {
        return "getHashScanResultSet";
    }

    public String joinResultSetMethodName() {
        return "getHashJoinResultSet";
    }

    public String halfOuterJoinResultSetMethodName() {
        return "getHashLeftOuterJoinResultSet";
    }

    public int getScanArgs(TransactionController transactionController, MethodBuilder methodBuilder, Optimizable optimizable, OptimizablePredicateList optimizablePredicateList, OptimizablePredicateList optimizablePredicateList2, ExpressionClassBuilderInterface expressionClassBuilderInterface, int n, MethodBuilder methodBuilder2, int n2, int n3, int n4, boolean bl, int n5, int n6) throws StandardException {
        ExpressionClassBuilder expressionClassBuilder = (ExpressionClassBuilder)expressionClassBuilderInterface;
        this.fillInScanArgs1(transactionController, methodBuilder, optimizable, optimizablePredicateList, expressionClassBuilder, methodBuilder2);
        optimizablePredicateList2.generateQualifiers(expressionClassBuilder, methodBuilder, optimizable, true);
        methodBuilder.push(optimizable.initialCapacity());
        methodBuilder.push(optimizable.loadFactor());
        methodBuilder.push(optimizable.maxCapacity(this, n6));
        int[] nArray = optimizable.hashKeyColumns();
        Object[] objectArray = FormatableIntHolder.getFormatableIntHolders(nArray);
        FormatableArrayHolder formatableArrayHolder = new FormatableArrayHolder(objectArray);
        int n7 = expressionClassBuilder.addItem(formatableArrayHolder);
        methodBuilder.push(n7);
        this.fillInScanArgs2(methodBuilder, optimizable, n, n2, n3, n4, bl, n5);
        return 28;
    }

    public void divideUpPredicateLists(Optimizable optimizable, OptimizablePredicateList optimizablePredicateList, OptimizablePredicateList optimizablePredicateList2, OptimizablePredicateList optimizablePredicateList3, OptimizablePredicateList optimizablePredicateList4, DataDictionary dataDictionary) throws StandardException {
        int n;
        Object object2;
        int n2;
        optimizablePredicateList.copyPredicatesToOtherList(optimizablePredicateList4);
        ConglomerateDescriptor conglomerateDescriptor = optimizable.getTrulyTheBestAccessPath().getConglomerateDescriptor();
        optimizablePredicateList.transferPredicates(optimizablePredicateList2, optimizable.getReferencedTableMap(), optimizable);
        for (n2 = optimizablePredicateList2.size() - 1; n2 >= 0; --n2) {
            object2 = (Predicate)optimizablePredicateList2.getOptPredicate(n2);
            if (((Predicate)object2).isStoreQualifier() || ((Predicate)object2).isStartKey() || ((Predicate)object2).isStopKey()) continue;
            optimizablePredicateList2.removeOptPredicate(n2);
        }
        for (n2 = optimizablePredicateList.size() - 1; n2 >= 0; --n2) {
            object2 = (Predicate)optimizablePredicateList.getOptPredicate(n2);
            if (((Predicate)object2).isStoreQualifier()) continue;
            optimizablePredicateList.removeOptPredicate(n2);
        }
        optimizablePredicateList.copyPredicatesToOtherList(optimizablePredicateList3);
        Optimizable optimizable2 = optimizable;
        if (optimizable instanceof ProjectRestrictNode && ((SingleChildResultSetNode)(object2 = (ProjectRestrictNode)optimizable)).getChildResult() instanceof Optimizable) {
            optimizable2 = (Optimizable)((Object)((SingleChildResultSetNode)object2).getChildResult());
        }
        if ((object2 = (Object)this.findHashKeyColumns(optimizable2, conglomerateDescriptor, optimizablePredicateList3)) == null) {
            String string = conglomerateDescriptor != null && conglomerateDescriptor.isIndex() ? conglomerateDescriptor.getConglomerateName() : optimizable.getBaseTableName();
            throw StandardException.newException("42Y63", string, (Object)optimizable.getBaseTableName());
        }
        optimizable.setHashKeyColumns((int[])object2);
        optimizablePredicateList3.markAllPredicatesQualifiers();
        int[] nArray = new int[((Object)object2).length];
        if (conglomerateDescriptor != null && conglomerateDescriptor.isIndex()) {
            for (n = 0; n < ((Object)object2).length; ++n) {
                nArray[n] = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions()[object2[n]];
            }
        } else {
            for (n = 0; n < ((Object)object2).length; ++n) {
                nArray[n] = (int)(object2[n] + true);
            }
        }
        for (n = ((Object)object2).length - 1; n >= 0; --n) {
            optimizablePredicateList3.putOptimizableEqualityPredicateFirst(optimizable, nArray[n]);
        }
    }

    public boolean isHashJoin() {
        return true;
    }

    public boolean doesMaterialization() {
        return true;
    }

    private int[] findHashKeyColumns(Optimizable optimizable, ConglomerateDescriptor conglomerateDescriptor, OptimizablePredicateList optimizablePredicateList) throws StandardException {
        int n;
        if (optimizablePredicateList == null) {
            return null;
        }
        int[] nArray = null;
        if (conglomerateDescriptor == null) {
            nArray = new int[optimizable.getNumColumnsReturned()];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = n + 1;
            }
        } else if (conglomerateDescriptor.isIndex()) {
            nArray = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions();
        } else {
            nArray = new int[optimizable.getTableDescriptor().getNumberOfColumns()];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = n + 1;
            }
        }
        Vector<Integer> vector = new Vector<Integer>();
        for (n = 0; n < nArray.length; ++n) {
            if (!optimizablePredicateList.hasOptimizableEquijoin(optimizable, nArray[n])) continue;
            vector.addElement(new Integer(n));
        }
        if (vector.size() > 0) {
            int[] nArray2 = new int[vector.size()];
            for (int j = 0; j < nArray2.length; ++j) {
                nArray2[j] = (Integer)vector.elementAt(j);
            }
            return nArray2;
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }
}

