/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.sql.compile.ConstraintDefinitionNode;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.execute.ConstraintInfo;

public final class FKConstraintDefinitionNode
extends ConstraintDefinitionNode {
    TableName refTableName;
    ResultColumnList refRcl;
    SchemaDescriptor refTableSd;
    int refActionDeleteRule;
    int refActionUpdateRule;

    public void init(Object object2, Object object3, Object object4, Object object5, Object object6) {
        super.init(object2, ReuseFactory.getInteger(6), object4, null, null, null);
        this.refRcl = (ResultColumnList)object5;
        this.refTableName = (TableName)object3;
        this.refActionDeleteRule = ((int[])object6)[0];
        this.refActionUpdateRule = ((int[])object6)[1];
    }

    protected void bind(DDLStatementNode dDLStatementNode, DataDictionary dataDictionary) throws StandardException {
        super.bind(dDLStatementNode, dataDictionary);
        this.refTableSd = this.getSchemaDescriptor(this.refTableName.getSchemaName());
        if (this.refTableSd.isSystemSchema()) {
            throw StandardException.newException("42Y08");
        }
        if (!this.refTableName.equals(dDLStatementNode.getObjectName())) {
            if (this.getTableDescriptor(this.refTableName.getTableName(), this.refTableSd) == null) {
                throw StandardException.newException("X0Y46.S", this.getConstraintMoniker(), (Object)this.refTableName.getTableName());
            }
            dDLStatementNode.getTableDescriptor(this.refTableName);
        }
    }

    public ConstraintInfo getReferencedConstraintInfo() {
        return new ConstraintInfo(this.refTableName.getTableName(), this.refTableSd, this.refRcl.getColumnNames(), this.refActionDeleteRule, this.refActionUpdateRule);
    }

    public TableName getRefTableName() {
        return this.refTableName;
    }
}

