/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DropStatementNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;

public class DropTableNode
extends DropStatementNode {
    private long conglomerateNumber;
    private int dropBehavior;
    private TableDescriptor td;

    public void init(Object object2, Object object3) throws StandardException {
        this.initAndCheck(object2);
        this.dropBehavior = (Integer)object3;
    }

    public String toString() {
        return "";
    }

    public String statementToString() {
        return "DROP TABLE";
    }

    public QueryTreeNode bind() throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        this.td = this.getTableDescriptor();
        this.conglomerateNumber = this.td.getHeapConglomerateId();
        ConglomerateDescriptor conglomerateDescriptor = this.td.getConglomerateDescriptor(this.conglomerateNumber);
        compilerContext.createDependency(this.td);
        compilerContext.createDependency(conglomerateDescriptor);
        return this;
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.isSessionSchema(this.td.getSchemaDescriptor());
    }

    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getDropTableConstantAction(this.getFullName(), this.getRelativeName(), this.getSchemaDescriptor(), this.conglomerateNumber, this.td.getUUID(), this.dropBehavior);
    }
}

