/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.compile.NodeFactory;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.GenericDescriptorList;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.CurrentOfNode;
import org.apache.derby.impl.sql.compile.CurrentRowLocationNode;
import org.apache.derby.impl.sql.compile.DMLModStatementNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.UpdateNode;
import org.apache.derby.impl.sql.compile.VTIDeferModPolicy;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.execute.FKInfo;

public class DeleteNode
extends DMLModStatementNode {
    public static final String COLUMNNAME = "###RowLocationToDelete";
    protected boolean deferred;
    protected ExecRow emptyHeapRow;
    protected FromTable targetTable;
    protected FKInfo fkInfo;
    protected FormatableBitSet readColsBitSet;
    private ConstantAction[] dependentConstantActions;
    private boolean cascadeDelete;
    private QueryTreeNode[] dependentNodes;

    public void init(Object object2, Object object3) {
        super.init(object3);
        this.targetTableName = (TableName)object2;
    }

    public String statementToString() {
        return "DELETE";
    }

    public QueryTreeNode bind() throws StandardException {
        int n;
        int n2;
        Object object2;
        FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
        ResultColumn resultColumn = null;
        TableName tableName = null;
        CurrentOfNode currentOfNode = null;
        DataDictionary dataDictionary = this.getDataDictionary();
        super.bindTables(dataDictionary);
        SelectNode selectNode = (SelectNode)this.resultSet;
        this.targetTable = (FromTable)selectNode.fromList.elementAt(0);
        if (this.targetTable instanceof CurrentOfNode) {
            currentOfNode = (CurrentOfNode)this.targetTable;
            tableName = currentOfNode.getBaseCursorTargetTableName();
        }
        if (this.targetTable instanceof FromVTI) {
            this.targetVTI = (FromVTI)this.targetTable;
            this.targetVTI.setTarget();
        } else {
            if (this.targetTableName == null) {
                this.targetTableName = tableName;
            } else if (tableName != null && !this.targetTableName.equals(tableName)) {
                throw StandardException.newException("42X28", this.targetTableName, (Object)currentOfNode.getCursorName());
            }
            this.verifyTargetTable();
        }
        if (this.targetTable instanceof FromVTI) {
            this.getResultColumnList();
            this.resultColumnList = this.targetTable.getResultColumnsForList(null, this.resultColumnList, null);
            this.resultSet.setResultColumns(this.resultColumnList);
        } else {
            this.resultColumnList = new ResultColumnList();
            object2 = this.getResultColumnList(this.resultColumnList);
            this.readColsBitSet = this.getReadMap(dataDictionary, this.targetTableDescriptor);
            this.resultColumnList = ((FromBaseTable)object2).addColsToList(this.resultColumnList, this.readColsBitSet);
            n2 = this.targetTableDescriptor.getMaxColumnID();
            for (n = 1; n <= n2 && this.readColsBitSet.get(n); ++n) {
            }
            if (n > n2) {
                this.readColsBitSet = null;
            }
            this.emptyHeapRow = this.targetTableDescriptor.getEmptyExecRow(this.getContextManager());
            CurrentRowLocationNode currentRowLocationNode = (CurrentRowLocationNode)this.getNodeFactory().getNode(2, this.getContextManager());
            resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, COLUMNNAME, currentRowLocationNode, this.getContextManager());
            resultColumn.markGenerated();
            this.resultColumnList.addResultColumn(resultColumn);
            this.resultSet.setResultColumns(this.resultColumnList);
        }
        super.bindExpressions();
        this.resultSet.getResultColumns().bindUntypedNullsToResultColumns(this.resultColumnList);
        if (!(this.targetTable instanceof FromVTI)) {
            resultColumn.bindResultColumnToExpression();
            this.bindConstraints(dataDictionary, this.getNodeFactory(), this.targetTableDescriptor, null, this.resultColumnList, null, this.readColsBitSet, false, true);
            if (this.resultSet.subqueryReferencesTarget(this.targetTableDescriptor.getName(), true) || this.requiresDeferredProcessing()) {
                this.deferred = true;
            }
        } else {
            this.deferred = VTIDeferModPolicy.deferIt(3, this.targetVTI, null, selectNode.getWhereClause());
        }
        selectNode = null;
        if (this.fkTableNames != null) {
            object2 = this.targetTableDescriptor.getSchemaName() + "." + this.targetTableDescriptor.getName();
            if (!this.isDependentTable) {
                this.graphHashTable = new Hashtable();
            }
            if (!this.graphHashTable.containsKey(object2)) {
                this.cascadeDelete = true;
                n = this.fkTableNames.length;
                this.dependentNodes = new QueryTreeNode[n];
                this.graphHashTable.put(object2, new Integer(n));
                for (n2 = 0; n2 < n; ++n2) {
                    this.dependentNodes[n2] = this.getDependentTableNode(this.fkTableNames[n2], this.fkRefActions[n2], this.fkColDescriptors[n2]);
                    this.dependentNodes[n2].bind();
                }
            }
        } else if (this.isDependentTable) {
            object2 = this.targetTableDescriptor.getSchemaName() + "." + this.targetTableDescriptor.getName();
            this.graphHashTable.put(object2, new Integer(0));
        }
        return this;
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.resultSet.referencesSessionSchema();
    }

    public ConstantAction makeConstantAction() throws StandardException {
        if (this.targetTableDescriptor != null) {
            int n = this.resultSet.updateTargetLockMode();
            long l = this.targetTableDescriptor.getHeapConglomerateId();
            TransactionController transactionController = this.getLanguageConnectionContext().getTransactionCompile();
            StaticCompiledOpenConglomInfo[] staticCompiledOpenConglomInfoArray = new StaticCompiledOpenConglomInfo[this.indexConglomerateNumbers.length];
            for (int j = 0; j < staticCompiledOpenConglomInfoArray.length; ++j) {
                staticCompiledOpenConglomInfoArray[j] = transactionController.getStaticCompiledConglomInfo(this.indexConglomerateNumbers[j]);
            }
            if (this.targetTableDescriptor.getLockGranularity() == 'T') {
                n = 7;
            }
            ResultDescription resultDescription = null;
            if (this.isDependentTable) {
                resultDescription = this.makeResultDescription();
            }
            return this.getGenericConstantActionFactory().getDeleteConstantAction(l, this.targetTableDescriptor.getTableType(), transactionController.getStaticCompiledConglomInfo(l), this.indicesToMaintain, this.indexConglomerateNumbers, staticCompiledOpenConglomInfoArray, this.emptyHeapRow, this.deferred, false, this.targetTableDescriptor.getUUID(), n, null, null, null, 0L, null, null, resultDescription, this.getFKInfo(), this.getTriggerInfo(), this.readColsBitSet == null ? (FormatableBitSet)null : new FormatableBitSet(this.readColsBitSet), DeleteNode.getReadColMap(this.targetTableDescriptor.getNumberOfColumns(), this.readColsBitSet), this.resultColumnList.getStreamStorableColIds(this.targetTableDescriptor.getNumberOfColumns()), this.readColsBitSet == null ? this.targetTableDescriptor.getNumberOfColumns() : this.readColsBitSet.getNumBitsSet(), null, this.resultSet.isOneRowResultSet(), this.dependentConstantActions);
        }
        return this.getGenericConstantActionFactory().getUpdatableVTIConstantAction(3, this.deferred);
    }

    public void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n;
        String string;
        int n2;
        String string2;
        this.generateCodeForTemporaryTable(activationClassBuilder, methodBuilder);
        if (!this.isDependentTable) {
            this.generateParameterValueSet(activationClassBuilder);
        }
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        activationClassBuilder.newRowLocationScanResultSetName();
        this.resultSet.generate(activationClassBuilder, methodBuilder);
        if (this.targetTableDescriptor != null) {
            activationClassBuilder.newFieldDeclaration(2, "org.apache.derby.iapi.sql.execute.CursorResultSet", activationClassBuilder.getRowLocationScanResultSetName());
            string2 = this.cascadeDelete || this.isDependentTable ? "getDeleteCascadeResultSet" : "getDeleteResultSet";
            n2 = 2;
        } else {
            n2 = 2;
            string2 = "getDeleteVTIResultSet";
        }
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        if (this.isDependentTable) {
            n2 = 3;
            methodBuilder.push(activationClassBuilder.addItem(this.makeConstantAction()));
        } else if (this.cascadeDelete) {
            n2 = 3;
            methodBuilder.push(-1);
        }
        String string3 = "org.apache.derby.iapi.sql.ResultSet[]";
        if (this.cascadeDelete) {
            string = this.targetTableDescriptor.getSchemaName() + "." + this.targetTableDescriptor.getName();
            LocalField localField = activationClassBuilder.newFieldDeclaration(2, string3);
            methodBuilder.pushNewArray("org.apache.derby.iapi.sql.ResultSet", this.dependentNodes.length);
            methodBuilder.setField(localField);
            n2 = 4;
            for (int j = 0; j < this.dependentNodes.length; ++j) {
                this.dependentNodes[j].setRefActionInfo(this.fkIndexConglomNumbers[j], this.fkColArrays[j], string, true);
                methodBuilder.getField(localField);
                if (methodBuilder.statementNumHitLimit(10)) {
                    MethodBuilder methodBuilder2 = activationClassBuilder.newGeneratedFun("org.apache.derby.iapi.sql.ResultSet", 2);
                    this.dependentNodes[j].generate(activationClassBuilder, methodBuilder2);
                    methodBuilder2.methodReturn();
                    methodBuilder2.complete();
                    methodBuilder.pushThis();
                    methodBuilder.callMethod((short)182, null, methodBuilder2.getName(), "org.apache.derby.iapi.sql.ResultSet", 0);
                } else {
                    this.dependentNodes[j].generate(activationClassBuilder, methodBuilder);
                }
                methodBuilder.setArrayElement(j);
            }
            methodBuilder.getField(localField);
        } else if (this.isDependentTable) {
            n2 = 4;
            methodBuilder.pushNull(string3);
        }
        if (this.cascadeDelete || this.isDependentTable) {
            string = this.targetTableDescriptor.getSchemaName() + "." + this.targetTableDescriptor.getName();
            n2 = 5;
            methodBuilder.push(string);
        }
        methodBuilder.callMethod((short)185, null, string2, "org.apache.derby.iapi.sql.ResultSet", n2);
        if (!this.isDependentTable && this.cascadeDelete && (n = activationClassBuilder.getRowCount()) > 0) {
            MethodBuilder methodBuilder3 = activationClassBuilder.getConstructor();
            methodBuilder3.pushThis();
            methodBuilder3.pushNewArray("org.apache.derby.iapi.sql.execute.CursorResultSet", n);
            methodBuilder3.putField("org.apache.derby.impl.sql.execute.BaseActivation", "raParentResultSets", "org.apache.derby.iapi.sql.execute.CursorResultSet[]");
            methodBuilder3.endStatement();
        }
        if (!this.isDependentTable) {
            this.generateParameterHolders(activationClassBuilder);
        }
    }

    protected final int getStatementType() {
        return 4;
    }

    public FormatableBitSet getReadMap(DataDictionary dataDictionary, TableDescriptor tableDescriptor) throws StandardException {
        boolean[] blArray = new boolean[]{this.requiresDeferredProcessing()};
        Vector vector = new Vector();
        this.relevantTriggers = new GenericDescriptorList();
        FormatableBitSet formatableBitSet = DeleteNode.getDeleteReadMap(tableDescriptor, vector, this.relevantTriggers, blArray);
        this.markAffectedIndexes(vector);
        this.adjustDeferredFlag(blArray[0]);
        return formatableBitSet;
    }

    private QueryTreeNode getDependentTableNode(String string, int n, ColumnDescriptorList columnDescriptorList) throws StandardException {
        QueryTreeNode queryTreeNode = null;
        int n2 = string.indexOf(46);
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1);
        if (n == 0) {
            queryTreeNode = this.getEmptyDeleteNode(string2, string3);
            ((DeleteNode)queryTreeNode).isDependentTable = true;
            ((DeleteNode)queryTreeNode).graphHashTable = this.graphHashTable;
        }
        if (n == 3) {
            queryTreeNode = this.getEmptyUpdateNode(string2, string3, columnDescriptorList);
            ((UpdateNode)queryTreeNode).isDependentTable = true;
            ((UpdateNode)queryTreeNode).graphHashTable = this.graphHashTable;
        }
        return queryTreeNode;
    }

    private QueryTreeNode getEmptyDeleteNode(String string, String string2) throws StandardException {
        Object var3_3 = null;
        TableName tableName = null;
        FromTable fromTable = null;
        tableName = new TableName();
        tableName.init(string, string2);
        NodeFactory nodeFactory = this.getNodeFactory();
        FromList fromList = (FromList)nodeFactory.getNode(37, this.getContextManager());
        fromTable = (FromTable)nodeFactory.getNode(135, tableName, null, ReuseFactory.getInteger(2), null, this.getContextManager());
        FormatableProperties formatableProperties = new FormatableProperties();
        formatableProperties.put("index", "null");
        ((FromBaseTable)fromTable).setTableProperties(formatableProperties);
        fromList.addFromTable(fromTable);
        SelectNode selectNode = (SelectNode)nodeFactory.getNode(129, null, null, fromList, var3_3, null, this.getContextManager());
        QueryTreeNode queryTreeNode = nodeFactory.getNode(101, tableName, selectNode, this.getContextManager());
        return queryTreeNode;
    }

    private QueryTreeNode getEmptyUpdateNode(String string, String string2, ColumnDescriptorList columnDescriptorList) throws StandardException {
        Object var4_4 = null;
        TableName tableName = null;
        FromTable fromTable = null;
        tableName = new TableName();
        tableName.init(string, string2);
        NodeFactory nodeFactory = this.getNodeFactory();
        FromList fromList = (FromList)nodeFactory.getNode(37, this.getContextManager());
        fromTable = (FromTable)nodeFactory.getNode(135, tableName, null, ReuseFactory.getInteger(2), null, this.getContextManager());
        FormatableProperties formatableProperties = new FormatableProperties();
        formatableProperties.put("index", "null");
        ((FromBaseTable)fromTable).setTableProperties(formatableProperties);
        fromList.addFromTable(fromTable);
        SelectNode selectNode = (SelectNode)nodeFactory.getNode(129, this.getSetClause(tableName, columnDescriptorList), null, fromList, var4_4, null, this.getContextManager());
        QueryTreeNode queryTreeNode = nodeFactory.getNode(102, tableName, selectNode, this.getContextManager());
        return queryTreeNode;
    }

    private ResultColumnList getSetClause(TableName tableName, ColumnDescriptorList columnDescriptorList) throws StandardException {
        NodeFactory nodeFactory = this.getNodeFactory();
        ResultColumnList resultColumnList = (ResultColumnList)nodeFactory.getNode(9, this.getContextManager());
        ValueNode valueNode = (ValueNode)nodeFactory.getNode(13, this.getContextManager());
        for (int j = 0; j < columnDescriptorList.size(); ++j) {
            ColumnDescriptor columnDescriptor = columnDescriptorList.elementAt(j);
            if (!columnDescriptor.getType().isNullable()) continue;
            ResultColumn resultColumn = (ResultColumn)nodeFactory.getNode(80, columnDescriptor, valueNode, this.getContextManager());
            resultColumnList.addResultColumn(resultColumn);
        }
        return resultColumnList;
    }

    public QueryTreeNode optimize() throws StandardException {
        if (this.cascadeDelete) {
            for (int j = 0; j < this.dependentNodes.length; ++j) {
                this.dependentNodes[j] = this.dependentNodes[j].optimize();
            }
        }
        return super.optimize();
    }

    private static FormatableBitSet getDeleteReadMap(TableDescriptor tableDescriptor, Vector vector, GenericDescriptorList genericDescriptorList, boolean[] blArray) throws StandardException {
        int n = tableDescriptor.getMaxColumnID();
        FormatableBitSet formatableBitSet = new FormatableBitSet(n + 1);
        DMLModStatementNode.getXAffectedIndexes(tableDescriptor, null, formatableBitSet, vector);
        tableDescriptor.getAllRelevantTriggers(4, null, genericDescriptorList);
        if (genericDescriptorList.size() > 0) {
            blArray[0] = true;
        }
        if (genericDescriptorList.size() > 0) {
            for (int j = 1; j <= n; ++j) {
                formatableBitSet.set(j);
            }
        }
        return formatableBitSet;
    }
}

