/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class CurrentDatetimeOperatorNode
extends ValueNode {
    public static final int CURRENT_DATE = 0;
    public static final int CURRENT_TIME = 1;
    public static final int CURRENT_TIMESTAMP = 2;
    private static final int[] jdbcTypeId = new int[]{91, 92, 93};
    private static final String[] methodName = new String[]{"CURRENT DATE", "CURRENT TIME", "CURRENT TIMSTAMP"};
    private int whichType;

    public void init(Object object2) {
        this.whichType = (Integer)object2;
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        this.checkReliability(methodName[this.whichType], 1);
        this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcTypeId[this.whichType], false));
        return this;
    }

    protected int getOrderableVariantType() {
        return 2;
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        expressionClassBuilder.pushDataValueFactory(methodBuilder);
        switch (this.whichType) {
            case 0: {
                expressionClassBuilder.getCurrentDateExpression(methodBuilder);
                break;
            }
            case 1: {
                expressionClassBuilder.getCurrentTimeExpression(methodBuilder);
                break;
            }
            case 2: {
                expressionClassBuilder.getCurrentTimestampExpression(methodBuilder);
            }
        }
        String string = this.getTypeCompiler().interfaceName();
        LocalField localField = expressionClassBuilder.newFieldDeclaration(2, string);
        this.getTypeCompiler().generateDataValue(methodBuilder, localField);
    }

    public String toString() {
        return "";
    }
}

