/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.NodeFactory;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.CreateStatementNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.execute.ColumnInfo;

public class CreateViewNode
extends CreateStatementNode {
    Dependent currentDependent;
    ResultColumnList resultColumns;
    ResultSetNode queryExpression;
    String qeText;
    int checkOption;
    ProviderInfo[] providerInfos;
    ColumnInfo[] colInfos;

    public void init(Object object2, Object object3, Object object4, Object object5, Object object6) throws StandardException {
        this.initAndCheck(object2);
        this.resultColumns = (ResultColumnList)object3;
        this.queryExpression = (ResultSetNode)object4;
        this.checkOption = (Integer)object5;
        this.qeText = ((String)object6).trim();
        this.implicitCreateSchema = true;
    }

    public String toString() {
        return "";
    }

    public String statementToString() {
        return "CREATE VIEW";
    }

    public void printSubNodes(int n) {
    }

    public int getCheckOption() {
        return this.checkOption;
    }

    public ProviderInfo[] getProviderInfo() {
        return this.providerInfos;
    }

    public ColumnInfo[] getColumnInfo() {
        return this.colInfos;
    }

    public QueryTreeNode bind() throws StandardException {
        String string;
        CompilerContext compilerContext = this.getCompilerContext();
        DataDictionary dataDictionary = this.getDataDictionary();
        this.providerInfos = this.bindViewDefinition(dataDictionary, compilerContext, this.getLanguageConnectionContext(), this.getNodeFactory(), this.queryExpression, this.getContextManager());
        ResultColumnList resultColumnList = this.queryExpression.getResultColumns();
        if (this.resultColumns != null) {
            if (this.resultColumns.size() != resultColumnList.size()) {
                throw StandardException.newException("42X56", this.getFullName());
            }
            resultColumnList.copyResultColumnNames(this.resultColumns);
        }
        if ((string = resultColumnList.verifyUniqueNames(this.resultColumns == null)) != null) {
            throw StandardException.newException("42Y13", string);
        }
        this.currentDependent = compilerContext.getCurrentDependent();
        if (this.queryExpression.getResultColumns().size() > 5000) {
            throw StandardException.newException("54011", String.valueOf(this.queryExpression.getResultColumns().size()), (Object)this.getRelativeName(), (Object)String.valueOf(5000));
        }
        this.colInfos = new ColumnInfo[this.queryExpression.getResultColumns().size()];
        this.genColumnInfos(this.colInfos);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProviderInfo[] bindViewDefinition(DataDictionary dataDictionary, CompilerContext compilerContext, LanguageConnectionContext languageConnectionContext, NodeFactory nodeFactory, ResultSetNode resultSetNode, ContextManager contextManager) throws StandardException {
        FromList fromList = (FromList)nodeFactory.getNode(37, nodeFactory.doJoinOrderOptimization(), contextManager);
        ProviderList providerList = compilerContext.getCurrentAuxiliaryProviderList();
        ProviderList providerList2 = new ProviderList();
        try {
            compilerContext.setCurrentAuxiliaryProviderList(providerList2);
            resultSetNode = resultSetNode.bindNonVTITables(dataDictionary, fromList);
            resultSetNode = resultSetNode.bindVTITables(fromList);
            resultSetNode.bindExpressions(fromList);
            if (resultSetNode instanceof SelectNode && resultSetNode.referencesSessionSchema()) {
                throw StandardException.newException("XCL51.S");
            }
            resultSetNode.bindResultColumns(fromList);
        }
        finally {
            compilerContext.setCurrentAuxiliaryProviderList(providerList);
        }
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        ProviderInfo[] providerInfoArray = dependencyManager.getPersistentProviderInfos(providerList2);
        dependencyManager.clearColumnInfoInProviders(providerList2);
        return providerInfoArray;
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.queryExpression.referencesSessionSchema();
    }

    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getCreateViewConstantAction(this.getSchemaDescriptor().getSchemaName(), this.getRelativeName(), 2, this.qeText, this.checkOption, this.colInfos, this.providerInfos, null);
    }

    private void genColumnInfos(ColumnInfo[] columnInfoArray) {
        ResultColumnList resultColumnList = this.queryExpression.getResultColumns();
        int n = resultColumnList.size();
        for (int j = 0; j < n; ++j) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(j);
            columnInfoArray[j] = new ColumnInfo(resultColumn.getName(), resultColumn.getType(), null, null, null, null, 0, 0L, 0L);
        }
    }

    ResultSetNode getParsedQueryExpression() {
        return this.queryExpression;
    }

    public Visitable accept(Visitor visitor) throws StandardException {
        Visitable visitable = visitor.visit(this);
        if (visitor.skipChildren(this)) {
            return visitable;
        }
        if (!visitor.stopTraversal()) {
            super.accept(visitor);
        }
        if (this.queryExpression != null && !visitor.stopTraversal()) {
            this.queryExpression = (ResultSetNode)this.queryExpression.accept(visitor);
        }
        return visitable;
    }
}

