/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.CharConstantNode;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.UserTypeConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class CastNode
extends ValueNode {
    DataTypeDescriptor castTarget;
    ValueNode castOperand;
    int targetCharType;
    TypeId destCTI = null;
    TypeId sourceCTI = null;
    boolean forDataTypeFunction = false;

    public void init(Object object2, Object object3) throws StandardException {
        this.castOperand = (ValueNode)object2;
        this.castTarget = (DataTypeDescriptor)object3;
    }

    public void init(Object object2, Object object3, Object object4) throws StandardException {
        this.castOperand = (ValueNode)object2;
        int n = (Integer)object4;
        this.targetCharType = (Integer)object3;
        if (n < 0) {
            return;
        }
        this.castTarget = DataTypeDescriptor.getBuiltInDataTypeDescriptor(this.targetCharType, n);
    }

    public String toString() {
        return "";
    }

    public void printSubNodes(int n) {
    }

    protected int getOrderableVariantType() throws StandardException {
        return this.castOperand.getOrderableVariantType();
    }

    public void setClause(int n) {
        super.setClause(n);
        this.castOperand.setClause(n);
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        Object object2;
        int n;
        Object object3;
        this.castOperand = this.castOperand.bindExpression(fromList, subqueryList, vector);
        if (this.castTarget == null) {
            object3 = this.castOperand.getTypeServices();
            n = -1;
            TypeId typeId = ((DataTypeDescriptor)object3).getTypeId();
            if (object3 != null) {
                if (typeId.isNumericTypeId()) {
                    n = ((DataTypeDescriptor)object3).getPrecision() + 1;
                    if (((DataTypeDescriptor)object3).getScale() > 0) {
                        ++n;
                    }
                } else {
                    object2 = ((DataTypeDescriptor)object3).getTypeId();
                    if (n < 0) {
                        n = DataTypeUtilities.getColumnDisplaySize(((TypeId)object2).getJDBCTypeId(), -1);
                    }
                }
            }
            if (n < 0) {
                n = 1;
            }
            this.castTarget = DataTypeDescriptor.getBuiltInDataTypeDescriptor(this.targetCharType, n);
        }
        if (this.castOperand instanceof UntypedNullConstantNode) {
            this.castOperand.setType(this.castTarget);
        }
        this.bindCastNodeOnly();
        if (this.castOperand instanceof ConstantNode && !(this.castOperand instanceof UntypedNullConstantNode)) {
            object3 = this;
            n = this.sourceCTI.getJDBCTypeId();
            int n2 = this.destCTI.getJDBCTypeId();
            switch (n) {
                case -7: 
                case 16: {
                    if (n2 == -7 || n2 == 16) {
                        object3 = this.castOperand;
                        break;
                    }
                    if (n2 != 1) break;
                    object2 = (BooleanConstantNode)this.castOperand;
                    String string = ((BooleanConstantNode)object2).getValueAsString();
                    object3 = (ValueNode)this.getNodeFactory().getNode(61, string, ReuseFactory.getInteger(this.castTarget.getMaximumWidth()), this.getContextManager());
                    break;
                }
                case 1: {
                    object3 = this.getCastFromCharConstant(n2);
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    if (n2 != 1) break;
                    object2 = ((UserTypeConstantNode)this.castOperand).getObjectValue().toString();
                    object3 = (ValueNode)this.getNodeFactory().getNode(61, object2, ReuseFactory.getInteger(this.castTarget.getMaximumWidth()), this.getContextManager());
                    break;
                }
                case 3: {
                    if (n2 == 3 || n2 == 2) break;
                }
                case -6: 
                case -5: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    object3 = this.getCastFromNumericType(((ConstantNode)this.castOperand).getValue(), n2);
                }
            }
            return object3;
        }
        return this;
    }

    public void bindCastNodeOnly() throws StandardException {
        Object object2;
        this.setType(this.castTarget);
        this.destCTI = this.castTarget.getTypeId();
        this.sourceCTI = this.castOperand.getTypeId();
        if (!this.destCTI.systemBuiltIn()) {
            object2 = this.dataTypeServices.getTypeId().getCorrespondingJavaTypeName();
            boolean bl = !this.destCTI.getClassNameWasDelimitedIdentifier();
            object2 = this.verifyClassExist((String)object2, bl);
            this.castTarget = new DataTypeDescriptor(TypeId.getUserDefinedTypeId((String)object2, false), true);
            this.setType(this.castTarget);
            this.destCTI = this.castTarget.getTypeId();
        }
        if (this.castOperand.isParameterNode()) {
            this.bindParameter();
        } else if (!(this.castOperand instanceof UntypedNullConstantNode) && !(object2 = this.castOperand.getTypeCompiler()).convertible(this.destCTI, this.forDataTypeFunction)) {
            throw StandardException.newException("42846", this.sourceCTI.getSQLTypeName(), (Object)this.destCTI.getSQLTypeName());
        }
    }

    private ValueNode getCastFromCharConstant(int n) throws StandardException {
        String string = ((CharConstantNode)this.castOperand).getString();
        String string2 = StringUtil.SQLToUpperCase(string.trim());
        CastNode castNode = this;
        switch (n) {
            case -7: 
            case 16: {
                if (string2.equals("TRUE")) {
                    return (ValueNode)this.getNodeFactory().getNode(38, Boolean.TRUE, this.getContextManager());
                }
                if (string2.equals("FALSE")) {
                    return (ValueNode)this.getNodeFactory().getNode(38, Boolean.FALSE, this.getContextManager());
                }
                throw StandardException.newException("22018", "boolean");
            }
            case 91: {
                return (ValueNode)this.getNodeFactory().getNode(76, this.getDataValueFactory().getDateValue(string2, false), this.getContextManager());
            }
            case 93: {
                return (ValueNode)this.getNodeFactory().getNode(76, this.getDataValueFactory().getTimestampValue(string2, false), this.getContextManager());
            }
            case 92: {
                return (ValueNode)this.getNodeFactory().getNode(76, this.getDataValueFactory().getTimeValue(string2, false), this.getContextManager());
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                try {
                    return this.getCastFromIntegralType(new Double(string2).longValue(), n);
                }
                catch (NumberFormatException numberFormatException) {
                    String string3 = TypeId.getBuiltInTypeId(n).getSQLTypeName();
                    throw StandardException.newException("22018", string3);
                }
            }
            case 7: {
                Float f2;
                try {
                    f2 = Float.valueOf(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw StandardException.newException("22018", "float");
                }
                return (ValueNode)this.getNodeFactory().getNode(69, f2, this.getContextManager());
            }
            case 8: {
                Double d2;
                try {
                    d2 = new Double(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw StandardException.newException("22018", "double");
                }
                return (ValueNode)this.getNodeFactory().getNode(68, d2, this.getContextManager());
            }
        }
        return castNode;
    }

    private ValueNode getCastFromIntegralType(long l, int n) throws StandardException {
        CastNode castNode = this;
        switch (n) {
            case 1: {
                return (ValueNode)this.getNodeFactory().getNode(61, Long.toString(l), ReuseFactory.getInteger(this.castTarget.getMaximumWidth()), this.getContextManager());
            }
            case -6: {
                if (l < -128L || l > 127L) {
                    throw StandardException.newException("22003", "TINYINT");
                }
                return (ValueNode)this.getNodeFactory().getNode(75, ReuseFactory.getByte((byte)l), this.getContextManager());
            }
            case 5: {
                if (l < -32768L || l > 32767L) {
                    throw StandardException.newException("22003", "SHORT");
                }
                return (ValueNode)this.getNodeFactory().getNode(74, ReuseFactory.getShort((short)l), this.getContextManager());
            }
            case 4: {
                if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                    throw StandardException.newException("22003", "INTEGER");
                }
                return (ValueNode)this.getNodeFactory().getNode(70, ReuseFactory.getInteger((int)l), this.getContextManager());
            }
            case -5: {
                return (ValueNode)this.getNodeFactory().getNode(71, ReuseFactory.getLong(l), this.getContextManager());
            }
            case 7: {
                if ((float)Math.abs(l) > Float.MAX_VALUE) {
                    throw StandardException.newException("22003", "REAL");
                }
                return (ValueNode)this.getNodeFactory().getNode(69, new Float(l), this.getContextManager());
            }
            case 8: {
                return (ValueNode)this.getNodeFactory().getNode(68, new Double(l), this.getContextManager());
            }
        }
        return castNode;
    }

    private ValueNode getCastFromNumericType(DataValueDescriptor dataValueDescriptor, int n) throws StandardException {
        int n2 = -1;
        Object object2 = null;
        switch (n) {
            case 1: {
                n2 = 61;
                object2 = dataValueDescriptor.getString();
                return (ValueNode)this.getNodeFactory().getNode(n2, object2, ReuseFactory.getInteger(this.castTarget.getMaximumWidth()), this.getContextManager());
            }
            case -6: {
                n2 = 75;
                object2 = new Byte(dataValueDescriptor.getByte());
                break;
            }
            case 5: {
                n2 = 74;
                object2 = ReuseFactory.getShort(dataValueDescriptor.getShort());
                break;
            }
            case 4: {
                n2 = 70;
                object2 = ReuseFactory.getInteger(dataValueDescriptor.getInt());
                break;
            }
            case -5: {
                n2 = 71;
                object2 = ReuseFactory.getLong(dataValueDescriptor.getLong());
                break;
            }
            case 7: {
                n2 = 69;
                object2 = new Float(NumberDataType.normalizeREAL(dataValueDescriptor.getDouble()));
                break;
            }
            case 8: {
                n2 = 68;
                object2 = new Double(dataValueDescriptor.getDouble());
            }
        }
        if (n2 == -1) {
            return this;
        }
        return (ValueNode)this.getNodeFactory().getNode(n2, object2, this.getContextManager());
    }

    public ValueNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        this.castOperand = this.castOperand.preprocess(n, fromList, subqueryList, predicateList);
        return this;
    }

    public boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        return this.castOperand.categorize(jBitSet, bl);
    }

    public ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.castOperand = this.castOperand.remapColumnReferencesToExpressions();
        return this;
    }

    public boolean isConstantExpression() {
        return this.castOperand.isConstantExpression();
    }

    public boolean constantExpression(PredicateList predicateList) {
        return this.castOperand.constantExpression(predicateList);
    }

    void bindParameter() throws StandardException {
        ((ParameterNode)this.castOperand).setDescriptor(this.castTarget);
    }

    Object getConstantValueAsObject() throws StandardException {
        Object object2 = this.castOperand.getConstantValueAsObject();
        if (object2 == null) {
            return null;
        }
        if (this.sourceCTI.getCorrespondingJavaTypeName().equals(this.destCTI.getCorrespondingJavaTypeName())) {
            return object2;
        }
        return null;
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.castOperand.generateExpression(expressionClassBuilder, methodBuilder);
        if (this.castOperand instanceof UntypedNullConstantNode) {
            return;
        }
        if (this.castOperand.isParameterNode()) {
            this.sourceCTI = this.destCTI;
        }
        this.genDataValueConversion(expressionClassBuilder, methodBuilder);
    }

    private void genDataValueConversion(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        String string;
        MethodBuilder methodBuilder2 = expressionClassBuilder.getConstructor();
        String string2 = this.getTypeCompiler().interfaceName();
        LocalField localField = expressionClassBuilder.newFieldDeclaration(2, string2);
        expressionClassBuilder.generateNull(methodBuilder2, this.getTypeCompiler(this.destCTI));
        methodBuilder2.setField(localField);
        if (!(this.sourceCTI.isNationalStringTypeId() || this.sourceCTI.userType() || this.destCTI.userType())) {
            methodBuilder.getField(localField);
            methodBuilder.swap();
            methodBuilder.cast("org.apache.derby.iapi.types.DataValueDescriptor");
            methodBuilder.callMethod((short)185, "org.apache.derby.iapi.types.DataValueDescriptor", "setValue", "void", 1);
            methodBuilder.getField(localField);
            if (this.destCTI.variableLength()) {
                boolean bl = this.destCTI.isNumericTypeId();
                methodBuilder.push(bl ? this.castTarget.getPrecision() : this.castTarget.getMaximumWidth());
                methodBuilder.push(this.castTarget.getScale());
                methodBuilder.push(!this.sourceCTI.variableLength() || bl);
                methodBuilder.callMethod((short)185, "org.apache.derby.iapi.types.VariableSizeDataValue", "setWidth", "org.apache.derby.iapi.types.DataValueDescriptor", 3);
                methodBuilder.cast(string2);
            }
            return;
        }
        String string3 = "getObject";
        String string4 = "java.lang.Object";
        String string5 = this.sourceCTI.getCorrespondingJavaTypeName();
        int n = 0;
        if (this.sourceCTI.isNationalStringTypeId()) {
            switch (this.destCTI.getJDBCTypeId()) {
                case 91: {
                    string3 = "getDate";
                    string5 = string4 = "java.sql.Date";
                    break;
                }
                case 92: {
                    string3 = "getTime";
                    string5 = string4 = "java.sql.Time";
                    break;
                }
                case 93: {
                    string3 = "getTimestamp";
                    string5 = string4 = "java.sql.Timestamp";
                }
            }
            if (!string3.equals("getObject")) {
                methodBuilder.pushThis();
                methodBuilder.callMethod((short)182, expressionClassBuilder.getBaseClassName(), "getCalendar", "java.util.Calendar", 0);
                ++n;
            }
        }
        methodBuilder.callMethod((short)185, "org.apache.derby.iapi.types.DataValueDescriptor", string3, string4, n);
        methodBuilder.cast(this.destCTI.userType() || this.sourceCTI.userType() ? "java.lang.Object" : string5);
        methodBuilder.getField(localField);
        methodBuilder.swap();
        if (this.sourceCTI.userType()) {
            string = this.getTypeId().getCorrespondingJavaTypeName();
            methodBuilder.dup();
            methodBuilder.isInstanceOf(string);
            methodBuilder.push(string);
            methodBuilder.callMethod((short)185, "org.apache.derby.iapi.types.DataValueDescriptor", "setObjectForCast", "void", 3);
        } else {
            string = "org.apache.derby.iapi.types.DataValueDescriptor";
            if (string5.startsWith("java.lang.") && !string5.equals("java.lang.String") && !string5.equals("java.lang.Object")) {
                string = string2;
            }
            methodBuilder.callMethod((short)185, string, "setValue", "void", 1);
        }
        methodBuilder.getField(localField);
        if (this.destCTI.variableLength()) {
            boolean bl = this.destCTI.isNumericTypeId();
            methodBuilder.push(bl ? this.castTarget.getPrecision() : this.castTarget.getMaximumWidth());
            methodBuilder.push(this.castTarget.getScale());
            methodBuilder.push(!this.sourceCTI.variableLength() || bl);
            methodBuilder.callMethod((short)185, "org.apache.derby.iapi.types.VariableSizeDataValue", "setWidth", "org.apache.derby.iapi.types.DataValueDescriptor", 3);
            methodBuilder.cast(string2);
        }
    }

    public Visitable accept(Visitor visitor) throws StandardException {
        Visitable visitable = visitor.visit(this);
        if (visitor.skipChildren(this)) {
            return visitable;
        }
        if (this.castOperand != null && !visitor.stopTraversal()) {
            this.castOperand = (ValueNode)this.castOperand.accept(visitor);
        }
        return visitable;
    }

    public void setForDataTypeFunction(boolean bl) {
        this.forDataTypeFunction = bl;
    }

    public boolean getForDataTypeFunction() {
        return this.forDataTypeFunction;
    }
}

