/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.impl.sql.GenericColumnDescriptor;

public final class GenericResultDescription
implements ResultDescription,
Formatable {
    private ResultColumnDescriptor[] columns;
    private String statementType;

    public GenericResultDescription() {
    }

    public GenericResultDescription(ResultColumnDescriptor[] resultColumnDescriptorArray, String string) {
        this.columns = resultColumnDescriptorArray;
        this.statementType = string;
    }

    public GenericResultDescription(ResultDescription resultDescription, int[] nArray) {
        this.columns = new ResultColumnDescriptor[nArray.length];
        for (int j = 0; j < nArray.length; ++j) {
            this.columns[j] = resultDescription.getColumnDescriptor(nArray[j]);
        }
        this.statementType = resultDescription.getStatementType();
    }

    public String getStatementType() {
        return this.statementType;
    }

    public int getColumnCount() {
        return this.columns == null ? 0 : this.columns.length;
    }

    public ResultColumnDescriptor[] getColumnInfo() {
        return this.columns;
    }

    public ResultColumnDescriptor getColumnDescriptor(int n) {
        return this.columns[n - 1];
    }

    public ResultDescription truncateColumns(int n) {
        ResultColumnDescriptor[] resultColumnDescriptorArray = new ResultColumnDescriptor[n - 1];
        System.arraycopy(this.columns, 0, resultColumnDescriptorArray, 0, resultColumnDescriptorArray.length);
        return new GenericResultDescription(resultColumnDescriptorArray, this.statementType);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.columns == null ? 0 : this.columns.length;
        objectOutput.writeObject(this.statementType);
        objectOutput.writeInt(n);
        while (n-- > 0) {
            if (!(this.columns[n] instanceof GenericColumnDescriptor)) {
                this.columns[n] = new GenericColumnDescriptor(this.columns[n]);
            }
            objectOutput.writeObject(this.columns[n]);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.columns = null;
        this.statementType = (String)objectInput.readObject();
        int n = objectInput.readInt();
        if (n > 0) {
            this.columns = new GenericColumnDescriptor[n];
            while (n-- > 0) {
                this.columns[n] = (ResultColumnDescriptor)objectInput.readObject();
            }
        }
    }

    public int getTypeFormatId() {
        return 228;
    }

    public String toString() {
        return "";
    }
}

