/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql;

import java.sql.SQLWarning;
import java.sql.Timestamp;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.Statement;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecCursorTableReference;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.sql.CursorInfo;
import org.apache.derby.impl.sql.GenericActivationHolder;
import org.apache.derby.impl.sql.compile.QueryTreeNode;

public class GenericPreparedStatement
implements ExecPreparedStatement {
    public Statement statement;
    protected GeneratedClass activationClass;
    protected ResultDescription resultDesc;
    protected DataTypeDescriptor[] paramTypeDescriptors;
    private String spsName;
    private SQLWarning warnings;
    private boolean referencesSessionSchema;
    protected ExecCursorTableReference targetTable;
    protected ResultColumnDescriptor[] targetColumns;
    protected String[] updateColumns;
    protected int updateMode;
    protected ConstantAction executionConstants;
    protected Object[] savedObjects;
    protected String UUIDString;
    protected UUID UUIDValue;
    private ParameterValueSet params;
    private boolean needsSavepoint;
    private String execStmtName;
    private String execSchemaName;
    protected boolean isAtomic;
    protected String sourceTxt;
    private int inUseCount;
    boolean compilingStatement;
    protected long parseTime;
    protected long bindTime;
    protected long optimizeTime;
    protected long generateTime;
    protected long compileTime;
    protected Timestamp beginCompileTimestamp;
    protected Timestamp endCompileTimestamp;
    protected boolean isValid;
    protected boolean spsAction;
    private Cacheable cacheHolder;

    protected GenericPreparedStatement() {
        UUIDFactory uUIDFactory = Monitor.getMonitor().getUUIDFactory();
        this.UUIDValue = uUIDFactory.createUUID();
        this.UUIDString = this.UUIDValue.toString();
        this.spsAction = false;
    }

    public GenericPreparedStatement(Statement statement) {
        this();
        this.statement = statement;
    }

    public synchronized boolean upToDate() throws StandardException {
        boolean bl;
        boolean bl2 = bl = this.isValid && this.activationClass != null && !this.compilingStatement;
        if (this.executionConstants != null) {
            boolean bl3 = this.executionConstants.upToDate();
            bl = bl && bl3;
        }
        return bl;
    }

    public void rePrepare(LanguageConnectionContext languageConnectionContext) throws StandardException {
        if (!this.upToDate()) {
            this.makeValid(languageConnectionContext);
        }
    }

    public synchronized Activation getActivation(LanguageConnectionContext languageConnectionContext, boolean bl) throws StandardException {
        GeneratedClass generatedClass = this.getActivationClass();
        if (generatedClass == null) {
            this.rePrepare(languageConnectionContext);
            generatedClass = this.getActivationClass();
        }
        GenericActivationHolder genericActivationHolder = new GenericActivationHolder(languageConnectionContext, generatedClass, this, bl);
        if (this.params != null) {
            genericActivationHolder.setParameters(this.params, null);
        }
        ++this.inUseCount;
        return genericActivationHolder;
    }

    public ResultSet execute(LanguageConnectionContext languageConnectionContext, boolean bl) throws StandardException {
        Activation activation = this.getActivation(languageConnectionContext, false);
        activation.setSingleExecution();
        return this.execute(activation, false, false, bl);
    }

    public ResultSet execute(Activation activation, boolean bl, boolean bl2, boolean bl3) throws StandardException {
        Object object2;
        Object object3;
        LanguageConnectionContext languageConnectionContext;
        boolean bl4 = false;
        if (activation == null || activation.getPreparedStatement() != this) {
            throw StandardException.newException("XCL09.S", "execute");
        }
        while (true) {
            Object object4;
            if ((languageConnectionContext = activation.getLanguageConnectionContext()).getLogStatementText()) {
                object4 = Monitor.getStream();
                object3 = languageConnectionContext.getTransactionExecute().getActiveStateTxIdString();
                object2 = "";
                ParameterValueSet parameterValueSet = activation.getParameterValueSet();
                if (parameterValueSet != null && parameterValueSet.getParameterCount() > 0) {
                    object2 = " with " + parameterValueSet.getParameterCount() + " parameters " + parameterValueSet.toString();
                }
                object4.printlnWithHeader("(XID = " + (String)object3 + "), " + "(SESSIONID = " + languageConnectionContext.getInstanceNumber() + "), " + "(DATABASE = " + languageConnectionContext.getDbname() + "), " + "(DRDAID = " + languageConnectionContext.getDrdaID() + "), Executing prepared statement: " + this.getSource() + " :End prepared statement" + (String)object2);
            }
            object4 = activation.getParameterValueSet();
            if (!this.spsAction) {
                this.rePrepare(languageConnectionContext);
            }
            object3 = languageConnectionContext.pushStatementContext(this.isAtomic, this.getSource(), (ParameterValueSet)object4, bl3);
            if (this.needsSavepoint()) {
                object3.setSavePoint();
                bl4 = true;
            }
            if (this.executionConstants != null) {
                languageConnectionContext.validateStmtExecution(this.executionConstants);
            }
            object2 = null;
            try {
                object2 = activation.execute();
                object2.open();
            }
            catch (StandardException standardException) {
                if (!standardException.getMessageId().equals("XCL32.S") || this.spsAction) {
                    throw standardException;
                }
                object3.cleanupOnError(standardException);
                continue;
            }
            break;
        }
        if (bl4) {
            object3.clearSavePoint();
        }
        languageConnectionContext.popStatementContext((StatementContext)object3, null);
        if (activation.isSingleExecution() && object2.isClosed()) {
            activation.close();
        }
        if (!object2.returnsRows() && bl) {
            throw StandardException.newException("X0Y78.S");
        }
        if (object2.returnsRows() && bl2) {
            throw StandardException.newException("X0Y79.S");
        }
        return object2;
    }

    public ResultDescription getResultDescription() {
        return this.resultDesc;
    }

    public DataTypeDescriptor[] getParameterTypes() {
        return this.paramTypeDescriptors;
    }

    public String getSource() {
        return this.sourceTxt != null ? this.sourceTxt : (this.statement == null ? "null" : this.statement.getSource());
    }

    public void setSource(String string) {
        this.sourceTxt = string;
    }

    public final void setSPSName(String string) {
        this.spsName = string;
    }

    public String getSPSName() {
        return this.spsName;
    }

    public long getCompileTimeInMillis() {
        return this.compileTime;
    }

    public long getParseTimeInMillis() {
        return this.parseTime;
    }

    public long getBindTimeInMillis() {
        return this.bindTime;
    }

    public long getOptimizeTimeInMillis() {
        return this.optimizeTime;
    }

    public long getGenerateTimeInMillis() {
        return this.generateTime;
    }

    public Timestamp getBeginCompileTimestamp() {
        return this.beginCompileTimestamp;
    }

    public Timestamp getEndCompileTimestamp() {
        return this.endCompileTimestamp;
    }

    void setCompileTimeWarnings(SQLWarning sQLWarning) {
        this.warnings = sQLWarning;
    }

    public final SQLWarning getCompileTimeWarnings() {
        return this.warnings;
    }

    protected void setCompileTimeMillis(long l, long l2, long l3, long l4, long l5, Timestamp timestamp, Timestamp timestamp2) {
        this.parseTime = l;
        this.bindTime = l2;
        this.optimizeTime = l3;
        this.generateTime = l4;
        this.compileTime = l5;
        this.beginCompileTimestamp = timestamp;
        this.endCompileTimestamp = timestamp2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(LanguageConnectionContext languageConnectionContext) {
        GenericPreparedStatement genericPreparedStatement = this;
        synchronized (genericPreparedStatement) {
            --this.inUseCount;
            if (this.cacheHolder != null) {
                return;
            }
            if (this.inUseCount != 0) {
                return;
            }
        }
        try {
            this.makeInvalid(11, languageConnectionContext);
        }
        catch (StandardException standardException) {
            // empty catch block
        }
    }

    public final void setConstantAction(ConstantAction constantAction) {
        this.executionConstants = constantAction;
    }

    public final ConstantAction getConstantAction() {
        return this.executionConstants;
    }

    public final void setSavedObjects(Object[] objectArray) {
        this.savedObjects = objectArray;
    }

    public final Object getSavedObject(int n) {
        return this.savedObjects[n];
    }

    public final Object[] getSavedObjects() {
        return this.savedObjects;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid() {
        this.isValid = true;
    }

    public void setSPSAction() {
        this.spsAction = true;
    }

    public void prepareToInvalidate(Provider provider, int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
        switch (n) {
            case 3: 
            case 5: {
                return;
            }
        }
        languageConnectionContext.verifyNoOpenResultSets(this, provider, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeInvalid(int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
        GenericPreparedStatement genericPreparedStatement;
        boolean bl;
        Object object2 = this;
        synchronized (object2) {
            if (this.compilingStatement) {
                return;
            }
            bl = !this.isValid;
            this.isValid = false;
            this.compilingStatement = true;
        }
        try {
            object2 = languageConnectionContext.getDataDictionary().getDependencyManager();
            if (!bl) {
                object2.invalidateFor(this, n, languageConnectionContext);
            }
            object2.clearDependencies(languageConnectionContext, this);
            if (this.execStmtName != null) {
                switch (n) {
                    case 5: 
                    case 23: {
                        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
                        SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(this.execSchemaName, languageConnectionContext.getTransactionCompile(), true);
                        SPSDescriptor sPSDescriptor = dataDictionary.getSPSDescriptor(this.execStmtName, schemaDescriptor);
                        sPSDescriptor.makeInvalid(n, languageConnectionContext);
                    }
                }
            }
            Object var9_9 = null;
            genericPreparedStatement = this;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            GenericPreparedStatement genericPreparedStatement2 = this;
            synchronized (genericPreparedStatement2) {
                this.compilingStatement = false;
                this.notifyAll();
            }
            throw throwable;
        }
        synchronized (genericPreparedStatement) {
            this.compilingStatement = false;
            this.notifyAll();
        }
    }

    public void makeValid(LanguageConnectionContext languageConnectionContext) throws StandardException {
        PreparedStatement preparedStatement = this.statement.prepare(languageConnectionContext);
    }

    public boolean isPersistent() {
        return false;
    }

    public DependableFinder getDependableFinder() {
        return null;
    }

    public String getObjectName() {
        return this.UUIDString;
    }

    public UUID getObjectID() {
        return this.UUIDValue;
    }

    public String getClassType() {
        return "PreparedStatement";
    }

    public boolean referencesSessionSchema() {
        return this.referencesSessionSchema;
    }

    public boolean referencesSessionSchema(QueryTreeNode queryTreeNode) throws StandardException {
        this.referencesSessionSchema = queryTreeNode.referencesSessionSchema();
        return this.referencesSessionSchema;
    }

    void completeCompile(QueryTreeNode queryTreeNode) throws StandardException {
        CursorInfo cursorInfo;
        this.paramTypeDescriptors = queryTreeNode.getParameterTypes();
        if (this.targetTable != null) {
            this.targetTable = null;
            this.updateMode = 0;
            this.updateColumns = null;
            this.targetColumns = null;
        }
        this.resultDesc = queryTreeNode.makeResultDescription();
        if (this.resultDesc != null && (cursorInfo = (CursorInfo)queryTreeNode.getCursorInfo()) != null) {
            this.targetTable = cursorInfo.targetTable;
            this.targetColumns = cursorInfo.targetColumns;
            this.updateColumns = cursorInfo.updateColumns;
            this.updateMode = cursorInfo.updateMode;
        }
        this.isValid = true;
    }

    public GeneratedClass getActivationClass() throws StandardException {
        return this.activationClass;
    }

    void setActivationClass(GeneratedClass generatedClass) {
        this.activationClass = generatedClass;
    }

    public int getUpdateMode() {
        return this.updateMode;
    }

    public ExecCursorTableReference getTargetTable() {
        return this.targetTable;
    }

    public ResultColumnDescriptor[] getTargetColumns() {
        return this.targetColumns;
    }

    public String[] getUpdateColumns() {
        return this.updateColumns;
    }

    public Object getCursorInfo() {
        return new CursorInfo(this.updateMode, this.targetTable, this.targetColumns, this.updateColumns);
    }

    void setCursorInfo(CursorInfo cursorInfo) {
        if (cursorInfo != null) {
            this.updateMode = cursorInfo.updateMode;
            this.targetTable = cursorInfo.targetTable;
            this.targetColumns = cursorInfo.targetColumns;
            this.updateColumns = cursorInfo.updateColumns;
        }
    }

    ByteArray getByteCodeSaver() {
        return null;
    }

    protected void setParams(ParameterValueSet parameterValueSet) {
        this.params = parameterValueSet;
    }

    public boolean needsSavepoint() {
        return this.needsSavepoint;
    }

    void setNeedsSavepoint(boolean bl) {
        this.needsSavepoint = bl;
    }

    void setIsAtomic(boolean bl) {
        this.isAtomic = bl;
    }

    public boolean isAtomic() {
        return this.isAtomic;
    }

    void setExecuteStatementNameAndSchema(String string, String string2) {
        this.execStmtName = string;
        this.execSchemaName = string2;
    }

    public ExecPreparedStatement getClone() throws StandardException {
        GenericPreparedStatement genericPreparedStatement = new GenericPreparedStatement(this.statement);
        genericPreparedStatement.activationClass = this.getActivationClass();
        genericPreparedStatement.resultDesc = this.resultDesc;
        genericPreparedStatement.paramTypeDescriptors = this.paramTypeDescriptors;
        genericPreparedStatement.executionConstants = this.executionConstants;
        genericPreparedStatement.UUIDString = this.UUIDString;
        genericPreparedStatement.UUIDValue = this.UUIDValue;
        genericPreparedStatement.savedObjects = this.savedObjects;
        genericPreparedStatement.execStmtName = this.execStmtName;
        genericPreparedStatement.execSchemaName = this.execSchemaName;
        genericPreparedStatement.isAtomic = this.isAtomic;
        genericPreparedStatement.sourceTxt = this.sourceTxt;
        genericPreparedStatement.targetTable = this.targetTable;
        genericPreparedStatement.targetColumns = this.targetColumns;
        genericPreparedStatement.updateColumns = this.updateColumns;
        genericPreparedStatement.updateMode = this.updateMode;
        genericPreparedStatement.params = this.params;
        genericPreparedStatement.needsSavepoint = this.needsSavepoint;
        return genericPreparedStatement;
    }

    public void setCacheHolder(Cacheable cacheable) {
        this.cacheHolder = cacheable;
        if (cacheable == null) {
            if (!this.isValid || this.inUseCount != 0) {
                return;
            }
            ContextManager contextManager = ContextService.getFactory().getCurrentContextManager();
            LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)contextManager.getContext("LanguageConnectionContext");
            try {
                this.makeInvalid(11, languageConnectionContext);
            }
            catch (StandardException standardException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return this.getObjectName();
    }

    public boolean isStorable() {
        return false;
    }
}

