/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.reflect;

import java.lang.reflect.Method;
import java.util.Hashtable;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.impl.services.reflect.DirectCall;
import org.apache.derby.impl.services.reflect.GCInstanceFactory;
import org.apache.derby.impl.services.reflect.LoadedGeneratedClass;
import org.apache.derby.impl.services.reflect.ReflectMethod;

public final class ReflectGeneratedClass
extends LoadedGeneratedClass {
    private final Hashtable methodCache = new Hashtable();
    private static final GeneratedMethod[] directs = new GeneratedMethod[10];
    private final Class factoryClass;
    private GCInstanceFactory factory;

    public ReflectGeneratedClass(ClassFactory classFactory, Class clazz, Class clazz2) {
        super(classFactory, clazz);
        this.factoryClass = clazz2;
    }

    public Object newInstance(Context context) throws StandardException {
        Object object2;
        if (this.factoryClass == null) {
            return super.newInstance(context);
        }
        if (this.factory == null) {
            try {
                this.factory = (GCInstanceFactory)this.factoryClass.newInstance();
                object2 = null;
            }
            catch (InstantiationException instantiationException) {
                object2 = instantiationException;
            }
            catch (IllegalAccessException illegalAccessException) {
                object2 = illegalAccessException;
            }
            catch (LinkageError linkageError) {
                object2 = linkageError;
            }
            if (object2 != null) {
                throw StandardException.newException("XBCM2.S", (Throwable)object2, (Object)this.getName());
            }
        }
        object2 = this.factory.getNewInstance();
        object2.initFromContext(context);
        object2.setGC(this);
        object2.postConstructor();
        return object2;
    }

    public GeneratedMethod getMethod(String string) throws StandardException {
        GeneratedMethod generatedMethod = (GeneratedMethod)this.methodCache.get(string);
        if (generatedMethod != null) {
            return generatedMethod;
        }
        try {
            if (string.length() == 2 && string.startsWith("e")) {
                int n = string.charAt(1) - 48;
                generatedMethod = directs[n];
            } else {
                Method method = this.getJVMClass().getMethod(string, null);
                generatedMethod = new ReflectMethod(method);
            }
            this.methodCache.put(string, generatedMethod);
            return generatedMethod;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw StandardException.newException("XBCM3.S", noSuchMethodException, (Object)this.getName(), (Object)string);
        }
    }

    static {
        for (int j = 0; j < directs.length; ++j) {
            ReflectGeneratedClass.directs[j] = new DirectCall(j);
        }
    }
}

