/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.monitor;

import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.monitor.PersistentService;
import org.apache.derby.impl.services.monitor.BaseMonitor;
import org.apache.derby.impl.services.monitor.ModuleInstance;
import org.apache.derby.impl.services.monitor.ProtocolKey;

final class TopService {
    ProtocolKey key;
    ModuleInstance topModule;
    Hashtable protocolTable;
    Vector moduleInstances;
    BaseMonitor monitor;
    boolean inShutdown;
    PersistentService serviceType;
    Locale serviceLocale;

    TopService(BaseMonitor baseMonitor) {
        this.monitor = baseMonitor;
        this.protocolTable = new Hashtable();
        this.moduleInstances = new Vector(0, 5);
    }

    TopService(BaseMonitor baseMonitor, ProtocolKey protocolKey, PersistentService persistentService, Locale locale) {
        this(baseMonitor);
        this.key = protocolKey;
        this.serviceType = persistentService;
        this.serviceLocale = locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTopModule(Object object2) {
        TopService topService = this;
        synchronized (topService) {
            for (int j = 0; j < this.moduleInstances.size(); ++j) {
                ModuleInstance moduleInstance = (ModuleInstance)this.moduleInstances.elementAt(j);
                if (moduleInstance.getInstance() != object2) continue;
                this.topModule = moduleInstance;
                this.notifyAll();
                break;
            }
            if (this.getServiceType() != null) {
                ProtocolKey protocolKey = new ProtocolKey(this.key.getFactoryInterface(), this.monitor.getServiceName(object2));
                this.addToProtocol(protocolKey, this.topModule);
            }
        }
    }

    Object getService() {
        return this.topModule.getInstance();
    }

    boolean isPotentialService(ProtocolKey protocolKey) {
        String string;
        if (this.serviceType == null) {
            string = protocolKey.getIdentifier();
        } else {
            try {
                string = this.serviceType.getCanonicalServiceName(protocolKey.getIdentifier());
            }
            catch (StandardException standardException) {
                return false;
            }
            if (string == null) {
                return false;
            }
        }
        if (this.topModule != null) {
            return this.topModule.isTypeAndName(this.serviceType, this.key.getFactoryInterface(), string);
        }
        if (!protocolKey.getFactoryInterface().isAssignableFrom(this.key.getFactoryInterface())) {
            return false;
        }
        return this.serviceType.isSameService(this.key.getIdentifier(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isActiveService() {
        TopService topService = this;
        synchronized (topService) {
            return this.topModule != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isActiveService(ProtocolKey protocolKey) {
        TopService topService = this;
        synchronized (topService) {
            if (this.inShutdown) {
                return false;
            }
            if (!this.isPotentialService(protocolKey)) {
                return false;
            }
            if (this.topModule != null) {
                return true;
            }
            while (!this.inShutdown && this.topModule == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
            }
            return !this.inShutdown;
            {
            }
        }
    }

    synchronized Object findModule(ProtocolKey protocolKey, boolean bl, Properties properties) {
        ModuleInstance moduleInstance = (ModuleInstance)this.protocolTable.get(protocolKey);
        if (moduleInstance == null) {
            return null;
        }
        Object object2 = moduleInstance.getInstance();
        if (bl || BaseMonitor.canSupport(object2, properties)) {
            return object2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object bootModule(boolean bl, Object object2, ProtocolKey protocolKey, Properties properties) throws StandardException {
        Object object3 = this;
        synchronized (object3) {
            if (this.inShutdown) {
                throw StandardException.newException("08006.D", this.getKey().getIdentifier());
            }
        }
        object3 = this.findModule(protocolKey, false, properties);
        if (object3 != null) {
            return object3;
        }
        if (this.monitor.reportOn) {
            this.monitor.report("Booting Module   " + protocolKey.toString() + " create = " + bl);
        }
        Object object4 = this;
        synchronized (object4) {
            for (int j = 0; j < this.moduleInstances.size(); ++j) {
                ModuleInstance moduleInstance = (ModuleInstance)this.moduleInstances.elementAt(j);
                if (!moduleInstance.isTypeAndName(null, protocolKey.getFactoryInterface(), protocolKey.getIdentifier()) || !BaseMonitor.canSupport(object3 = moduleInstance.getInstance(), properties) || !this.addToProtocol(protocolKey, moduleInstance)) continue;
                if (this.monitor.reportOn) {
                    this.monitor.report("Started Module   " + protocolKey.toString());
                    this.monitor.report("  Implementation " + object3.getClass().getName());
                }
                return object3;
            }
        }
        object3 = this.monitor.loadInstance(protocolKey.getFactoryInterface(), properties);
        if (object3 == null) {
            throw Monitor.missingImplementation(protocolKey.getFactoryInterface().getName());
        }
        object4 = new ModuleInstance(object3, protocolKey.getIdentifier(), object2, this.topModule == null ? (Object)null : this.topModule.getInstance());
        this.moduleInstances.addElement(object4);
        try {
            BaseMonitor.boot(object3, bl, properties);
        }
        catch (StandardException standardException) {
            this.moduleInstances.removeElement(object4);
            throw standardException;
        }
        TopService topService = this;
        synchronized (topService) {
            if (this.addToProtocol(protocolKey, (ModuleInstance)object4)) {
                if (this.monitor.reportOn) {
                    this.monitor.report("Started Module   " + protocolKey.toString());
                    this.monitor.report("  Implementation " + ((ModuleInstance)object4).getInstance().getClass().getName());
                }
                return ((ModuleInstance)object4).getInstance();
            }
        }
        TopService.stop(object3);
        this.moduleInstances.removeElement(object4);
        return this.findModule(protocolKey, true, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean shutdown() {
        Object object2 = this;
        synchronized (object2) {
            if (this.inShutdown) {
                return false;
            }
            this.inShutdown = true;
            this.notifyAll();
        }
        while (true) {
            Object object3 = this;
            synchronized (object3) {
                if (this.moduleInstances.isEmpty()) {
                    return true;
                }
                object2 = (ModuleInstance)this.moduleInstances.elementAt(0);
            }
            object3 = ((ModuleInstance)object2).getInstance();
            TopService.stop(object3);
            TopService topService = this;
            synchronized (topService) {
                this.moduleInstances.removeElementAt(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addToProtocol(ProtocolKey protocolKey, ModuleInstance moduleInstance) {
        String string = moduleInstance.getIdentifier();
        TopService topService = this;
        synchronized (topService) {
            Object v = this.protocolTable.get(protocolKey);
            if (v == null) {
                this.protocolTable.put(protocolKey, moduleInstance);
                return true;
            }
            return v == moduleInstance;
            {
            }
        }
    }

    boolean inService(Object object2) {
        for (int j = 0; j < this.moduleInstances.size(); ++j) {
            ModuleInstance moduleInstance = (ModuleInstance)this.moduleInstances.elementAt(j);
            if (moduleInstance.getInstance() != object2) continue;
            return true;
        }
        return false;
    }

    public ProtocolKey getKey() {
        return this.key;
    }

    PersistentService getServiceType() {
        return this.serviceType;
    }

    private static void stop(Object object2) {
        if (object2 instanceof ModuleControl) {
            ((ModuleControl)object2).stop();
        }
    }
}

