/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.monitor;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.monitor.PersistentService;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.WritableStorageFactory;

final class PersistentServiceImpl
implements PersistentService {
    private String home;
    private String canonicalHome;
    private final String subSubProtocol;
    private final Class storageFactoryClass;
    private StorageFactory rootStorageFactory;
    private char separatorChar;

    PersistentServiceImpl(String string, Class clazz) throws StandardException {
        this.subSubProtocol = string;
        this.storageFactoryClass = clazz;
        Object object2 = Monitor.getMonitor().getEnvironment();
        if (object2 instanceof File) {
            final File file = (File)object2;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException, StandardException {
                        PersistentServiceImpl.this.home = file.getPath();
                        PersistentServiceImpl.this.canonicalHome = file.getCanonicalPath();
                        PersistentServiceImpl.this.rootStorageFactory = PersistentServiceImpl.this.getStorageFactoryInstance(true, null, null, null);
                        if (PersistentServiceImpl.this.home != null) {
                            StorageFile storageFile = PersistentServiceImpl.this.rootStorageFactory.newStorageFile(null);
                            storageFile.mkdirs();
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.home = null;
                this.canonicalHome = null;
            }
        }
        if (this.rootStorageFactory == null) {
            try {
                this.rootStorageFactory = this.getStorageFactoryInstance(true, null, null, null);
            }
            catch (IOException iOException) {
                throw Monitor.exceptionStartingModule(iOException);
            }
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                PersistentServiceImpl.this.separatorChar = PersistentServiceImpl.this.rootStorageFactory.getSeparator();
                return null;
            }
        });
    }

    public boolean hasStorageFactory() {
        return true;
    }

    public StorageFactory getStorageFactoryInstance(final boolean bl, final String string, final String string2, final String string3) throws StandardException, IOException {
        try {
            return (StorageFactory)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws InstantiationException, IllegalAccessException, IOException {
                    return PersistentServiceImpl.this.privGetStorageFactoryInstance(bl, string, string2, string3);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            throw StandardException.newException("XBM0W.S", exception, (Object)this.subSubProtocol, (Object)this.storageFactoryClass);
        }
    }

    private StorageFactory privGetStorageFactoryInstance(boolean bl, String string, String string2, String string3) throws InstantiationException, IllegalAccessException, IOException {
        StorageFactory storageFactory = (StorageFactory)this.storageFactoryClass.newInstance();
        String string4 = string != null && this.subSubProtocol != null && string.startsWith(this.subSubProtocol + ":") ? string.substring(this.subSubProtocol.length() + 1) : string;
        storageFactory.init(bl ? this.home : null, string4, string2, string3);
        return storageFactory;
    }

    public String getType() {
        return this.subSubProtocol;
    }

    public Enumeration getBootTimeServices() {
        if (this.home == null) {
            return null;
        }
        return new DirectoryList();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties getServiceProperties(final String var1_1, Properties var2_2) throws StandardException {
        var3_3 = this.recreateServiceRoot(var1_1, var2_2);
        var4_4 = null;
        try {
            try {
                var4_4 = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws FileNotFoundException, IOException, StandardException, InstantiationException, IllegalAccessException {
                        if (var3_3 != null) {
                            File file = new File(var3_3, "service.properties");
                            return new FileInputStream(file);
                        }
                        StorageFactory storageFactory = PersistentServiceImpl.this.privGetStorageFactoryInstance(true, var1_1, null, null);
                        StorageFile storageFile = storageFactory.newStorageFile("service.properties");
                        InputStream inputStream = storageFile.getInputStream();
                        storageFactory.shutdown();
                        return inputStream;
                    }
                });
                var5_5 = new Properties(var2_2);
                var5_5.load(new BufferedInputStream(var4_4));
                var6_10 = var5_5;
                var8_13 = null;
                if (var4_4 == null) return var6_10;
            }
            catch (PrivilegedActionException var5_6) {
                if (var5_6.getException() instanceof FileNotFoundException == false) throw Monitor.exceptionStartingModule(var5_6.getException());
                var6_11 = null;
                var8_14 = null;
                if (var4_4 == null) return var6_11;
                try {
                    var4_4.close();
                    return var6_11;
                }
                catch (IOException var9_18) {
                    // empty catch block
                }
                return var6_11;
            }
            catch (FileNotFoundException var5_7) {
                var6_12 = null;
                var8_15 = null;
                if (var4_4 == null) return var6_12;
                ** try [egrp 2[TRYBLOCK] [8 : 135->143)] { 
lbl31:
                // 1 sources

                var4_4.close();
                return var6_12;
lbl33:
                // 1 sources

                catch (IOException var9_19) {
                    // empty catch block
                }
                return var6_12;
            }
            catch (SecurityException var5_8) {
                throw Monitor.exceptionStartingModule(var5_8);
            }
            catch (IOException var5_9) {
                throw Monitor.exceptionStartingModule(var5_9);
            }
        }
        catch (Throwable var7_21) {
            var8_16 = null;
            if (var4_4 == null) throw var7_21;
            try {}
            catch (IOException var9_20) {
                throw var7_21;
            }
            var4_4.close();
            throw var7_21;
        }
        try {}
        catch (IOException var9_17) {
            // empty catch block
            return var6_10;
        }
        var4_4.close();
        return var6_10;
    }

    public void saveServiceProperties(final String string, StorageFactory storageFactory, final Properties properties, final boolean bl) throws StandardException {
        if (!(storageFactory instanceof WritableStorageFactory)) {
            throw StandardException.newException("XBM0P.D");
        }
        final WritableStorageFactory writableStorageFactory = (WritableStorageFactory)storageFactory;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws StandardException {
                    StorageFile storageFile = null;
                    StorageFile storageFile2 = writableStorageFactory.newStorageFile("service.properties");
                    if (bl) {
                        storageFile = writableStorageFactory.newStorageFile("service.properties".concat("old"));
                        try {
                            if (!storageFile2.renameTo(storageFile)) {
                                throw StandardException.newException("XBM0S.D", storageFile2, (Object)storageFile);
                            }
                        }
                        catch (SecurityException securityException) {
                            throw Monitor.exceptionStartingModule(securityException);
                        }
                    }
                    OutputStream outputStream = null;
                    try {
                        outputStream = storageFile2.getOutputStream();
                        properties.store(outputStream, string + MessageService.getTextMessage("M001"));
                        writableStorageFactory.sync(outputStream, false);
                        outputStream.close();
                        outputStream = null;
                    }
                    catch (IOException iOException) {
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException iOException2) {
                                // empty catch block
                            }
                            outputStream = null;
                        }
                        if (storageFile != null) {
                            try {
                                storageFile2.delete();
                                storageFile.renameTo(storageFile2);
                            }
                            catch (SecurityException securityException) {
                                // empty catch block
                            }
                        }
                        throw Monitor.exceptionStartingModule(iOException);
                    }
                    if (storageFile != null) {
                        try {
                            storageFile.delete();
                            storageFile = null;
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (StandardException)privilegedActionException.getException();
        }
    }

    public void saveServiceProperties(String string, Properties properties, boolean bl) throws StandardException {
        File file = null;
        File file2 = new File(string, "service.properties");
        if (bl) {
            file = new File(string, "service.properties".concat("old"));
            try {
                if (!file2.renameTo(file)) {
                    throw StandardException.newException("XBM0S.D", file2, (Object)file);
                }
            }
            catch (SecurityException securityException) {
                throw Monitor.exceptionStartingModule(securityException);
            }
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file2);
            properties.store(fileOutputStream, string + MessageService.getTextMessage("M001"));
            fileOutputStream.getFD().sync();
            fileOutputStream.close();
            fileOutputStream = null;
            bl = false;
        }
        catch (IOException iOException) {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                fileOutputStream = null;
            }
            if (file != null) {
                try {
                    file2.delete();
                    file.renameTo(file2);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            throw Monitor.exceptionStartingModule(iOException);
        }
        if (file != null) {
            try {
                file.delete();
                file = null;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String recreateServiceRoot(final String string, Properties properties) throws StandardException {
        if (properties == null) {
            return null;
        }
        boolean bl = false;
        boolean bl2 = false;
        String string2 = properties.getProperty("createFrom");
        if (string2 != null) {
            bl = true;
            bl2 = false;
        } else {
            string2 = properties.getProperty("restoreFrom");
            if (string2 != null) {
                bl = true;
                bl2 = true;
            } else {
                string2 = properties.getProperty("rollForwardRecoveryFrom");
                if (string2 != null) {
                    try {
                        if (AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public Object run() throws IOException, StandardException, InstantiationException, IllegalAccessException {
                                StorageFactory storageFactory = PersistentServiceImpl.this.privGetStorageFactoryInstance(true, string, null, null);
                                try {
                                    StorageFile storageFile = storageFactory.newStorageFile(null);
                                    6 var3_3 = storageFile.exists() ? this : null;
                                    return var3_3;
                                }
                                finally {
                                    storageFactory.shutdown();
                                }
                            }
                        }) == null) {
                            bl = true;
                            bl2 = false;
                        }
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw Monitor.exceptionStartingModule((IOException)privilegedActionException.getException());
                    }
                }
            }
        }
        if (string2 == null) return string2;
        File file = new File(string2);
        if (!file.exists()) throw StandardException.newException("XBM0Y.D", file);
        File file2 = new File(string2, "service.properties");
        if (!file2.exists()) throw StandardException.newException("XBM0Q.D", file2);
        if (bl) {
            this.createServiceRoot(string, bl2);
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws IOException, StandardException, InstantiationException, IllegalAccessException {
                    WritableStorageFactory writableStorageFactory = (WritableStorageFactory)PersistentServiceImpl.this.privGetStorageFactoryInstance(true, string, null, null);
                    try {
                        StorageFile storageFile = writableStorageFactory.newStorageFile("service.properties");
                        if (storageFile.exists() && !storageFile.delete()) {
                            throw StandardException.newException("XBM0R.D", storageFile);
                        }
                        Object var3_3 = null;
                        return var3_3;
                    }
                    finally {
                        writableStorageFactory.shutdown();
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw Monitor.exceptionStartingModule((IOException)privilegedActionException.getException());
        }
        properties.put("derby.__rt.inRestore", "True");
        if (!bl) return string2;
        properties.put("derby.__rt.deleteRootOnError", "True");
        return string2;
    }

    public String createServiceRoot(final String string, final boolean bl) throws StandardException {
        Exception exception;
        block5: {
            if (!(this.rootStorageFactory instanceof WritableStorageFactory)) {
                throw StandardException.newException("XBM0P.D");
            }
            exception = null;
            try {
                String string2 = "";
                if (!this.getType().equals("directory")) {
                    string2 = this.getType() + ":";
                }
                return string2 + (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws StandardException, IOException, InstantiationException, IllegalAccessException {
                        StorageFactory storageFactory = PersistentServiceImpl.this.privGetStorageFactoryInstance(true, string, null, null);
                        try {
                            StorageFile storageFile = storageFactory.newStorageFile(null);
                            if (storageFile.exists()) {
                                if (bl) {
                                    if (!storageFile.deleteAll()) {
                                        throw StandardException.newException("XBM0I.D", PersistentServiceImpl.this.getDirectoryPath(string));
                                    }
                                } else {
                                    throw StandardException.newException("XBM0J.D", PersistentServiceImpl.this.getDirectoryPath(string));
                                }
                            }
                            if (storageFile.mkdirs()) {
                                try {
                                    String string2 = storageFactory.getCanonicalName();
                                    return string2;
                                }
                                catch (IOException iOException) {
                                    storageFile.deleteAll();
                                    throw iOException;
                                }
                            }
                            throw StandardException.newException("XBM0H.D", storageFile, null);
                        }
                        finally {
                            storageFactory.shutdown();
                        }
                    }
                });
            }
            catch (SecurityException securityException) {
                exception = securityException;
            }
            catch (PrivilegedActionException privilegedActionException) {
                exception = privilegedActionException.getException();
                if (!(exception instanceof StandardException)) break block5;
                throw (StandardException)exception;
            }
        }
        throw StandardException.newException("XBM0H.D", string, (Object)exception);
    }

    private String getDirectoryPath(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.home != null) {
            stringBuffer.append(this.home);
            stringBuffer.append(this.separatorChar);
        }
        if (this.separatorChar != '/') {
            stringBuffer.append(string.replace('/', this.separatorChar));
        } else {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public boolean removeServiceRoot(final String string) {
        if (!(this.rootStorageFactory instanceof WritableStorageFactory)) {
            return false;
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws StandardException, IOException, InstantiationException, IllegalAccessException {
                    StorageFactory storageFactory = PersistentServiceImpl.this.privGetStorageFactoryInstance(true, string, null, null);
                    try {
                        StorageFile storageFile = storageFactory.newStorageFile(null);
                        9 var3_3 = storageFile.deleteAll() ? this : null;
                        return var3_3;
                    }
                    finally {
                        storageFactory.shutdown();
                    }
                }
            }) != null;
        }
        catch (PrivilegedActionException privilegedActionException) {
            return false;
        }
    }

    public String getCanonicalServiceName(String string) throws StandardException {
        String string2 = this.getType() + ":";
        int n = string.indexOf(58);
        if (n > 1) {
            if (!string.startsWith(string2)) {
                return null;
            }
            string = string.substring(n + 1);
        }
        if (this.getType().equals("directory")) {
            string2 = "";
        }
        final String string3 = string;
        try {
            return string2 + (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws StandardException, IOException, InstantiationException, IllegalAccessException {
                    StorageFactory storageFactory = PersistentServiceImpl.this.privGetStorageFactoryInstance(true, string3, null, null);
                    try {
                        String string = storageFactory.getCanonicalName();
                        return string;
                    }
                    finally {
                        storageFactory.shutdown();
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw Monitor.exceptionStartingModule(privilegedActionException.getException());
        }
    }

    public String getUserServiceName(String string) {
        if (this.home != null && string.length() > this.canonicalHome.length() + 1 && string.startsWith(this.canonicalHome) && (string = string.substring(this.canonicalHome.length())).charAt(0) == this.separatorChar) {
            string = string.substring(1);
        }
        return string.replace(this.separatorChar, '/');
    }

    public boolean isSameService(String string, String string2) {
        return string.equals(string2);
    }

    public Class getStorageFactoryClass() {
        return this.storageFactoryClass;
    }

    final class DirectoryList
    implements Enumeration,
    PrivilegedAction {
        private String[] contents;
        private StorageFile systemDirectory;
        private int index;
        private boolean validIndex;
        private int actionCode = 0;
        private static final int INIT_ACTION = 0;
        private static final int HAS_MORE_ELEMENTS_ACTION = 1;

        DirectoryList() {
            AccessController.doPrivileged(this);
        }

        public boolean hasMoreElements() {
            if (this.validIndex) {
                return true;
            }
            this.actionCode = 1;
            return AccessController.doPrivileged(this) != null;
        }

        public Object nextElement() throws NoSuchElementException {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            this.validIndex = false;
            return this.contents[this.index++];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final Object run() {
            switch (this.actionCode) {
                case 0: {
                    this.systemDirectory = PersistentServiceImpl.this.rootStorageFactory.newStorageFile(null);
                    this.contents = this.systemDirectory.list();
                    return null;
                }
                case 1: {
                    break;
                }
                default: {
                    return null;
                }
            }
            while (this.index < this.contents.length) {
                try {
                    StorageFactory storageFactory = PersistentServiceImpl.this.privGetStorageFactoryInstance(true, this.contents[this.index], null, null);
                    try {
                        StorageFile storageFile = storageFactory.newStorageFile("service.properties");
                        if (storageFile.exists()) {
                            this.contents[this.index] = storageFactory.getCanonicalName();
                            this.validIndex = true;
                            DirectoryList directoryList = this;
                            return directoryList;
                        }
                    }
                    finally {
                        storageFactory.shutdown();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.contents[this.index++] = null;
            }
            return null;
        }
    }
}

