/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.locks.Latch;
import org.apache.derby.iapi.services.locks.Limit;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.util.Matchable;
import org.apache.derby.impl.services.locks.ActiveLock;
import org.apache.derby.impl.services.locks.Control;
import org.apache.derby.impl.services.locks.Lock;
import org.apache.derby.impl.services.locks.LockSet;
import org.apache.derby.impl.services.locks.LockSpace;
import org.apache.derby.impl.services.locks.LockTableVTI;

public class SinglePool
extends Hashtable
implements LockFactory {
    protected final LockSet lockTable = new LockSet(this);
    int deadlockMonitor;

    public boolean latchObject(Object object2, Lockable lockable, Object object3, int n) throws StandardException {
        Lock lock = this.lockTable.lockObject(object2, lockable, object3, n, null);
        return lock != null;
    }

    public void unlatch(Latch latch) {
        this.lockTable.unlock(latch, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Lock lockAnObject(Object object2, Object object3, Lockable lockable, Object object4, int n, Latch latch) throws StandardException {
        Lock lock = this.lockTable.lockObject(object2, lockable, object4, n, latch);
        if (lock == null) {
            return null;
        }
        SinglePool singlePool = this;
        synchronized (singlePool) {
            LockSpace lockSpace = (LockSpace)this.get(object2);
            if (lockSpace == null) {
                lockSpace = new LockSpace(this, object2);
                this.put(object2, lockSpace);
            }
            lockSpace.addLock(object3, lock);
        }
        return lock;
    }

    public boolean lockObject(Object object2, Object object3, Lockable lockable, Object object4, int n) throws StandardException {
        return this.lockAnObject(object2, object3, lockable, object4, n, null) != null;
    }

    public boolean lockObject(Object object2, Lockable lockable, Object object3, int n, Latch latch) throws StandardException {
        Lock lock = this.lockAnObject(latch.getCompatabilitySpace(), object2, lockable, object3, n, latch);
        return lock instanceof ActiveLock;
    }

    public int unlock(Object object2, Object object3, Lockable lockable, Object object4) {
        LockSpace lockSpace = (LockSpace)this.get(object2);
        if (lockSpace == null) {
            return 0;
        }
        int n = lockSpace.unlockReference(this.lockTable, lockable, object4, object3);
        return n;
    }

    public void unlockGroup(Object object2, Object object3) {
        LockSpace lockSpace = (LockSpace)this.get(object2);
        if (lockSpace == null) {
            return;
        }
        lockSpace.unlockGroup(this.lockTable, object3);
    }

    public void unlockGroup(Object object2, Object object3, Matchable matchable) {
        LockSpace lockSpace = (LockSpace)this.get(object2);
        if (lockSpace == null) {
            return;
        }
        lockSpace.unlockGroup(this.lockTable, object3, matchable);
    }

    public void transfer(Object object2, Object object3, Object object4) {
        LockSpace lockSpace = (LockSpace)this.get(object2);
        if (lockSpace == null) {
            return;
        }
        lockSpace.transfer(object3, object4);
    }

    public boolean anyoneBlocked() {
        return this.lockTable.anyoneBlocked();
    }

    public boolean areLocksHeld(Object object2, Object object3) {
        LockSpace lockSpace = (LockSpace)this.get(object2);
        if (lockSpace == null) {
            return false;
        }
        return lockSpace.areLocksHeld(object3);
    }

    public boolean areLocksHeld(Object object2) {
        LockSpace lockSpace = (LockSpace)this.get(object2);
        if (lockSpace == null) {
            return false;
        }
        return !lockSpace.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zeroDurationlockObject(Object object2, Lockable lockable, Object object3, int n) throws StandardException {
        Object object4 = this.lockTable;
        synchronized (object4) {
            Control control = (Control)this.lockTable.get(lockable);
            if (control == null) {
                return true;
            }
            if (control.isGrantable(true, object2, object3)) {
                return true;
            }
            if (n == 0) {
                return false;
            }
        }
        object4 = this.lockTable.lockObject(object2, lockable, object3, n, null);
        this.lockTable.unlock((Latch)object4, 1);
        return true;
    }

    public boolean isLockHeld(Object object2, Object object3, Lockable lockable, Object object4) {
        LockSpace lockSpace = (LockSpace)this.get(object2);
        if (lockSpace == null) {
            return false;
        }
        return lockSpace.isLockHeld(object3, lockable, object4);
    }

    public synchronized void setLimit(Object object2, Object object3, int n, Limit limit) {
        LockSpace lockSpace = (LockSpace)this.get(object2);
        if (lockSpace == null) {
            lockSpace = new LockSpace(this, object2);
            this.put(object2, lockSpace);
        }
        lockSpace.setLimit(object3, n, limit);
    }

    public void clearLimit(Object object2, Object object3) {
        LockSpace lockSpace = (LockSpace)this.get(object2);
        if (lockSpace == null) {
            return;
        }
        lockSpace.clearLimit(object3);
    }

    public Enumeration makeVirtualLockTable() {
        LockTableVTI lockTableVTI = new LockTableVTI(this.lockTable.shallowClone());
        return lockTableVTI;
    }

    public String toDebugString() {
        return this.lockTable.toDebugString();
    }

    public void init(boolean bl, Dictionary dictionary) {
        this.getAndApply(bl, dictionary, "derby.locks.deadlockTimeout");
        this.getAndApply(bl, dictionary, "derby.locks.waitTimeout");
        this.getAndApply(bl, dictionary, "derby.locks.monitor");
        this.getAndApply(bl, dictionary, "derby.locks.deadlockTrace");
    }

    private void getAndApply(boolean bl, Dictionary dictionary, String string) {
        try {
            String string2 = (String)((Object)PropertyUtil.getPropertyFromSet(bl, dictionary, string));
            if (string2 != null) {
                this.validate(string, (Serializable)((Object)string2), dictionary);
                this.apply(string, (Serializable)((Object)string2), dictionary);
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
    }

    public boolean validate(String string, Serializable serializable, Dictionary dictionary) throws StandardException {
        if (!string.startsWith("derby.locks.")) {
            return false;
        }
        if (serializable != null) {
            if (string.equals("derby.locks.deadlockTimeout")) {
                SinglePool.getWaitValue((String)((Object)serializable), 20);
            } else if (string.equals("derby.locks.waitTimeout")) {
                SinglePool.getWaitValue((String)((Object)serializable), 60);
            } else if (string.equals("derby.locks.monitor")) {
                PropertyUtil.booleanProperty("derby.locks.monitor", serializable, false);
            } else if (string.equals("derby.locks.deadlockTrace")) {
                PropertyUtil.booleanProperty("derby.locks.deadlockTrace", serializable, false);
            }
        }
        return true;
    }

    public Serviceable apply(String string, Serializable serializable, Dictionary dictionary) throws StandardException {
        if (serializable == null) {
            serializable = PropertyUtil.getPropertyFromSet(dictionary, string);
        }
        String string2 = (String)((Object)serializable);
        if (string.equals("derby.locks.deadlockTimeout")) {
            this.lockTable.deadlockTimeout = SinglePool.getWaitValue(string2, 20);
        } else if (string.equals("derby.locks.waitTimeout")) {
            this.lockTable.waitTimeout = SinglePool.getWaitValue(string2, 60);
        } else if (string.equals("derby.locks.monitor")) {
            this.deadlockMonitor = PropertyUtil.booleanProperty("derby.locks.monitor", (Serializable)((Object)string2), false) ? 2 : 0;
        } else if (string.equals("derby.locks.deadlockTrace")) {
            this.lockTable.setDeadlockTrace(PropertyUtil.booleanProperty("derby.locks.deadlockTrace", (Serializable)((Object)string2), false));
        }
        return null;
    }

    public Serializable map(String string, Serializable serializable, Dictionary dictionary) {
        return null;
    }

    private static int getWaitValue(String string, int n) {
        int n2 = PropertyUtil.handleInt(string, Integer.MIN_VALUE, 2147483, n);
        n2 = n2 < 0 ? -1 : (n2 *= 1000);
        return n2;
    }
}

