/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.locks.Latch;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.impl.services.locks.ActiveLock;
import org.apache.derby.impl.services.locks.Control;
import org.apache.derby.impl.services.locks.Deadlock;
import org.apache.derby.impl.services.locks.Lock;
import org.apache.derby.impl.services.locks.LockControl;
import org.apache.derby.impl.services.locks.SinglePool;
import org.apache.derby.impl.services.locks.Timeout;

public final class LockSet
extends Hashtable {
    private final SinglePool factory;
    protected int deadlockTimeout = 20000;
    protected int waitTimeout = 60000;
    private boolean deadlockTrace;
    private Hashtable lockTraces;
    protected int blockCount;

    protected LockSet(SinglePool singlePool) {
        this.factory = singlePool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Lock lockObject(Object object2, Lockable lockable, Object object3, int n, Latch latch) throws StandardException {
        int n2;
        Lock lock;
        Object var9_6 = null;
        LockSet lockSet = this;
        // MONITORENTER : lockSet
        Control control = this.getControl(lockable);
        if (control == null) {
            Lock lock2 = new Lock(object2, lockable, object3);
            lock2.grant();
            this.put(lockable, lock2);
            // MONITOREXIT : lockSet
            return lock2;
        }
        LockControl lockControl = control.getLockControl();
        if (lockControl != control) {
            this.put(lockable, lockControl);
        }
        if ((lock = lockControl.addLock(this, object2, object3)).getCount() != 0) {
            // MONITOREXIT : lockSet
            return lock;
        }
        if (n == 0) {
            lockControl.giveUpWait(lock, this);
            // MONITOREXIT : lockSet
            return null;
        }
        if (latch != null) {
            this.unlock(latch, 1);
        }
        // MONITOREXIT : lockSet
        boolean bl = false;
        if (n == -1) {
            bl = true;
            n2 = this.deadlockTimeout;
            if (n2 == -1) {
                n2 = 20000;
            }
        } else {
            if (n == -2) {
                n = n2 = this.waitTimeout;
            } else {
                n2 = n;
            }
            if (this.deadlockTimeout >= 0) {
                if (n2 < 0) {
                    bl = true;
                    n2 = this.deadlockTimeout;
                } else if (this.deadlockTimeout < n2) {
                    bl = true;
                    n2 = this.deadlockTimeout;
                    n -= this.deadlockTimeout;
                }
            }
        }
        ActiveLock activeLock = (ActiveLock)lock;
        lock = null;
        if (this.deadlockTrace) {
            this.lockTraces.put(activeLock, new Throwable());
        }
        int n3 = 0;
        long l = 0L;
        try {
            while (true) {
                Object var27_26;
                ActiveLock activeLock2;
                Serializable serializable;
                long l2;
                Enumeration enumeration;
                Object[] objectArray;
                ActiveLock activeLock3;
                byte by;
                block40: {
                    by = activeLock.waitForGrant(n2);
                    activeLock3 = null;
                    objectArray = null;
                    try {
                        enumeration = null;
                        l2 = 0L;
                        serializable = this;
                        // MONITORENTER : serializable
                        if (!lockControl.isGrantable(lockControl.firstWaiter() == activeLock, object2, object3)) break block40;
                        lockControl.grant(activeLock);
                        activeLock3 = lockControl.getNextWaiter(activeLock, true, this);
                        if (latch != null) {
                            this.lockObject(object2, latch.getLockable(), latch.getQualifier(), -1, null);
                        }
                        activeLock2 = activeLock;
                        // MONITOREXIT : serializable
                        var27_26 = null;
                        if (activeLock3 != null) {
                            activeLock3.wakeUp((byte)1);
                            activeLock3 = null;
                        }
                        if (!this.deadlockTrace) return activeLock2;
                        this.lockTraces.remove(activeLock);
                    }
                    catch (Throwable throwable) {
                        var27_26 = null;
                        if (activeLock3 == null) throw throwable;
                        activeLock3.wakeUp((byte)1);
                        activeLock3 = null;
                        throw throwable;
                    }
                    return activeLock2;
                }
                activeLock.clearPotentiallyGranted();
                boolean bl2 = by != 1;
                activeLock2 = null;
                if (by == 0 && bl || by == 2) {
                    objectArray = Deadlock.look(this.factory, this, lockControl, activeLock, by);
                    if (objectArray == null) {
                        bl = false;
                        n2 = n;
                        l = 0L;
                        bl2 = false;
                    } else {
                        bl2 = true;
                    }
                }
                activeLock3 = lockControl.getNextWaiter(activeLock, bl2, this);
                if (bl2) {
                    if (latch != null) {
                        this.lockObject(object2, latch.getLockable(), latch.getQualifier(), -1, null);
                    }
                    if (this.deadlockTrace && objectArray == null) {
                        l2 = System.currentTimeMillis();
                        enumeration = this.factory.makeVirtualLockTable();
                    }
                }
                // MONITOREXIT : serializable
                if (bl2) {
                    if (objectArray != null) throw Deadlock.buildException(this.factory, objectArray);
                    if (this.deadlockTrace) {
                        throw Timeout.buildException(activeLock, enumeration, l2);
                    }
                    serializable = StandardException.newException("40XL1");
                    throw serializable;
                }
                var27_26 = null;
                if (activeLock3 != null) {
                    activeLock3.wakeUp((byte)1);
                    activeLock3 = null;
                }
                if (n2 == -1) continue;
                if (by != 0) {
                    ++n3;
                }
                if (n3 <= 5) continue;
                long l3 = System.currentTimeMillis();
                if (l != 0L) {
                    l2 = l3 - l;
                    n2 = (int)((long)n2 - l2);
                }
                l = l3;
            }
        }
        catch (Throwable throwable) {
            if (!this.deadlockTrace) throw throwable;
            this.lockTraces.remove(activeLock);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlock(Latch latch, int n) {
        boolean bl = false;
        ActiveLock activeLock = null;
        LockSet lockSet = this;
        synchronized (lockSet) {
            Control control = this.getControl(latch.getLockable());
            bl = control.unlock(latch, n);
            latch = null;
            boolean bl2 = true;
            if (bl && (activeLock = control.firstWaiter()) != null) {
                bl2 = false;
                if (!activeLock.setPotentiallyGranted()) {
                    activeLock = null;
                }
            }
            if (bl2) {
                if (control.isEmpty()) {
                    this.remove(control.getLockable());
                }
                return;
            }
        }
        if (bl && activeLock != null) {
            activeLock.wakeUp((byte)1);
        }
    }

    void setDeadlockTrace(boolean bl) {
        this.deadlockTrace = bl;
        if (bl && this.lockTraces == null) {
            this.lockTraces = new Hashtable();
        } else if (!bl && this.lockTraces != null) {
            this.lockTraces = null;
        }
    }

    public String toDebugString() {
        return null;
    }

    synchronized LockSet shallowClone() {
        LockSet lockSet = new LockSet(this.factory);
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            Lockable lockable = (Lockable)enumeration.nextElement();
            Control control = this.getControl(lockable);
            lockSet.put(lockable, control.shallowClone());
        }
        return lockSet;
    }

    void oneMoreWaiter() {
        ++this.blockCount;
    }

    void oneLessWaiter() {
        --this.blockCount;
    }

    boolean anyoneBlocked() {
        return this.blockCount != 0;
    }

    public final Control getControl(Lockable lockable) {
        return (Control)this.get(lockable);
    }
}

