/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.cache;

import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.cache.CacheableFactory;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.cache.SizedCacheable;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.util.Matchable;
import org.apache.derby.iapi.util.Operator;
import org.apache.derby.impl.services.cache.CacheStat;
import org.apache.derby.impl.services.cache.CachedItem;

final class Clock
extends Hashtable
implements CacheManager,
Serviceable {
    public final CacheStat stat;
    private DaemonService cleaner;
    private final ArrayList holders;
    private int validItemCount = 0;
    private long maximumSize;
    private boolean useByteCount;
    private long currentByteCount = 0L;
    private static final int ITEM_OVERHEAD = ClassSize.estimateBaseFromCatalog(class$org$apache$derby$impl$services$cache$CachedItem == null ? (class$org$apache$derby$impl$services$cache$CachedItem = Clock.class$("org.apache.derby.impl.services.cache.CachedItem")) : class$org$apache$derby$impl$services$cache$CachedItem) + ClassSize.getRefSize() + ClassSize.estimateHashEntrySize();
    private final CacheableFactory holderFactory;
    private boolean active;
    private String name;
    private int clockHand;
    private int myClientNumber;
    private boolean wokenToClean;
    private boolean cleanerRunning;
    private boolean needService;
    private int trimRequests = 0;
    static /* synthetic */ Class class$org$apache$derby$impl$services$cache$CachedItem;

    Clock(CacheableFactory cacheableFactory, String string, int n, long l, boolean bl) {
        super(n, 0.95f);
        this.maximumSize = l;
        this.holderFactory = cacheableFactory;
        this.useByteCount = bl;
        this.holders = new ArrayList(n);
        this.name = string;
        this.active = true;
        this.stat = new CacheStat();
        this.stat.initialSize = n;
        this.stat.maxSize = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cacheable find(Object object2) throws StandardException {
        Object object3;
        while (true) {
            Object object4;
            Object object5;
            boolean bl = false;
            object3 = this;
            synchronized (object3) {
                if (!this.active) {
                    return null;
                }
                object5 = (CachedItem)this.get(object2);
                if (object5 != null) {
                    ((CachedItem)object5).keepAfterSearch();
                    ++this.stat.findHit;
                }
            }
            if (object5 == null) {
                object5 = this.findFreeItem();
                ++this.stat.findMiss;
                object3 = this;
                synchronized (object3) {
                    object4 = (CachedItem)this.get(object2);
                    if (object4 != null) {
                        ((CachedItem)object5).unkeepForCreate();
                        object5 = object4;
                        ((CachedItem)object5).keepAfterSearch();
                    } else {
                        this.put(object2, object5);
                        bl = true;
                    }
                }
            }
            if (bl) {
                ++this.stat.findFault;
                return this.addEntry((CachedItem)object5, object2, false, null);
            }
            object3 = ((CachedItem)object5).use();
            if (object3 != null) break;
            object4 = this;
            synchronized (object4) {
                ((CachedItem)object5).unkeep();
            }
        }
        return object3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cacheable findCached(Object object2) throws StandardException {
        CachedItem cachedItem;
        Object object3 = this;
        synchronized (object3) {
            if (!this.active) {
                return null;
            }
            cachedItem = (CachedItem)this.get(object2);
            if (cachedItem == null) {
                ++this.stat.findCachedMiss;
                return null;
            }
            ++this.stat.findCachedHit;
            cachedItem.keepAfterSearch();
        }
        object3 = cachedItem.use();
        if (object3 == null) {
            Clock clock = this;
            synchronized (clock) {
                cachedItem.unkeep();
            }
        }
        return object3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUsed(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Clock clock = this;
            synchronized (clock) {
                if (!this.active) {
                    return;
                }
                int n2 = n + 32;
                if (n2 > objectArray.length) {
                    n2 = objectArray.length;
                }
                while (n < n2) {
                    if (objectArray[n] == null) {
                        return;
                    }
                    CachedItem cachedItem = (CachedItem)this.get(objectArray[n]);
                    if (null != cachedItem) {
                        cachedItem.setUsed(true);
                    }
                    ++n;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cacheable create(Object object2, Object object3) throws StandardException {
        CachedItem cachedItem = this.findFreeItem();
        ++this.stat.create;
        Object object4 = this;
        synchronized (object4) {
            if (!this.active) {
                return null;
            }
            if (this.get(object2) != null) {
                cachedItem.unkeepForCreate();
                throw StandardException.newException("XBCA0.S", this.name, object2);
            }
            this.put(object2, cachedItem);
        }
        object4 = this.addEntry(cachedItem, object2, true, object3);
        return object4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Cacheable cacheable) {
        boolean bl;
        CachedItem cachedItem;
        long l = 0L;
        Clock clock = this;
        synchronized (clock) {
            cachedItem = (CachedItem)this.get(cacheable.getIdentity());
            bl = cachedItem.unkeep();
            if (bl) {
                this.remove(cacheable.getIdentity());
                cachedItem.keepForClean();
            }
            if (this.cleaner == null) {
                l = this.shrinkSize(this.getCurrentSize());
            }
        }
        if (bl) {
            cachedItem.notifyRemover();
        }
        if (l > 0L) {
            this.performWork(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void release(CachedItem cachedItem) {
        boolean bl;
        Clock clock = this;
        synchronized (clock) {
            bl = cachedItem.unkeep();
            if (bl) {
                this.remove(cachedItem.getEntry().getIdentity());
                cachedItem.keepForClean();
            }
        }
        if (bl) {
            cachedItem.notifyRemover();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Cacheable cacheable) throws StandardException {
        Clock clock;
        boolean bl;
        CachedItem cachedItem;
        long l = 0L;
        ++this.stat.remove;
        Clock clock2 = this;
        synchronized (clock2) {
            cachedItem = (CachedItem)this.get(cacheable.getIdentity());
            if (this.useByteCount) {
                l = this.getItemSize(cachedItem);
            }
            cachedItem.setRemoveState();
            bl = cachedItem.unkeep();
            if (bl) {
                this.remove(cacheable.getIdentity());
                cachedItem.keepForClean();
            }
        }
        try {
            cachedItem.remove(bl);
            Object var9_7 = null;
            clock = this;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            Clock clock3 = this;
            synchronized (clock3) {
                cachedItem.unkeep();
                cachedItem.setValidState(false);
                --this.validItemCount;
                cachedItem.getEntry().clearIdentity();
                if (this.useByteCount) {
                    this.currentByteCount += (long)this.getItemSize(cachedItem) - l;
                }
            }
            throw throwable;
        }
        synchronized (clock) {
            cachedItem.unkeep();
            cachedItem.setValidState(false);
            --this.validItemCount;
            cachedItem.getEntry().clearIdentity();
            if (this.useByteCount) {
                this.currentByteCount += (long)this.getItemSize(cachedItem) - l;
            }
        }
    }

    public void cleanAll() throws StandardException {
        ++this.stat.cleanAll;
        this.cleanCache(null);
    }

    public void clean(Matchable matchable) throws StandardException {
        this.cleanCache(matchable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ageOut() {
        ++this.stat.ageOut;
        Clock clock = this;
        synchronized (clock) {
            int n = this.holders.size();
            long l = this.shrinkSize(this.getCurrentSize());
            boolean bl = false;
            for (int j = 0; j < n; ++j) {
                CachedItem cachedItem = (CachedItem)this.holders.get(j);
                if (cachedItem.isKept() || !cachedItem.isValid() || cachedItem.getEntry().isDirty()) continue;
                long l2 = this.removeIdentity(cachedItem);
                if (l <= 0L) continue;
                l -= l2;
                bl = true;
            }
            if (bl) {
                this.trimToSize();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws StandardException {
        if (this.cleaner != null) {
            this.cleaner.unsubscribe(this.myClientNumber);
            this.cleaner = null;
        }
        Clock clock = this;
        synchronized (clock) {
            this.active = false;
        }
        this.ageOut();
        this.cleanAll();
        this.ageOut();
    }

    public void useDaemonService(DaemonService daemonService) {
        if (this.cleaner != null) {
            this.cleaner.unsubscribe(this.myClientNumber);
        }
        this.cleaner = daemonService;
        this.myClientNumber = this.cleaner.subscribe(this, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean discard(Matchable matchable) {
        boolean bl = true;
        Clock clock = this;
        synchronized (clock) {
            int n = this.holders.size();
            long l = this.shrinkSize(this.getCurrentSize());
            boolean bl2 = false;
            for (int j = 0; j < n; ++j) {
                CachedItem cachedItem = (CachedItem)this.holders.get(j);
                if (!cachedItem.isValid()) continue;
                Object object2 = cachedItem.getEntry().getIdentity();
                if (matchable != null && !matchable.match(object2)) continue;
                if (cachedItem.isKept()) {
                    bl = false;
                    continue;
                }
                long l2 = this.removeIdentity(cachedItem);
                if (l <= 0L) continue;
                l -= l2;
                bl2 = true;
            }
            if (bl2) {
                this.trimToSize();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cacheable addEntry(CachedItem cachedItem, Object object2, boolean bl, Object object3) throws StandardException {
        boolean bl2;
        Clock clock;
        Cacheable cacheable = null;
        long l = 0L;
        if (this.useByteCount) {
            l = this.getItemSize(cachedItem);
        }
        try {
            cacheable = cachedItem.takeOnIdentity(this, this.holderFactory, object2, bl, object3);
            Object var9_7 = null;
            clock = this;
        }
        catch (Throwable throwable) {
            boolean bl3;
            Object var9_8 = null;
            Clock clock2 = this;
            synchronized (clock2) {
                Object v = this.remove(object2);
                if (cacheable != null) {
                    this.put(cacheable.getIdentity(), cachedItem);
                    if (this.useByteCount) {
                        this.currentByteCount += (long)((SizedCacheable)cacheable).getSize() - l;
                    }
                    cachedItem.setValidState(true);
                    ++this.validItemCount;
                    bl3 = true;
                } else {
                    cachedItem.unkeep();
                    bl3 = cachedItem.isKept();
                }
            }
            if (bl3) {
                cachedItem.settingIdentityComplete();
            }
            throw throwable;
        }
        synchronized (clock) {
            Object v = this.remove(object2);
            if (cacheable != null) {
                this.put(cacheable.getIdentity(), cachedItem);
                if (this.useByteCount) {
                    this.currentByteCount += (long)((SizedCacheable)cacheable).getSize() - l;
                }
                cachedItem.setValidState(true);
                ++this.validItemCount;
                bl2 = true;
            } else {
                cachedItem.unkeep();
                bl2 = cachedItem.isKept();
            }
        }
        if (bl2) {
            cachedItem.settingIdentityComplete();
        }
        return cacheable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CachedItem findFreeItem() throws StandardException {
        Object object2;
        long l = this.getCurrentSize();
        if (l >= this.maximumSize && (object2 = this.rotateClock(0.2f)) != null) {
            return object2;
        }
        if (this.validItemCount < this.holders.size()) {
            object2 = this;
            synchronized (object2) {
                int n = this.holders.size() - this.validItemCount;
                for (int j = this.holders.size() - 1; n > 0 && j >= 0; --j) {
                    CachedItem cachedItem = (CachedItem)this.holders.get(j);
                    if (cachedItem.isKept()) {
                        if (cachedItem.isValid()) continue;
                        --n;
                        continue;
                    }
                    if (cachedItem.isValid()) continue;
                    cachedItem.keepForCreate();
                    return cachedItem;
                }
            }
        }
        return this.growCache();
    }

    /*
     * Exception decompiling
     */
    protected CachedItem rotateClock(float var1_1) throws StandardException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 17[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int incrClockHand() {
        if (++this.clockHand >= this.holders.size()) {
            this.clockHand = 0;
        }
        return this.clockHand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int performWork(ContextManager contextManager) {
        int n = this.performWork(false);
        Clock clock = this;
        synchronized (clock) {
            this.cleanerRunning = false;
        }
        return n;
    }

    public boolean serviceASAP() {
        return this.needService;
    }

    public boolean serviceImmediately() {
        return false;
    }

    public synchronized int getNumberInUse() {
        int n = this.holders.size();
        int n2 = 0;
        for (int j = 0; j < n; ++j) {
            CachedItem cachedItem = (CachedItem)this.holders.get(j);
            if (!cachedItem.isValid()) continue;
            ++n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedItem growCache() {
        CachedItem cachedItem = new CachedItem();
        cachedItem.keepForCreate();
        Clock clock = this;
        synchronized (clock) {
            this.holders.add(cachedItem);
        }
        return cachedItem;
    }

    protected long removeIdentity(CachedItem cachedItem) {
        long l = 1L;
        if (this.useByteCount) {
            l = ((SizedCacheable)cachedItem.getEntry()).getSize();
        }
        this.remove(cachedItem.getEntry().getIdentity());
        cachedItem.setValidState(false);
        --this.validItemCount;
        cachedItem.getEntry().clearIdentity();
        if (this.useByteCount) {
            this.currentByteCount -= (l -= (long)((SizedCacheable)cachedItem.getEntry()).getSize());
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanCache(Matchable matchable) throws StandardException {
        int n;
        Object object2 = this;
        synchronized (object2) {
            n = this.holders.size() - 1;
        }
        while (true) {
            object2 = null;
            Clock clock = this;
            synchronized (clock) {
                int n2 = this.holders.size();
                if (n >= n2) {
                    n = n2 - 1;
                }
                while (n >= 0) {
                    Object object3;
                    object2 = (CachedItem)this.holders.get(n);
                    if (((CachedItem)object2).isValid() && ((CachedItem)object2).getEntry().isDirty() && (matchable == null || matchable.match(object3 = ((CachedItem)object2).getEntry().getIdentity()))) {
                        ((CachedItem)object2).keepForClean();
                        break;
                    }
                    --n;
                    object2 = null;
                }
            }
            if (n < 0) {
                return;
            }
            try {
                ((CachedItem)object2).clean(false);
            }
            finally {
                this.release((CachedItem)object2);
            }
            --n;
        }
    }

    protected long shrinkSize(long l) {
        long l2 = this.getMaximumSize();
        long l3 = l - l2;
        if (l3 <= 0L) {
            return 0L;
        }
        long l4 = l2 / 10L;
        if (l4 == 0L) {
            l4 = 2L;
        }
        if (l3 < l4) {
            return l3;
        }
        return l4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int performWork(boolean bl) {
        int n;
        long l;
        long l2;
        Clock clock = this;
        synchronized (clock) {
            if (!this.active) {
                this.needService = false;
                return 1;
            }
            long l3 = this.getCurrentSize();
            l2 = l3 / 20L;
            long l4 = l = this.wokenToClean ? 0L : this.shrinkSize(l3);
            if (l2 == 0L) {
                this.wokenToClean = false;
                this.needService = false;
                return 1;
            }
            if (!this.wokenToClean && l <= 0L) {
                this.needService = false;
                return 1;
            }
            n = this.useByteCount ? this.holders.size() / 10 : (int)(l2 * 2L);
        }
        long l5 = 0L;
        boolean bl2 = false;
        CachedItem cachedItem = null;
        int n2 = 0;
        Object var12_12 = null;
        Clock clock2 = this;
        synchronized (clock2) {
            int n3 = this.holders.size();
            n2 = this.clockHand;
            boolean bl3 = false;
            long l6 = this.getCurrentSize();
            while (bl ? l6 > this.maximumSize && l > 0L : l5 < l2) {
                if (++n2 >= n3) {
                    if (n3 == 0) break;
                    n2 = 0;
                }
                if (n-- <= 0) break;
                cachedItem = (CachedItem)this.holders.get(n2);
                if (!cachedItem.isKept()) {
                    if (!cachedItem.isValid()) {
                        if (l > 0L) {
                            l -= l6;
                            this.holders.remove(n2);
                            if (this.useByteCount) {
                                this.currentByteCount -= (long)this.getItemSize(cachedItem);
                            }
                            l6 = this.getCurrentSize();
                            l += l6;
                            --n3;
                            --n2;
                            bl3 = true;
                        }
                    } else if (!cachedItem.recentlyUsed()) {
                        int n4 = this.getItemSize(cachedItem);
                        l5 += (long)n4;
                        if (!cachedItem.getEntry().isDirty()) {
                            if (l > 0L) {
                                l -= l6;
                                this.removeIdentity(cachedItem);
                                this.holders.remove(n2);
                                if (this.useByteCount) {
                                    this.currentByteCount -= (long)this.getItemSize(cachedItem);
                                }
                                l6 = this.getCurrentSize();
                                l += l6;
                                --n3;
                                bl3 = true;
                                --n2;
                            }
                        } else if (!bl) {
                            cachedItem.keepForClean();
                            break;
                        }
                    }
                }
                cachedItem = null;
            }
            if (bl3) {
                this.trimToSize();
            }
            if (cachedItem == null) {
                this.wokenToClean = false;
                this.needService = false;
                return 1;
            }
        }
        try {
            cachedItem.clean(false);
        }
        catch (StandardException standardException) {
        }
        finally {
            this.release(cachedItem);
            cachedItem = null;
        }
        this.needService = true;
        return 2;
    }

    private int getItemSize(CachedItem cachedItem) {
        if (!this.useByteCount) {
            return 1;
        }
        SizedCacheable sizedCacheable = (SizedCacheable)cachedItem.getEntry();
        if (null == sizedCacheable) {
            return 0;
        }
        return sizedCacheable.getSize();
    }

    public synchronized long[] getCacheStats() {
        this.stat.currentSize = this.getCurrentSize();
        return this.stat.getStats();
    }

    public void resetCacheStats() {
        this.stat.reset();
    }

    public synchronized long getMaximumSize() {
        return this.maximumSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(long l) throws StandardException {
        boolean bl;
        Object object2 = this;
        synchronized (object2) {
            this.stat.maxSize = this.maximumSize = l;
            bl = this.shrinkSize(this.getCurrentSize()) > 0L;
        }
        if (bl) {
            this.performWork(true);
            if (this.shrinkSize(this.getCurrentSize()) > 0L && (object2 = this.rotateClock(2.0f)) != null) {
                ((CachedItem)object2).unkeepForCreate();
            }
        }
    }

    private synchronized long getCurrentSize() {
        if (!this.useByteCount) {
            return this.holders.size();
        }
        return this.currentByteCount + (long)(this.holders.size() * ITEM_OVERHEAD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(Matchable matchable, Operator operator) {
        boolean bl = true;
        Cacheable cacheable = null;
        CachedItem cachedItem = null;
        int n = 0;
        while (true) {
            Clock clock = this;
            synchronized (clock) {
                if (null != cachedItem) {
                    this.release(cachedItem);
                    cachedItem = null;
                }
                while (n < this.holders.size()) {
                    block11: {
                        cachedItem = (CachedItem)this.holders.get(n);
                        if (null != cachedItem) {
                            try {
                                cacheable = cachedItem.use();
                            }
                            catch (StandardException standardException) {
                                break block11;
                            }
                            if (null != cacheable && (null == matchable || matchable.match(cacheable))) {
                                cachedItem.keepForClean();
                                break;
                            }
                        }
                    }
                    ++n;
                }
                if (n >= this.holders.size()) {
                    return;
                }
            }
            operator.operate(cacheable);
            ++n;
        }
    }

    private void trimToSize() {
        int n;
        int n2 = this.holders.size();
        ++this.trimRequests;
        if (this.trimRequests < n2 / 8) {
            return;
        }
        this.trimRequests = 0;
        int n3 = n2 - 1;
        int n4 = 0;
        block0: for (n = 0; n <= n3; ++n) {
            CachedItem cachedItem = (CachedItem)this.holders.get(n);
            if (cachedItem.isKept() || cachedItem.isValid()) continue;
            ++n4;
            while (n3 > n) {
                CachedItem cachedItem2 = (CachedItem)this.holders.get(n3);
                if (cachedItem2.isValid()) {
                    this.holders.set(n, cachedItem2);
                    this.holders.set(n3, cachedItem);
                    --n3;
                    continue block0;
                }
                --n3;
            }
        }
        if (n2 < 32) {
            return;
        }
        n = n2 - n4;
        if (n > 3 * n2 / 4) {
            return;
        }
        int n5 = n + n / 10;
        if (n5 >= n2) {
            return;
        }
        for (int j = n2 - 1; j > n5; --j) {
            CachedItem cachedItem = (CachedItem)this.holders.get(j);
            if (cachedItem.isKept() || cachedItem.isValid()) continue;
            if (this.useByteCount) {
                this.currentByteCount -= (long)this.getItemSize(cachedItem);
            }
            this.holders.remove(j);
        }
        this.holders.trimToSize();
        this.clockHand = n + 1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

