/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.cache;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.cache.CacheableFactory;

public final class CachedItem {
    private static final int VALID = 1;
    private static final int REMOVE_REQUESTED = 2;
    private static final int SETTING_IDENTITY = 4;
    private static final int REMOVE_OK = 8;
    private static final int RECENTLY_USED = 16;
    private int state;
    private int keepCount;
    private Cacheable entry;

    public void keepAfterSearch() {
        ++this.keepCount;
        this.setUsed(true);
    }

    public void keepForCreate() {
        this.keepCount = 1;
        this.state |= 4;
    }

    public void unkeepForCreate() {
        this.settingIdentityComplete();
        this.unkeep();
    }

    public void keepForClean() {
        ++this.keepCount;
    }

    public synchronized boolean unkeep() {
        boolean bl = --this.keepCount == 0;
        return bl && (this.state & 2) != 0;
    }

    public final boolean isKept() {
        return this.keepCount != 0;
    }

    public void clean(boolean bl) throws StandardException {
        this.entry.clean(bl);
    }

    public synchronized void setRemoveState() {
        this.state |= 2;
    }

    public final synchronized boolean isValid() {
        return (this.state & 1) != 0;
    }

    public synchronized void setValidState(boolean bl) {
        this.state = bl ? (this.state |= 1) : (this.state &= 0xFFFFFFFE);
        this.state &= 0xFFFFFFF5;
        this.setUsed(bl);
    }

    public Cacheable getEntry() {
        return this.entry;
    }

    public Cacheable takeOnIdentity(CacheManager cacheManager, CacheableFactory cacheableFactory, Object object2, boolean bl, Object object3) throws StandardException {
        Cacheable cacheable = this.entry;
        if (cacheable == null) {
            cacheable = cacheableFactory.newCacheable(cacheManager);
        }
        this.entry = bl ? cacheable.createIdentity(object2, object3) : cacheable.setIdentity(object2);
        if (this.entry != null) {
            return this.entry;
        }
        this.entry = cacheable;
        return null;
    }

    public synchronized void settingIdentityComplete() {
        this.state &= 0xFFFFFFFB;
        this.notifyAll();
    }

    public synchronized Cacheable use() throws StandardException {
        while ((this.state & 4) != 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw StandardException.interrupt(interruptedException);
            }
        }
        if (!this.isValid()) {
            return null;
        }
        return this.entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(boolean bl) throws StandardException {
        if (!bl) {
            CachedItem cachedItem = this;
            synchronized (cachedItem) {
                while ((this.state & 8) == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw StandardException.interrupt(interruptedException);
                    }
                }
            }
        }
        this.clean(true);
    }

    public synchronized void notifyRemover() {
        this.state |= 8;
        this.notifyAll();
    }

    public synchronized void setUsed(boolean bl) {
        this.state = bl ? (this.state |= 0x10) : (this.state &= 0xFFFFFFEF);
    }

    public synchronized boolean recentlyUsed() {
        return (this.state & 0x10) != 0;
    }
}

