/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.bytecode;

import org.apache.derby.impl.services.bytecode.CodeChunk;

class Conditional {
    private final Conditional parent;
    private final int ifOffset;
    private int clearTo;
    private int thenGotoOffset;

    Conditional(Conditional conditional, CodeChunk codeChunk, short s2, int n) {
        this.parent = conditional;
        this.ifOffset = codeChunk.getRelativePC();
        this.clearTo = n;
        codeChunk.addInstrU2(s2, 0);
    }

    int startElse(CodeChunk codeChunk, int n) {
        this.thenGotoOffset = codeChunk.getRelativePC();
        codeChunk.addInstrU2((short)167, 0);
        this.fillIn(codeChunk, this.ifOffset);
        int n2 = this.clearTo;
        this.clearTo = n;
        return n2;
    }

    Conditional end(CodeChunk codeChunk, int n) {
        if (this.thenGotoOffset == 0) {
            this.fillIn(codeChunk, this.ifOffset);
        } else {
            this.fillIn(codeChunk, this.thenGotoOffset);
        }
        if (this.clearTo != n) {
            throw new RuntimeException("mismatched sizes then " + this.clearTo + " else " + n);
        }
        return this.parent;
    }

    private void fillIn(CodeChunk codeChunk, int n) {
        byte[] byArray = codeChunk.getCout().getData();
        int n2 = codeChunk.getRelativePC() - n;
        byArray[(n += 8) + 1] = (byte)(n2 >> 8);
        byArray[n + 2] = (byte)n2;
    }
}

