/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.LimitReader;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.VariableSizeDataValue;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedParameterSetMetaData;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.impl.jdbc.EmbedStatement;
import org.apache.derby.impl.jdbc.RawToBinaryFormatStream;
import org.apache.derby.impl.jdbc.ReaderToUTF8Stream;
import org.apache.derby.impl.jdbc.Util;

public abstract class EmbedPreparedStatement
extends EmbedStatement
implements PreparedStatement {
    protected ResultSetMetaData rMetaData;
    private String gcDuringGetMetaData;
    protected org.apache.derby.iapi.sql.PreparedStatement preparedStatement;
    private Activation activation;

    public EmbedPreparedStatement(EmbedConnection embedConnection, String string, boolean bl, int n, int n2, int n3, int n4, int[] nArray, String[] stringArray) throws SQLException {
        super(embedConnection, bl, n, n2, n3);
        if (string == null) {
            throw this.newSQLException("XJ067.S");
        }
        this.SQLText = string;
        try {
            this.preparedStatement = this.lcc.prepareInternalStatement(string);
            this.addWarning(this.preparedStatement.getCompileTimeWarnings());
            this.activation = this.preparedStatement.getActivation(this.lcc, n == 1004);
            this.checkRequiresCallableStatement(this.activation);
            if (n4 == 1) {
                this.activation.setAutoGeneratedKeysResultsetInfo(nArray, stringArray);
            }
        }
        catch (Throwable throwable) {
            throw this.handleException(throwable);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.activation != null) {
            this.activation.markUnused();
        }
    }

    public final boolean execute(String string) throws SQLException {
        throw this.newSQLException("XJ016.S", "execute(String)");
    }

    public final boolean execute(String string, int n) throws SQLException {
        throw this.newSQLException("XJ016.S", "execute(String, int)");
    }

    public final boolean execute(String string, int[] nArray) throws SQLException {
        throw this.newSQLException("XJ016.S", "execute(String, int[])");
    }

    public final boolean execute(String string, String[] stringArray) throws SQLException {
        throw this.newSQLException("XJ016.S", "execute(String, String[])");
    }

    public final ResultSet executeQuery(String string) throws SQLException {
        throw this.newSQLException("XJ016.S", "executeQuery(String)");
    }

    public final int executeUpdate(String string) throws SQLException {
        throw this.newSQLException("XJ016.S", "executeUpdate(String)");
    }

    public final int executeUpdate(String string, int n) throws SQLException {
        throw this.newSQLException("XJ016.S", "executeUpdate(String, int)");
    }

    public final int executeUpdate(String string, int[] nArray) throws SQLException {
        throw this.newSQLException("XJ016.S", "executeUpdate(String, int[])");
    }

    public final int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw this.newSQLException("XJ016.S", "executeUpdate(String, String[])");
    }

    public final void addBatch(String string) throws SQLException {
        throw this.newSQLException("XJ016.S", "addBatch(String)");
    }

    protected void closeActions() throws SQLException {
        this.preparedStatement = null;
        try {
            this.setupContextStack();
        }
        catch (SQLException sQLException) {
            return;
        }
        try {
            this.activation.close();
            this.activation = null;
        }
        catch (Throwable throwable) {
            throw this.handleException(throwable);
        }
        finally {
            this.restoreContextStack();
        }
    }

    public final ResultSet executeQuery() throws SQLException {
        this.executeStatement(this.activation, true, false);
        return this.results;
    }

    public final int executeUpdate() throws SQLException {
        this.executeStatement(this.activation, false, true);
        return this.updateCount;
    }

    public void setNull(int n, int n2) throws SQLException {
        this.checkStatus();
        int n3 = this.getParameterJDBCType(n);
        if (!DataTypeDescriptor.isJDBCTypeEquivalent(n3, n2)) {
            throw this.dataTypeConversion(n, Util.typeName(n2));
        }
        try {
            this.getParms().getParameterForSet(n - 1).setToNull();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(n - 1).setValue(bl);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void setByte(int n, byte by) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(n - 1).setValue(by);
        }
        catch (Throwable throwable) {
            throw EmbedResultSet.noStateChangeException(throwable);
        }
    }

    public void setShort(int n, short s2) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(n - 1).setValue(s2);
        }
        catch (Throwable throwable) {
            throw EmbedResultSet.noStateChangeException(throwable);
        }
    }

    public void setInt(int n, int n2) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(n - 1).setValue(n2);
        }
        catch (Throwable throwable) {
            throw EmbedResultSet.noStateChangeException(throwable);
        }
    }

    public void setLong(int n, long l) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(n - 1).setValue(l);
        }
        catch (Throwable throwable) {
            throw EmbedResultSet.noStateChangeException(throwable);
        }
    }

    public void setFloat(int n, float f2) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(n - 1).setValue(f2);
        }
        catch (Throwable throwable) {
            throw EmbedResultSet.noStateChangeException(throwable);
        }
    }

    public void setDouble(int n, double d2) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(n - 1).setValue(d2);
        }
        catch (Throwable throwable) {
            throw EmbedResultSet.noStateChangeException(throwable);
        }
    }

    public void setString(int n, String string) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(n - 1).setValue(string);
        }
        catch (Throwable throwable) {
            throw EmbedResultSet.noStateChangeException(throwable);
        }
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(n - 1).setValue(byArray);
        }
        catch (Throwable throwable) {
            throw EmbedResultSet.noStateChangeException(throwable);
        }
    }

    public void setDate(int n, Date date) throws SQLException {
        this.setDate(n, date, null);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.setTime(n, time, null);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setTimestamp(n, timestamp, null);
    }

    public final void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkStatus();
        int n3 = this.getParameterJDBCType(n);
        switch (n3) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                break;
            }
            default: {
                throw this.dataTypeConversion(n, "java.io.InputStream(ASCII)");
            }
        }
        InputStreamReader inputStreamReader = null;
        if (inputStream != null) {
            try {
                inputStreamReader = new InputStreamReader(inputStream, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException(unsupportedEncodingException.getMessage());
            }
        }
        this.setCharacterStream(n, (Reader)inputStreamReader, n2);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw Util.notImplemented("setUnicodeStream");
    }

    public final void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        int n3 = this.getParameterJDBCType(n);
        switch (n3) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                break;
            }
            default: {
                throw this.dataTypeConversion(n, "java.io.Reader");
            }
        }
        if (n2 < 0) {
            throw this.newSQLException("XJ025.S");
        }
        if (reader == null) {
            this.setNull(n, n3);
            return;
        }
        this.setCharacterStreamInternal(n, reader, n2);
    }

    protected void setCharacterStreamInternal(int n, Reader reader, int n2) throws SQLException {
        this.checkStatus();
        int n3 = this.getParameterJDBCType(n);
        try {
            ParameterValueSet parameterValueSet = this.getParms();
            LimitReader limitReader = new LimitReader(reader);
            if (n2 != -1) {
                limitReader.setLimit(n2);
            }
            ReaderToUTF8Stream readerToUTF8Stream = new ReaderToUTF8Stream(limitReader);
            parameterValueSet.getParameterForSet(n - 1).setValue(readerToUTF8Stream, n2);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        int n3 = this.getParameterJDBCType(n);
        switch (n3) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                break;
            }
            default: {
                throw this.dataTypeConversion(n, "java.io.InputStream");
            }
        }
        if (n2 < 0) {
            throw this.newSQLException("XJ025.S");
        }
        this.setBinaryStreamInternal(n, inputStream, n2);
    }

    protected void setBinaryStreamInternal(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkStatus();
        int n3 = this.getParameterJDBCType(n);
        if (inputStream == null) {
            this.setNull(n, n3);
            return;
        }
        try {
            this.getParms().getParameterForSet(n - 1).setValue(new RawToBinaryFormatStream(inputStream, n2), n2);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        throw Util.notImplemented("setNull");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatch() throws SQLException {
        this.checkStatus();
        Object object2 = this.getConnectionSynchronization();
        synchronized (object2) {
            if (this.batchStatements == null) {
                this.batchStatements = new Vector();
            }
            this.batchStatements.addElement(this.getParms().getClone());
            this.clearParameters();
        }
    }

    boolean executeBatchElement(Object object2) throws SQLException, StandardException {
        ParameterValueSet parameterValueSet = (ParameterValueSet)object2;
        int n = parameterValueSet.getParameterCount();
        for (int j = 0; j < n; ++j) {
            parameterValueSet.getParameter(j).setInto(this, j + 1);
        }
        return super.executeStatement(this.activation, false, true);
    }

    public void clearParameters() throws SQLException {
        this.checkStatus();
        ParameterValueSet parameterValueSet = this.getParms();
        if (parameterValueSet != null) {
            parameterValueSet.clearParameters();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkExecStatus();
        Object object2 = this.getConnectionSynchronization();
        synchronized (object2) {
            ExecPreparedStatement execPreparedStatement = (ExecPreparedStatement)this.preparedStatement;
            this.setupContextStack();
            try {
                ResultDescription resultDescription;
                if (!this.preparedStatement.isValid()) {
                    this.preparedStatement.rePrepare(this.lcc);
                    this.rMetaData = null;
                }
                if (this.gcDuringGetMetaData == null || !this.gcDuringGetMetaData.equals(execPreparedStatement.getActivationClass().getName())) {
                    this.rMetaData = null;
                    this.gcDuringGetMetaData = execPreparedStatement.getActivationClass().getName();
                }
                if (this.rMetaData == null && (resultDescription = this.preparedStatement.getResultDescription()) != null) {
                    String string = resultDescription.getStatementType();
                    this.rMetaData = string.equals("INSERT") || string.equals("UPDATE") || string.equals("DELETE") ? null : this.newEmbedResultSetMetaData(resultDescription);
                }
            }
            catch (Throwable throwable) {
                throw this.handleException(throwable);
            }
            finally {
                this.restoreContextStack();
            }
        }
        return this.rMetaData;
    }

    public final void setObject(int n, Object object2, int n2, int n3) throws SQLException {
        if (object2 == null) {
            this.setNull(n, n2);
            return;
        }
        int n4 = this.getParameterJDBCType(n);
        if (n4 != 2000 && !DataTypeDescriptor.isJDBCTypeEquivalent(n4, n2)) {
            throw this.dataTypeConversion(n, Util.typeName(n2));
        }
        this.setObject(n, object2);
        if (n4 == 3 || n4 == 2) {
            this.setScale(n, n3);
        }
    }

    public final void setObject(int n, Object object2, int n2) throws SQLException {
        this.setObject(n, object2, n2, 0);
    }

    public final void setObject(int n, Object object2) throws SQLException {
        this.checkStatus();
        int n2 = this.getParameterJDBCType(n);
        if (object2 == null) {
            throw this.dataTypeConversion(n, "null");
        }
        if (n2 == 2000) {
            try {
                this.getParms().setParameterAsObject(n - 1, object2);
                return;
            }
            catch (Throwable throwable) {
                throw EmbedResultSet.noStateChangeException(throwable);
            }
        }
        if (object2 instanceof String) {
            this.setString(n, (String)object2);
            return;
        }
        if (object2 instanceof Boolean) {
            this.setBoolean(n, (Boolean)object2);
            return;
        }
        if (object2 instanceof Integer) {
            this.setInt(n, (Integer)object2);
            return;
        }
        if (object2 instanceof Long) {
            this.setLong(n, (Long)object2);
            return;
        }
        if (object2 instanceof Float) {
            this.setFloat(n, ((Float)object2).floatValue());
            return;
        }
        if (object2 instanceof Double) {
            this.setDouble(n, (Double)object2);
            return;
        }
        if (object2 instanceof byte[]) {
            this.setBytes(n, (byte[])object2);
            return;
        }
        if (object2 instanceof Date) {
            this.setDate(n, (Date)object2);
            return;
        }
        if (object2 instanceof Time) {
            this.setTime(n, (Time)object2);
            return;
        }
        if (object2 instanceof Timestamp) {
            this.setTimestamp(n, (Timestamp)object2);
            return;
        }
        if (object2 instanceof Blob) {
            this.setBlob(n, (Blob)object2);
            return;
        }
        if (object2 instanceof Clob) {
            this.setClob(n, (Clob)object2);
            return;
        }
        if (this.setObjectConvert(n, object2)) {
            return;
        }
        throw this.dataTypeConversion(n, object2.getClass().getName());
    }

    boolean setObjectConvert(int n, Object object2) throws SQLException {
        return false;
    }

    public final boolean execute() throws SQLException {
        return this.executeStatement(this.activation, false, false);
    }

    public final void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(n - 1).setValue(date, calendar);
        }
        catch (Throwable throwable) {
            throw EmbedResultSet.noStateChangeException(throwable);
        }
    }

    public final void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(n - 1).setValue(time, calendar);
        }
        catch (Throwable throwable) {
            throw EmbedResultSet.noStateChangeException(throwable);
        }
    }

    public final void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(n - 1).setValue(timestamp, calendar);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlob(int n, Blob blob) throws SQLException {
        int n2;
        Object object2 = this.getConnectionSynchronization();
        synchronized (object2) {
            n2 = this.getParameterJDBCType(n);
        }
        if (n2 != 2004) {
            throw this.dataTypeConversion(n, "java.sql.Blob");
        }
        if (blob == null) {
            this.setNull(n, 2004);
        } else {
            this.setBinaryStreamInternal(n, blob.getBinaryStream(), -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClob(int n, Clob clob) throws SQLException {
        int n2;
        Object object2 = this.getConnectionSynchronization();
        synchronized (object2) {
            n2 = this.getParameterJDBCType(n);
        }
        if (n2 != 2005) {
            throw this.dataTypeConversion(n, "java.sql.Clob");
        }
        if (clob == null) {
            this.setNull(n, 2005);
        } else {
            this.setCharacterStreamInternal(n, clob.getCharacterStream(), -1);
        }
    }

    public final ParameterValueSet getParms() {
        return this.activation.getParameterValueSet();
    }

    protected final DataTypeDescriptor[] getTypes(int n) throws SQLException {
        DataTypeDescriptor[] dataTypeDescriptorArray = this.preparedStatement.getParameterTypes();
        if (dataTypeDescriptorArray == null) {
            throw this.newSQLException("07009");
        }
        if (n < 1 || n > dataTypeDescriptorArray.length) {
            throw this.newSQLException("XCL13.S", new Integer(n), new Integer(dataTypeDescriptorArray.length));
        }
        return dataTypeDescriptorArray;
    }

    protected int getParameterJDBCType(int n) throws SQLException {
        DataTypeDescriptor[] dataTypeDescriptorArray = this.getTypes(n);
        int n2 = dataTypeDescriptorArray[n - 1] == null ? 1111 : dataTypeDescriptorArray[n - 1].getTypeId().getJDBCTypeId();
        return n2;
    }

    private void setScale(int n, int n2) throws SQLException {
        this.checkStatus();
        if (n2 < 0) {
            throw this.newSQLException("XJ044.S", new Integer(n2));
        }
        try {
            ParameterValueSet parameterValueSet = this.getParms();
            DataValueDescriptor dataValueDescriptor = parameterValueSet.getParameter(n - 1);
            int n3 = dataValueDescriptor.getLength();
            ((VariableSizeDataValue)((Object)dataValueDescriptor)).setWidth(-1, n2, false);
            if (dataValueDescriptor.getLength() < n3) {
                this.activation.addWarning(StandardException.newWarning("01505", dataValueDescriptor.getString()));
            }
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public EmbedParameterSetMetaData getEmbedParameterSetMetaData() throws SQLException {
        this.checkExecStatus();
        return new EmbedParameterSetMetaData(this.getParms(), this.preparedStatement.getParameterTypes());
    }

    public final void setURL(int n, URL uRL) throws SQLException {
        throw Util.notImplemented();
    }

    protected EmbedResultSetMetaData newEmbedResultSetMetaData(ResultDescription resultDescription) {
        return new EmbedResultSetMetaData(resultDescription.getColumnInfo());
    }

    public String toString() {
        if (this.activation != null) {
            return this.activation.getPreparedStatement().getObjectName();
        }
        return super.toString();
    }

    public void transferParameters(EmbedPreparedStatement embedPreparedStatement) throws SQLException {
        try {
            embedPreparedStatement.activation.setParameters(this.getParms(), this.preparedStatement.getParameterTypes());
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    boolean executeStatement(Activation activation, boolean bl, boolean bl2) throws SQLException {
        this.checkExecStatus();
        this.checkIfInMiddleOfBatch();
        this.clearResultSets();
        return super.executeStatement(activation, bl, bl2);
    }

    final SQLException dataTypeConversion(int n, String string) throws SQLException {
        SQLException sQLException = this.newSQLException("22005", this.getEmbedParameterSetMetaData().getParameterTypeName(n), string);
        return sQLException;
    }
}

