/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedSavepoint30;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.jdbc.InternalDriver;

public class EmbedConnection30
extends EmbedConnection {
    public EmbedConnection30(InternalDriver internalDriver, String string, Properties properties) throws SQLException {
        super(internalDriver, string, properties);
    }

    public EmbedConnection30(EmbedConnection embedConnection) {
        super(embedConnection);
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.commonSetSavepointCode(null, false);
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        return this.commonSetSavepointCode(string, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Savepoint commonSetSavepointCode(String string, boolean bl) throws SQLException {
        Object object2 = this.getConnectionSynchronization();
        synchronized (object2) {
            this.setupContextStack();
            try {
                EmbedSavepoint30 embedSavepoint30;
                this.verifySavepointCommandIsAllowed();
                if (bl && string == null) {
                    throw this.newSQLException("XJ011.S");
                }
                if (bl && string.length() > 128) {
                    throw this.newSQLException("42622", string, String.valueOf(128));
                }
                if (bl && string.startsWith("SYS")) {
                    throw this.newSQLException("42939", "SYS");
                }
                EmbedSavepoint30 embedSavepoint302 = embedSavepoint30 = new EmbedSavepoint30(this, string);
                return embedSavepoint302;
            }
            catch (StandardException standardException) {
                throw this.handleException(standardException);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Savepoint savepoint) throws SQLException {
        Object object2 = this.getConnectionSynchronization();
        synchronized (object2) {
            this.setupContextStack();
            try {
                this.verifySavepointCommandIsAllowed();
                this.verifySavepointArg(savepoint);
                this.getLanguageConnection().internalRollbackToSavepoint(((EmbedSavepoint30)savepoint).getInternalName(), true, savepoint);
            }
            catch (StandardException standardException) {
                throw this.handleException(standardException);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        Object object2 = this.getConnectionSynchronization();
        synchronized (object2) {
            this.setupContextStack();
            try {
                this.verifySavepointCommandIsAllowed();
                this.verifySavepointArg(savepoint);
                this.getLanguageConnection().releaseSavePoint(((EmbedSavepoint30)savepoint).getInternalName(), savepoint);
            }
            catch (StandardException standardException) {
                throw this.handleException(standardException);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    private void verifySavepointCommandIsAllowed() throws SQLException {
        if (this.autoCommit) {
            throw this.newSQLException("XJ010.S");
        }
        StatementContext statementContext = this.getLanguageConnection().getStatementContext();
        if (statementContext != null && statementContext.inTrigger()) {
            throw this.newSQLException("XJ017.S");
        }
    }

    private void verifySavepointArg(Savepoint savepoint) throws SQLException {
        EmbedSavepoint30 embedSavepoint30 = (EmbedSavepoint30)savepoint;
        if (embedSavepoint30 == null) {
            throw Util.generateCsSQLException("3B001.S", "null");
        }
        if (!embedSavepoint30.sameConnection(this)) {
            throw this.newSQLException("3B502.S");
        }
    }
}

