/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.AuthenticationService;
import org.apache.derby.iapi.jdbc.EngineConnection;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecutionContext;
import org.apache.derby.iapi.store.access.XATransactionController;
import org.apache.derby.impl.jdbc.EmbedConnectionContext;
import org.apache.derby.impl.jdbc.EmbedSQLWarning;
import org.apache.derby.impl.jdbc.TransactionResourceImpl;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.jdbc.InternalDriver;

public class EmbedConnection
implements EngineConnection {
    private static final StandardException exceptionClose = StandardException.closeException();
    protected DatabaseMetaData dbMetadata;
    protected final TransactionResourceImpl tr;
    private boolean active;
    protected boolean autoCommit = true;
    boolean needCommit;
    private int connectionHoldAbility = 1;
    protected final EmbedConnection rootConnection;
    private SQLWarning topWarning;
    public InternalDriver factory;
    private Connection applicationConnection;
    private int resultSetId;
    private String idString;

    public EmbedConnection(InternalDriver internalDriver, String string, Properties properties) throws SQLException {
        this.rootConnection = this;
        this.applicationConnection = this.rootConnection;
        this.factory = internalDriver;
        this.tr = new TransactionResourceImpl(internalDriver, string, properties);
        this.active = true;
        this.setupContextStack();
        try {
            EmbedConnectionContext embedConnectionContext = this.pushConnectionContext(this.tr.getContextManager());
            boolean bl = Boolean.valueOf(properties.getProperty("shutdown"));
            Database database = (Database)Monitor.findService("org.apache.derby.database.Database", this.tr.getDBName());
            boolean bl2 = this.createBoot(properties);
            if (database != null) {
                this.tr.setDatabase(database);
            } else if (!bl && !this.bootDatabase(properties)) {
                this.tr.clearContextInError();
                this.setInactive();
                return;
            }
            if (bl2 && !bl) {
                if (this.tr.getDatabase() != null) {
                    this.addWarning(EmbedSQLWarning.newEmbedSQLWarning("01J01", this.getDBName()));
                } else {
                    this.checkUserCredentials(null, properties);
                    database = this.createDatabase(this.tr.getDBName(), properties);
                    this.tr.setDatabase(database);
                }
            }
            if (this.tr.getDatabase() == null) {
                String string2 = this.tr.getDBName();
                this.setInactive();
                throw this.newSQLException("XJ004.C", string2);
            }
            this.checkUserCredentials(this.tr.getDBName(), properties);
            this.tr.startTransaction();
            if (bl) {
                throw this.tr.shutdownDatabaseException();
            }
        }
        catch (Throwable throwable) {
            throw this.handleException(throwable);
        }
        finally {
            this.restoreContextStack();
            properties = null;
        }
    }

    private boolean createBoot(Properties properties) throws SQLException {
        int n = 0;
        if (Boolean.valueOf(properties.getProperty("create")).booleanValue()) {
            ++n;
        }
        int n2 = 0;
        if (properties.getProperty("createFrom") != null) {
            ++n2;
        }
        if (properties.getProperty("restoreFrom") != null) {
            ++n2;
        }
        if (properties.getProperty("rollForwardRecoveryFrom") != null) {
            ++n2;
        }
        if (n2 > 1) {
            throw this.newSQLException("XJ081.C");
        }
        if ((n += n2) > 1) {
            throw this.newSQLException("XJ049.C");
        }
        return n - n2 == 1;
    }

    public EmbedConnection(EmbedConnection embedConnection) {
        this.autoCommit = false;
        this.tr = null;
        this.active = true;
        this.rootConnection = embedConnection.rootConnection;
        this.applicationConnection = this;
        this.factory = embedConnection.factory;
        this.connectionHoldAbility = embedConnection.connectionHoldAbility;
    }

    private void checkUserCredentials(String string, Properties properties) throws SQLException {
        AuthenticationService authenticationService = null;
        authenticationService = string == null ? this.getLocalDriver().getAuthenticationService() : this.getTR().getDatabase().getAuthenticationService();
        if (authenticationService == null) {
            String string2 = MessageService.getTextMessage(string == null ? "A001" : "A002");
            throw this.newSQLException("08004", string2);
        }
        if (!authenticationService.authenticate(string, properties)) {
            throw this.newSQLException("08004", MessageService.getTextMessage("A020"));
        }
    }

    public int getEngineType() {
        Database database = this.getDatabase();
        if (null == database) {
            return 0;
        }
        return database.getEngineType();
    }

    public final Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, this.connectionHoldAbility);
    }

    public final Statement createStatement(int n, int n2) throws SQLException {
        return this.createStatement(n, n2, this.connectionHoldAbility);
    }

    public final Statement createStatement(int n, int n2, int n3) throws SQLException {
        if (this.isClosed()) {
            throw Util.noCurrentConnection();
        }
        return this.factory.newEmbedStatement(this, false, this.setResultSetType(n), this.setResultSetConcurrency(n, n2), n3);
    }

    public final PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007, this.connectionHoldAbility, 2, null, null);
    }

    public final PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.prepareStatement(string, n, n2, this.connectionHoldAbility, 2, null, null);
    }

    public final PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        return this.prepareStatement(string, n, n2, n3, 2, null, null);
    }

    public final PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw Util.notImplemented("prepareStatement(String, int[])");
    }

    public final PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw Util.notImplemented("prepareStatement(String, String[])");
    }

    public final PreparedStatement prepareStatement(String string, int n) throws SQLException {
        return this.prepareStatement(string, 1003, 1007, this.connectionHoldAbility, n, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement prepareStatement(String string, int n, int n2, int n3, int n4, int[] nArray, String[] stringArray) throws SQLException {
        Object object2 = this.getConnectionSynchronization();
        synchronized (object2) {
            PreparedStatement preparedStatement;
            this.setupContextStack();
            try {
                preparedStatement = this.factory.newEmbedPreparedStatement(this, string, false, this.setResultSetType(n), this.setResultSetConcurrency(n, n2), n3, n4, nArray, stringArray);
            }
            catch (Throwable throwable) {
                this.restoreContextStack();
                throw throwable;
            }
            this.restoreContextStack();
            return preparedStatement;
        }
    }

    public final CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1003, 1007, this.connectionHoldAbility);
    }

    public final CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.prepareCall(string, n, n2, this.connectionHoldAbility);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        Object object2 = this.getConnectionSynchronization();
        synchronized (object2) {
            CallableStatement callableStatement;
            this.setupContextStack();
            try {
                callableStatement = this.factory.newEmbedCallableStatement(this, string, this.setResultSetType(n), this.setResultSetConcurrency(n, n2), n3);
            }
            catch (Throwable throwable) {
                this.restoreContextStack();
                throw throwable;
            }
            this.restoreContextStack();
            return callableStatement;
        }
    }

    public String nativeSQL(String string) {
        return string;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (this.rootConnection != this && bl) {
            throw this.newSQLException("XJ030.S");
        }
        if (this.autoCommit != bl) {
            this.commit();
        }
        this.autoCommit = bl;
    }

    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SQLException {
        Object object2 = this.getConnectionSynchronization();
        synchronized (object2) {
            this.setupContextStack();
            try {
                this.getTR().commit();
            }
            catch (Throwable throwable) {
                throw this.handleException(throwable);
            }
            finally {
                this.restoreContextStack();
            }
            this.needCommit = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SQLException {
        Object object2 = this.getConnectionSynchronization();
        synchronized (object2) {
            this.setupContextStack();
            try {
                this.getTR().rollback();
            }
            catch (Throwable throwable) {
                throw this.handleException(throwable);
            }
            finally {
                this.restoreContextStack();
            }
            this.needCommit = false;
        }
    }

    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        if (this.rootConnection == this) {
            if (!this.autoCommit && !this.transactionIsIdle()) {
                throw this.newSQLException("25000");
            }
            this.close(exceptionClose);
        } else {
            this.setInactive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(Exception exception) throws SQLException {
        Object object2 = this.getConnectionSynchronization();
        synchronized (object2) {
            if (this.rootConnection == this && this.active) {
                this.setupContextStack();
                try {
                    this.tr.rollback();
                    this.tr.clearLcc();
                    this.tr.cleanupOnError(exception);
                }
                catch (Throwable throwable) {
                    throw this.handleException(throwable);
                }
                finally {
                    this.restoreContextStack();
                }
            }
            if (!this.isClosed()) {
                this.setInactive();
            }
        }
    }

    public final boolean isClosed() {
        if (this.active) {
            if (this.getTR().isActive()) {
                return false;
            }
            this.setInactive();
        }
        return true;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.isClosed()) {
            throw Util.noCurrentConnection();
        }
        if (this.dbMetadata == null) {
            this.dbMetadata = this.factory.newEmbedDatabaseMetaData(this, this.getTR().getUrl());
        }
        return this.dbMetadata;
    }

    public final int getHoldability() {
        return this.connectionHoldAbility;
    }

    public final void setHoldability(int n) {
        this.connectionHoldAbility = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setReadOnly(boolean bl) throws SQLException {
        Object object2 = this.getConnectionSynchronization();
        synchronized (object2) {
            this.setupContextStack();
            try {
                this.getLanguageConnection().setReadOnly(bl);
            }
            catch (StandardException standardException) {
                throw this.handleException(standardException);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    public final boolean isReadOnly() throws SQLException {
        return this.getLanguageConnection().isReadOnly();
    }

    public void setCatalog(String string) throws SQLException {
    }

    public String getCatalog() throws SQLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransactionIsolation(int n) throws SQLException {
        int n2;
        if (n == this.getTransactionIsolation()) {
            return;
        }
        switch (n) {
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 4;
                break;
            }
            default: {
                throw this.newSQLException("XJ045.S", new Integer(n));
            }
        }
        Object object2 = this.getConnectionSynchronization();
        synchronized (object2) {
            this.setupContextStack();
            try {
                this.getLanguageConnection().setIsolationLevel(n2);
            }
            catch (StandardException standardException) {
                throw this.handleException(standardException);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    public final int getTransactionIsolation() throws SQLException {
        return ExecutionContext.CS_TO_JDBC_ISOLATION_LEVEL_MAP[this.getLanguageConnection().getCurrentIsolationLevel()];
    }

    public final synchronized SQLWarning getWarnings() {
        return this.topWarning;
    }

    public final synchronized void clearWarnings() {
        this.topWarning = null;
    }

    public final Map getTypeMap() {
        return Collections.EMPTY_MAP;
    }

    public final void setTypeMap(Map map2) throws SQLException {
        if (map2 == null) {
            throw Util.generateCsSQLException("XJ081.S", map2, "map", "java.sql.Connection.setTypeMap");
        }
        if (!map2.isEmpty()) {
            throw Util.notImplemented();
        }
    }

    public final synchronized void addWarning(SQLWarning sQLWarning) {
        if (this.topWarning == null) {
            this.topWarning = sQLWarning;
            return;
        }
        this.topWarning.setNextWarning(sQLWarning);
    }

    public String getDBName() {
        return this.getTR().getDBName();
    }

    public final LanguageConnectionContext getLanguageConnection() {
        return this.getTR().getLcc();
    }

    public SQLException handleException(Throwable throwable) throws SQLException {
        return this.getTR().handleException(throwable, this.autoCommit, true);
    }

    final SQLException handleException(Throwable throwable, boolean bl) throws SQLException {
        return this.getTR().handleException(throwable, this.autoCommit, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setInactive() {
        if (!this.active) {
            return;
        }
        Object object2 = this.getConnectionSynchronization();
        synchronized (object2) {
            this.active = false;
            this.dbMetadata = null;
        }
    }

    protected void finalize() throws Throwable {
        if (this.rootConnection == this) {
            super.finalize();
            if (!this.isClosed()) {
                this.close(exceptionClose);
            }
        }
    }

    protected void needCommit() {
        if (!this.needCommit) {
            this.needCommit = true;
        }
    }

    protected void commitIfNeeded() throws SQLException {
        if (this.autoCommit && this.needCommit) {
            try {
                this.getTR().commit();
            }
            catch (Throwable throwable) {
                throw this.handleException(throwable);
            }
            this.needCommit = false;
        }
    }

    protected void commitIfAutoCommit() throws SQLException {
        if (this.autoCommit) {
            try {
                this.getTR().commit();
            }
            catch (Throwable throwable) {
                throw this.handleException(throwable);
            }
            this.needCommit = false;
        }
    }

    protected final Object getConnectionSynchronization() {
        return this.rootConnection;
    }

    protected final void setupContextStack() throws SQLException {
        if (this.isClosed()) {
            throw Util.noCurrentConnection();
        }
        this.getTR().setupContextStack();
    }

    protected final void restoreContextStack() throws SQLException {
        TransactionResourceImpl transactionResourceImpl = this.getTR();
        transactionResourceImpl.restoreContextStack();
    }

    private Database createDatabase(String string, Properties properties) throws SQLException {
        properties = this.filterProperties(properties);
        try {
            if (Monitor.createPersistentService("org.apache.derby.database.Database", string, properties) == null) {
                this.addWarning(EmbedSQLWarning.newEmbedSQLWarning("01J01", string));
            }
        }
        catch (StandardException standardException) {
            SQLException sQLException = this.newSQLException("XJ041.C", string);
            sQLException.setNextException(this.handleException(standardException));
            throw sQLException;
        }
        properties.clear();
        return (Database)Monitor.findService("org.apache.derby.database.Database", string);
    }

    private boolean bootDatabase(Properties properties) throws Throwable {
        String string = this.tr.getDBName();
        try {
            properties = this.filterProperties(properties);
            if (!Monitor.startPersistentService(string, properties)) {
                return false;
            }
            properties.clear();
            Database database = (Database)Monitor.findService("org.apache.derby.database.Database", string);
            this.tr.setDatabase(database);
        }
        catch (StandardException standardException) {
            SQLException sQLException = this.newSQLException("XJ040.C", string);
            Throwable throwable = standardException.getNestedException();
            SQLException sQLException2 = throwable instanceof StandardException ? Util.generateCsSQLException((StandardException)throwable) : (throwable != null ? Util.javaException(throwable) : Util.generateCsSQLException(standardException));
            sQLException.setNextException(sQLException2);
            throw sQLException;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PreparedStatement prepareMetaDataStatement(String string) throws SQLException {
        Object object2 = this.getConnectionSynchronization();
        synchronized (object2) {
            this.setupContextStack();
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = this.factory.newEmbedPreparedStatement(this, string, true, 1003, 1007, this.connectionHoldAbility, 2, null, null);
            }
            finally {
                this.restoreContextStack();
            }
            return preparedStatement;
        }
    }

    public final InternalDriver getLocalDriver() {
        return this.getTR().getDriver();
    }

    public final ContextManager getContextManager() {
        return this.getTR().getContextManager();
    }

    private Properties filterProperties(Properties properties) {
        Properties properties2 = new Properties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.startsWith("derby.")) continue;
            properties2.put(string, properties.getProperty(string));
        }
        return properties2;
    }

    protected Database getDatabase() {
        return this.getTR().getDatabase();
    }

    protected final TransactionResourceImpl getTR() {
        return this.rootConnection.tr;
    }

    private EmbedConnectionContext pushConnectionContext(ContextManager contextManager) {
        return new EmbedConnectionContext(contextManager, this);
    }

    public final void setApplicationConnection(Connection connection) {
        this.applicationConnection = connection;
    }

    public final Connection getApplicationConnection() {
        return this.applicationConnection;
    }

    public void setDrdaID(String string) {
        this.getLanguageConnection().setDrdaID(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetFromPool() throws SQLException {
        Object object2 = this.getConnectionSynchronization();
        synchronized (object2) {
            this.setupContextStack();
            try {
                this.getLanguageConnection().resetFromPool();
            }
            catch (StandardException standardException) {
                throw this.handleException(standardException);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int xa_prepare() throws SQLException {
        Object object2 = this.getConnectionSynchronization();
        synchronized (object2) {
            this.setupContextStack();
            try {
                XATransactionController xATransactionController = (XATransactionController)this.getLanguageConnection().getTransactionExecute();
                int n = xATransactionController.xa_prepare();
                if (n == 1) {
                    this.getLanguageConnection().internalCommit(false);
                }
                int n2 = n;
                return n2;
            }
            catch (StandardException standardException) {
                throw this.handleException(standardException);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void xa_commit(boolean bl) throws SQLException {
        Object object2 = this.getConnectionSynchronization();
        synchronized (object2) {
            this.setupContextStack();
            try {
                this.getLanguageConnection().xaCommit(bl);
            }
            catch (StandardException standardException) {
                throw this.handleException(standardException);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void xa_rollback() throws SQLException {
        Object object2 = this.getConnectionSynchronization();
        synchronized (object2) {
            this.setupContextStack();
            try {
                this.getLanguageConnection().xaRollback();
            }
            catch (StandardException standardException) {
                throw this.handleException(standardException);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    public final boolean transactionIsIdle() {
        return this.getTR().isIdle();
    }

    private int setResultSetType(int n) {
        if (n == 1005) {
            this.addWarning(EmbedSQLWarning.newEmbedSQLWarning("01J02"));
            n = 1004;
        }
        return n;
    }

    private int setResultSetConcurrency(int n, int n2) {
        if (n != 1003 && n2 == 1008) {
            this.addWarning(EmbedSQLWarning.newEmbedSQLWarning("01J03"));
            n2 = 1007;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrepareIsolation(int n) throws SQLException {
        if (n == this.getPrepareIsolation()) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw Util.generateCsSQLException("XJ045.S", new Integer(n));
            }
        }
        Object object2 = this.getConnectionSynchronization();
        synchronized (object2) {
            this.getLanguageConnection().setPrepareIsolationLevel(n);
        }
    }

    public int getPrepareIsolation() {
        return this.getLanguageConnection().getPrepareIsolationLevel();
    }

    final int getResultSetOrderId() {
        if (this == this.rootConnection) {
            return 0;
        }
        return this.rootConnection.resultSetId++;
    }

    protected SQLException newSQLException(String string) {
        return Util.generateCsSQLException(string);
    }

    protected SQLException newSQLException(String string, Object object2) {
        return Util.generateCsSQLException(string, object2);
    }

    protected SQLException newSQLException(String string, Object object2, Object object3) {
        return Util.generateCsSQLException(string, object2, object3);
    }

    public String toString() {
        if (this.idString == null) {
            this.idString = Integer.toString(this.getLanguageConnection().getInstanceNumber());
        }
        return this.idString;
    }
}

