/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.sql.SQLException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class DecryptionManager {
    private static final byte[] modulusBytes__ = new byte[]{-58, 33, 18, -41, 62, -26, 19, -16, -108, 122, -77, 31, 15, 104, 70, -95, -65, -11, -77, -92, -54, 13, 96, -68, 30, 76, 122, 13, -116, 22, -77, -29};
    private static final BigInteger modulus__ = new BigInteger(1, modulusBytes__);
    private static final byte[] baseBytes__ = new byte[]{70, -112, -6, 31, 123, -98, 29, 68, 66, -56, 108, -111, 20, 96, 63, -34, -49, 7, 30, -36, -20, 95, 98, 110, 33, -30, 86, -82, -39, -22, 52, -28};
    private static final BigInteger base__ = new BigInteger(1, baseBytes__);
    private static final int exponential_length__ = 255;
    private KeyPairGenerator keyPairGenerator_;
    private KeyPair keyPair_;
    private KeyAgreement keyAgreement_;
    private DHParameterSpec paramSpec_;

    public DecryptionManager() throws SQLException {
        try {
            if (Security.getProvider("IBMJCE") == null) {
                Security.addProvider((Provider)Class.forName("IBMJCE").newInstance());
            }
            this.paramSpec_ = new DHParameterSpec(modulus__, base__, 255);
            this.keyPairGenerator_ = KeyPairGenerator.getInstance("DH", "IBMJCE");
            this.keyPairGenerator_.initialize(this.paramSpec_);
            this.keyPair_ = this.keyPairGenerator_.generateKeyPair();
            this.keyAgreement_ = KeyAgreement.getInstance("DH", "IBMJCE");
            this.keyAgreement_.init(this.keyPair_.getPrivate());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException("java.lang.ClassNotFoundException is caught when initializing EncryptionManager '" + classNotFoundException.getMessage() + "'");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException("java.lang.IllegalAccessException is caught when initializing EncryptionManager '" + illegalAccessException.getMessage() + "'");
        }
        catch (InstantiationException instantiationException) {
            throw new SQLException("java.lang.InstantiationException is caught when initializing EncryptionManager '" + instantiationException.getMessage() + "'");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new SQLException("java.security.NoSuchProviderException is caught when initializing EncryptionManager '" + noSuchProviderException.getMessage() + "'");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SQLException("java.security.NoSuchAlgorithmException is caught when initializing EncryptionManager '" + noSuchAlgorithmException.getMessage() + "'");
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new SQLException("java.security.InvalidAlgorithmParameterException is caught when initializing EncryptionManager '" + invalidAlgorithmParameterException.getMessage() + "'");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SQLException("java.security.InvalidKeyException is caught when initializing EncryptionManager '" + invalidKeyException.getMessage() + "'");
        }
    }

    public byte[] obtainPublicKey() {
        byte[] byArray = this.keyPair_.getPublic().getEncoded();
        BigInteger bigInteger = ((DHPublicKey)this.keyPair_.getPublic()).getY();
        byte[] byArray2 = bigInteger.toByteArray();
        if (byArray2.length == 33 && byArray2[0] == 0) {
            byte[] byArray3 = new byte[32];
            for (int j = 0; j < byArray3.length; ++j) {
                byArray3[j] = byArray2[j + 1];
            }
            return byArray3;
        }
        if (byArray2.length < 32) {
            int n;
            byte[] byArray4 = new byte[32];
            for (n = 0; n < 32 - byArray2.length; ++n) {
                byArray4[n] = 0;
            }
            for (int j = n; j < byArray4.length; ++j) {
                byArray4[j] = byArray2[j - n];
            }
            return byArray4;
        }
        return byArray2;
    }

    private byte[] calculateDecryptionToken(int n, byte[] byArray) {
        byte[] byArray2;
        block7: {
            block6: {
                byArray2 = new byte[8];
                if (n != 7) break block6;
                if (byArray.length < 8) {
                    int n2;
                    for (n2 = 0; n2 < byArray.length; ++n2) {
                        byArray2[n2] = byArray[n2];
                    }
                    for (n2 = byArray.length; n2 < 8; ++n2) {
                        byArray2[n2] = 0;
                    }
                } else {
                    for (int j = 0; j < 8; ++j) {
                        byArray2[j] = byArray[j];
                    }
                }
                break block7;
            }
            if (n != 9) break block7;
            for (int j = 0; j < 8; ++j) {
                byArray2[j] = byArray[j + 12];
            }
        }
        return byArray2;
    }

    public byte[] decryptData(byte[] byArray, int n, byte[] byArray2, byte[] byArray3) throws SQLException {
        byte[] byArray4 = null;
        byte[] byArray5 = this.calculateDecryptionToken(n, byArray2);
        try {
            int n2;
            int n3;
            KeyFactory keyFactory = KeyFactory.getInstance("DH", "IBMJCE");
            BigInteger bigInteger = new BigInteger(1, byArray3);
            DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(bigInteger, modulus__, base__);
            PublicKey publicKey = keyFactory.generatePublic(dHPublicKeySpec);
            this.keyAgreement_.doPhase(publicKey, true);
            byte[] byArray6 = this.keyAgreement_.generateSecret();
            byte[] byArray7 = new byte[32];
            if (byArray6.length == 33 && byArray6[0] == 0) {
                for (n3 = 0; n3 < byArray7.length; ++n3) {
                    byArray7[n3] = byArray6[n3 + 1];
                }
            }
            if (byArray6.length < 32) {
                for (n3 = 0; n3 < 32 - byArray6.length; ++n3) {
                    byArray7[n3] = 0;
                }
                for (n2 = n3; n2 < byArray6.length; ++n2) {
                    byArray7[n2] = byArray6[n2 - n3];
                }
            }
            byte[] byArray8 = new byte[8];
            if (byArray6.length == 32) {
                for (n2 = 0; n2 < 8; ++n2) {
                    byArray8[n2] = byArray6[n2 + 12];
                }
            } else if (byArray6.length == 33 || byArray6.length < 32) {
                for (n2 = 0; n2 < 8; ++n2) {
                    byArray8[n2] = byArray7[n2 + 12];
                }
            } else {
                throw new SQLException("sharedSecret key length error " + byArray6.length);
            }
            for (int j = 0; j < 8; ++j) {
                n2 = byArray8[j];
                int n4 = 1;
                for (int k = 0; k < 8; ++k) {
                    if (n2 < 0) {
                        n4 = 1 - n4;
                    }
                    n2 = (byte)(n2 << 1);
                }
                if (n4 != true) continue;
                if ((byArray8[j] & 1) != 0) {
                    int n5 = j;
                    byArray8[n5] = (byte)(byArray8[n5] & 0xFE);
                    continue;
                }
                int n6 = j;
                byArray8[n6] = (byte)(byArray8[n6] | 1);
            }
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray8, "DES");
            Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding", "IBMJCE");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray5);
            cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
            byArray4 = cipher.doFinal(byArray);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new SQLException("java.security.NoSuchProviderException is caught when encrypting data '" + noSuchProviderException.getMessage() + "'");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SQLException("java.security.NoSuchAlgorithmException is caught when encrypting data '" + noSuchAlgorithmException.getMessage() + "'");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new SQLException("java.security.InvalidKeySpecException is caught when encrypting data");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SQLException("java.security.InvalidKeyException is caught when encrypting data '" + invalidKeyException.getMessage() + "'");
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new SQLException("javax.crypto.NoSuchPaddingException is caught when encrypting data '" + noSuchPaddingException.getMessage() + "'");
        }
        catch (BadPaddingException badPaddingException) {
            throw new SQLException("javax.crypto.BadPaddingException is caught when encrypting data '" + badPaddingException.getMessage() + "'");
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new SQLException("java.security.InvalidAlgorithmParameterException is caught when encrypting data '" + invalidAlgorithmParameterException.getMessage() + "'");
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new SQLException("javax.crypto.IllegalBlockSizeException is caught when encrypting data '" + illegalBlockSizeException.getMessage() + "'");
        }
        return byArray4;
    }
}

