/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.derby.impl.drda.DDMReader;
import org.apache.derby.impl.drda.DDMWriter;
import org.apache.derby.impl.drda.DRDAConnThread;
import org.apache.derby.impl.drda.DRDAProtocolException;
import org.apache.derby.impl.drda.DRDAXid;
import org.apache.derby.impl.drda.XADatabase;

public class DRDAXAProtocol {
    private DRDAConnThread connThread;
    private DDMReader reader;
    private DDMWriter writer;

    public DRDAXAProtocol(DRDAConnThread dRDAConnThread) {
        this.connThread = dRDAConnThread;
        this.reader = dRDAConnThread.getReader();
        this.writer = dRDAConnThread.getWriter();
    }

    protected void parseSYNCCTL() throws DRDAProtocolException {
        this.reader.markCollection();
        int n = this.reader.getCodePoint(4487);
        int n2 = this.parseSYNCTYPE();
        int n3 = 0;
        boolean bl = false;
        Xid xid = null;
        n = this.reader.getCodePoint();
        while (n != -1) {
            switch (n) {
                case 6145: {
                    xid = this.parseXID();
                    break;
                }
                case 6403: {
                    n3 = this.parseXAFlags();
                    bl = true;
                    break;
                }
                case 6407: {
                    this.reader.skipBytes();
                    break;
                }
                case 4511: {
                    this.connThread.codePointNotSupported(n);
                }
                default: {
                    this.connThread.invalidCodePoint(n);
                }
            }
            n = this.reader.getCodePoint();
        }
        this.connThread.trace("syncType = " + this.syncTypeToString(n2));
        this.connThread.trace("xid = " + xid);
        this.connThread.trace("xaflags =" + this.xaflagsToString(n3));
        if (n2 != 12) {
            if (xid == null) {
                this.connThread.missingCodePoint(6145);
            }
            if (n2 == 6 || !bl) {
                // empty if block
            }
        }
        switch (n2) {
            case 9: {
                this.startXATransaction(xid, n3);
                break;
            }
            case 11: {
                this.endXA(xid, n3);
                break;
            }
            case 1: {
                this.prepareXATransaction(xid);
                break;
            }
            case 2: {
                this.connThread.codePointNotSupported(n);
                break;
            }
            case 5: {
                this.commitTransaction(xid, n3);
                break;
            }
            case 3: {
                this.commitTransaction(xid, n3);
                break;
            }
            case 6: {
                this.forgetXATransaction(xid);
                break;
            }
            case 4: {
                this.rollbackTransaction(xid);
                break;
            }
            case 12: {
                if (bl) {
                    this.recoverXA(n3);
                    break;
                }
                this.recoverXA();
                break;
            }
            default: {
                this.connThread.invalidCodePoint(n);
            }
        }
    }

    protected int parseSYNCTYPE() throws DRDAProtocolException {
        return this.reader.readUnsignedByte();
    }

    private Xid parseXID() throws DRDAProtocolException {
        int n = this.reader.readNetworkInt();
        byte[] byArray = null;
        byte[] byArray2 = null;
        if (n != -1) {
            int n2 = this.reader.readNetworkInt();
            int n3 = this.reader.readNetworkInt();
            byArray = this.reader.readBytes(n2);
            byArray2 = this.reader.readBytes(n3);
        }
        return new DRDAXid(n, byArray, byArray2);
    }

    private int parseXIDSHR() throws DRDAProtocolException {
        return this.reader.readUnsignedByte();
    }

    private int parseXAFlags() throws DRDAProtocolException {
        return this.reader.readNetworkInt();
    }

    private void startXATransaction(Xid xid, int n) throws DRDAProtocolException {
        XAResource xAResource = this.getXAResource();
        int n2 = 0;
        try {
            if (xid.getFormatId() != -1) {
                xAResource.start(xid, n);
            }
        }
        catch (XAException xAException) {
            n2 = this.processXAException(xAException);
        }
        this.writeSYNCCRD(9, n2, null);
    }

    private void commitTransaction(Xid xid, int n) throws DRDAProtocolException {
        boolean bl;
        boolean bl2 = bl = xid.getFormatId() == -1;
        if (bl) {
            this.commitLocalTransaction();
        } else {
            this.commitXATransaction(xid, n);
        }
    }

    private void commitLocalTransaction() throws DRDAProtocolException {
        int n = 0;
        try {
            this.connThread.getDatabase().commit();
        }
        catch (Exception exception) {
            n = -7;
        }
        this.writeSYNCCRD(3, n, null);
    }

    private void commitXATransaction(Xid xid, int n) throws DRDAProtocolException {
        XAResource xAResource = this.getXAResource();
        int n2 = 0;
        boolean bl = (n & 0x40000000) != 0;
        try {
            xAResource.commit(xid, bl);
        }
        catch (XAException xAException) {
            n2 = this.processXAException(xAException);
        }
        this.writeSYNCCRD(3, n2, null);
    }

    private void rollbackTransaction(Xid xid) throws DRDAProtocolException {
        boolean bl;
        boolean bl2 = bl = xid.getFormatId() == -1;
        if (bl) {
            this.rollbackLocalTransaction();
        } else {
            this.rollbackXATransaction(xid);
        }
    }

    private void rollbackLocalTransaction() throws DRDAProtocolException {
        int n = 0;
        try {
            this.connThread.getDatabase().rollback();
        }
        catch (Exception exception) {
            n = -7;
        }
        this.writeSYNCCRD(3, n, null);
    }

    private void rollbackXATransaction(Xid xid) throws DRDAProtocolException {
        XAResource xAResource = this.getXAResource();
        int n = 0;
        try {
            xAResource.rollback(xid);
        }
        catch (XAException xAException) {
            n = this.processXAException(xAException);
        }
        this.writeSYNCCRD(4, n, null);
    }

    private void endXA(Xid xid, int n) throws DRDAProtocolException {
        XAResource xAResource = this.getXAResource();
        int n2 = 0;
        try {
            xAResource.end(xid, n);
        }
        catch (XAException xAException) {
            n2 = this.processXAException(xAException);
        }
        this.writeSYNCCRD(11, n2, null);
    }

    private void prepareXATransaction(Xid xid) throws DRDAProtocolException {
        XAResource xAResource = this.getXAResource();
        int n = 0;
        try {
            n = xAResource.prepare(xid);
        }
        catch (XAException xAException) {
            n = this.processXAException(xAException);
        }
        this.writeSYNCCRD(1, n, null);
    }

    private void forgetXATransaction(Xid xid) throws DRDAProtocolException {
        XAResource xAResource = this.getXAResource();
        int n = 0;
        try {
            xAResource.forget(xid);
        }
        catch (XAException xAException) {
            n = this.processXAException(xAException);
        }
        this.writeSYNCCRD(6, n, null);
    }

    private void recoverXA() throws DRDAProtocolException {
        this.recoverXA(0x1000000);
    }

    private void recoverXA(int n) throws DRDAProtocolException {
        XAResource xAResource = this.getXAResource();
        int n2 = 0;
        Xid[] xidArray = null;
        try {
            xidArray = xAResource.recover(n);
        }
        catch (XAException xAException) {
            n2 = this.processXAException(xAException);
        }
        this.writeSYNCCRD(12, n2, xidArray);
    }

    private void writeSYNCCRD(int n, int n2, Xid[] xidArray) throws DRDAProtocolException {
        this.writer.createDssReply();
        this.writer.startDdm(4680);
        this.writer.startDdm(6404);
        this.writer.writeInt(n2);
        this.writer.endDdm();
        if (xidArray != null) {
            this.writePRPHRCLST(xidArray);
        }
        this.writer.endDdmAndDss();
    }

    private void writePRPHRCLST(Xid[] xidArray) throws DRDAProtocolException {
        int n = xidArray == null ? 0 : xidArray.length;
        this.writer.startDdm(6405);
        this.writer.writeScalar2Bytes(6406, n);
        for (int j = 0; j < n; ++j) {
            this.writeXID(xidArray[j]);
        }
        this.writer.endDdm();
    }

    private void writeXID(Xid xid) throws DRDAProtocolException {
        this.writer.startDdm(6145);
        int n = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        this.writer.writeInt(n);
        this.writer.writeInt(byArray.length);
        this.writer.writeInt(byArray2.length);
        this.writer.writeBytes(byArray);
        this.writer.writeBytes(byArray2);
        this.writer.endDdm();
    }

    private XAResource getXAResource() {
        return ((XADatabase)this.connThread.getDatabase()).getXAResource();
    }

    private String syncTypeToString(int n) {
        switch (n) {
            case 9: {
                return "SYNCTYPE_NEW_UOW";
            }
            case 11: {
                return "SYNCTYPE_END_UOW";
            }
            case 1: {
                return "SYNCTYPE_PREPARE";
            }
            case 2: {
                return "SYNCTYPE_MIGRATE";
            }
            case 5: {
                return "SYNCTYPE_REQ_COMMIT";
            }
            case 3: {
                return "SYNCTYPE_COMMITTED";
            }
            case 6: {
                return "SYNCTYPE_FORGET";
            }
            case 4: {
                return "SYNCTYPE_ROLLBACK";
            }
            case 8: {
                return "SYNCTYPE_REQ_LOG";
            }
            case 10: {
                return "SYNCTYPE_MIGRATED";
            }
            case 12: {
                return "SYNCTYPE_INDOUBT";
            }
        }
        return "UNKNOWN SYNCTYPE";
    }

    private String xaflagsToString(int n) {
        switch (n) {
            case 0x800000: {
                return "XAResource.TMENDRSCAN";
            }
            case 0x20000000: {
                return "XAResource.TMFAIL";
            }
            case 0: {
                return "XAResource.TMNOFLAGS";
            }
            case 0x200000: {
                return "XAResource.TMJOIN";
            }
            case 0x40000000: {
                return "XAResource.TMONEPHASE";
            }
            case 0x8000000: {
                return "XAResource.TMRESUME";
            }
            case 0x1000000: {
                return "XAResource.TMSTARTRSCAN";
            }
            case 0x4000000: {
                return "XAResource.TMSUCCESS";
            }
            case 0x2000000: {
                return "XAResource.TMSUSPEND";
            }
        }
        return "UNRECOGNIZED flags:" + n;
    }

    private int processXAException(XAException xAException) {
        int n = xAException.errorCode;
        return n;
    }
}

