/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.derby.impl.drda.ConsistencyToken;
import org.apache.derby.impl.drda.FdocaConstants;
import org.apache.derby.impl.jdbc.EmbedResultSet;

class DRDAResultSet {
    protected static final int NOT_OPENED = 1;
    protected static final int SUSPENDED = 2;
    public static final int QRYCLSIMP_DEFAULT = 2;
    boolean explicitlyClosed = false;
    int state;
    protected boolean hasdata = true;
    protected int[] rsLens;
    private int[] rsDRDATypes;
    private int[] rsPrecision;
    private int[] rsScale;
    protected int[] outovr_drdaType;
    protected int withHoldCursor;
    protected int scrollType = 1003;
    protected int concurType;
    protected long rowCount;
    private ResultSet rs;
    protected int blksize;
    protected int maxblkext;
    protected int outovropt;
    private int qryclsimp;
    protected boolean qryrelscr;
    protected long qryrownbr;
    protected boolean qryrfrtbl;
    protected int qryscrorn;
    protected boolean qryrowsns;
    protected boolean qryblkrst;
    protected boolean qryrtndta;
    protected int qryrowset;
    private int qryprctyp;
    private boolean gotPrctyp;
    protected int rtnextdta;
    protected int nbrrow;
    protected byte[] rslsetflg;
    private ArrayList extDtaObjects;
    private ArrayList rsExtPositions;
    protected ConsistencyToken pkgcnstkn;
    private byte[] splitQRYDTA;

    protected DRDAResultSet(ResultSet resultSet) throws SQLException {
        this.setResultSet(resultSet);
        this.state = 1;
    }

    protected DRDAResultSet() {
        this.state = 1;
    }

    protected void setResultSet(ResultSet resultSet) throws SQLException {
        this.rs = resultSet;
        this.gotPrctyp = false;
        if (resultSet != null) {
            int n = this.rs.getMetaData().getColumnCount();
            this.rsDRDATypes = new int[n];
        }
        this.explicitlyClosed = false;
    }

    protected void setPkgcnstkn(ConsistencyToken consistencyToken) {
        this.pkgcnstkn = consistencyToken;
    }

    protected ResultSet getResultSet() {
        return this.rs;
    }

    public void setSplitQRYDTA(byte[] byArray) {
        this.splitQRYDTA = byArray;
    }

    public byte[] getSplitQRYDTA() {
        return this.splitQRYDTA;
    }

    protected void setRsDRDATypes(int[] nArray) {
        this.rsDRDATypes = nArray;
    }

    protected int[] getRsDRDATypes() {
        if (this.outovr_drdaType != null) {
            return this.outovr_drdaType;
        }
        return this.rsDRDATypes;
    }

    protected void setRsPrecision(int n, int n2) {
        if (this.rsPrecision == null) {
            this.rsPrecision = new int[this.rsDRDATypes.length];
        }
        this.rsPrecision[n - 1] = n2;
    }

    protected int getRsPrecision(int n) {
        if (this.rsPrecision == null) {
            return 0;
        }
        return this.rsPrecision[n - 1];
    }

    protected void setRsScale(int n, int n2) {
        if (this.rsScale == null) {
            this.rsScale = new int[this.rsDRDATypes.length];
        }
        this.rsScale[n - 1] = n2;
    }

    protected int getRsScale(int n) {
        if (this.rsScale == null) {
            return 0;
        }
        return this.rsScale[n - 1];
    }

    protected void setRsDRDAType(int n, int n2) {
        this.rsDRDATypes[n - 1] = n2;
    }

    protected int getRsDRDAType(int n) {
        return this.rsDRDATypes[n - 1];
    }

    protected void setRsLen(int n, int n2) {
        if (this.rsLens == null) {
            this.rsLens = new int[this.rsDRDATypes.length];
        }
        this.rsLens[n - 1] = n2;
    }

    protected int getRsLen(int n) {
        return this.rsLens[n - 1];
    }

    protected void addExtDtaObject(Object object2, int n) {
        if (this.extDtaObjects == null) {
            this.extDtaObjects = new ArrayList();
        }
        this.extDtaObjects.add(object2);
        if (this.rsExtPositions == null) {
            this.rsExtPositions = new ArrayList();
        }
        this.rsExtPositions.add(new Integer(n - 1));
    }

    protected void clearExtDtaObjects() {
        if (this.extDtaObjects != null) {
            this.extDtaObjects.clear();
        }
        if (this.rsExtPositions != null) {
            this.rsExtPositions.clear();
        }
    }

    protected boolean isExtDtaValueNullable(int n) {
        if (this.rsExtPositions == null || this.rsExtPositions.get(n) == null) {
            return false;
        }
        int n2 = (Integer)this.rsExtPositions.get(n);
        return FdocaConstants.isNullable(this.getRsDRDATypes()[n2]);
    }

    protected ArrayList getExtDtaObjects() {
        return this.extDtaObjects;
    }

    protected void setExtDtaObjects(ArrayList arrayList) {
        this.extDtaObjects = arrayList;
    }

    protected void close() throws SQLException {
        if (this.rs != null) {
            this.rs.close();
        }
        this.rs = null;
        this.outovr_drdaType = null;
        this.rsLens = null;
        this.rsDRDATypes = null;
        this.rsPrecision = null;
        this.rsScale = null;
        this.extDtaObjects = null;
        this.splitQRYDTA = null;
        this.rsExtPositions = null;
    }

    protected void reset() {
        this.explicitlyClosed = false;
        this.state = 1;
        this.hasdata = true;
        this.rsLens = null;
        this.rsDRDATypes = null;
        this.rsPrecision = null;
        this.rsScale = null;
        this.outovr_drdaType = null;
        this.withHoldCursor = 0;
        this.scrollType = 1003;
        this.concurType = 0;
        this.rowCount = 0L;
        this.rs = null;
        this.blksize = 0;
        this.maxblkext = 0;
        this.outovropt = 0;
        this.qryclsimp = 2;
        this.qryrelscr = false;
        this.qryrownbr = 0L;
        this.qryrfrtbl = false;
        this.qryscrorn = 0;
        this.qryrowsns = false;
        this.qryblkrst = false;
        this.qryrtndta = false;
        this.qryrowset = 0;
        this.qryprctyp = 0;
        this.gotPrctyp = false;
        this.rtnextdta = 0;
        this.nbrrow = 0;
        this.rslsetflg = null;
        this.extDtaObjects = null;
        this.rsExtPositions = null;
        this.pkgcnstkn = null;
        this.splitQRYDTA = null;
    }

    protected void CLSQRY() {
        this.explicitlyClosed = true;
    }

    protected boolean wasExplicitlyClosed() {
        return this.explicitlyClosed;
    }

    private boolean hasLobColumns() throws SQLException {
        ResultSetMetaData resultSetMetaData = this.rs.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        for (int j = 1; j <= n; ++j) {
            int n2 = resultSetMetaData.getColumnType(j);
            if (n2 != 2004 && n2 != 2005) continue;
            return true;
        }
        return false;
    }

    public String getResultSetCursorName() throws SQLException {
        if (this.rs != null) {
            return this.rs.getCursorName();
        }
        return null;
    }

    protected int getQryprctyp() throws SQLException {
        if (!this.gotPrctyp && this.qryprctyp == 9239) {
            this.gotPrctyp = true;
            if (this.rs == null || ((EmbedResultSet)this.rs).isForUpdate() || this.hasLobColumns()) {
                this.qryprctyp = 9240;
            }
        }
        return this.qryprctyp;
    }

    protected void setQryprctyp(int n) {
        this.qryprctyp = n;
    }

    protected boolean isClosed() {
        return this.state == 1;
    }

    protected void suspend() {
        this.state = 2;
    }

    protected String toDebugString(String string) {
        String string2 = string + "***** DRDASResultSet toDebugString ******\n";
        string2 = string2 + string + "State:" + this.getStateString(this.state) + "\n";
        string2 = string2 + string + "pkgcnstkn: {" + this.pkgcnstkn + "}\n";
        string2 = string2 + string + "cursor Name: ";
        String string3 = null;
        try {
            if (this.rs != null) {
                string3 = this.rs.getCursorName();
            }
        }
        catch (SQLException sQLException) {
            string3 = "invalid rs";
        }
        string2 = string2 + string + string3 + "\n";
        return string2;
    }

    private String getStateString(int n) {
        switch (n) {
            case 1: {
                return "NOT_OPENED";
            }
            case 2: {
                return "SUSPENDED";
            }
        }
        return "UNKNOWN_STATE";
    }

    boolean isRSCloseImplicit() throws SQLException {
        return this.qryclsimp == 1 && this.getQryprctyp() != 9239;
    }

    protected void setOPNQRYOptions(int n, int n2, int n3, int n4, int n5, int n6) {
        this.blksize = n;
        this.setQryprctyp(n2);
        this.maxblkext = n3;
        this.outovropt = n4;
        this.qryrowset = n5;
        this.qryclsimp = n6 == 0 ? 2 : n6;
    }
}

