/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.math.BigInteger;

final class ConsistencyToken {
    private final byte[] bytes;
    private int hash = 0;

    ConsistencyToken(byte[] byArray) {
        this.bytes = byArray;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public boolean equals(Object object2) {
        if (!(object2 instanceof ConsistencyToken)) {
            return false;
        }
        ConsistencyToken consistencyToken = (ConsistencyToken)object2;
        int n = this.bytes.length;
        if (n != consistencyToken.bytes.length) {
            return false;
        }
        for (int j = 0; j < n; ++j) {
            if (this.bytes[j] == consistencyToken.bytes[j]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int n = this.bytes.length;
            for (int j = 0; j < n; ++j) {
                this.hash ^= this.bytes[j];
            }
        }
        return this.hash;
    }

    public String toString() {
        return new BigInteger(this.bytes).toString();
    }
}

