/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.derby.impl.drda.DRDAConnThread;
import org.apache.derby.impl.drda.NetworkServerControlImpl;
import org.apache.derby.impl.drda.Session;

final class ClientThread
extends Thread {
    NetworkServerControlImpl parent;
    ServerSocket serverSocket;
    private int timeSlice;
    private int connNum;

    ClientThread(NetworkServerControlImpl networkServerControlImpl, ServerSocket serverSocket) {
        NetworkServerControlImpl.setUniqueThreadName(this, "NetworkServerThread");
        this.parent = networkServerControlImpl;
        this.serverSocket = serverSocket;
        this.timeSlice = networkServerControlImpl.getTimeSlice();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Socket socket = null;
        Session session = null;
        block7: while (true) {
            try {
                while (true) {
                    try {
                        socket = (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws IOException {
                                return ClientThread.this.serverSocket.accept();
                            }
                        });
                        socket.setKeepAlive(this.parent.getKeepAlive());
                        if (this.timeSlice != 0) {
                            socket.setSoTimeout(this.timeSlice);
                        }
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof IOException) {
                            Object object2 = this.parent.getShutdownSync();
                            synchronized (object2) {
                                if (!this.parent.getShutdown()) {
                                    this.parent.consolePropertyMessage("DRDA_UnableToAccept.S");
                                }
                                break block7;
                            }
                        }
                        throw exception;
                    }
                    this.connNum = this.parent.getNewConnNum();
                    this.parent.consolePropertyMessage("DRDA_ConnNumber.I", Integer.toString(this.connNum));
                    session = new Session(this.connNum, socket, this.parent.getTraceDirectory(), this.parent.getTraceAll());
                    this.parent.addToSessionTable(new Integer(this.connNum), session);
                    if (this.parent.getFreeThreads() == 0 && (this.parent.getMaxThreads() == 0 || this.parent.getThreadList().size() < this.parent.getMaxThreads())) {
                        DRDAConnThread dRDAConnThread = new DRDAConnThread(session, this.parent, this.timeSlice, this.parent.getLogConnections());
                        this.parent.getThreadList().addElement(dRDAConnThread);
                        dRDAConnThread.start();
                        continue;
                    }
                    this.parent.runQueueAdd(session);
                }
            }
            catch (Exception exception) {
                if (exception instanceof InterruptedException) {
                    return;
                }
                this.parent.consoleExceptionPrintTrace(exception);
                continue;
            }
            break;
        }
    }
}

