/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.db;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.Collator;
import java.text.DateFormat;
import java.text.RuleBasedCollator;
import java.util.Dictionary;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.AuthenticationService;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.JarReader;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyFactory;
import org.apache.derby.iapi.services.property.PropertySetCallback;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.LanguageFactory;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionFactory;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DataDictionaryContext;
import org.apache.derby.iapi.sql.dictionary.FileInfoDescriptor;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.FileResource;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.DoubleProperties;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.db.DatabaseContextImpl;
import org.apache.derby.impl.db.StoreClassFactoryContext;
import org.apache.derby.impl.sql.execute.JarDDL;
import org.apache.derby.io.StorageFile;

public class BasicDatabase
implements ModuleControl,
ModuleSupportable,
PropertySetCallback,
Database,
JarReader {
    private boolean active;
    private AuthenticationService authenticationService;
    protected AccessFactory af;
    protected PropertyFactory pf;
    protected ClassFactory cfDB;
    protected LanguageConnectionFactory lcf;
    protected LanguageFactory lf;
    protected Object resourceAdapter;
    private Locale databaseLocale;
    private RuleBasedCollator ruleBasedCollator;
    private int spaceInt;
    private boolean spaceIntSet;
    private DateFormat dateFormat;
    private DateFormat timeFormat;
    private DateFormat timestampFormat;
    private UUID myUUID;
    private boolean normalizeToUpper = true;
    protected boolean lastToBoot = true;
    protected Properties allParams;

    public boolean canSupport(Properties properties) {
        return Monitor.isDesiredCreateType(properties, 2);
    }

    public void boot(boolean bl, Properties properties) throws StandardException {
        ModuleFactory moduleFactory = Monitor.getMonitor();
        if (bl) {
            String string;
            if (properties.getProperty("derby.__rt.storage.createWithNoLog") == null) {
                properties.put("derby.__rt.storage.createWithNoLog", "true");
            }
            if ((string = properties.getProperty("territory")) == null) {
                string = Locale.getDefault().toString();
            }
            this.databaseLocale = moduleFactory.setLocale(properties, string);
        } else {
            this.databaseLocale = moduleFactory.getLocale(this);
        }
        this.setLocale(this.databaseLocale);
        this.normalizeToUpper = true;
        this.bootValidation(bl, properties);
        Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.types.DataValueFactory", properties);
        this.bootStore(bl, properties);
        this.myUUID = this.makeDatabaseID(bl, properties);
        this.allParams = new DoubleProperties(this.getAllDatabaseProperties(), properties);
        if (this.pf != null) {
            this.pf.addPropertySetNotification(this);
        }
        this.bootClassFactory(bl, this.allParams);
        this.lcf = (LanguageConnectionFactory)Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.sql.conn.LanguageConnectionFactory", this.allParams);
        this.lf = (LanguageFactory)Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.sql.LanguageFactory", this.allParams);
        this.bootResourceAdapter(bl, properties);
        this.authenticationService = this.bootAuthenticationService(bl, this.allParams);
        if (bl && this.lastToBoot && properties.getProperty("derby.__rt.storage.createWithNoLog") != null) {
            this.createFinished();
        }
        this.active = true;
        if (this.lastToBoot) {
            this.allParams = null;
        }
    }

    public void stop() {
        this.active = false;
    }

    public int getEngineType() {
        return 2;
    }

    public boolean isReadOnly() {
        return this.af.isReadOnly();
    }

    public LanguageConnectionContext setupConnection(ContextManager contextManager, String string, String string2, String string3) throws StandardException {
        TransactionController transactionController = this.getConnectionTransaction(contextManager);
        contextManager.setLocaleFinder(this);
        this.pushDbContext(contextManager);
        LanguageConnectionContext languageConnectionContext = this.lcf.newLanguageConnectionContext(contextManager, transactionController, this.lf, this, string, string2, string3);
        this.pushClassFactoryContext(contextManager, this.lcf.getClassFactory());
        ExecutionFactory executionFactory = this.lcf.getExecutionFactory();
        executionFactory.newExecutionContext(contextManager);
        languageConnectionContext.initialize(true);
        languageConnectionContext.internalCommitNoSync(5);
        return languageConnectionContext;
    }

    public void pushDbContext(ContextManager contextManager) {
        DatabaseContextImpl databaseContextImpl = new DatabaseContextImpl(contextManager, this);
    }

    public final AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public void freeze() throws SQLException {
        try {
            this.af.freeze();
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public void unfreeze() throws SQLException {
        try {
            this.af.unfreeze();
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public void backup(String string) throws SQLException {
        try {
            this.af.backup(string);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public void backup(File file) throws SQLException {
        try {
            this.af.backup(file);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public void backupAndEnableLogArchiveMode(String string, boolean bl) throws SQLException {
        try {
            this.af.backupAndEnableLogArchiveMode(string, bl);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public void backupAndEnableLogArchiveMode(File file, boolean bl) throws SQLException {
        try {
            this.af.backupAndEnableLogArchiveMode(file, bl);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public void disableLogArchiveMode(boolean bl) throws SQLException {
        try {
            this.af.disableLogArchiveMode(bl);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public void checkpoint() throws SQLException {
        try {
            this.af.checkpoint();
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public Locale getLocale() {
        return this.databaseLocale;
    }

    public final UUID getId() {
        return this.myUUID;
    }

    public Locale getCurrentLocale() throws StandardException {
        if (this.databaseLocale != null) {
            return this.databaseLocale;
        }
        throw BasicDatabase.noLocale();
    }

    public RuleBasedCollator getCollator() throws StandardException {
        RuleBasedCollator ruleBasedCollator = this.ruleBasedCollator;
        if (ruleBasedCollator == null) {
            if (this.databaseLocale != null) {
                ruleBasedCollator = this.ruleBasedCollator = (RuleBasedCollator)Collator.getInstance(this.databaseLocale);
            } else {
                throw BasicDatabase.noLocale();
            }
        }
        return ruleBasedCollator;
    }

    public DateFormat getDateFormat() throws StandardException {
        if (this.databaseLocale != null) {
            if (this.dateFormat == null) {
                this.dateFormat = DateFormat.getDateInstance(1, this.databaseLocale);
            }
            return this.dateFormat;
        }
        throw BasicDatabase.noLocale();
    }

    public DateFormat getTimeFormat() throws StandardException {
        if (this.databaseLocale != null) {
            if (this.timeFormat == null) {
                this.timeFormat = DateFormat.getTimeInstance(1, this.databaseLocale);
            }
            return this.timeFormat;
        }
        throw BasicDatabase.noLocale();
    }

    public DateFormat getTimestampFormat() throws StandardException {
        if (this.databaseLocale != null) {
            if (this.timestampFormat == null) {
                this.timestampFormat = DateFormat.getDateTimeInstance(1, 1, this.databaseLocale);
            }
            return this.timestampFormat;
        }
        throw BasicDatabase.noLocale();
    }

    private static StandardException noLocale() {
        return StandardException.newException("XCXE0.S");
    }

    public void setLocale(Locale locale) {
        this.databaseLocale = locale;
        this.dateFormat = null;
        this.timeFormat = null;
        this.timestampFormat = null;
    }

    public boolean isActive() {
        return this.active;
    }

    protected UUID makeDatabaseID(boolean bl, Properties properties) throws StandardException {
        TransactionController transactionController = this.af.getTransaction(ContextService.getFactory().getCurrentContextManager());
        String string = null;
        UUID uUID = (UUID)transactionController.getProperty("derby.databaseID");
        if (uUID == null) {
            UUIDFactory uUIDFactory = Monitor.getMonitor().getUUIDFactory();
            string = properties.getProperty("derby.databaseID");
            uUID = string == null ? uUIDFactory.createUUID() : uUIDFactory.recreateUUID(string);
            transactionController.setProperty("derby.databaseID", uUID, true);
        }
        if (string != null) {
            properties.remove("derby.databaseID");
        }
        transactionController.commit();
        transactionController.destroy();
        return uUID;
    }

    public void dropAllJDBCMetaDataSPSes() throws SQLException {
        try {
            LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
            DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
            TransactionController transactionController = languageConnectionContext.getTransactionExecute();
            dataDictionary.startWriting(languageConnectionContext);
            ListIterator listIterator = dataDictionary.getAllSPSDescriptors().listIterator();
            while (listIterator.hasNext()) {
                SPSDescriptor sPSDescriptor = (SPSDescriptor)listIterator.next();
                if (!sPSDescriptor.getSchemaDescriptor().isSystemSchema() || sPSDescriptor.getSchemaDescriptor().isSYSIBM()) continue;
                dataDictionary.dropSPSDescriptor(sPSDescriptor, transactionController);
                dataDictionary.dropDependentsStoredDependencies(sPSDescriptor.getUUID(), transactionController);
            }
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    public Object getResourceAdapter() {
        return this.resourceAdapter;
    }

    public void init(boolean bl, Dictionary dictionary) {
    }

    public boolean validate(String string, Serializable serializable, Dictionary dictionary) throws StandardException {
        if (string.equals("derby.engineType")) {
            throw StandardException.newException("XCY02.S", string, (Object)serializable);
        }
        if (!string.equals("derby.database.classpath")) {
            return false;
        }
        String string2 = (String)((Object)serializable);
        String[][] stringArray = null;
        if (string2 != null) {
            stringArray = IdUtil.parseDbClassPath(string2, this.normalizeToUpper);
        }
        DataDictionaryContext dataDictionaryContext = (DataDictionaryContext)ContextService.getContext("DataDictionaryContext");
        DataDictionary dataDictionary = dataDictionaryContext.getDataDictionary();
        if (stringArray != null) {
            for (int j = 0; j < stringArray.length; ++j) {
                SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(stringArray[j][0], null, false);
                FileInfoDescriptor fileInfoDescriptor = null;
                if (schemaDescriptor != null) {
                    fileInfoDescriptor = dataDictionary.getFileInfoDescriptor(schemaDescriptor, stringArray[j][1]);
                }
                if (fileInfoDescriptor != null) continue;
                throw StandardException.newException("42X96", IdUtil.mkQualifiedName(stringArray[j]));
            }
        }
        return true;
    }

    public Serviceable apply(String string, Serializable serializable, Dictionary dictionary) throws StandardException {
        if (!string.equals("derby.database.classpath")) {
            return null;
        }
        if (this.cfDB != null) {
            DataDictionaryContext dataDictionaryContext = (DataDictionaryContext)ContextService.getContext("DataDictionaryContext");
            DataDictionary dataDictionary = dataDictionaryContext.getDataDictionary();
            dataDictionary.invalidateAllSPSPlans();
            String string2 = (String)((Object)serializable);
            if (string2 == null) {
                string2 = "";
            }
            this.cfDB.notifyModifyClasspath(string2);
        }
        return null;
    }

    public Serializable map(String string, Serializable serializable, Dictionary dictionary) {
        return null;
    }

    protected void createFinished() throws StandardException {
        this.af.createFinished();
    }

    protected String getClasspath(Properties properties) {
        String string = PropertyUtil.getPropertyFromSet(properties, "derby.database.classpath");
        if (string == null) {
            string = PropertyUtil.getSystemProperty("derby.database.classpath", "");
        }
        return string;
    }

    protected void bootClassFactory(boolean bl, Properties properties) throws StandardException {
        String string = this.getClasspath(properties);
        boolean bl2 = true;
        String[][] stringArray = IdUtil.parseDbClassPath(string, bl2);
        properties.put("derby.__rt.database.classpath", string);
        this.cfDB = (ClassFactory)Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.services.loader.ClassFactory", properties);
    }

    protected TransactionController getConnectionTransaction(ContextManager contextManager) throws StandardException {
        return this.af.getTransaction(contextManager);
    }

    protected AuthenticationService bootAuthenticationService(boolean bl, Properties properties) throws StandardException {
        return (AuthenticationService)Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.jdbc.AuthenticationService", properties);
    }

    protected void bootValidation(boolean bl, Properties properties) throws StandardException {
        this.pf = (PropertyFactory)Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.services.property.PropertyFactory", properties);
    }

    protected void bootStore(boolean bl, Properties properties) throws StandardException {
        this.af = (AccessFactory)Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.store.access.AccessFactory", properties);
    }

    protected Properties getAllDatabaseProperties() throws StandardException {
        TransactionController transactionController = this.af.getTransaction(ContextService.getFactory().getCurrentContextManager());
        Properties properties = transactionController.getProperties();
        transactionController.commit();
        transactionController.destroy();
        return properties;
    }

    protected void bootResourceAdapter(boolean bl, Properties properties) {
        try {
            this.resourceAdapter = Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.jdbc.ResourceAdapter", this.allParams);
        }
        catch (StandardException standardException) {
            // empty catch block
        }
    }

    protected void pushClassFactoryContext(ContextManager contextManager, ClassFactory classFactory) {
        new StoreClassFactoryContext(contextManager, classFactory, this.af, this);
    }

    public Object readJarFile(String string, String string2) throws StandardException {
        String string3;
        SchemaDescriptor schemaDescriptor;
        DataDictionaryContext dataDictionaryContext = (DataDictionaryContext)ContextService.getContext("DataDictionaryContext");
        DataDictionary dataDictionary = dataDictionaryContext.getDataDictionary();
        FileInfoDescriptor fileInfoDescriptor = dataDictionary.getFileInfoDescriptor(schemaDescriptor = dataDictionary.getSchemaDescriptor(string, null, true), string2);
        if (fileInfoDescriptor == null) {
            throw StandardException.newException("X0X13.S", string2, (Object)string);
        }
        long l = fileInfoDescriptor.getGenerationId();
        FileResource fileResource = this.af.getTransaction(dataDictionaryContext.getContextManager()).getFileHandler();
        StorageFile storageFile = fileResource.getAsFile(string3 = JarDDL.mkExternalName(string, string2, fileResource.getSeparatorChar()), l);
        if (storageFile instanceof File) {
            return storageFile;
        }
        try {
            return fileResource.getAsStream(string3, l);
        }
        catch (IOException iOException) {
            throw StandardException.newException("X0X63.S", iOException.toString(), (Object)iOException);
        }
    }
}

