/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.util;

import java.util.Locale;

public class StringUtil {
    private static char[] hex_table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static final String formatForPrint(String string) {
        if (string.length() > 60) {
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, 60));
            stringBuffer.append("&");
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String[] toStringArray(Object[] objectArray) {
        int n = objectArray.length;
        String[] stringArray = new String[n];
        for (int j = 0; j < n; ++j) {
            stringArray[j] = objectArray[j].toString();
        }
        return stringArray;
    }

    public static byte[] getAsciiBytes(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int j = 0; j < cArray.length; ++j) {
            byArray[j] = (byte)(cArray[j] & 0x7F);
        }
        return byArray;
    }

    public static String trimTrailing(String string) {
        int n;
        if (string == null) {
            return null;
        }
        for (n = string.length(); n > 0 && Character.isWhitespace(string.charAt(n - 1)); --n) {
        }
        return string.substring(0, n);
    }

    public static String truncate(String string, int n) {
        if (string != null && string.length() > n) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static String toHexString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2 * 2);
        int n3 = n + n2;
        for (int j = n; j < n3; ++j) {
            int n4 = (byArray[j] & 0xF0) >>> 4;
            int n5 = byArray[j] & 0xF;
            stringBuffer.append(hex_table[n4]);
            stringBuffer.append(hex_table[n5]);
        }
        return stringBuffer.toString();
    }

    public static byte[] fromHexString(String string, int n, int n2) {
        if (n2 % 2 != 0) {
            return null;
        }
        byte[] byArray = new byte[n2 / 2];
        int n3 = 0;
        int n4 = n + n2;
        for (int j = n; j < n4; j += 2) {
            int n5 = Character.digit(string.charAt(j), 16);
            int n6 = Character.digit(string.charAt(j + 1), 16);
            if (n5 == -1 || n6 == -1) {
                return null;
            }
            byArray[n3++] = (byte)(n5 << 4 & 0xF0 | n6 & 0xF);
        }
        return byArray;
    }

    public static String hexDump(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 3);
        stringBuffer.append("Hex dump:\n");
        for (int j = 0; j < byArray.length; j += 16) {
            char c2;
            int n;
            String string = Integer.toHexString(j);
            for (n = string.length(); n < 8; ++n) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
            stringBuffer.append(":");
            for (n = 0; n < 16 && j + n < byArray.length; ++n) {
                byte by = byArray[j + n];
                if (n % 2 == 0) {
                    stringBuffer.append(" ");
                }
                c2 = (char)((by & 0xF0) >>> 4);
                byte by2 = (byte)(by & 0xF);
                stringBuffer.append(hex_table[c2]);
                stringBuffer.append(hex_table[by2]);
            }
            stringBuffer.append("  ");
            for (n = 0; n < 16 && j + n < byArray.length; ++n) {
                c2 = (char)byArray[j + n];
                if (Character.isLetterOrDigit(c2)) {
                    stringBuffer.append(String.valueOf(c2));
                    continue;
                }
                stringBuffer.append(".");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static String SQLToUpperCase(String string) {
        return string.toUpperCase(Locale.ENGLISH);
    }

    public static String SQLToLowerCase(String string) {
        return string.toLowerCase(Locale.ENGLISH);
    }

    public static boolean SQLEqualsIgnoreCase(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        return string.toUpperCase(Locale.ENGLISH).equals(string2.toUpperCase(Locale.ENGLISH));
    }
}

