/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.util;

import java.util.BitSet;

public final class JBitSet {
    private final BitSet bitSet;
    private int size;

    public JBitSet(int n) {
        this.bitSet = new BitSet(n);
        this.size = n;
    }

    private JBitSet(BitSet bitSet, int n) {
        this.bitSet = bitSet;
        this.size = n;
    }

    public void setTo(JBitSet jBitSet) {
        this.and(jBitSet);
        this.or(jBitSet);
    }

    public boolean contains(JBitSet jBitSet) {
        for (int j = 0; j < this.size; ++j) {
            if (!jBitSet.bitSet.get(j) || this.bitSet.get(j)) continue;
            return false;
        }
        return true;
    }

    public boolean hasSingleBitSet() {
        boolean bl = false;
        for (int j = 0; j < this.size; ++j) {
            if (!this.bitSet.get(j)) continue;
            if (bl) {
                return false;
            }
            bl = true;
        }
        return bl;
    }

    public int getFirstSetBit() {
        for (int j = 0; j < this.size; ++j) {
            if (!this.bitSet.get(j)) continue;
            return j;
        }
        return -1;
    }

    public void grow(int n) {
        this.size = n;
    }

    public void clearAll() {
        for (int j = 0; j < this.size; ++j) {
            if (!this.bitSet.get(j)) continue;
            this.bitSet.clear(j);
        }
    }

    public String toString() {
        return this.bitSet.toString();
    }

    public boolean equals(Object object2) {
        return this.bitSet.equals(((JBitSet)object2).bitSet);
    }

    public int hashCode() {
        return this.bitSet.hashCode();
    }

    public Object clone() {
        return new JBitSet((BitSet)this.bitSet.clone(), this.size);
    }

    public boolean get(int n) {
        return this.bitSet.get(n);
    }

    public void set(int n) {
        this.bitSet.set(n);
    }

    public void clear(int n) {
        this.bitSet.clear(n);
    }

    public void and(JBitSet jBitSet) {
        this.bitSet.and(jBitSet.bitSet);
    }

    public void or(JBitSet jBitSet) {
        this.bitSet.or(jBitSet.bitSet);
    }

    public void xor(JBitSet jBitSet) {
        this.bitSet.xor(jBitSet.bitSet);
    }

    public int size() {
        return this.size;
    }
}

