/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLBoolean;

public final class SQLTinyint
extends NumberDataType {
    static final int TINYINT_LENGTH = 1;
    private byte value;
    private boolean isnull;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(class$org$apache$derby$iapi$types$SQLTinyint == null ? (class$org$apache$derby$iapi$types$SQLTinyint = SQLTinyint.class$("org.apache.derby.iapi.types.SQLTinyint")) : class$org$apache$derby$iapi$types$SQLTinyint);
    static /* synthetic */ Class class$org$apache$derby$iapi$types$SQLTinyint;

    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }

    public SQLTinyint() {
        this.isnull = true;
    }

    public SQLTinyint(byte by) {
        this.value = by;
    }

    public SQLTinyint(byte by, boolean bl) {
        this.value = by;
        this.isnull = bl;
    }

    public int getInt() {
        return this.value;
    }

    public byte getByte() {
        return this.value;
    }

    public short getShort() {
        return this.value;
    }

    public long getLong() {
        return this.value;
    }

    public float getFloat() {
        return this.value;
    }

    public double getDouble() {
        return this.value;
    }

    public boolean getBoolean() {
        return this.value != 0;
    }

    public String getString() {
        return this.isNull() ? null : Byte.toString(this.value);
    }

    public int getLength() {
        return 1;
    }

    public Object getObject() {
        return this.isNull() ? null : new Integer(this.value);
    }

    public String getTypeName() {
        return "TINYINT";
    }

    public int getTypeFormatId() {
        return 199;
    }

    public boolean isNull() {
        return this.isnull;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(this.value);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.value = objectInput.readByte();
        this.isnull = false;
    }

    public void readExternalFromArray(ArrayInputStream arrayInputStream) throws IOException {
        this.value = arrayInputStream.readByte();
        this.isnull = false;
    }

    public void restoreToNull() {
        this.value = 0;
        this.isnull = true;
    }

    protected int typeCompare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        int n;
        int n2 = this.getInt();
        if (n2 == (n = dataValueDescriptor.getInt())) {
            return 0;
        }
        if (n2 > n) {
            return 1;
        }
        return -1;
    }

    public DataValueDescriptor getClone() {
        return new SQLTinyint(this.value, this.isnull);
    }

    public DataValueDescriptor getNewNull() {
        return new SQLTinyint();
    }

    public void setValueFromResultSet(ResultSet resultSet, int n, boolean bl) throws SQLException {
        this.value = resultSet.getByte(n);
        this.isnull = bl && resultSet.wasNull();
    }

    public final void setInto(PreparedStatement preparedStatement, int n) throws SQLException {
        if (this.isNull()) {
            preparedStatement.setNull(n, -6);
            return;
        }
        preparedStatement.setByte(n, this.value);
    }

    public final void setInto(ResultSet resultSet, int n) throws SQLException, StandardException {
        resultSet.updateByte(n, this.value);
    }

    public void setValue(String string) throws StandardException {
        if (string == null) {
            this.value = 0;
            this.isnull = true;
        } else {
            try {
                this.value = Byte.valueOf(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw this.invalidFormat();
            }
            this.isnull = false;
        }
    }

    public void setValue(byte by) {
        this.value = by;
        this.isnull = false;
    }

    public void setValue(short s2) throws StandardException {
        if (s2 > 127 || s2 < -128) {
            throw StandardException.newException("22003", "TINYINT");
        }
        this.value = (byte)s2;
        this.isnull = false;
    }

    public void setValue(int n) throws StandardException {
        if (n > 127 || n < -128) {
            throw StandardException.newException("22003", "TINYINT");
        }
        this.value = (byte)n;
        this.isnull = false;
    }

    public void setValue(long l) throws StandardException {
        if (l > 127L || l < -128L) {
            throw StandardException.newException("22003", "TINYINT");
        }
        this.value = (byte)l;
        this.isnull = false;
    }

    public void setValue(float f2) throws StandardException {
        if ((f2 = NumberDataType.normalizeREAL(f2)) > 127.0f || f2 < -128.0f) {
            throw StandardException.newException("22003", "TINYINT");
        }
        float f3 = (float)Math.floor(f2);
        this.value = (byte)f3;
        this.isnull = false;
    }

    public void setValue(double d2) throws StandardException {
        if ((d2 = NumberDataType.normalizeDOUBLE(d2)) > 127.0 || d2 < -128.0) {
            throw this.outOfRange();
        }
        double d3 = Math.floor(d2);
        this.value = (byte)d3;
        this.isnull = false;
    }

    public void setValue(boolean bl) {
        this.value = bl ? (byte)1 : 0;
        this.isnull = false;
    }

    public void setValue(Object object2) throws StandardException {
        if (object2 == null) {
            this.setToNull();
        } else if (object2 instanceof Number) {
            this.setValue(((Number)object2).byteValue());
        } else {
            this.genericSetObject(object2);
        }
    }

    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        this.setValue(dataValueDescriptor.getByte());
    }

    public int typePrecedence() {
        return 30;
    }

    public BooleanDataValue equals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getByte() == dataValueDescriptor2.getByte());
    }

    public BooleanDataValue notEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getByte() != dataValueDescriptor2.getByte());
    }

    public BooleanDataValue lessThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getByte() < dataValueDescriptor2.getByte());
    }

    public BooleanDataValue greaterThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getByte() > dataValueDescriptor2.getByte());
    }

    public BooleanDataValue lessOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getByte() <= dataValueDescriptor2.getByte());
    }

    public BooleanDataValue greaterOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getByte() >= dataValueDescriptor2.getByte());
    }

    public NumberDataValue times(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLTinyint();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        int n = numberDataValue.getByte() * numberDataValue2.getByte();
        numberDataValue3.setValue(n);
        return numberDataValue3;
    }

    public NumberDataValue mod(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLTinyint();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        byte by = numberDataValue2.getByte();
        if (by == 0) {
            throw StandardException.newException("22012");
        }
        numberDataValue3.setValue(numberDataValue.getByte() % by);
        return numberDataValue3;
    }

    public NumberDataValue minus(NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            numberDataValue = new SQLTinyint();
        }
        if (this.isNull()) {
            numberDataValue.setToNull();
            return numberDataValue;
        }
        byte by = this.getByte();
        numberDataValue.setValue((int)(-by));
        return numberDataValue;
    }

    protected boolean isNegative() {
        return !this.isNull() && this.value < 0;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return Byte.toString(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

