/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLBoolean;

public final class SQLSmallint
extends NumberDataType {
    static final int SMALLINT_LENGTH = 2;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(class$org$apache$derby$iapi$types$SQLSmallint == null ? (class$org$apache$derby$iapi$types$SQLSmallint = SQLSmallint.class$("org.apache.derby.iapi.types.SQLSmallint")) : class$org$apache$derby$iapi$types$SQLSmallint);
    private short value;
    private boolean isnull;
    static /* synthetic */ Class class$org$apache$derby$iapi$types$SQLSmallint;

    public int getInt() {
        return this.value;
    }

    public byte getByte() throws StandardException {
        if (this.value > 127 || this.value < -128) {
            throw StandardException.newException("22003", "TINYINT");
        }
        return (byte)this.value;
    }

    public short getShort() {
        return this.value;
    }

    public long getLong() {
        return this.value;
    }

    public float getFloat() {
        return this.value;
    }

    public double getDouble() {
        return this.value;
    }

    public boolean getBoolean() {
        return this.value != 0;
    }

    public String getString() {
        if (this.isNull()) {
            return null;
        }
        return Short.toString(this.value);
    }

    public int getLength() {
        return 2;
    }

    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return new Integer(this.value);
    }

    public String getTypeName() {
        return "SMALLINT";
    }

    public int getTypeFormatId() {
        return 83;
    }

    public boolean isNull() {
        return this.isnull;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeShort(this.value);
    }

    public void readExternalFromArray(ArrayInputStream arrayInputStream) throws IOException {
        this.value = arrayInputStream.readShort();
        this.isnull = false;
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.value = objectInput.readShort();
        this.isnull = false;
    }

    public void restoreToNull() {
        this.value = 0;
        this.isnull = true;
    }

    protected int typeCompare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        int n;
        int n2 = this.getInt();
        if (n2 == (n = dataValueDescriptor.getInt())) {
            return 0;
        }
        if (n2 > n) {
            return 1;
        }
        return -1;
    }

    public DataValueDescriptor getClone() {
        return new SQLSmallint(this.value, this.isnull);
    }

    public DataValueDescriptor getNewNull() {
        return new SQLSmallint();
    }

    public void setValueFromResultSet(ResultSet resultSet, int n, boolean bl) throws SQLException {
        try {
            this.value = resultSet.getShort(n);
            this.isnull = bl && resultSet.wasNull();
        }
        catch (SQLException sQLException) {
            int n2 = resultSet.getInt(n);
            this.value = (short)n2;
            this.isnull = false;
        }
    }

    public final void setInto(PreparedStatement preparedStatement, int n) throws SQLException {
        if (this.isNull()) {
            preparedStatement.setNull(n, 5);
            return;
        }
        preparedStatement.setShort(n, this.value);
    }

    public final void setInto(ResultSet resultSet, int n) throws SQLException, StandardException {
        resultSet.updateShort(n, this.value);
    }

    public SQLSmallint() {
        this.isnull = true;
    }

    public SQLSmallint(short s2) {
        this.value = s2;
    }

    public SQLSmallint(short s2, boolean bl) {
        this.value = s2;
        this.isnull = bl;
    }

    public void setValue(String string) throws StandardException {
        if (string == null) {
            this.value = 0;
            this.isnull = true;
        } else {
            try {
                this.value = Short.valueOf(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw this.invalidFormat();
            }
            this.isnull = false;
        }
    }

    public void setValue(short s2) {
        this.value = s2;
        this.isnull = false;
    }

    public void setValue(byte by) {
        this.value = by;
        this.isnull = false;
    }

    public void setValue(int n) throws StandardException {
        if (n > Short.MAX_VALUE || n < Short.MIN_VALUE) {
            throw StandardException.newException("22003", "SMALLINT");
        }
        this.value = (short)n;
        this.isnull = false;
    }

    public void setValue(long l) throws StandardException {
        if (l > 32767L || l < -32768L) {
            throw StandardException.newException("22003", "SMALLINT");
        }
        this.value = (short)l;
        this.isnull = false;
    }

    public void setValue(float f2) throws StandardException {
        if ((f2 = NumberDataType.normalizeREAL(f2)) > 32767.0f || f2 < -32768.0f) {
            throw StandardException.newException("22003", "SMALLINT");
        }
        float f3 = (float)Math.floor(f2);
        this.value = (short)f3;
        this.isnull = false;
    }

    public void setValue(double d2) throws StandardException {
        if ((d2 = NumberDataType.normalizeDOUBLE(d2)) > 32767.0 || d2 < -32768.0) {
            throw StandardException.newException("22003", "SMALLINT");
        }
        double d3 = Math.floor(d2);
        this.value = (short)d3;
        this.isnull = false;
    }

    public void setValue(boolean bl) {
        this.value = bl ? (short)1 : 0;
        this.isnull = false;
    }

    public void setValue(Object object2) throws StandardException {
        if (object2 == null) {
            this.setToNull();
        } else if (object2 instanceof Number) {
            this.setValue(((Number)object2).shortValue());
        } else {
            this.genericSetObject(object2);
        }
    }

    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        this.setValue(dataValueDescriptor.getShort());
    }

    public int typePrecedence() {
        return 40;
    }

    public BooleanDataValue equals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getShort() == dataValueDescriptor2.getShort());
    }

    public BooleanDataValue notEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getShort() != dataValueDescriptor2.getShort());
    }

    public BooleanDataValue lessThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getShort() < dataValueDescriptor2.getShort());
    }

    public BooleanDataValue greaterThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getShort() > dataValueDescriptor2.getShort());
    }

    public BooleanDataValue lessOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getShort() <= dataValueDescriptor2.getShort());
    }

    public BooleanDataValue greaterOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getShort() >= dataValueDescriptor2.getShort());
    }

    public NumberDataValue times(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLSmallint();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        int n = numberDataValue.getShort() * numberDataValue2.getShort();
        numberDataValue3.setValue(n);
        return numberDataValue3;
    }

    public NumberDataValue mod(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLSmallint();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        short s2 = numberDataValue2.getShort();
        if (s2 == 0) {
            throw StandardException.newException("22012");
        }
        numberDataValue3.setValue(numberDataValue.getShort() % s2);
        return numberDataValue3;
    }

    public NumberDataValue minus(NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            numberDataValue = new SQLSmallint();
        }
        if (this.isNull()) {
            numberDataValue.setToNull();
            return numberDataValue;
        }
        short s2 = this.getShort();
        numberDataValue.setValue((int)(-s2));
        return numberDataValue;
    }

    protected boolean isNegative() {
        return !this.isNull() && this.value < 0;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return Short.toString(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

