/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UTFDataFormatException;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.CollationElementIterator;
import java.text.CollationKey;
import java.text.DateFormat;
import java.text.RuleBasedCollator;
import java.util.Calendar;
import java.util.Locale;
import org.apache.derby.iapi.db.DatabaseContext;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.i18n.LocaleFinder;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.FormatIdInputStream;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.ConcatableDataValue;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.Like;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLDate;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLTime;
import org.apache.derby.iapi.types.SQLTimestamp;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.types.XML;
import org.apache.derby.iapi.types.XMLDataValue;
import org.apache.derby.iapi.util.StringUtil;

public class SQLChar
extends DataType
implements StringDataValue,
StreamStorable {
    protected static final int RETURN_SPACE_THRESHOLD = 4096;
    private static final int GROWBY_FOR_CHAR = 64;
    private static final char[] BLANKS = new char[40];
    char[][] arg_passer = new char[1][];
    private String value;
    private char[] rawData;
    private int rawLength = -1;
    private CollationKey cKey;
    protected InputStream stream;
    private int[] intArray;
    private int intLength;
    private LocaleFinder localeFinder;
    private static final int BASE_MEMORY_USAGE;
    static /* synthetic */ Class class$org$apache$derby$iapi$types$SQLChar;

    public static void appendBlanks(char[] cArray, int n, int n2) {
        while (n2 > 0) {
            int n3 = n2 > BLANKS.length ? BLANKS.length : n2;
            System.arraycopy(BLANKS, 0, cArray, n, n3);
            n2 -= n3;
            n += n3;
        }
    }

    public boolean getBoolean() throws StandardException {
        if (this.isNull()) {
            return false;
        }
        String string = this.getString().trim();
        return !string.equals("0") && !string.equals("false");
    }

    public byte getByte() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            return Byte.parseByte(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("22018", "byte");
        }
    }

    public short getShort() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            return Short.parseShort(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("22018", "short");
        }
    }

    public int getInt() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            return Integer.parseInt(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("22018", "int");
        }
    }

    public long getLong() throws StandardException {
        if (this.isNull()) {
            return 0L;
        }
        try {
            return Long.parseLong(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("22018", "long");
        }
    }

    public float getFloat() throws StandardException {
        if (this.isNull()) {
            return 0.0f;
        }
        try {
            return new Float(this.getString().trim()).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("22018", "float");
        }
    }

    public double getDouble() throws StandardException {
        if (this.isNull()) {
            return 0.0;
        }
        try {
            return new Double(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("22018", "double");
        }
    }

    public int typeToBigDecimal() throws StandardException {
        return 1;
    }

    public Date getDate(Calendar calendar) throws StandardException {
        return SQLChar.getDate(calendar, this.getString(), this.getLocaleFinder());
    }

    public static Date getDate(Calendar calendar, String string, LocaleFinder localeFinder) throws StandardException {
        if (string == null) {
            return null;
        }
        SQLDate sQLDate = new SQLDate(string, false, localeFinder);
        return sQLDate.getDate(calendar);
    }

    public Time getTime(Calendar calendar) throws StandardException {
        return SQLChar.getTime(calendar, this.getString(), this.getLocaleFinder());
    }

    public static Time getTime(Calendar calendar, String string, LocaleFinder localeFinder) throws StandardException {
        if (string == null) {
            return null;
        }
        SQLTime sQLTime = new SQLTime(string, false, localeFinder, calendar);
        return sQLTime.getTime(calendar);
    }

    public Timestamp getTimestamp(Calendar calendar) throws StandardException {
        return SQLChar.getTimestamp(calendar, this.getString(), this.getLocaleFinder());
    }

    public static Timestamp getTimestamp(Calendar calendar, String string, LocaleFinder localeFinder) throws StandardException {
        if (string == null) {
            return null;
        }
        SQLTimestamp sQLTimestamp = new SQLTimestamp(string, false, localeFinder, calendar);
        return sQLTimestamp.getTimestamp(calendar);
    }

    public Object getObject() throws StandardException {
        return this.getString();
    }

    public InputStream getStream() throws StandardException {
        return this.stream;
    }

    public int getLength() throws StandardException {
        if (this.rawLength != -1) {
            return this.rawLength;
        }
        String string = this.getString();
        return string == null ? 0 : string.length();
    }

    public String getTypeName() {
        return "CHAR";
    }

    public String getString() throws StandardException {
        if (this.value == null) {
            int n = this.rawLength;
            if (n != -1) {
                this.value = new String(this.rawData, 0, n);
                if (n > 4096) {
                    this.rawData = null;
                    this.rawLength = -1;
                    this.intArray = null;
                    this.intLength = 0;
                    this.cKey = null;
                }
            } else if (this.stream != null) {
                try {
                    if (this.stream instanceof FormatIdInputStream) {
                        this.readExternal((FormatIdInputStream)this.stream);
                    } else {
                        this.readExternal(new FormatIdInputStream(this.stream));
                    }
                    this.stream = null;
                    return this.getString();
                }
                catch (IOException iOException) {
                    throw StandardException.newException("XCL30.S", iOException, (Object)"java.sql.String");
                }
            }
        }
        return this.value;
    }

    public char[] getCharArray() throws StandardException {
        if (this.isNull()) {
            return null;
        }
        if (this.rawLength != -1) {
            return this.rawData;
        }
        this.getString();
        this.rawData = this.value.toCharArray();
        this.rawLength = this.rawData.length;
        this.intArray = null;
        this.intLength = 0;
        this.cKey = null;
        return this.rawData;
    }

    public InputStream returnStream() {
        return this.stream;
    }

    public void setStream(InputStream inputStream) {
        this.value = null;
        this.rawLength = -1;
        this.stream = inputStream;
        this.intArray = null;
        this.intLength = 0;
        this.cKey = null;
    }

    public void loadStream() throws StandardException {
        this.getString();
    }

    public int getTypeFormatId() {
        return 78;
    }

    public boolean isNull() {
        return this.value == null && this.rawLength == -1 && this.stream == null;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n;
        int n2;
        boolean bl;
        String string = null;
        char[] cArray = null;
        int n3 = this.rawLength;
        if (n3 < 0) {
            string = this.value;
            n3 = string.length();
            bl = false;
        } else {
            cArray = this.rawData;
            bl = true;
        }
        int n4 = n3;
        for (n2 = 0; n2 < n3 && n4 <= 65535; ++n2) {
            int n5 = n = bl ? cArray[n2] : string.charAt(n2);
            if (n >= 1 && n <= 127) continue;
            if (n > 2047) {
                n4 += 2;
                continue;
            }
            ++n4;
        }
        n2 = 0;
        if (n4 > 65535) {
            n2 = 1;
            n4 = 0;
        }
        objectOutput.write(n4 >>> 8 & 0xFF);
        objectOutput.write(n4 >>> 0 & 0xFF);
        for (n = 0; n < n3; ++n) {
            char c2;
            char c3 = c2 = bl ? cArray[n] : string.charAt(n);
            if (c2 >= '\u0001' && c2 <= '\u007f') {
                objectOutput.write(c2);
                continue;
            }
            if (c2 > '\u07ff') {
                objectOutput.write(0xE0 | c2 >> 12 & 0xF);
                objectOutput.write(0x80 | c2 >> 6 & 0x3F);
                objectOutput.write(0x80 | c2 >> 0 & 0x3F);
                continue;
            }
            objectOutput.write(0xC0 | c2 >> 6 & 0x1F);
            objectOutput.write(0x80 | c2 >> 0 & 0x3F);
        }
        if (n2 != 0) {
            objectOutput.write(224);
            objectOutput.write(0);
            objectOutput.write(0);
        }
    }

    public void readExternalFromArray(ArrayInputStream arrayInputStream) throws IOException {
        this.arg_passer[0] = this.rawData;
        this.rawLength = arrayInputStream.readCloudscapeUTF(this.arg_passer);
        this.rawData = this.arg_passer[0];
        this.value = null;
        this.stream = null;
        this.intArray = null;
        this.intLength = 0;
        this.cKey = null;
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        int n;
        int n2 = objectInput.readUnsignedShort();
        int n3 = this.growBy();
        if (n2 != 0) {
            n = n2;
        } else {
            n = objectInput.available();
            if (n < n3) {
                n = n3;
            }
        }
        char[] cArray = this.rawData == null || n > this.rawData.length ? new char[n] : this.rawData;
        int n4 = cArray.length;
        this.rawData = null;
        this.restoreToNull();
        int n5 = 0;
        int n6 = 0;
        while (n5 < n2 || n2 == 0) {
            char c2;
            int n7;
            int n8;
            int n9;
            try {
                n9 = objectInput.readUnsignedByte();
            }
            catch (EOFException eOFException) {
                if (n2 == 0) break;
                throw new EOFException();
            }
            if (n6 >= n4) {
                n8 = objectInput.available();
                if (n8 < n3) {
                    n8 = n3;
                }
                n7 = n4 + n8;
                char[] cArray2 = cArray;
                cArray = new char[n7];
                System.arraycopy(cArray2, 0, cArray, 0, n4);
                n4 = n7;
            }
            if ((n9 & 0x80) == 0) {
                ++n5;
                c2 = (char)n9;
            } else if ((n9 & 0x60) == 64) {
                if (n2 != 0 && (n5 += 2) > n2) {
                    throw new UTFDataFormatException();
                }
                n8 = objectInput.readUnsignedByte();
                if ((n8 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                c2 = (char)((n9 & 0x1F) << 6 | n8 & 0x3F);
            } else if ((n9 & 0x70) == 96) {
                if (n2 != 0 && (n5 += 3) > n2) {
                    throw new UTFDataFormatException();
                }
                n8 = objectInput.readUnsignedByte();
                n7 = objectInput.readUnsignedByte();
                if (n9 == 224 && n8 == 0 && n7 == 0 && n2 == 0) break;
                if ((n8 & 0xC0) != 128 || (n7 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                c2 = (char)((n9 & 0xF) << 12 | (n8 & 0x3F) << 6 | (n7 & 0x3F) << 0);
            } else {
                throw new UTFDataFormatException();
            }
            cArray[n6++] = c2;
        }
        this.rawData = cArray;
        this.rawLength = n6;
        this.intArray = null;
        this.intLength = 0;
        this.cKey = null;
    }

    protected int growBy() {
        return 64;
    }

    public void restoreToNull() {
        this.value = null;
        this.stream = null;
        this.rawLength = -1;
        this.intArray = null;
        this.intLength = 0;
        this.cKey = null;
    }

    public boolean compare(int n, DataValueDescriptor dataValueDescriptor, boolean bl, boolean bl2) throws StandardException {
        if (!bl && (this.isNull() || dataValueDescriptor.isNull())) {
            return bl2;
        }
        if (!(dataValueDescriptor instanceof SQLChar)) {
            return dataValueDescriptor.compare(SQLChar.flip(n), this, bl, bl2);
        }
        return super.compare(n, dataValueDescriptor, bl, bl2);
    }

    public int compare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (this.typePrecedence() < dataValueDescriptor.typePrecedence()) {
            return -dataValueDescriptor.compare(this);
        }
        return this.stringCompare(this, (SQLChar)dataValueDescriptor);
    }

    public Object cloneObject() {
        if (this.stream == null) {
            return this.getClone();
        }
        SQLChar sQLChar = (SQLChar)this.getNewNull();
        sQLChar.copyState(this);
        return sQLChar;
    }

    public DataValueDescriptor getClone() {
        try {
            return new SQLChar(this.getString());
        }
        catch (StandardException standardException) {
            return null;
        }
    }

    public DataValueDescriptor getNewNull() {
        return new SQLChar();
    }

    public final void setValueFromResultSet(ResultSet resultSet, int n, boolean bl) throws SQLException {
        this.setValue(resultSet.getString(n));
    }

    public final void setInto(PreparedStatement preparedStatement, int n) throws SQLException, StandardException {
        preparedStatement.setString(n, this.getString());
    }

    public SQLChar() {
    }

    public SQLChar(String string) {
        this.value = string;
    }

    public void setValue(String string) {
        this.stream = null;
        this.rawLength = -1;
        this.intArray = null;
        this.intLength = 0;
        this.cKey = null;
        this.value = string;
    }

    public void setValue(boolean bl) throws StandardException {
        this.setValue(bl ? "1" : "0");
    }

    public void setValue(int n) throws StandardException {
        this.setValue(Integer.toString(n));
    }

    public void setValue(double d2) throws StandardException {
        this.setValue(Double.toString(d2));
    }

    public void setValue(float f2) throws StandardException {
        this.setValue(Float.toString(f2));
    }

    public void setValue(short s2) throws StandardException {
        this.setValue(Short.toString(s2));
    }

    public void setValue(long l) throws StandardException {
        this.setValue(Long.toString(l));
    }

    public void setValue(byte by) throws StandardException {
        this.setValue(Byte.toString(by));
    }

    public void setValue(byte[] byArray) throws StandardException {
        if (byArray == null) {
            this.restoreToNull();
            return;
        }
        int n = byArray.length % 2;
        int n2 = byArray.length / 2 + n;
        char[] cArray = new char[n2];
        int n3 = 0;
        int n4 = 0;
        if (n == 1) {
            cArray[--n2] = (char)(byArray[byArray.length - 1] << 8);
        }
        while (n3 < n2) {
            cArray[n3] = (char)(byArray[n4] << 8 | byArray[n4 + 1] & 0xFF);
            n4 += 2;
            ++n3;
        }
        this.setValue(new String(cArray));
    }

    public void setBigDecimal(Number number) throws StandardException {
        this.setValue(number);
    }

    public void setValue(Date date, Calendar calendar) throws StandardException {
        String string = null;
        if (date != null) {
            if (calendar == null) {
                string = date.toString();
            } else {
                calendar.setTime(date);
                StringBuffer stringBuffer = new StringBuffer();
                this.formatJDBCDate(calendar, stringBuffer);
                string = stringBuffer.toString();
            }
        }
        this.setValue(string);
    }

    public void setValue(Time time, Calendar calendar) throws StandardException {
        String string = null;
        if (time != null) {
            if (calendar == null) {
                string = time.toString();
            } else {
                calendar.setTime(time);
                StringBuffer stringBuffer = new StringBuffer();
                this.formatJDBCTime(calendar, stringBuffer);
                string = stringBuffer.toString();
            }
        }
        this.setValue(string);
    }

    public void setValue(Timestamp timestamp, Calendar calendar) throws StandardException {
        String string = null;
        if (timestamp != null) {
            if (calendar == null) {
                string = timestamp.toString();
            } else {
                calendar.setTime(timestamp);
                StringBuffer stringBuffer = new StringBuffer();
                this.formatJDBCDate(calendar, stringBuffer);
                stringBuffer.append(' ');
                this.formatJDBCTime(calendar, stringBuffer);
                int n = (timestamp.getNanos() + 500) / 1000;
                if (n > 0) {
                    stringBuffer.append('.');
                    String string2 = Integer.toString(n);
                    if (string2.length() > 6) {
                        stringBuffer.append(string2.substring(0, 6));
                    } else {
                        for (int j = string2.length(); j < 6; ++j) {
                            stringBuffer.append('0');
                        }
                        stringBuffer.append(string2);
                    }
                }
                string = stringBuffer.toString();
            }
        }
        this.setValue(string);
    }

    private void formatJDBCDate(Calendar calendar, StringBuffer stringBuffer) {
        SQLDate.dateToString(calendar.get(1), calendar.get(2) - 0 + 1, calendar.get(5), stringBuffer);
    }

    private void formatJDBCTime(Calendar calendar, StringBuffer stringBuffer) {
        SQLTime.timeToString(calendar.get(10), calendar.get(12), calendar.get(13), stringBuffer);
    }

    public void setValue(InputStream inputStream, int n) {
        this.value = null;
        this.rawLength = -1;
        this.stream = inputStream;
        this.intArray = null;
        this.intLength = 0;
        this.cKey = null;
    }

    public void setValue(Object object2) throws StandardException {
        if (object2 instanceof String || object2 == null) {
            this.setValue((String)object2);
        } else {
            this.setValue(object2.toString());
        }
    }

    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        this.setValue(dataValueDescriptor.getString());
    }

    private void setAsToNationalString(Object object2) {
        String string = null;
        if (object2 != null) {
            string = object2.toString();
        }
        this.setValue(string);
    }

    public void normalize(DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor) throws StandardException {
        this.normalize(dataTypeDescriptor, dataValueDescriptor.getString());
    }

    protected void normalize(DataTypeDescriptor dataTypeDescriptor, String string) throws StandardException {
        int n = dataTypeDescriptor.getMaximumWidth();
        int n2 = string.length();
        if (n2 == n) {
            this.setValue(string);
            return;
        }
        if (n2 < n) {
            char[] cArray;
            this.setToNull();
            if (this.rawData == null || n > this.rawData.length) {
                this.rawData = new char[n];
                cArray = this.rawData;
            } else {
                cArray = this.rawData;
            }
            string.getChars(0, n2, cArray, 0);
            SQLChar.appendBlanks(cArray, n2, n - n2);
            this.rawLength = n;
            return;
        }
        this.hasNonBlankChars(string, n, n2);
        String string2 = string.substring(0, n);
        this.setValue(string2);
    }

    protected final void hasNonBlankChars(String string, int n, int n2) throws StandardException {
        for (int j = n; j < n2; ++j) {
            if (string.charAt(j) == ' ') continue;
            throw StandardException.newException("22001", this.getTypeName(), (Object)StringUtil.formatForPrint(string), (Object)String.valueOf(n));
        }
    }

    public DataValueDescriptor setWidth(int n, int n2, boolean bl) throws StandardException {
        if (this.getString() == null) {
            return this;
        }
        int n3 = this.getLength();
        if (n3 < n) {
            if (!(this instanceof SQLVarchar)) {
                StringBuffer stringBuffer = new StringBuffer(this.getString());
                while (n3 < n) {
                    stringBuffer.append(' ');
                    ++n3;
                }
                this.setValue(new String(stringBuffer));
            }
        } else if (n3 > n && n > 0) {
            if (bl) {
                this.hasNonBlankChars(this.getString(), n, n3);
            }
            this.setValue(this.getString().substring(0, n));
        }
        return this;
    }

    public BooleanDataValue equals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = dataValueDescriptor instanceof SQLChar && dataValueDescriptor2 instanceof SQLChar ? this.stringCompare((SQLChar)dataValueDescriptor, (SQLChar)dataValueDescriptor2) == 0 : SQLChar.stringCompare(dataValueDescriptor.getString(), dataValueDescriptor2.getString()) == 0;
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, bl);
    }

    public BooleanDataValue notEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = dataValueDescriptor instanceof SQLChar && dataValueDescriptor2 instanceof SQLChar ? this.stringCompare((SQLChar)dataValueDescriptor, (SQLChar)dataValueDescriptor2) != 0 : SQLChar.stringCompare(dataValueDescriptor.getString(), dataValueDescriptor2.getString()) != 0;
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, bl);
    }

    public BooleanDataValue lessThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = dataValueDescriptor instanceof SQLChar && dataValueDescriptor2 instanceof SQLChar ? this.stringCompare((SQLChar)dataValueDescriptor, (SQLChar)dataValueDescriptor2) < 0 : SQLChar.stringCompare(dataValueDescriptor.getString(), dataValueDescriptor2.getString()) < 0;
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, bl);
    }

    public BooleanDataValue greaterThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = dataValueDescriptor instanceof SQLChar && dataValueDescriptor2 instanceof SQLChar ? this.stringCompare((SQLChar)dataValueDescriptor, (SQLChar)dataValueDescriptor2) > 0 : SQLChar.stringCompare(dataValueDescriptor.getString(), dataValueDescriptor2.getString()) > 0;
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, bl);
    }

    public BooleanDataValue lessOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = dataValueDescriptor instanceof SQLChar && dataValueDescriptor2 instanceof SQLChar ? this.stringCompare((SQLChar)dataValueDescriptor, (SQLChar)dataValueDescriptor2) <= 0 : SQLChar.stringCompare(dataValueDescriptor.getString(), dataValueDescriptor2.getString()) <= 0;
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, bl);
    }

    public BooleanDataValue greaterOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = dataValueDescriptor instanceof SQLChar && dataValueDescriptor2 instanceof SQLChar ? this.stringCompare((SQLChar)dataValueDescriptor, (SQLChar)dataValueDescriptor2) >= 0 : SQLChar.stringCompare(dataValueDescriptor.getString(), dataValueDescriptor2.getString()) >= 0;
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, bl);
    }

    public NumberDataValue charLength(NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            numberDataValue = new SQLInteger();
        }
        if (this.isNull()) {
            numberDataValue.setToNull();
            return numberDataValue;
        }
        numberDataValue.setValue(this.getLength());
        return numberDataValue;
    }

    public StringDataValue concatenate(StringDataValue stringDataValue, StringDataValue stringDataValue2, StringDataValue stringDataValue3) throws StandardException {
        if (stringDataValue.isNull() || stringDataValue.getString() == null || stringDataValue2.isNull() || stringDataValue2.getString() == null) {
            stringDataValue3.setToNull();
            return stringDataValue3;
        }
        stringDataValue3.setValue(stringDataValue.getString().concat(stringDataValue2.getString()));
        return stringDataValue3;
    }

    public BooleanDataValue like(DataValueDescriptor dataValueDescriptor) throws StandardException {
        Boolean bl;
        if (!this.isNationalString()) {
            char[] cArray = this.getCharArray();
            char[] cArray2 = ((SQLChar)dataValueDescriptor).getCharArray();
            bl = Like.like(cArray, this.getLength(), cArray2, dataValueDescriptor.getLength());
        } else {
            SQLChar sQLChar = (SQLChar)dataValueDescriptor;
            bl = Like.like(this.getIntArray(), this.getIntLength(), sQLChar.getIntArray(), sQLChar.getIntLength(), this.getLocaleFinder().getCollator());
        }
        return SQLBoolean.truthValue((DataValueDescriptor)this, dataValueDescriptor, bl);
    }

    public BooleanDataValue like(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        Boolean bl;
        if (dataValueDescriptor2.isNull()) {
            throw StandardException.newException("22501");
        }
        if (!this.isNationalString()) {
            char[] cArray = this.getCharArray();
            char[] cArray2 = ((SQLChar)dataValueDescriptor).getCharArray();
            char[] cArray3 = ((SQLChar)dataValueDescriptor2).getCharArray();
            int n = dataValueDescriptor2.getLength();
            if (cArray3 != null && n != 1) {
                throw StandardException.newException("22019", new String(cArray3));
            }
            SQLChar sQLChar = (SQLChar)dataValueDescriptor2;
            int[] nArray = sQLChar.getIntArray();
            if (nArray != null && nArray.length != 1) {
                throw StandardException.newException("22019", new String(sQLChar.getCharArray()));
            }
            bl = Like.like(cArray, this.getLength(), cArray2, dataValueDescriptor.getLength(), cArray3, n);
        } else {
            SQLChar sQLChar = (SQLChar)dataValueDescriptor;
            SQLChar sQLChar2 = (SQLChar)dataValueDescriptor2;
            int[] nArray = sQLChar2.getIntArray();
            int n = sQLChar2.getIntLength();
            if (nArray != null && nArray.length != 1) {
                throw StandardException.newException("22019", new String(sQLChar2.getCharArray()));
            }
            bl = Like.like(this.getIntArray(), this.getIntLength(), sQLChar.getIntArray(), sQLChar.getIntLength(), nArray, n, this.getLocaleFinder().getCollator());
        }
        return SQLBoolean.truthValue((DataValueDescriptor)this, dataValueDescriptor, bl);
    }

    public NumberDataValue locate(StringDataValue stringDataValue, NumberDataValue numberDataValue, NumberDataValue numberDataValue2) throws StandardException {
        if (numberDataValue2 == null) {
            numberDataValue2 = new SQLInteger();
        }
        int n = numberDataValue.isNull() ? 1 : numberDataValue.getInt();
        if (this.isNull() || stringDataValue.isNull()) {
            numberDataValue2.setToNull();
            return numberDataValue2;
        }
        String string = stringDataValue.getString();
        String string2 = this.getString();
        if (n < 1) {
            throw StandardException.newException("22014", new String(this.getString()), (Object)new String(string), (Object)new Integer(n));
        }
        if (string2.length() == 0) {
            numberDataValue2.setValue(n);
            return numberDataValue2;
        }
        numberDataValue2.setValue(string.indexOf(string2, n - 1) + 1);
        return numberDataValue2;
    }

    public ConcatableDataValue substring(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, ConcatableDataValue concatableDataValue, int n) throws StandardException {
        if (concatableDataValue == null) {
            concatableDataValue = this.getNewVarchar();
        }
        StringDataValue stringDataValue = (StringDataValue)concatableDataValue;
        if (this.isNull() || numberDataValue.isNull() || numberDataValue2 != null && numberDataValue2.isNull()) {
            stringDataValue.setToNull();
            return stringDataValue;
        }
        int n2 = numberDataValue.getInt();
        int n3 = numberDataValue2 != null ? numberDataValue2.getInt() : n - n2 + 1;
        if (n2 <= 0 || n3 < 0 || n2 > n || n3 > n - n2 + 1) {
            throw StandardException.newException("22011");
        }
        if (n3 < 0) {
            stringDataValue.setToNull();
            return stringDataValue;
        }
        if (n2 < 0) {
            if (n2 + this.getLength() < 0 && n2 + this.getLength() + n3 <= 0) {
                stringDataValue.setValue("");
                return stringDataValue;
            }
            n2 += this.getLength();
            while (n2 < 0) {
                ++n2;
                --n3;
            }
        } else if (n2 > 0) {
            --n2;
        }
        if (n3 == 0 || n3 <= 0 - n2 || n2 > this.getLength()) {
            stringDataValue.setValue("");
            return stringDataValue;
        }
        if (n3 >= this.getLength() - n2) {
            stringDataValue.setValue(this.getString().substring(n2));
        } else {
            stringDataValue.setValue(this.getString().substring(n2, n2 + n3));
        }
        return stringDataValue;
    }

    public StringDataValue trim(int n, StringDataValue stringDataValue) throws StandardException {
        int n2;
        boolean bl;
        int n3;
        if (stringDataValue == null) {
            stringDataValue = this.getNewVarchar();
        }
        if (this.isNull()) {
            stringDataValue.setToNull();
            return stringDataValue;
        }
        char[] cArray = new char[]{' '};
        String string = this.getString();
        if (n == 2) {
            for (n3 = 0; n3 < string.length(); ++n3) {
                bl = false;
                for (n2 = 0; n2 < cArray.length; ++n2) {
                    if (string.charAt(n3) != cArray[n2]) continue;
                    bl = true;
                    break;
                }
                if (!bl) break;
            }
            if (n3 == string.length()) {
                string = "";
            } else if (n3 > 0) {
                string = string.substring(n3);
            }
        }
        if (n == 1) {
            for (n3 = string.length(); n3 > 0; --n3) {
                bl = false;
                for (n2 = 0; n2 < cArray.length; ++n2) {
                    if (string.charAt(n3 - 1) != cArray[n2]) continue;
                    bl = true;
                    break;
                }
                if (!bl) break;
            }
            if (n3 == 0) {
                string = "";
            } else if (n3 < string.length()) {
                string = string.substring(0, n3);
            }
        }
        stringDataValue.setValue(string);
        return stringDataValue;
    }

    public StringDataValue upper(StringDataValue stringDataValue) throws StandardException {
        if (stringDataValue == null) {
            stringDataValue = (StringDataValue)this.getNewNull();
        }
        if (this.isNull()) {
            stringDataValue.setToNull();
            return stringDataValue;
        }
        String string = this.getString();
        string = string.toUpperCase(this.getLocale());
        stringDataValue.setValue(string);
        return stringDataValue;
    }

    public StringDataValue lower(StringDataValue stringDataValue) throws StandardException {
        if (stringDataValue == null) {
            stringDataValue = (StringDataValue)this.getNewNull();
        }
        if (this.isNull()) {
            stringDataValue.setToNull();
            return stringDataValue;
        }
        String string = this.getString();
        string = string.toLowerCase(this.getLocale());
        stringDataValue.setValue(string);
        return stringDataValue;
    }

    public int typePrecedence() {
        return 0;
    }

    protected static int stringCompare(String string, String string2) {
        int n;
        String string3;
        int n2;
        int n3;
        int n4;
        if (string == null || string2 == null) {
            if (string != null) {
                return -1;
            }
            if (string2 != null) {
                return 1;
            }
            return 0;
        }
        int n5 = string.length();
        int n6 = n5 < (n4 = string2.length()) ? n5 : n4;
        for (n3 = 0; n3 < n6; ++n3) {
            char c2;
            char c3 = string.charAt(n3);
            if (c3 == (c2 = string2.charAt(n3))) continue;
            if (c3 < c2) {
                return -1;
            }
            return 1;
        }
        if (n5 == n4) {
            return 0;
        }
        if (n5 > n4) {
            n2 = -1;
            string3 = string;
            n3 = n4;
            n = n5;
        } else {
            n2 = 1;
            string3 = string2;
            n3 = n5;
            n = n4;
        }
        while (n3 < n) {
            char c4 = string3.charAt(n3);
            if (c4 < ' ') {
                return n2;
            }
            if (c4 > ' ') {
                return -n2;
            }
            ++n3;
        }
        return 0;
    }

    protected int stringCompare(SQLChar sQLChar, SQLChar sQLChar2) throws StandardException {
        return SQLChar.stringCompare(sQLChar.getCharArray(), sQLChar.getLength(), sQLChar2.getCharArray(), sQLChar2.getLength());
    }

    protected static int stringCompare(char[] cArray, int n, char[] cArray2, int n2) {
        int n3;
        char[] cArray3;
        int n4;
        int n5;
        if (cArray == null || cArray2 == null) {
            if (cArray != null) {
                return -1;
            }
            if (cArray2 != null) {
                return 1;
            }
            return 0;
        }
        int n6 = n < n2 ? n : n2;
        for (n5 = 0; n5 < n6; ++n5) {
            char c2 = cArray[n5];
            char c3 = cArray2[n5];
            if (c2 == c3) continue;
            if (c2 < c3) {
                return -1;
            }
            return 1;
        }
        if (n == n2) {
            return 0;
        }
        if (n > n2) {
            n4 = -1;
            cArray3 = cArray;
            n5 = n2;
            n3 = n;
        } else {
            n4 = 1;
            cArray3 = cArray2;
            n5 = n;
            n3 = n2;
        }
        while (n5 < n3) {
            char c4 = cArray3[n5];
            if (c4 < ' ') {
                return n4;
            }
            if (c4 > ' ') {
                return -n4;
            }
            ++n5;
        }
        return 0;
    }

    protected int stringCollatorCompare(SQLChar sQLChar) throws StandardException {
        CollationKey collationKey = this.getCollationKey();
        CollationKey collationKey2 = sQLChar.getCollationKey();
        if (collationKey == null || collationKey2 == null) {
            if (collationKey != null) {
                return -1;
            }
            if (collationKey2 != null) {
                return 1;
            }
            return 0;
        }
        return collationKey.compareTo(collationKey2);
    }

    protected CollationKey getCollationKey() throws StandardException {
        int n;
        char[] cArray;
        if (this.cKey != null) {
            return this.cKey;
        }
        if (this.rawLength == -1 && (cArray = this.getCharArray()) == null) {
            return null;
        }
        for (n = this.rawLength; n > 0 && this.rawData[n - 1] == ' '; --n) {
        }
        RuleBasedCollator ruleBasedCollator = this.getLocaleFinder().getCollator();
        this.cKey = ruleBasedCollator.getCollationKey(new String(this.rawData, 0, n));
        return this.cKey;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        if (this.value == null && this.rawLength != -1) {
            return new String(this.rawData, 0, this.rawLength);
        }
        if (this.stream != null) {
            try {
                return this.getString();
            }
            catch (Exception exception) {
                return exception.toString();
            }
        }
        return this.value;
    }

    public int hashCode() {
        int n;
        try {
            if (this.getString() == null) {
                return 0;
            }
        }
        catch (StandardException standardException) {
            return 0;
        }
        int n2 = 0;
        String string = this.value;
        for (n = string.length() - 1; n >= 0 && string.charAt(n) == ' '; --n) {
        }
        while (n >= 0) {
            n2 += string.charAt(n);
            --n;
        }
        return n2;
    }

    protected int nationalHashCode() {
        CollationKey collationKey = null;
        try {
            collationKey = this.getCollationKey();
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        if (collationKey == null) {
            return 0;
        }
        return collationKey.hashCode();
    }

    private int[] getIntArray() throws StandardException {
        int n;
        if (this.isNull()) {
            return null;
        }
        if (this.intArray != null) {
            return this.intArray;
        }
        this.intArray = new int[this.getLength()];
        RuleBasedCollator ruleBasedCollator = this.getLocaleFinder().getCollator();
        CollationElementIterator collationElementIterator = ruleBasedCollator.getCollationElementIterator(this.getString());
        while ((n = collationElementIterator.next()) != -1) {
            if (this.intLength == this.intArray.length) {
                int[] nArray = this.intArray;
                this.intArray = new int[this.intLength + 5];
                for (int j = 0; j < nArray.length; ++j) {
                    this.intArray[j] = nArray[j];
                }
            }
            this.intArray[this.intLength++] = n;
        }
        return this.intArray;
    }

    private int getIntLength() {
        return this.intLength;
    }

    protected StringDataValue getNewVarchar() throws StandardException {
        return new SQLVarchar();
    }

    protected boolean isNationalString() {
        return false;
    }

    protected Date nationalGetDate(Calendar calendar) throws StandardException {
        if (this.isNull()) {
            return null;
        }
        SQLDate sQLDate = new SQLDate(this.getString(), false, this.getLocaleFinder(), calendar);
        return sQLDate.getDate(calendar);
    }

    protected Time nationalGetTime(Calendar calendar) throws StandardException {
        if (this.isNull()) {
            return null;
        }
        SQLTime sQLTime = new SQLTime(this.getString(), false, this.getLocaleFinder(), calendar);
        return sQLTime.getTime(calendar);
    }

    protected Timestamp nationalGetTimestamp(Calendar calendar) throws StandardException {
        return SQLChar.getTimestamp(calendar, this.getString(), this.getLocaleFinder());
    }

    protected void setLocaleFinder(LocaleFinder localeFinder) {
        this.localeFinder = localeFinder;
    }

    private Locale getLocale() throws StandardException {
        return this.getLocaleFinder().getCurrentLocale();
    }

    protected LocaleFinder getLocaleFinder() {
        DatabaseContext databaseContext;
        if (this.localeFinder == null && (databaseContext = (DatabaseContext)ContextService.getContext("Database")) != null) {
            this.localeFinder = databaseContext.getDatabase();
        }
        return this.localeFinder;
    }

    protected DateFormat getDateFormat() throws StandardException {
        return this.getLocaleFinder().getDateFormat();
    }

    protected DateFormat getTimeFormat() throws StandardException {
        return this.getLocaleFinder().getTimeFormat();
    }

    protected DateFormat getTimestampFormat() throws StandardException {
        return this.getLocaleFinder().getTimestampFormat();
    }

    protected DateFormat getDateFormat(Calendar calendar) throws StandardException {
        return this.setDateFormatCalendar(this.getLocaleFinder().getDateFormat(), calendar);
    }

    protected DateFormat getTimeFormat(Calendar calendar) throws StandardException {
        return this.setDateFormatCalendar(this.getLocaleFinder().getTimeFormat(), calendar);
    }

    protected DateFormat getTimestampFormat(Calendar calendar) throws StandardException {
        return this.setDateFormatCalendar(this.getLocaleFinder().getTimestampFormat(), calendar);
    }

    private DateFormat setDateFormatCalendar(DateFormat dateFormat, Calendar calendar) {
        if (calendar != null && dateFormat.getTimeZone() != calendar.getTimeZone()) {
            dateFormat = (DateFormat)dateFormat.clone();
            dateFormat.setCalendar(calendar);
        }
        return dateFormat;
    }

    public int estimateMemoryUsage() {
        int n = BASE_MEMORY_USAGE + ClassSize.estimateMemoryUsage(this.value);
        if (null != this.rawData) {
            n += 2 * this.rawData.length;
        }
        if (null != this.intArray) {
            n += this.intArray.length * ClassSize.getIntSize();
        }
        return n;
    }

    protected void copyState(SQLChar sQLChar) {
        this.value = sQLChar.value;
        this.rawData = sQLChar.rawData;
        this.rawLength = sQLChar.rawLength;
        this.cKey = sQLChar.cKey;
        this.stream = sQLChar.stream;
        this.intArray = this.intArray;
        this.intLength = this.intLength;
        this.localeFinder = this.localeFinder;
    }

    public XMLDataValue XMLParse(XMLDataValue xMLDataValue, boolean bl) throws StandardException {
        if (xMLDataValue == null) {
            xMLDataValue = new XML();
        }
        if (this.isNull()) {
            xMLDataValue.setToNull();
            return xMLDataValue;
        }
        String string = this.getString();
        xMLDataValue.parseAndLoadXML(string, bl);
        return xMLDataValue;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        for (int j = 0; j < BLANKS.length; ++j) {
            SQLChar.BLANKS[j] = 32;
        }
        BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(class$org$apache$derby$iapi$types$SQLChar == null ? (class$org$apache$derby$iapi$types$SQLChar = SQLChar.class$("org.apache.derby.iapi.types.SQLChar")) : class$org$apache$derby$iapi$types$SQLChar);
    }
}

